/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.lint;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.model.DefaultModelUpdater;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.AdditionalDeviceService;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.lint.InflationParam;
import com.android.tools.idea.uibuilder.lint.VisualLintServiceKt;
import com.android.tools.idea.uibuilder.model.NlComponentRegistrar;
import com.android.tools.idea.uibuilder.scene.NlModelHierarchyUpdater;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintAnalysisKt;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintAnalyticsManager;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintBaseConfigIssues;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintIssueProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/uibuilder/lint/VisualLintService;", "", "()V", "issueProvider", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintIssueProvider;", "getIssueProvider", "()Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintIssueProvider;", "runVisualLintAnalysis", "", "models", "", "Lcom/android/tools/idea/common/model/NlModel;", "issueModel", "Lcom/android/tools/idea/common/error/IssueModel;", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "Companion", "intellij.android.designer"})
public final class VisualLintService {
    @NotNull
    private final VisualLintIssueProvider issueProvider = new VisualLintIssueProvider();
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final VisualLintIssueProvider getIssueProvider() {
        return this.issueProvider;
    }

    public final void runVisualLintAnalysis(@NotNull List<? extends NlModel> models2, @NotNull IssueModel issueModel, @NotNull DesignSurface surface2) {
        Intrinsics.checkNotNullParameter(models2, (String)"models");
        Intrinsics.checkNotNullParameter((Object)issueModel, (String)"issueModel");
        Intrinsics.checkNotNullParameter((Object)((Object)surface2), (String)"surface");
        issueModel.removeIssueProvider(this.issueProvider);
        this.issueProvider.clear();
        if (models2.isEmpty()) {
            return;
        }
        issueModel.addIssueProvider(this.issueProvider, false);
        NlModel displayingModel = models2.get(0);
        Object object = AdditionalDeviceService.Companion.getInstance();
        if (object == null || (object = object.getWindowSizeDevices()) == null) {
            return;
        }
        Object devices2 = object;
        Iterator iterator = devices2.iterator();
        while (iterator.hasNext()) {
            Configuration config;
            Device device = (Device)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)Configuration.copy((Configuration)displayingModel.getConfiguration()), (String)"Configuration.copy(displayingModel.configuration)");
            config.setDevice(device, false);
            Project project = displayingModel.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"displayingModel.project");
            XmlFile xmlFile = displayingModel.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"displayingModel.file");
            AndroidFacet androidFacet = displayingModel.getFacet();
            Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"displayingModel.facet");
            InflationParam param = new InflationParam(config, project, xmlFile, androidFacet, true);
            ((CompletableFuture)VisualLintServiceKt.inflate(param).thenCompose(new Function(this, param, surface2){
                final /* synthetic */ VisualLintService this$0;
                final /* synthetic */ InflationParam $param;
                final /* synthetic */ DesignSurface $surface;

                public final CompletionStage apply(RenderResult result) {
                    if (result == null) {
                        return CompletableFuture.completedFuture(null);
                    }
                    Device device = this.$param.getConfig().getDevice();
                    NlModel inflatedModel = NlModel.builder(this.$param.getFacet(), this.$param.getFile().getVirtualFile(), this.$param.getConfig()).withModelDisplayName(String.valueOf(device != null ? device.getDisplayName() : null)).withModelUpdater(new DefaultModelUpdater()).withComponentRegistrar(NlComponentRegistrar.INSTANCE).build();
                    NlModelHierarchyUpdater.updateHierarchy(result, inflatedModel);
                    VisualLintAnalysisKt.analyzeAfterModelUpdate(result, inflatedModel, this.this$0.getIssueProvider(), new VisualLintBaseConfigIssues(), new VisualLintAnalyticsManager(this.$surface));
                    return CompletableFuture.completedFuture(null);
                }
                {
                    this.this$0 = visualLintService;
                    this.$param = inflationParam;
                    this.$surface = designSurface;
                }
            })).thenAccept(new Consumer(issueModel){
                final /* synthetic */ IssueModel $issueModel;

                public final void accept(@Nullable Void it) {
                    this.$issueModel.updateErrorsList();
                }
                {
                    this.$issueModel = issueModel;
                }
            });
        }
    }

    @JvmStatic
    @Nullable
    public static final VisualLintService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/uibuilder/lint/VisualLintService$Companion;", "", "()V", "getInstance", "Lcom/android/tools/idea/uibuilder/lint/VisualLintService;", "intellij.android.designer"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final VisualLintService getInstance() {
            return (VisualLintService)ApplicationManager.getApplication().getService(VisualLintService.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

