/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property.action;

import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTagWriter;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.property.MotionLayoutAttributesModel;
import com.android.tools.idea.uibuilder.handlers.motion.property.MotionSelection;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.property.panel.api.InspectorLineModel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubSectionControlAction
extends AnAction {
    private final NlPropertyItem myProperty;
    private InspectorLineModel myLineModel;
    private LookupResult myLookupResult;

    public SubSectionControlAction(@Nullable NlPropertyItem property) {
        this.myProperty = property;
        this.myLookupResult = new LookupResult();
    }

    public void setLineModel(@NotNull InspectorLineModel lineModel) {
        if (lineModel == null) {
            SubSectionControlAction.$$$reportNull$$$0(0);
        }
        this.myLineModel = lineModel;
        this.myLineModel.setEnabled(this.check());
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            SubSectionControlAction.$$$reportNull$$$0(1);
        }
        boolean isPresent = this.check();
        Presentation presentation = event.getPresentation();
        presentation.setDescription(this.getCommandName(isPresent));
        presentation.setIcon(isPresent ? AllIcons.Diff.GutterCheckBoxSelected : AllIcons.Diff.GutterCheckBox);
        if (this.myLineModel != null) {
            this.myLineModel.setEnabled(isPresent);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        boolean isPresent;
        String commandName;
        if (event == null) {
            SubSectionControlAction.$$$reportNull$$$0(2);
        }
        if ((commandName = this.getCommandName(isPresent = this.check())) == null) {
            return;
        }
        if (isPresent) {
            MotionSceneTagWriter tagWriter = this.myLookupResult.subTag.getTagWriter();
            tagWriter.deleteTag();
            tagWriter.commit(commandName);
        } else {
            MTag.TagWriter tagWriter = MotionLayoutAttributesModel.createSubTag(this.myLookupResult.selection, this.myLookupResult.tag, this.myLookupResult.subTagName);
            tagWriter.commit(commandName);
        }
    }

    private boolean check() {
        if (this.myProperty == null) {
            return false;
        }
        MotionSelection selection = MotionLayoutAttributesModel.getMotionSelection(this.myProperty);
        String subTagName = MotionLayoutAttributesModel.getSubTag(this.myProperty);
        if (selection == null || subTagName == null || selection.getType() != MotionEditorSelector.Type.CONSTRAINT && selection.getType() != MotionEditorSelector.Type.TRANSITION) {
            return false;
        }
        MotionSceneTag tag = selection.getMotionSceneTag();
        if (tag == null) {
            return false;
        }
        MotionSceneTag subTag = MotionLayoutAttributesModel.getSubTag(tag, subTagName);
        this.myLookupResult.selection = selection;
        this.myLookupResult.tag = tag;
        this.myLookupResult.subTagName = subTagName;
        this.myLookupResult.subTag = subTag;
        return subTag != null;
    }

    @Nullable
    private String getCommandName(boolean isPresent) {
        String subTagName = this.myLookupResult.subTagName;
        if (subTagName == null) {
            return null;
        }
        if (!isPresent) {
            return String.format("Create %1$s tag", subTagName);
        }
        return String.format("Remove %1$s tag", subTagName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineModel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/property/action/SubSectionControlAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setLineModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LookupResult {
        MotionSelection selection;
        MotionSceneTag tag;
        String subTagName;
        MotionSceneTag subTag;

        private LookupResult() {
        }
    }
}

