/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MotionSceneAttrs;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionAttributes;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.property.MotionIdPropertyItem;
import com.android.tools.idea.uibuilder.handlers.motion.property.MotionSelection;
import com.android.tools.idea.uibuilder.property.NlFlagsPropertyItem;
import com.android.tools.idea.uibuilder.property.NlPropertiesModel;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.NlPropertyType;
import com.android.tools.idea.uibuilder.property.PropertiesProvider;
import com.android.tools.idea.uibuilder.property.support.TypeResolver;
import com.android.tools.property.panel.api.PropertiesTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.NamespaceAwareXmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionLayoutPropertyProvider
implements PropertiesProvider {
    private final AndroidFacet myFacet;
    private final XmlElementDescriptorProvider myDescriptorProvider;
    private final Table<String, String, NlPropertyItem> myEmptyTable;
    private static final int EXPECTED_ROWS = 3;
    private static final int EXPECTED_CELLS_PER_ROW = 10;
    private static final List<String> INCLUDE_SUB_TAGS_OF = ImmutableList.of((Object)"Constraint", (Object)"Transition");

    public MotionLayoutPropertyProvider(@NotNull AndroidFacet facet) {
        if (facet == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(0);
        }
        this.myFacet = facet;
        this.myDescriptorProvider = new AndroidDomElementDescriptorProvider();
        this.myEmptyTable = ImmutableTable.of();
    }

    @Override
    @NotNull
    public PropertiesTable<NlPropertyItem> getProperties(@NotNull NlPropertiesModel model2, @Nullable Object optionalValue, @NotNull List<? extends NlComponent> components) {
        if (model2 == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(1);
        }
        if (components == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(2);
        }
        PropertiesTable propertiesTable = PropertiesTable.Companion.emptyTable();
        if (propertiesTable == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(3);
        }
        return propertiesTable;
    }

    @Override
    @NotNull
    public PropertiesTable<NlPropertyItem> createEmptyTable() {
        PropertiesTable propertiesTable = PropertiesTable.Companion.create((Table)HashBasedTable.create((int)3, (int)10));
        if (propertiesTable == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(4);
        }
        return propertiesTable;
    }

    @NotNull
    public Map<String, PropertiesTable<NlPropertyItem>> getAllProperties(@NotNull NlPropertiesModel model2, @NotNull MotionSelection selection) {
        if (model2 == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(5);
        }
        if (selection == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(6);
        }
        if (selection.getComponents().isEmpty()) {
            Map<String, PropertiesTable<NlPropertyItem>> map2 = Collections.emptyMap();
            if (map2 == null) {
                MotionLayoutPropertyProvider.$$$reportNull$$$0(7);
            }
            return map2;
        }
        ModuleResourceManagers resourceManagers = ModuleResourceManagers.getInstance((AndroidFacet)this.myFacet);
        LocalResourceManager localResourceManager = resourceManagers.getLocalResourceManager();
        FrameworkResourceManager frameworkResourceManager = resourceManagers.getFrameworkResourceManager();
        if (frameworkResourceManager == null) {
            Logger.getInstance(MotionLayoutPropertyProvider.class).error("No system resource manager for module: " + this.myFacet.getModule().getName());
            Map<String, PropertiesTable<NlPropertyItem>> map3 = Collections.emptyMap();
            if (map3 == null) {
                MotionLayoutPropertyProvider.$$$reportNull$$$0(8);
            }
            return map3;
        }
        AttributeDefinitions localAttrDefs = localResourceManager.getAttributeDefinitions();
        AttributeDefinitions systemAttrDefs = frameworkResourceManager.getAttributeDefinitions();
        if (localAttrDefs == null) {
            Map<String, PropertiesTable<NlPropertyItem>> map4 = Collections.emptyMap();
            if (map4 == null) {
                MotionLayoutPropertyProvider.$$$reportNull$$$0(9);
            }
            return map4;
        }
        LinkedHashMap<String, PropertiesTable<NlPropertyItem>> allProperties = new LinkedHashMap<String, PropertiesTable<NlPropertyItem>>();
        MotionSceneTag motionSceneTag = selection.getMotionSceneTag();
        XmlTag tag = selection.getXmlTag(motionSceneTag);
        if (motionSceneTag != null && tag != null) {
            XmlElementDescriptor elementDescriptor = this.myDescriptorProvider.getDescriptor(tag);
            if (elementDescriptor == null) {
                Map<String, PropertiesTable<NlPropertyItem>> map5 = Collections.emptyMap();
                if (map5 == null) {
                    MotionLayoutPropertyProvider.$$$reportNull$$$0(10);
                }
                return map5;
            }
            XmlAttributeDescriptor[] descriptors = elementDescriptor.getAttributesDescriptors(tag);
            HashBasedTable properties = HashBasedTable.create((int)3, (int)descriptors.length);
            for (XmlAttributeDescriptor descriptor : descriptors) {
                String namespaceUri = MotionLayoutPropertyProvider.getNamespace(descriptor, tag);
                String name = descriptor.getName();
                AttributeDefinitions attrDefs = "http://schemas.android.com/apk/res/android" == namespaceUri ? systemAttrDefs : localAttrDefs;
                ResourceNamespace namespace = ResourceNamespace.fromNamespaceUri((String)namespaceUri);
                AttributeDefinition attrDef = namespace != null && attrDefs != null ? attrDefs.getAttrDefinition(ResourceReference.attr((ResourceNamespace)namespace, (String)name)) : null;
                NlPropertyItem property = MotionLayoutPropertyProvider.createProperty(namespaceUri, name, attrDef, model2, selection, null);
                properties.put((Object)namespaceUri, (Object)name, (Object)property);
            }
            allProperties.put(tag.getLocalName(), (PropertiesTable<NlPropertyItem>)PropertiesTable.Companion.create((Table)properties));
            MotionLayoutPropertyProvider.loadCustomAttributes(model2, allProperties, motionSceneTag, selection);
            if (INCLUDE_SUB_TAGS_OF.contains(tag.getLocalName())) {
                XmlElementDescriptor[] subTagDescriptors;
                for (XmlElementDescriptor descriptor : subTagDescriptors = elementDescriptor.getElementsDescriptors(tag)) {
                    String subTagName = descriptor.getName();
                    if (subTagName.equals("CustomAttribute")) continue;
                    Table<String, String, NlPropertyItem> subTagProperties = this.loadFromStyleableName(subTagName, localAttrDefs, model2, selection);
                    allProperties.put(subTagName, (PropertiesTable<NlPropertyItem>)PropertiesTable.Companion.create(subTagProperties));
                }
            }
        } else if (selection.getType() == MotionEditorSelector.Type.CONSTRAINT) {
            Table<String, String, NlPropertyItem> constraintProperties = this.loadFromStyleableName("Constraint", localAttrDefs, model2, selection);
            NlPropertyItem id2 = MotionLayoutPropertyProvider.createProperty("http://schemas.android.com/apk/res/android", "id", null, model2, selection, null);
            constraintProperties.put((Object)id2.getNamespace(), (Object)id2.getName(), (Object)id2);
            allProperties.put("Constraint", (PropertiesTable<NlPropertyItem>)PropertiesTable.Companion.create(constraintProperties));
            MotionLayoutPropertyProvider.loadCustomAttributes(model2, allProperties, null, selection);
        }
        LinkedHashMap<String, PropertiesTable<NlPropertyItem>> linkedHashMap = allProperties;
        if (linkedHashMap == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(11);
        }
        return linkedHashMap;
    }

    private static void loadCustomAttributes(@NotNull NlPropertiesModel model2, @NotNull Map<String, PropertiesTable<NlPropertyItem>> allProperties, @Nullable MotionSceneTag motionSceneTag, @NotNull MotionSelection selection) {
        if (model2 == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(12);
        }
        if (allProperties == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(13);
        }
        if (selection == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(14);
        }
        MTag[] customTags = motionSceneTag != null ? motionSceneTag.getChildTags("CustomAttribute") : new MTag[]{};
        List<MotionAttributes.DefinedAttribute> inheritedAttributes = Collections.emptyList();
        MotionAttributes attributes = selection.getMotionAttributes();
        if (attributes != null) {
            inheritedAttributes = attributes.getAttrMap().values().stream().filter(defined -> defined.isCustomAttribute()).collect(Collectors.toList());
        }
        if (customTags.length == 0 && inheritedAttributes.isEmpty()) {
            return;
        }
        HashBasedTable customProperties = HashBasedTable.create((int)3, (int)customTags.length);
        block0: for (MTag customTag : customTags) {
            String name = customTag.getAttributeValue("attributeName");
            if (name == null) continue;
            for (String customType : MotionSceneAttrs.ourCustomAttribute) {
                String customValue = customTag.getAttributeValue(customType);
                if (customValue == null) continue;
                NlPropertyItem item = MotionLayoutPropertyProvider.createCustomProperty(name, customType, selection, model2);
                customProperties.put((Object)item.getNamespace(), (Object)item.getName(), (Object)item);
                continue block0;
            }
        }
        inheritedAttributes.forEach(arg_0 -> MotionLayoutPropertyProvider.lambda$loadCustomAttributes$1(selection, model2, (Table)customProperties, arg_0));
        allProperties.put("CustomAttribute", (PropertiesTable<NlPropertyItem>)PropertiesTable.Companion.create((Table)customProperties));
    }

    private Table<String, String, NlPropertyItem> loadFromStyleableName(@NotNull String subTagName, @NotNull AttributeDefinitions attrDefs, @NotNull NlPropertiesModel model2, @NotNull MotionSelection selection) {
        ResourceReference reference2;
        StyleableDefinition styleable2;
        if (subTagName == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(15);
        }
        if (attrDefs == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(16);
        }
        if (model2 == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(17);
        }
        if (selection == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(18);
        }
        if ((styleable2 = attrDefs.getStyleableDefinition(reference2 = new ResourceReference(ResourceNamespace.TODO(), ResourceType.STYLEABLE, subTagName))) == null) {
            return this.myEmptyTable;
        }
        HashBasedTable properties = HashBasedTable.create((int)3, (int)styleable2.getAttributes().size());
        styleable2.getAttributes().forEach(arg_0 -> MotionLayoutPropertyProvider.lambda$loadFromStyleableName$2(model2, selection, subTagName, (Table)properties, arg_0));
        return properties;
    }

    public static NlPropertyItem createCustomProperty(@NotNull String name, @NotNull String customType, @NotNull MotionSelection selection, @NotNull NlPropertiesModel model2) {
        if (name == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(19);
        }
        if (customType == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(20);
        }
        if (selection == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(21);
        }
        if (model2 == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(22);
        }
        NlPropertyType type = MotionLayoutPropertyProvider.mapFromCustomType(customType);
        List<? extends NlComponent> components = selection.getComponents();
        return new NlPropertyItem("", name, type, null, "", "", model2, components, selection, "CustomAttribute");
    }

    private static NlPropertyItem createProperty(@NotNull String namespace, @NotNull String name, @Nullable AttributeDefinition attr2, @NotNull NlPropertiesModel model2, @NotNull MotionSelection selection, @Nullable String subTag) {
        if (namespace == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(23);
        }
        if (name == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(24);
        }
        if (model2 == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(25);
        }
        if (selection == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(26);
        }
        List<? extends NlComponent> components = selection.getComponents();
        NlPropertyType type = TypeResolver.INSTANCE.resolveType(name, attr2);
        String libraryName = StringUtil.notNullize((String)(attr2 != null ? attr2.getLibraryName() : null));
        if (namespace.equals("http://schemas.android.com/apk/res/android") && name.equals("id")) {
            return new MotionIdPropertyItem(model2, attr2, "", components, selection, subTag);
        }
        if (attr2 != null && attr2.getFormats().contains(AttributeFormat.FLAGS) && attr2.getValues().length == 0) {
            return new NlFlagsPropertyItem(namespace, name, type, attr2, "", libraryName, model2, components, selection, subTag);
        }
        return new NlPropertyItem(namespace, name, type, attr2, "", libraryName, model2, components, selection, subTag);
    }

    @NotNull
    private static String getNamespace(@NotNull XmlAttributeDescriptor descriptor, @NotNull XmlTag context) {
        if (descriptor == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(27);
        }
        if (context == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(28);
        }
        String namespace = null;
        if (descriptor instanceof NamespaceAwareXmlAttributeDescriptor) {
            namespace = ((NamespaceAwareXmlAttributeDescriptor)descriptor).getNamespace(context);
        }
        return namespace != null ? namespace : "http://schemas.android.com/apk/res/android";
    }

    @NotNull
    static NlPropertyType mapFromCustomType(@NotNull String customType) {
        if (customType == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(29);
        }
        switch (customType) {
            case "customColorValue": {
                NlPropertyType nlPropertyType = NlPropertyType.COLOR;
                if (nlPropertyType == null) {
                    MotionLayoutPropertyProvider.$$$reportNull$$$0(30);
                }
                return nlPropertyType;
            }
            case "customColorDrawableValue": {
                NlPropertyType nlPropertyType = NlPropertyType.COLOR_STATE_LIST;
                if (nlPropertyType == null) {
                    MotionLayoutPropertyProvider.$$$reportNull$$$0(31);
                }
                return nlPropertyType;
            }
            case "customIntegerValue": {
                NlPropertyType nlPropertyType = NlPropertyType.INTEGER;
                if (nlPropertyType == null) {
                    MotionLayoutPropertyProvider.$$$reportNull$$$0(32);
                }
                return nlPropertyType;
            }
            case "customFloatValue": {
                NlPropertyType nlPropertyType = NlPropertyType.FLOAT;
                if (nlPropertyType == null) {
                    MotionLayoutPropertyProvider.$$$reportNull$$$0(33);
                }
                return nlPropertyType;
            }
            case "customDimension": {
                NlPropertyType nlPropertyType = NlPropertyType.DIMENSION;
                if (nlPropertyType == null) {
                    MotionLayoutPropertyProvider.$$$reportNull$$$0(34);
                }
                return nlPropertyType;
            }
            case "customPixelDimension": {
                NlPropertyType nlPropertyType = NlPropertyType.DIMENSION_PIXEL;
                if (nlPropertyType == null) {
                    MotionLayoutPropertyProvider.$$$reportNull$$$0(35);
                }
                return nlPropertyType;
            }
            case "customBoolean": {
                NlPropertyType nlPropertyType = NlPropertyType.BOOLEAN;
                if (nlPropertyType == null) {
                    MotionLayoutPropertyProvider.$$$reportNull$$$0(36);
                }
                return nlPropertyType;
            }
        }
        NlPropertyType nlPropertyType = NlPropertyType.STRING;
        if (nlPropertyType == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(37);
        }
        return nlPropertyType;
    }

    @NotNull
    static String mapToCustomType(@NotNull NlPropertyType type) {
        if (type == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(38);
        }
        switch (type) {
            case COLOR: {
                return "customColorValue";
            }
            case COLOR_STATE_LIST: {
                return "customColorDrawableValue";
            }
            case INTEGER: {
                return "customIntegerValue";
            }
            case FLOAT: {
                return "customFloatValue";
            }
            case DIMENSION: {
                return "customDimension";
            }
            case DIMENSION_PIXEL: {
                return "customPixelDimension";
            }
            case BOOLEAN: {
                return "customBoolean";
            }
        }
        return "customStringValue";
    }

    private static /* synthetic */ void lambda$loadFromStyleableName$2(NlPropertiesModel model2, MotionSelection selection, String subTagName, Table properties, AttributeDefinition attr2) {
        NlPropertyItem property = MotionLayoutPropertyProvider.createProperty(attr2.getResourceReference().getNamespace().getXmlNamespaceUri(), attr2.getName(), attr2, model2, selection, subTagName);
        properties.put((Object)property.getNamespace(), (Object)property.getName(), (Object)property);
    }

    private static /* synthetic */ void lambda$loadCustomAttributes$1(MotionSelection selection, NlPropertiesModel model2, Table customProperties, MotionAttributes.DefinedAttribute defined) {
        NlPropertyItem item = MotionLayoutPropertyProvider.createCustomProperty(defined.getName(), defined.getCustomType(), selection, model2);
        customProperties.put((Object)item.getNamespace(), (Object)item.getName(), (Object)item);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 5: 
            case 12: 
            case 17: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/motion/property/MotionLayoutPropertyProvider";
                break;
            }
            case 6: 
            case 14: 
            case 18: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allProperties";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subTagName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrDefs";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/property/MotionLayoutPropertyProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyTable";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProperties";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "mapFromCustomType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllProperties";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadCustomAttributes";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadFromStyleableName";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createCustomProperty";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createProperty";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getNamespace";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "mapFromCustomType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "mapToCustomType";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

