/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.ui;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.Icon;

public class Utils {
    public static final int ICON_LIGHT = 0;
    public static final int ICON_LIGHT_SELECTED = 1;
    public static final int ICON_SELECTED = 2;

    public static String stripID(String id2) {
        if (id2 == null) {
            return "";
        }
        int index = id2.indexOf(47);
        if (index < 0) {
            return id2;
        }
        return id2.substring(index + 1).trim();
    }

    public static String formatTransition(MTag tag) {
        String id2 = Utils.stripID(tag.getAttributeValue("id"));
        String start = Utils.stripID(tag.getAttributeValue("constraintSetStart"));
        String end = Utils.stripID(tag.getAttributeValue("constraintSetEnd"));
        return Utils.formatTransition(id2, start, end);
    }

    public static String formatTransition(String id2, String start, String end) {
        if (id2 == null || id2.length() == 0) {
            return start + "->" + end;
        }
        return id2;
    }

    public static Icon computeLiteIcon(int mode, Icon icon2) {
        int w = icon2.getIconWidth();
        int h = icon2.getIconHeight();
        BufferedImage image = MEUI.createImage(w, h, 2);
        Graphics2D g2d = image.createGraphics();
        icon2.paintIcon(null, g2d, 0, 0);
        int[] data = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        switch (mode) {
            case 0: {
                for (int i = 0; i < data.length; ++i) {
                    int v = data[i] & 0xFF;
                    int a = data[i] >> 24 & 0xFF;
                    data[i] = (a /= 3) << 24 | v * 65793;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < data.length; ++i) {
                    int a = data[i] >> 24 & 0xFF;
                    int v = 255;
                    data[i] = (a /= 3) << 24 | v * 65793;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < data.length; ++i) {
                    int a = data[i] >> 24 & 0xFF;
                    int v = 255;
                    data[i] = a << 24 | v * 65793;
                }
                break;
            }
        }
        return MEUI.generateImageIcon(image);
    }
}

