/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.ui;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.CreateKeyAttribute;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.CreateKeyCycle;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.CreateKeyPosition;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.CreateKeyTimeCycle;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.CreateKeyTrigger;
import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.TimeLinePanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MTagActionListener;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MeModel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditor;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class TransitionPanel
extends JPanel {
    TimeLinePanel mTimeLinePanel = new TimeLinePanel();
    MTag mTransitionTag;
    private MeModel mMeModel;
    MotionEditorSelector mMotionEditorSelector;
    CreateKeyPosition mCreateKeyPosition = new CreateKeyPosition();
    CreateKeyAttribute mCreateKeyAttribute = new CreateKeyAttribute();
    CreateKeyTrigger mCreateKeyTrigger = new CreateKeyTrigger();
    CreateKeyCycle mCreateKeyCycle = new CreateKeyCycle();
    CreateKeyTimeCycle mCreateKeyTimeCycle = new CreateKeyTimeCycle();
    JPopupMenu myPopupMenu = new JPopupMenu();

    public TransitionPanel(MotionEditor motionEditor) {
        super(new BorderLayout());
        JPanel left = new JPanel(new GridBagLayout());
        JPanel right2 = new JPanel(new FlowLayout(2));
        JPanel top = new JPanel(new BorderLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        top.add((Component)left, "West");
        top.add((Component)right2, "East");
        top.setBorder(MEUI.getPanelBottomBorder());
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.ipadx = 16;
        left.add((Component)new JLabel("Transition ", MEIcons.LIST_TRANSITION, 0), gbc);
        JButton create = MEUI.createToolBarButton(MEIcons.CREATE_KEYFRAME, "Create KeyFrames");
        create.setContentAreaFilled(false);
        right2.add(create);
        this.myPopupMenu.add(this.mCreateKeyPosition.getAction(create, motionEditor));
        this.myPopupMenu.add(this.mCreateKeyAttribute.getAction(create, motionEditor));
        this.myPopupMenu.add(this.mCreateKeyTrigger.getAction(create, motionEditor));
        this.myPopupMenu.add(this.mCreateKeyCycle.getAction(create, motionEditor));
        this.myPopupMenu.add(this.mCreateKeyTimeCycle.getAction(create, motionEditor));
        create.addActionListener(e -> this.myPopupMenu.show(create, 0, 0));
        this.add((Component)top, "North");
        this.add((Component)this.mTimeLinePanel, "Center");
        this.mTimeLinePanel.addTimeLineListener(new MotionEditorSelector.TimeLineListener(){

            @Override
            public void command(MotionEditorSelector.TimeLineCmd cmd, float pos) {
                if (TransitionPanel.this.mMeModel != null) {
                    TransitionPanel.this.mMeModel.setProgress(pos);
                }
            }
        });
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.myPopupMenu != null) {
            this.myPopupMenu.updateUI();
            int n = this.myPopupMenu.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = this.myPopupMenu.getComponent(i);
                if (!(component instanceof JComponent)) continue;
                ((JComponent)component).updateUI();
            }
        }
    }

    public void setMTag(MTag transitionTag, MeModel model2) {
        this.mTransitionTag = transitionTag;
        this.mMeModel = model2;
        this.mTimeLinePanel.setMTag(transitionTag, model2);
    }

    public void setListeners(MotionEditorSelector listeners) {
        this.mMotionEditorSelector = listeners;
        this.mTimeLinePanel.setListeners(listeners);
    }

    public void addTimeLineListener(MotionEditorSelector.TimeLineListener timeLineListener) {
        this.mTimeLinePanel.addTimeLineListener(timeLineListener);
    }

    public void clearSelection() {
        this.mTimeLinePanel.clearSelection();
    }

    public void setActionListener(MTagActionListener listener2) {
        this.mTimeLinePanel.setActionListener(listener2);
    }

    public void stopAnimation() {
        this.mTimeLinePanel.stopAnimation();
    }
}

