/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.ui;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MotionSceneAttrs;
import com.android.tools.idea.uibuilder.handlers.motion.editor.utils.Debug;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class MotionAttributes {
    private final MTag mConstraintSet;
    private boolean mDefinedLayout = false;
    private boolean mDefinedPropertySet = false;
    private boolean mDefinedTransform = false;
    private boolean mDefinedMotion = false;
    private String mId;
    private String mLayoutFrom = "undefined";
    private HashMap<String, DefinedAttribute> definedAttributes = new HashMap();
    static HashMap<String, HashSet<String>> validMap = new HashMap();

    public String getId() {
        return this.mId;
    }

    public String getLayoutSource() {
        return this.mLayoutFrom;
    }

    public MTag getConstraintSet() {
        return this.mConstraintSet;
    }

    public void fillTagWriter(MTag.TagWriter writer) {
        for (DefinedAttribute value2 : this.getAttrMap().values()) {
            writer.setAttribute(value2.nameSpace, value2.name, value2.value);
        }
    }

    public HashMap<String, DefinedAttribute> getAttrMap() {
        return this.definedAttributes;
    }

    public void loadViewAttrs(MTag viewTag) {
        HashMap<String, MTag.Attribute> map2 = viewTag.getAttrList();
        for (String type : map2.keySet()) {
            DefinedAttribute newAttribute;
            MTag.Attribute attr2 = map2.get(type);
            if (!this.mDefinedPropertySet && MotionSceneAttrs.isPropertySetAttribute(attr2)) {
                newAttribute = new DefinedAttribute();
                newAttribute.source_id = null;
                newAttribute.nameSpace = attr2.mNamespace;
                newAttribute.customType = null;
                newAttribute.name = attr2.mAttribute;
                newAttribute.value = attr2.mValue;
                this.definedAttributes.put(newAttribute.name, newAttribute);
            }
            if (!this.mDefinedTransform && MotionSceneAttrs.isTransformAttribute(attr2)) {
                newAttribute = new DefinedAttribute();
                newAttribute.source_id = null;
                newAttribute.nameSpace = attr2.mNamespace;
                newAttribute.customType = null;
                newAttribute.name = attr2.mAttribute;
                newAttribute.value = attr2.mValue;
                this.definedAttributes.put(newAttribute.name, newAttribute);
            }
            if (this.mDefinedLayout || !MotionSceneAttrs.isLayoutAttribute(attr2)) continue;
            this.mLayoutFrom = "MotionLayout";
            newAttribute = new DefinedAttribute();
            newAttribute.source_id = null;
            newAttribute.nameSpace = attr2.mNamespace;
            newAttribute.customType = null;
            newAttribute.name = attr2.mAttribute;
            newAttribute.value = attr2.mValue;
            this.definedAttributes.put(newAttribute.name, newAttribute);
        }
    }

    public MotionAttributes(String id2, MTag constraintSet) {
        this.mId = id2;
        this.mConstraintSet = constraintSet;
    }

    public void dumpList() {
        Debug.log("   " + this.mId);
        for (DefinedAttribute attribute : this.definedAttributes.values()) {
            String s = attribute.name + "  " + attribute.value;
            System.out.println(s);
        }
    }

    public void addCustomAttrs(String constraintSetId, MTag customAttr) {
        String name = customAttr.getAttributeValue("attributeName");
        String customType = null;
        String value2 = null;
        for (String s : MotionSceneAttrs.ourCustomAttribute) {
            String v = customAttr.getAttributeValue(s);
            if (v == null) continue;
            customType = s;
            value2 = v;
            break;
        }
        if (this.definedAttributes.containsKey(name)) {
            return;
        }
        DefinedAttribute newAttribute = new DefinedAttribute();
        newAttribute.source_id = constraintSetId;
        newAttribute.customType = customType;
        newAttribute.name = name;
        newAttribute.value = value2;
        this.definedAttributes.put(newAttribute.name, newAttribute);
    }

    public static Set<String> getCustomAttributesFor(NlComponent nlComponent, String customAttributeType) {
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(nlComponent);
        if (viewInfo == null) {
            return Collections.emptySet();
        }
        Object o = viewInfo.getViewObject();
        if (o == null) {
            return Collections.emptySet();
        }
        Method[] m = o.getClass().getMethods();
        HashSet<String> ret = new HashSet<String>();
        HashSet<String> valid = validMap.get(customAttributeType);
        for (int i = 0; i < m.length; ++i) {
            String typeStr;
            Class<?>[] types;
            Method method = m[i];
            Object name = method.getName();
            if (!((String)name).startsWith("set") || !Character.isUpperCase(((String)name).charAt(3)) || (types = method.getParameterTypes()).length != 1 || !valid.contains(typeStr = types[0].getSimpleName())) continue;
            name = Character.toLowerCase(((String)name).charAt(3)) + ((String)name).substring(4);
            ret.add((String)name);
        }
        return ret;
    }

    public void consume(boolean definedLayout, boolean definedPropertySet, boolean definedTransform, boolean definedMotion) {
        this.mDefinedLayout |= definedLayout;
        this.mDefinedPropertySet |= definedPropertySet;
        this.mDefinedTransform |= definedTransform;
        this.mDefinedMotion |= definedMotion;
    }

    public boolean allFilled() {
        return this.mDefinedLayout && this.mDefinedMotion && this.mDefinedPropertySet && this.mDefinedTransform;
    }

    public boolean layoutTagsFilled() {
        return this.mDefinedLayout && this.mDefinedPropertySet && this.mDefinedTransform;
    }

    public void loadAttrs(Section type, String constraintSetId, HashMap<String, MTag.Attribute> attr2) {
        switch (type) {
            case LAYOUT: {
                if (this.mDefinedLayout) {
                    return;
                }
                this.mLayoutFrom = constraintSetId;
                this.mDefinedLayout = true;
                break;
            }
            case PROPERTY_SET: {
                if (this.mDefinedPropertySet) {
                    return;
                }
                this.mDefinedPropertySet = true;
                break;
            }
            case TRANSFORM: {
                if (this.mDefinedTransform) {
                    return;
                }
                this.mDefinedTransform = true;
                break;
            }
            case MOTION: {
                if (this.mDefinedMotion) {
                    return;
                }
                this.mDefinedMotion = true;
                break;
            }
            case ALL: {
                if (!this.mDefinedLayout) {
                    this.mLayoutFrom = constraintSetId;
                }
                this.mDefinedLayout = true;
                this.mDefinedPropertySet = true;
                this.mDefinedMotion = true;
                this.mDefinedTransform = true;
            }
        }
        for (String key : attr2.keySet()) {
            MTag.Attribute a = attr2.get(key);
            DefinedAttribute newAttribute = new DefinedAttribute();
            newAttribute.source_id = constraintSetId;
            newAttribute.nameSpace = a.mNamespace;
            newAttribute.customType = null;
            newAttribute.name = a.mAttribute;
            newAttribute.value = a.mValue;
            this.definedAttributes.put(newAttribute.name, newAttribute);
        }
    }

    static {
        validMap.put("customColorValue", new HashSet<String>(Arrays.asList("int")));
        validMap.put("customColorDrawableValue", new HashSet<String>(Arrays.asList("Drawable")));
        validMap.put("customIntegerValue", new HashSet<String>(Arrays.asList("int")));
        validMap.put("customFloatValue", new HashSet<String>(Arrays.asList("float")));
        validMap.put("customStringValue", new HashSet<String>(Arrays.asList("CharSequence", "String")));
        validMap.put("customDimension", new HashSet<String>(Arrays.asList("float")));
        validMap.put("customPixelDimension", new HashSet<String>(Arrays.asList("float")));
        validMap.put("customBoolean", new HashSet<String>(Arrays.asList("boolean")));
    }

    public static enum Section {
        LAYOUT,
        PROPERTY_SET,
        TRANSFORM,
        MOTION,
        ALL;

    }

    public static class DefinedAttribute {
        private String source_id;
        private String nameSpace;
        private String customType;
        private String name;
        private String value;

        public String toString() {
            String ret = "(" + (this.source_id == null ? "LAYOUT" : this.source_id) + ")" + this.name + " " + this.value;
            if (this.customType != null) {
                ret = ret + "(" + this.customType + ")";
            }
            return ret;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getNamespace() {
            return this.nameSpace;
        }

        public String getSourceId() {
            return this.source_id;
        }

        public String getCustomType() {
            return this.customType;
        }

        public boolean isLayoutAttribute() {
            return MotionSceneAttrs.layout_tags.contains(this.name);
        }

        public boolean isPropertySetAttribute() {
            return MotionSceneAttrs.ourPropertySet_tags.contains(this.name);
        }

        public boolean isTransformAttribute() {
            return MotionSceneAttrs.ourTransform_tags.contains(this.name);
        }

        public boolean isMotionAttribute() {
            return MotionSceneAttrs.ourMotion_tags.contains(this.name);
        }

        public boolean isCustomAttribute() {
            return this.customType != null;
        }
    }
}

