/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.graph;

import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.graph.Interpolator;

public class MonotoneSpline
extends Interpolator {
    private static final String TAG = "MonotoneSpline";
    private double[] mT;
    private double[][] mY;
    private double[][] mTangent;

    public MonotoneSpline(double[] time, double[][] y) {
        int N = time.length;
        int dim = y[0].length;
        double[][] slope = new double[N - 1][dim];
        double[][] tangent = new double[N][dim];
        for (int j = 0; j < dim; ++j) {
            for (int i = 0; i < N - 1; ++i) {
                double dt = time[i + 1] - time[i];
                slope[i][j] = (y[i + 1][j] - y[i][j]) / dt;
                tangent[i][j] = i == 0 ? slope[i][j] : (slope[i - 1][j] + slope[i][j]) * 0.5;
            }
            tangent[N - 1][j] = slope[N - 2][j];
        }
        for (int i = 0; i < N - 1; ++i) {
            for (int j = 0; j < dim; ++j) {
                if (slope[i][j] == 0.0) {
                    tangent[i][j] = 0.0;
                    tangent[i + 1][j] = 0.0;
                    continue;
                }
                double a = tangent[i][j] / slope[i][j];
                double b = tangent[i + 1][j] / slope[i][j];
                double h = Math.hypot(a, b);
                if (!(h > 9.0)) continue;
                double t = 3.0 / h;
                tangent[i][j] = t * a * slope[i][j];
                tangent[i + 1][j] = t * b * slope[i][j];
            }
        }
        this.mT = time;
        this.mY = y;
        this.mTangent = tangent;
    }

    @Override
    public void getPos(double t, double[] v) {
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (t <= this.mT[0]) {
            for (int j = 0; j < dim; ++j) {
                v[j] = this.mY[0][j];
            }
            return;
        }
        if (t >= this.mT[n - 1]) {
            for (int j = 0; j < dim; ++j) {
                v[j] = this.mY[n - 1][j];
            }
            return;
        }
        for (int i = 0; i < n - 1; ++i) {
            if (t == this.mT[i]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[i][j];
                }
            }
            if (!(t < this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            for (int j = 0; j < dim; ++j) {
                double y1 = this.mY[i][j];
                double y2 = this.mY[i + 1][j];
                double t1 = this.mTangent[i][j];
                double t2 = this.mTangent[i + 1][j];
                v[j] = MonotoneSpline.interpolate(h, x, y1, y2, t1, t2);
            }
            return;
        }
    }

    @Override
    public void getPos(double t, float[] v) {
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (t <= this.mT[0]) {
            for (int j = 0; j < dim; ++j) {
                v[j] = (float)this.mY[0][j];
            }
            return;
        }
        if (t >= this.mT[n - 1]) {
            for (int j = 0; j < dim; ++j) {
                v[j] = (float)this.mY[n - 1][j];
            }
            return;
        }
        for (int i = 0; i < n - 1; ++i) {
            if (t == this.mT[i]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)this.mY[i][j];
                }
            }
            if (!(t < this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            for (int j = 0; j < dim; ++j) {
                double y1 = this.mY[i][j];
                double y2 = this.mY[i + 1][j];
                double t1 = this.mTangent[i][j];
                double t2 = this.mTangent[i + 1][j];
                v[j] = (float)MonotoneSpline.interpolate(h, x, y1, y2, t1, t2);
            }
            return;
        }
    }

    @Override
    public double getPos(double t, int j) {
        int n = this.mT.length;
        if (t <= this.mT[0]) {
            return this.mY[0][j];
        }
        if (t >= this.mT[n - 1]) {
            return this.mY[n - 1][j];
        }
        for (int i = 0; i < n - 1; ++i) {
            if (t == this.mT[i]) {
                return this.mY[i][j];
            }
            if (!(t < this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            double y1 = this.mY[i][j];
            double y2 = this.mY[i + 1][j];
            double t1 = this.mTangent[i][j];
            double t2 = this.mTangent[i + 1][j];
            return MonotoneSpline.interpolate(h, x, y1, y2, t1, t2);
        }
        return 0.0;
    }

    @Override
    public void getSlope(double t, double[] v) {
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (t <= this.mT[0]) {
            t = this.mT[0];
        } else if (t >= this.mT[n - 1]) {
            t = this.mT[n - 1];
        }
        for (int i = 0; i < n - 1; ++i) {
            if (!(t <= this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            for (int j = 0; j < dim; ++j) {
                double y1 = this.mY[i][j];
                double y2 = this.mY[i + 1][j];
                double t1 = this.mTangent[i][j];
                double t2 = this.mTangent[i + 1][j];
                v[j] = MonotoneSpline.diff(h, x, y1, y2, t1, t2) / h;
            }
            break;
        }
    }

    @Override
    public double getSlope(double t, int j) {
        int n = this.mT.length;
        if (t < this.mT[0]) {
            t = this.mT[0];
        } else if (t >= this.mT[n - 1]) {
            t = this.mT[n - 1];
        }
        for (int i = 0; i < n - 1; ++i) {
            if (!(t <= this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            double y1 = this.mY[i][j];
            double y2 = this.mY[i + 1][j];
            double t1 = this.mTangent[i][j];
            double t2 = this.mTangent[i + 1][j];
            return MonotoneSpline.diff(h, x, y1, y2, t1, t2) / h;
        }
        return 0.0;
    }

    public double getLength2D(double t) {
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (dim < 2) {
            return 0.0;
        }
        if (t <= this.mT[0]) {
            return 0.0;
        }
        if (t >= this.mT[n - 1]) {
            t = this.mT[n - 1];
        }
        double sum = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            double iy;
            double ty2;
            double ty1;
            double y2;
            double y1;
            double ix;
            double tx2;
            double tx1;
            double x2;
            double x1;
            double x;
            double h;
            if (t == this.mT[i]) {
                double x3 = this.mY[i][0];
                double d = this.mY[i][1];
            }
            if (t >= this.mT[i + 1]) {
                h = this.mT[i + 1] - this.mT[i];
                x = 1.0;
                x1 = this.mY[i][0];
                x2 = this.mY[i + 1][0];
                tx1 = this.mTangent[i][0];
                tx2 = this.mTangent[i + 1][0];
                ix = MonotoneSpline.length(h, x, x1, x2, tx1, tx2);
                y1 = this.mY[i][1];
                y2 = this.mY[i + 1][1];
                ty1 = this.mTangent[i][1];
                ty2 = this.mTangent[i + 1][1];
                iy = MonotoneSpline.length(h, x, y1, y2, ty1, ty2);
                sum += iy + ix;
                continue;
            }
            if (!(t < this.mT[i + 1])) continue;
            h = this.mT[i + 1] - this.mT[i];
            x = (t - this.mT[i]) / h;
            x1 = this.mY[i][0];
            x2 = this.mY[i + 1][0];
            tx1 = this.mTangent[i][0];
            tx2 = this.mTangent[i + 1][0];
            ix = MonotoneSpline.length(h, x, x1, x2, tx1, tx2);
            y1 = this.mY[i][1];
            y2 = this.mY[i + 1][1];
            ty1 = this.mTangent[i][1];
            ty2 = this.mTangent[i + 1][1];
            iy = MonotoneSpline.length(h, x, y1, y2, ty1, ty2);
            sum += iy + ix;
        }
        return sum;
    }

    @Override
    public double[] getTimePoints() {
        return this.mT;
    }

    private static double length(double h, double x, double y1, double y2, double t1, double t2) {
        double x2 = x * x;
        double x3 = x2 * x;
        double x4 = x3 * x;
        return -(x4 * y2) / 2.0 + x3 * y2 + x4 * y1 / 2.0 - x3 * y1 + x * y1 + h * t2 * x4 / 4.0 + h * t1 * x4 / 4.0 - h * t2 * x3 / 3.0 + -2.0 * h * t1 * x3 / 3.0 + h * t1 * x2 / 2.0;
    }

    private static double interpolate(double h, double x, double y1, double y2, double t1, double t2) {
        double x2 = x * x;
        double x3 = x2 * x;
        return -2.0 * x3 * y2 + 3.0 * x2 * y2 + 2.0 * x3 * y1 - 3.0 * x2 * y1 + y1 + h * t2 * x3 + h * t1 * x3 - h * t2 * x2 - 2.0 * h * t1 * x2 + h * t1 * x;
    }

    private static double diff(double h, double x, double y1, double y2, double t1, double t2) {
        double x2 = x * x;
        return -6.0 * x2 * y2 + 6.0 * x * y2 + 6.0 * x2 * y1 - 6.0 * x * y1 + 3.0 * h * t2 * x2 + 3.0 * h * t1 * x2 - 2.0 * h * t2 * x - 4.0 * h * t1 * x + h * t1;
    }

    public static double dumbLength(MonotoneSpline m, double delta) {
        double sum = 0.0;
        double last_x = 0.0;
        double last_y = 0.0;
        float t = 0.0f;
        while (t <= 1.0f) {
            double x = m.getPos((double)t, 0);
            double y = m.getPos((double)t, 1);
            if (t > 0.0f) {
                sum += Math.hypot(x - last_x, y - last_y);
            }
            last_x = x;
            last_y = y;
            t = (float)((double)t + delta);
        }
        System.out.println("dum sum = " + sum);
        return sum;
    }
}

