/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.Track;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.BaseCreateKey;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MeModel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class CreateKeyPosition
extends BaseCreateKey {
    public static final boolean DEBUG = false;
    static String TITLE = "Create ConstraintSet";
    private static final String KEY_TAG = "KeyPosition";
    private final JTextField mPosition;
    private final JComboBox<String> mType;
    protected final JTextField mPercentX;
    protected final JTextField mPercentY;
    private final String POS_PROMPT = "0-100";
    private final String PERCENT_PROMPT = "float";
    String[] options = new String[]{"deltaRelative", "pathRelative", "parentRelative"};
    JComboBox<String> comboBox = MEUI.makeComboBox(this.options);
    MTag mKeyFrameSet;
    private MTag mSelectedTransition;

    public CreateKeyPosition() {
        this.icon = MEIcons.CREATE_TRANSITION;
        GridBagConstraints gbc = new GridBagConstraints();
        int y = this.createTop(gbc, "CREATE KEY POSITION");
        CreateKeyPosition.grid(gbc, 0, y++, 2, 1);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogSeparatorInsets();
        gbc.anchor = 10;
        this.add((Component)new JSeparator(), gbc);
        CreateKeyPosition.grid(gbc, 0, y++, 2, 1);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("Position"), gbc);
        CreateKeyPosition.grid(gbc, 0, y++, 2, 1);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.mPosition = this.newTextField("0-100", 15);
        this.add((Component)this.mPosition, gbc);
        CreateKeyPosition.grid(gbc, 0, y++, 2, 1);
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("Type"), gbc);
        CreateKeyPosition.grid(gbc, 0, y++, 2, 1);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.mType = this.comboBox;
        this.add(this.mType, gbc);
        CreateKeyPosition.grid(gbc, 0, y++, 2, 1);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("PercentX"), gbc);
        CreateKeyPosition.grid(gbc, 0, y++, 2, 1);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.mPercentX = this.newTextField("float", 15);
        this.add((Component)this.mPercentX, gbc);
        CreateKeyPosition.grid(gbc, 0, y++, 2, 1);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("PercentY"), gbc);
        CreateKeyPosition.grid(gbc, 0, y++, 2, 1);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.mPercentY = this.newTextField("float", 15);
        this.add((Component)this.mPercentY, gbc);
        gbc.weighty = 1.0;
        CreateKeyPosition.grid(gbc, 0, y++, 2, 1);
        this.add((Component)new JComponent(){}, gbc);
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.insets = MEUI.dialogBottomButtonInsets();
        gbc.anchor = 14;
        CreateKeyPosition.grid(gbc, 0, y++, 2, 1);
        JButton ok = new JButton("Add");
        this.add((Component)ok, gbc);
        ok.addActionListener(e -> this.create());
    }

    @Override
    protected boolean populateDialog() {
        MTag[] mtags;
        MeModel model2 = this.mMotionEditor.getMeModel();
        this.populateTags(model2.getLayoutViewNames());
        MotionEditorSelector.Type selectionType = model2.getSelectedType();
        if (selectionType == null) {
            return false;
        }
        MTag[] selected = model2.getSelected();
        switch (selectionType) {
            case KEY_FRAME: 
            case KEY_FRAME_GROUP: {
                this.mKeyFrameSet = selected[0].getParent();
                this.mMatchTag.setText(selected[0].getAttributeValue("motionTarget"));
                String type = selected[0].getAttributeValue("keyPositionType");
                for (int i = 0; i < this.options.length; ++i) {
                    if (!this.options[i].equals(type)) continue;
                    this.mType.setSelectedIndex(i);
                }
                break;
            }
            case TRANSITION: {
                MTag[] tag = selected[0].getChildTags("KeyFrameSet");
                if (tag != null && tag.length > 0) {
                    this.mKeyFrameSet = tag[0];
                }
                this.mSelectedTransition = selected[0];
            }
        }
        float pos = model2.getCurrentProgress();
        if (!Float.isNaN(pos)) {
            this.mPosition.setText(Integer.toString((int)(pos * 100.0f)));
        }
        if ((mtags = model2.motionScene.getChildTags("ConstraintSet")).length < 2) {
            this.showPreconditionDialog("Transition must at least 2 ConstraintSets to create a Transition");
            return false;
        }
        return true;
    }

    @Override
    public MTag create() {
        String yStr;
        MTag.TagWriter keyPosition;
        MTag.TagWriter toCommit;
        String tag = this.getMotionTarget();
        if (this.mKeyFrameSet == null) {
            toCommit = this.mSelectedTransition.getChildTagWriter("KeyFrameSet");
            this.mKeyFrameSet = toCommit;
            keyPosition = this.mKeyFrameSet.getChildTagWriter(KEY_TAG);
        } else {
            toCommit = keyPosition = this.mKeyFrameSet.getChildTagWriter(KEY_TAG);
        }
        String pos = this.mPosition.getText();
        if (pos.trim().length() == 0 || pos.equals("0-100")) {
            this.showErrorDialog("Must define the position of the view");
            return null;
        }
        keyPosition.setAttribute("motion", "motionTarget", tag);
        try {
            int posInt = Integer.parseInt(pos.trim());
            keyPosition.setAttribute("motion", "framePosition", pos.trim());
        }
        catch (Exception ex) {
            this.showErrorDialog("was not able to parse \"" + pos.trim() + "\"");
            return null;
        }
        keyPosition.setAttribute("motion", "keyPositionType", (String)this.mType.getSelectedItem());
        String xStr = this.mPercentX.getText().trim();
        if (xStr.length() > 0 && !xStr.equals("float")) {
            try {
                float f = Float.parseFloat(xStr);
                keyPosition.setAttribute("motion", "percentX", xStr);
            }
            catch (NumberFormatException ex) {
                this.showErrorDialog("was not able to parse \"" + xStr + "\"");
            }
        }
        if ((yStr = this.mPercentY.getText().trim()).length() > 0 && !yStr.equals("float")) {
            try {
                float f = Float.parseFloat(yStr);
                keyPosition.setAttribute("motion", "percentY", yStr);
            }
            catch (NumberFormatException ex) {
                this.showErrorDialog("was not able to parse \"" + yStr + "\"");
            }
        }
        MTag ret = toCommit.commit("Create KeyPosition");
        Track.createKeyPosition(this.mMotionEditor.myTrack);
        this.mMotionEditor.dataChanged();
        super.create();
        return ret;
    }

    @Override
    public String getName() {
        return KEY_TAG;
    }
}

