/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MotionSceneAttrs;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.Track;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.BaseCreateKey;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MeModel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class CreateKeyCycle
extends BaseCreateKey {
    String mTitle = "CREATE KEY CYCLE";
    protected String KEY_TAG = "KeyCycle";
    protected MTag mKeyFrameSet;
    protected JTextField mPosition;
    private MTag mSelectedTransition;
    private final String POS_PROMPT = "0-100";
    private JTextField mWavePeriod;
    static String TITLE = "Create KeyCycle";
    String[] attributeOptions = MotionSceneAttrs.KeyAttributeOptions;
    String[] optionsNameSpace = MotionSceneAttrs.KeyAttributeOptionsNameSpace;
    HashMap<String, MTag> myCustomTypes = new HashMap();
    JComboBox<String> attribute = MEUI.makeComboBox(this.attributeOptions);
    String[] waveShapeOptions = new String[]{"sin", "square", "triangle", "sawtooth", "reverseSawtooth", "cos", "bounce"};
    JComboBox<String> waveShape = MEUI.makeComboBox(this.waveShapeOptions);

    public CreateKeyCycle(String title) {
        this.mTitle = title;
        this.setup();
    }

    public CreateKeyCycle() {
        this.setup();
    }

    private void setup() {
        this.icon = MEIcons.CREATE_TRANSITION;
        GridBagConstraints gbc = new GridBagConstraints();
        int y = this.createTop(gbc, this.mTitle);
        CreateKeyCycle.grid(gbc, 0, y++, 2, 1);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogSeparatorInsets();
        gbc.anchor = 10;
        this.add((Component)new JSeparator(), gbc);
        CreateKeyCycle.grid(gbc, 0, y++, 2, 1);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("Position"), gbc);
        CreateKeyCycle.grid(gbc, 0, y++, 2, 1);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.mPosition = this.newTextField("0-100", 15);
        this.add((Component)this.mPosition, gbc);
        CreateKeyCycle.grid(gbc, 0, y++, 2, 1);
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("Wave Shape"), gbc);
        CreateKeyCycle.grid(gbc, 0, y++, 2, 1);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.add(this.waveShape, gbc);
        CreateKeyCycle.grid(gbc, 0, y++, 2, 1);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("Wave Period"), gbc);
        CreateKeyCycle.grid(gbc, 0, y++, 2, 1);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.mWavePeriod = this.newTextField("1", 15);
        this.add((Component)this.mWavePeriod, gbc);
        CreateKeyCycle.grid(gbc, 0, y++, 2, 1);
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("Attribute to cycle"), gbc);
        CreateKeyCycle.grid(gbc, 0, y++, 2, 1);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.add(this.attribute, gbc);
        gbc.weighty = 1.0;
        CreateKeyCycle.grid(gbc, 0, y++, 2, 1);
        this.add((Component)new JComponent(){}, gbc);
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.insets = MEUI.dialogBottomButtonInsets();
        gbc.anchor = 14;
        CreateKeyCycle.grid(gbc, 0, y++, 2, 1);
        JButton ok = new JButton("Add");
        this.add((Component)ok, gbc);
        ok.addActionListener(e -> this.create());
    }

    @Override
    protected boolean populateDialog() {
        MTag[] mtags;
        MeModel model2 = this.mMotionEditor.getMeModel();
        this.populateTags(model2.getLayoutViewNames());
        MotionEditorSelector.Type selectionType = model2.getSelectedType();
        if (selectionType == null) {
            return false;
        }
        MTag[] selected = model2.getSelected();
        MTag start = model2.findStartConstraintSet(selected[0]);
        MTag end = model2.findEndConstraintSet(selected[0]);
        ArrayList<MTag> csets = new ArrayList<MTag>();
        for (MTag tag : start.getChildTags()) {
            csets.addAll(Arrays.asList(tag.getChildTags("CustomAttribute")));
        }
        for (MTag tag : end.getChildTags()) {
            csets.addAll(Arrays.asList(tag.getChildTags("CustomAttribute")));
        }
        this.myCustomTypes.clear();
        for (MTag cset : csets) {
            String str = cset.getAttributeValue("attributeName");
            String value2 = cset.getAttributeValue("customFloatValue");
            if (value2 == null) continue;
            this.myCustomTypes.put(str, cset);
        }
        if (!this.myCustomTypes.isEmpty()) {
            this.attribute.removeAllItems();
            for (String option : this.attributeOptions) {
                this.attribute.addItem(option);
            }
            for (String s : this.myCustomTypes.keySet()) {
                this.attribute.addItem("Custom:" + s);
            }
        }
        block0 : switch (selectionType) {
            case KEY_FRAME: 
            case KEY_FRAME_GROUP: {
                this.mKeyFrameSet = selected[0].getParent();
                this.mMatchTag.setText(selected[0].getAttributeValue("motionTarget"));
                String wavePeriod = selected[0].getAttributeValue("wavePeriod");
                for (int i = 0; i < this.attributeOptions.length; ++i) {
                    String str = selected[0].getAttributeValue(this.attributeOptions[i]);
                    if (str == null) continue;
                    this.attribute.setSelectedIndex(i);
                    break block0;
                }
                break;
            }
            case TRANSITION: {
                MTag[] tag = selected[0].getChildTags("KeyFrameSet");
                if (tag != null && tag.length > 0) {
                    this.mKeyFrameSet = tag[0];
                }
                this.mSelectedTransition = selected[0];
            }
        }
        float pos = model2.getCurrentProgress();
        if (!Float.isNaN(pos)) {
            this.mPosition.setText(Integer.toString((int)(pos * 100.0f)));
        }
        if ((mtags = model2.motionScene.getChildTags("ConstraintSet")).length < 2) {
            this.showPreconditionDialog("Transition must at least 2 ConstraintSets to create a Transition");
            return false;
        }
        return true;
    }

    @Override
    public MTag create() {
        int index;
        MTag.TagWriter keyPosition;
        MTag.TagWriter toCommit;
        if (this.mKeyFrameSet == null) {
            toCommit = this.mSelectedTransition.getChildTagWriter("KeyFrameSet");
            this.mKeyFrameSet = toCommit;
            keyPosition = this.mKeyFrameSet.getChildTagWriter(this.KEY_TAG);
        } else {
            toCommit = keyPosition = this.mKeyFrameSet.getChildTagWriter(this.KEY_TAG);
        }
        String pos = this.mPosition.getText();
        if (pos.trim().length() == 0 || pos.equals("0-100")) {
            this.showErrorDialog("Must define the position of the view");
            return null;
        }
        keyPosition.setAttribute("motion", "motionTarget", this.getMotionTarget());
        try {
            int posInt = Integer.parseInt(pos.trim());
            keyPosition.setAttribute("motion", "framePosition", pos.trim());
        }
        catch (Exception ex) {
            this.showErrorDialog("was not able to parse \"" + pos.trim() + "\"");
            return null;
        }
        keyPosition.setAttribute("motion", "wavePeriod", this.mWavePeriod.getText());
        if (this.waveShape.getSelectedIndex() != 0) {
            keyPosition.setAttribute("motion", "waveShape", (String)this.waveShape.getSelectedItem());
        }
        if ((index = this.attribute.getSelectedIndex()) < MotionSceneAttrs.KeyCycleOptionsDefaultValue.length) {
            String value2 = MotionSceneAttrs.KeyCycleOptionsDefaultValue[index];
            keyPosition.setAttribute(this.optionsNameSpace[index], (String)this.attribute.getSelectedItem(), value2);
            String offset2 = MotionSceneAttrs.KeyCycleOptionsDefaultOffset[index];
            keyPosition.setAttribute("motion", "waveOffset", offset2);
        } else {
            String item = (String)this.attribute.getSelectedItem();
            if (item.startsWith("Custom:")) {
                String name = item.substring("Custom:".length());
                MTag copyFromTag = this.myCustomTypes.get(name);
                MTag.TagWriter customTag = toCommit.getChildTagWriter("CustomAttribute");
                for (MTag.Attribute value3 : copyFromTag.getAttrList().values()) {
                    customTag.setAttribute(value3.mNamespace, value3.mAttribute, value3.mValue);
                }
            }
        }
        MTag ret = toCommit.commit("Create KeyCycle");
        if (this.KEY_TAG.equals("KeyTimeCycle")) {
            Track.createKeyTimeCycle(this.mMotionEditor.myTrack);
        } else {
            Track.createKeyCycle(this.mMotionEditor.myTrack);
        }
        this.mMotionEditor.dataChanged();
        super.create();
        return ret;
    }

    @Override
    public String getName() {
        return "KeyCycle";
    }
}

