/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MotionSceneAttrs;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.Track;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.BaseCreateKey;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MeModel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class CreateKeyAttribute
extends BaseCreateKey {
    private static final String KEY_TAG = "KeyAttribute";
    static String TITLE = "Create ConstraintSet";
    String[] options = MotionSceneAttrs.KeyAttributeOptions;
    String[] optionsNameSpace = MotionSceneAttrs.KeyAttributeOptionsNameSpace;
    HashMap<String, MTag> myCustomTypes = new HashMap();
    static final String CUSTOM = "Custom:";
    JComboBox<String> comboBox = MEUI.makeComboBox(this.options);
    private final JTextField mPosition;
    MTag mKeyFrameSet;
    private MTag mSelectedTransition;
    private final String POS_PROMPT = "0-100";

    public CreateKeyAttribute() {
        this.icon = MEIcons.CREATE_TRANSITION;
        GridBagConstraints gbc = new GridBagConstraints();
        int y = this.createTop(gbc, "CREATE KEY ATTRIBUTE");
        CreateKeyAttribute.grid(gbc, 0, y++, 2, 1);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogSeparatorInsets();
        gbc.anchor = 10;
        this.add((Component)new JSeparator(), gbc);
        CreateKeyAttribute.grid(gbc, 0, y++, 2, 1);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("Position"), gbc);
        CreateKeyAttribute.grid(gbc, 0, y++, 2, 1);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.mPosition = this.newTextField("0-100", 15);
        this.add((Component)this.mPosition, gbc);
        CreateKeyAttribute.grid(gbc, 0, y++, 2, 1);
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("Attribute"), gbc);
        CreateKeyAttribute.grid(gbc, 0, y++, 2, 1);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.add(this.comboBox, gbc);
        gbc.weighty = 1.0;
        CreateKeyAttribute.grid(gbc, 0, y++, 2, 1);
        this.add((Component)new JComponent(){}, gbc);
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.insets = MEUI.dialogBottomButtonInsets();
        gbc.anchor = 14;
        CreateKeyAttribute.grid(gbc, 0, y++, 2, 1);
        JButton ok = new JButton("Add");
        this.add((Component)ok, gbc);
        ok.addActionListener(e -> this.create());
    }

    @Override
    protected boolean populateDialog() {
        MTag[] mtags;
        MeModel model2 = this.mMotionEditor.getMeModel();
        this.populateTags(model2.getLayoutViewNames());
        MotionEditorSelector.Type selectionType = model2.getSelectedType();
        if (selectionType == null) {
            return false;
        }
        MTag[] selected = model2.getSelected();
        MTag start = model2.findStartConstraintSet(selected[0]);
        MTag end = model2.findEndConstraintSet(selected[0]);
        ArrayList<MTag> csets = new ArrayList<MTag>();
        if (start != null) {
            for (MTag mTag : start.getChildTags()) {
                csets.addAll(Arrays.asList(mTag.getChildTags("CustomAttribute")));
            }
        }
        if (end != null) {
            for (MTag mTag : end.getChildTags()) {
                csets.addAll(Arrays.asList(mTag.getChildTags("CustomAttribute")));
            }
        }
        this.myCustomTypes.clear();
        for (MTag cset : csets) {
            String str = cset.getAttributeValue("attributeName");
            this.myCustomTypes.put(str, cset);
        }
        this.comboBox.removeAllItems();
        for (String string2 : this.options) {
            this.comboBox.addItem(string2);
        }
        for (String s : this.myCustomTypes.keySet()) {
            this.comboBox.addItem(CUSTOM + s);
        }
        block0 : switch (selectionType) {
            case KEY_FRAME: 
            case KEY_FRAME_GROUP: {
                this.mKeyFrameSet = selected[0].getParent();
                this.mMatchTag.setText(selected[0].getAttributeValue("motionTarget"));
                for (int i = 0; i < this.options.length; ++i) {
                    String str = selected[0].getAttributeValue(this.options[i]);
                    System.out.println(str + " = " + this.options[i]);
                    if (str == null) continue;
                    this.comboBox.setSelectedIndex(i);
                    break block0;
                }
                break;
            }
            case TRANSITION: {
                MTag[] tag = selected[0].getChildTags("KeyFrameSet");
                if (tag != null && tag.length > 0) {
                    this.mKeyFrameSet = tag[0];
                }
                this.mSelectedTransition = selected[0];
            }
        }
        float pos = model2.getCurrentProgress();
        if (!Float.isNaN(pos)) {
            this.mPosition.setText(Integer.toString((int)(pos * 100.0f)));
        }
        if ((mtags = model2.motionScene.getChildTags("ConstraintSet")).length < 2) {
            this.showPreconditionDialog("Transition must at least 2 ConstraintSets to create a Transition");
            return false;
        }
        return true;
    }

    @Override
    public MTag create() {
        MTag.TagWriter keyPosition;
        MTag.TagWriter toCommit;
        if (this.mKeyFrameSet == null) {
            toCommit = this.mSelectedTransition.getChildTagWriter("KeyFrameSet");
            this.mKeyFrameSet = toCommit;
            keyPosition = this.mKeyFrameSet.getChildTagWriter(KEY_TAG);
        } else {
            toCommit = keyPosition = this.mKeyFrameSet.getChildTagWriter(KEY_TAG);
        }
        String pos = this.mPosition.getText();
        if (pos.trim().length() == 0 || pos.equals("0-100")) {
            this.showErrorDialog("Must define the position of the view");
            return null;
        }
        keyPosition.setAttribute("motion", "motionTarget", this.getMotionTarget());
        try {
            int posInt = Integer.parseInt(pos.trim());
            keyPosition.setAttribute("motion", "framePosition", pos.trim());
        }
        catch (Exception ex) {
            this.showErrorDialog("was not able to parse \"" + pos.trim() + "\"");
            return null;
        }
        int index = this.comboBox.getSelectedIndex();
        if (index < MotionSceneAttrs.KeyAttributeOptionsDefaultValue.length) {
            String value2 = MotionSceneAttrs.KeyAttributeOptionsDefaultValue[index];
            keyPosition.setAttribute(this.optionsNameSpace[index], (String)this.comboBox.getSelectedItem(), value2);
        } else {
            String item = (String)this.comboBox.getSelectedItem();
            if (item.startsWith(CUSTOM)) {
                String name = item.substring(CUSTOM.length());
                MTag copyFromTag = this.myCustomTypes.get(name);
                MTag.TagWriter customTag = toCommit.getChildTagWriter("CustomAttribute");
                for (MTag.Attribute value3 : copyFromTag.getAttrList().values()) {
                    customTag.setAttribute(value3.mNamespace, value3.mAttribute, value3.mValue);
                }
            }
        }
        MTag ret = toCommit.commit("Create KeyAttribute");
        Track.createKeyAttribute(this.mMotionEditor.myTrack);
        this.mMotionEditor.dataChanged();
        super.create();
        return ret;
    }

    @Override
    public String getName() {
        return KEY_TAG;
    }
}

