/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion;

import android.view.View;
import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.handlers.motion.Debug;
import com.android.tools.idea.uibuilder.handlers.motion.MotionUtils;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.utils.Pair;
import com.intellij.openapi.module.Module;
import com.intellij.util.ArrayUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;

public class MotionLayoutComponentHelper {
    private static final boolean USE_MOTIONLAYOUT_HELPER_CACHE = true;
    private InvokeMethod myGetKeyframeAtLocation;
    private InvokeMethod myGetKeyframe;
    private Method myCallSetTransitionPosition;
    private Method myCallSetState;
    private Method myCallGetState;
    private Method myCallGetStartState;
    private Method myCallGetEndState;
    private Method myCallDisableAutoTransition;
    private Method myCallGetProgress;
    private Method myCallSetTransition;
    private Method myGetMaxTimeMethod;
    private Method mySetKeyframePositionMethod;
    private Method motionLayoutAccess;
    private Method mySetAttributesMethod;
    private Method myGetKeyframeMethod;
    private Method myGetKeyFramePositionsMethod;
    private Method myGetKeyFrameInfoMethod;
    private Method mySetKeyframeMethod;
    private Method myGetPositionKeyframeMethod;
    private Method myGetKeyframeAtLocationMethod;
    private Method myCallIsInTransition;
    private Method myUpdateLiveAttributesMethod;
    private Method myGetAnimationPathMethod;
    public static final int PATH_PERCENT = 0;
    public static final int PATH_PERPENDICULAR = 1;
    public static final int HORIZONTAL_PATH_X = 2;
    public static final int HORIZONTAL_PATH_Y = 3;
    public static final int VERTICAL_PATH_X = 4;
    public static final int VERTICAL_PATH_Y = 5;
    private Object myDesignTool;
    private final NlComponent myMotionLayoutComponent;
    private final boolean DEBUG = false;
    private static boolean mShowPaths = true;
    private CompletableFuture<Void> myFuture;
    private HashMap<String, float[]> myCachedPath;
    private boolean myCachedPositionKeyframe;
    private String myCachedState;
    private String myCachedStartState;
    private String myCachedEndState;
    private float myCachedProgress;
    private boolean myCachedIsInTransition;
    private long myCachedMaxTimeMs;
    private HashMap<String, KeyframePos> myCachedKeyframePos;
    private HashMap<String, KeyframeInfo> myCachedKeyframeInfo;
    static WeakHashMap<NlComponent, MotionLayoutComponentHelper> sCache = new WeakHashMap();

    public static void clearCache() {
        sCache.clear();
    }

    public static MotionLayoutComponentHelper create(@NotNull NlComponent component) {
        MotionLayoutComponentHelper helper;
        if (component == null) {
            MotionLayoutComponentHelper.$$$reportNull$$$0(0);
        }
        if ((helper = sCache.get(component)) == null) {
            helper = new MotionLayoutComponentHelper(component);
            sCache.put(component, helper);
        }
        return helper;
    }

    private MotionLayoutComponentHelper(@NotNull NlComponent component) {
        ViewInfo info;
        if (component == null) {
            MotionLayoutComponentHelper.$$$reportNull$$$0(1);
        }
        this.myGetKeyframeAtLocation = new InvokeMethod("getKeyframeAtLocation", Object.class, Float.TYPE, Float.TYPE);
        this.myGetKeyframe = new InvokeMethod("getKeyframe", Object.class, Integer.TYPE, Integer.TYPE);
        this.DEBUG = false;
        this.myCachedPath = new HashMap();
        this.myCachedPositionKeyframe = false;
        this.myCachedState = null;
        this.myCachedStartState = null;
        this.myCachedEndState = null;
        this.myCachedProgress = 0.0f;
        this.myCachedIsInTransition = false;
        this.myCachedMaxTimeMs = 0L;
        this.myCachedKeyframePos = new HashMap();
        this.myCachedKeyframeInfo = new HashMap();
        component = MotionUtils.getMotionLayoutAncestor(component);
        ViewInfo viewInfo = info = component != null ? NlComponentHelperKt.getViewInfo(component) : null;
        if (info == null) {
            this.myDesignTool = null;
            this.myMotionLayoutComponent = null;
            return;
        }
        Object instance = info.getViewObject();
        if (instance == null) {
            this.myDesignTool = null;
            this.myMotionLayoutComponent = null;
            return;
        }
        try {
            Method accessor = instance.getClass().getMethod("getDesignTool", new Class[0]);
            if (accessor != null) {
                try {
                    this.myFuture = RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> this.getDesignInstance(accessor, instance));
                }
                catch (Exception exception) {}
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.myMotionLayoutComponent = component;
    }

    private void getDesignInstance(Method accessor, Object instance) {
        try {
            this.myDesignTool = accessor.invoke(instance, new Object[0]);
            this.myGetKeyframeAtLocation.update(this.myDesignTool);
            this.myGetKeyframe.update(this.myDesignTool);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public int getPath(NlComponent nlComponent, float[] path, int size) {
        float[] tmpPath = this.myCachedPath.get(nlComponent.getId());
        this.cachedGetPath(nlComponent, path, size);
        if (tmpPath != null) {
            System.arraycopy(tmpPath, 0, path, 0, tmpPath.length);
            return tmpPath.length;
        }
        return -1;
    }

    private boolean isMyDesignToolAvailable() {
        if (this.myDesignTool == null) {
            if (this.myFuture != null) {
                try {
                    this.myFuture.get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            if (this.myDesignTool == null) {
                return false;
            }
        }
        return true;
    }

    private void cachedGetPath(NlComponent nlComponent, float[] path, int size) {
        if (!this.isMyDesignToolAvailable()) {
            return;
        }
        if (this.myGetAnimationPathMethod == null) {
            try {
                Method[] methods = this.myDesignTool.getClass().getMethods();
                this.myGetAnimationPathMethod = this.myDesignTool.getClass().getMethod("getAnimationPath", Object.class, float[].class, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        if (this.myGetAnimationPathMethod != null) {
            try {
                RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
                    try {
                        ViewInfo info = NlComponentHelperKt.getViewInfo(nlComponent);
                        if (info == null) {
                            return;
                        }
                        this.myGetAnimationPathMethod.invoke(this.myDesignTool, info.getViewObject(), path, size);
                        this.myCachedPath.put(nlComponent.getId(), path);
                        return;
                    }
                    catch (Exception e) {
                        this.myGetAnimationPathMethod = null;
                        e.printStackTrace();
                        return;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Object getKeyframeAtLocation(Object view, float x, float y) {
        return this.myGetKeyframeAtLocation.invoke(view, Float.valueOf(x), Float.valueOf(y));
    }

    public Object getKeyframe(Object view, int type, int position) {
        return this.myGetKeyframe.invoke(view, type, position);
    }

    public Object __getKeyframeAtLocation(Object view, float x, float y) {
        if (this.myDesignTool == null) {
            return null;
        }
        if (this.myGetKeyframeAtLocationMethod == null) {
            try {
                this.myGetKeyframeAtLocationMethod = this.myDesignTool.getClass().getMethod("getKeyframeAtLocation", Object.class, Float.TYPE, Float.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (this.myGetKeyframeAtLocationMethod != null) {
            try {
                return RenderService.runRenderAction(() -> {
                    try {
                        return this.myGetKeyframeAtLocationMethod.invoke(this.myDesignTool, view, Float.valueOf(x), Float.valueOf(y));
                    }
                    catch (Exception e) {
                        this.myGetKeyframeAtLocationMethod = null;
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean getPositionKeyframe(Object keyframe, Object view, float x, float y, String[] attributes, float[] values2) {
        this.cachedGetPositionKeyframe(keyframe, view, x, y, attributes, values2);
        return this.myCachedPositionKeyframe;
    }

    private void cachedGetPositionKeyframe(Object keyframe, Object view, float x, float y, String[] attributes, float[] values2) {
        if (!this.isMyDesignToolAvailable()) {
            return;
        }
        if (this.myGetPositionKeyframeMethod == null) {
            try {
                this.myGetPositionKeyframeMethod = this.myDesignTool.getClass().getMethod("getPositionKeyframe", Object.class, Object.class, Float.TYPE, Float.TYPE, String[].class, float[].class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (this.myGetPositionKeyframeMethod != null) {
            try {
                RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
                    try {
                        this.myCachedPositionKeyframe = this.myGetPositionKeyframeMethod.invoke(this.myDesignTool, keyframe, view, Float.valueOf(x), Float.valueOf(y), attributes, values2) == Boolean.TRUE;
                    }
                    catch (Exception e) {
                        this.myGetPositionKeyframeMethod = null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Object __getKeyframe(int type, int target, int position) {
        if (this.myDesignTool == null) {
            return null;
        }
        if (this.myGetKeyframeMethod == null) {
            try {
                this.myGetKeyframeMethod = this.myDesignTool.getClass().getMethod("getKeyframe", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (this.myGetKeyframeMethod != null) {
            try {
                return RenderService.runRenderAction(() -> {
                    try {
                        return this.myGetKeyframeMethod.invoke(this.myDesignTool, type, target, position);
                    }
                    catch (Exception e) {
                        this.myGetKeyframeMethod = null;
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setKeyframe(Object keyframe, String tag, Object value2) {
        if (!this.isMyDesignToolAvailable()) {
            return;
        }
        if (this.mySetKeyframeMethod == null) {
            try {
                this.mySetKeyframeMethod = this.myDesignTool.getClass().getMethod("setKeyframe", Object.class, String.class, Object.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (this.mySetKeyframeMethod != null) {
            try {
                RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
                    try {
                        this.mySetKeyframeMethod.invoke(this.myDesignTool, keyframe, tag, value2);
                    }
                    catch (Exception e) {
                        this.mySetKeyframeMethod = null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setAttributes(int dpiValue, String constraintSetId, Object view, Object attributes) {
        if (!this.isMyDesignToolAvailable()) {
            return;
        }
        if (this.mySetAttributesMethod == null) {
            try {
                this.mySetAttributesMethod = this.myDesignTool.getClass().getMethod("setAttributes", Integer.TYPE, String.class, Object.class, Object.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (this.mySetAttributesMethod != null) {
            try {
                RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
                    try {
                        this.mySetAttributesMethod.invoke(this.myDesignTool, dpiValue, constraintSetId, view, attributes);
                    }
                    catch (Exception e) {
                        this.mySetAttributesMethod = null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    boolean __setKeyframePosition(Object view, int position, int type, float x, float y) {
        if (this.myDesignTool == null) {
            return false;
        }
        if (this.mySetKeyframePositionMethod == null) {
            try {
                this.mySetKeyframePositionMethod = this.myDesignTool.getClass().getMethod("setKeyFramePosition", Object.class, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        boolean[] didUpdate = new boolean[]{false};
        if (this.mySetKeyframePositionMethod != null) {
            try {
                RenderService.runRenderAction(() -> {
                    try {
                        didUpdate[0] = (Boolean)this.mySetKeyframePositionMethod.invoke(this.myDesignTool, view, position, type, Float.valueOf(x), Float.valueOf(y));
                        NlModel model2 = this.myMotionLayoutComponent.getModel();
                        model2.notifyLiveUpdate(false);
                    }
                    catch (Exception e) {
                        this.mySetKeyframePositionMethod = null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return didUpdate[0];
    }

    private boolean setTransitionPosition(float position) {
        if (!this.isMyDesignToolAvailable()) {
            return false;
        }
        if (this.myCallSetTransitionPosition == null) {
            try {
                this.myCallSetTransitionPosition = this.myDesignTool.getClass().getMethod("setToolPosition", Float.TYPE);
            }
            catch (NoSuchMethodException e) {
                this.myCallSetTransitionPosition = null;
                return false;
            }
        }
        if (this.myCallSetTransitionPosition != null) {
            try {
                RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
                    try {
                        this.myCallSetTransitionPosition.invoke(this.myDesignTool, Float.valueOf(position));
                    }
                    catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                        this.myCallSetTransitionPosition = null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.myCallSetTransitionPosition != null;
    }

    public boolean setProgress(float value2) {
        if (!this.isMyDesignToolAvailable()) {
            return false;
        }
        NlModel model2 = this.myMotionLayoutComponent.getModel();
        if (!this.setTransitionPosition(value2)) {
            return false;
        }
        model2.notifyLiveUpdate(false);
        MotionLayoutComponentHelper.refresh(this.myMotionLayoutComponent);
        return true;
    }

    public void setTransition(String start, String end) {
        if (!this.isMyDesignToolAvailable()) {
            return;
        }
        if (this.myCallSetTransition == null) {
            this.disableAutoTransition(true);
            try {
                this.myCallSetTransition = this.myDesignTool.getClass().getMethod("setTransition", String.class, String.class);
            }
            catch (NoSuchMethodException e) {
                this.myCallSetTransition = null;
                return;
            }
        }
        if (this.myCallSetTransition != null) {
            try {
                RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
                    try {
                        this.myCallSetTransition.invoke(this.myDesignTool, start, end);
                    }
                    catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                        this.myCallSetTransition = null;
                    }
                });
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.myCallSetTransition == null) {
            return;
        }
        NlModel model2 = this.myMotionLayoutComponent.getModel();
        model2.notifyLiveUpdate(false);
    }

    public void setState(String state) {
        if (!this.isMyDesignToolAvailable()) {
            return;
        }
        if (this.myCallSetState == null) {
            try {
                this.myCallSetState = this.myDesignTool.getClass().getMethod("setState", String.class);
            }
            catch (NoSuchMethodException e) {
                this.myCallSetState = null;
                return;
            }
        }
        if (this.myCallSetState != null) {
            try {
                RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
                    try {
                        this.myCallSetState.invoke(this.myDesignTool, state);
                    }
                    catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                        this.myCallSetState = null;
                    }
                });
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.myCallSetState == null) {
            return;
        }
        NlModel model2 = this.myMotionLayoutComponent.getModel();
        model2.notifyLiveUpdate(false);
    }

    public void disableAutoTransition(boolean disable) {
        if (!this.isMyDesignToolAvailable()) {
            return;
        }
        if (this.myCallDisableAutoTransition == null) {
            try {
                this.myCallDisableAutoTransition = this.myDesignTool.getClass().getMethod("disableAutoTransition", Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                this.myCallDisableAutoTransition = null;
                return;
            }
        }
        if (this.myCallDisableAutoTransition != null) {
            try {
                RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
                    try {
                        this.myCallDisableAutoTransition.invoke(this.myDesignTool, disable);
                    }
                    catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                        this.myCallDisableAutoTransition = null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getState() {
        this.cachedGetState();
        return this.myCachedState;
    }

    private void cachedGetState() {
        if (!this.isMyDesignToolAvailable()) {
            return;
        }
        if (this.myCallGetState == null) {
            try {
                this.myCallGetState = this.myDesignTool.getClass().getMethod("getState", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.myCallGetState = null;
                return;
            }
        }
        if (this.myCallGetState != null) {
            try {
                RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
                    try {
                        this.myCachedState = (String)this.myCallGetState.invoke(this.myDesignTool, new Object[0]);
                    }
                    catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                        this.myCallSetState = null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getStartState() {
        this.cachedGetStartState();
        return this.myCachedStartState;
    }

    private void cachedGetStartState() {
        if (!this.isMyDesignToolAvailable()) {
            return;
        }
        if (this.myCallGetStartState == null) {
            try {
                this.myCallGetStartState = this.myDesignTool.getClass().getMethod("getStartState", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.myCallGetStartState = null;
                return;
            }
        }
        if (this.myCallGetStartState != null) {
            try {
                RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
                    try {
                        this.myCachedStartState = (String)this.myCallGetStartState.invoke(this.myDesignTool, new Object[0]);
                    }
                    catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                        this.myCallGetStartState = null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getEndState() {
        this.cachedGetEndState();
        return this.myCachedEndState;
    }

    private void cachedGetEndState() {
        if (!this.isMyDesignToolAvailable()) {
            return;
        }
        if (this.myCallGetEndState == null) {
            try {
                this.myCallGetEndState = this.myDesignTool.getClass().getMethod("getEndState", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.myCallGetEndState = null;
                return;
            }
        }
        if (this.myCallGetEndState != null) {
            try {
                RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
                    try {
                        this.myCachedEndState = (String)this.myCallGetEndState.invoke(this.myDesignTool, new Object[0]);
                    }
                    catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                        this.myCallGetEndState = null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public float getProgress() {
        this.cachedGetProgress();
        return this.myCachedProgress;
    }

    private void cachedGetProgress() {
        if (!this.isMyDesignToolAvailable()) {
            return;
        }
        if (this.myCallGetProgress == null) {
            try {
                this.myCallGetProgress = this.myDesignTool.getClass().getMethod("getProgress", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.myCallGetProgress = null;
                return;
            }
        }
        if (this.myCallGetProgress != null) {
            try {
                RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
                    try {
                        this.myCachedProgress = ((Float)this.myCallGetProgress.invoke(this.myDesignTool, new Object[0])).floatValue();
                    }
                    catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                        this.myCallGetProgress = null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isInTransition() {
        this.cachedIsInTransition();
        return this.myCachedIsInTransition;
    }

    private void cachedIsInTransition() {
        if (!this.isMyDesignToolAvailable()) {
            return;
        }
        if (this.myCallIsInTransition == null) {
            try {
                this.myCallIsInTransition = this.myDesignTool.getClass().getMethod("isInTransition", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.myCallIsInTransition = null;
                return;
            }
        }
        if (this.myCallIsInTransition != null) {
            try {
                RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
                    try {
                        this.myCachedIsInTransition = (Boolean)this.myCallIsInTransition.invoke(this.myDesignTool, new Object[0]);
                    }
                    catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                        this.myCallIsInTransition = null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public long getMaxTimeMs() {
        this.cachedGetMaxTimeMs();
        return this.myCachedMaxTimeMs;
    }

    private void cachedGetMaxTimeMs() {
        if (!this.isMyDesignToolAvailable()) {
            return;
        }
        if (this.myGetMaxTimeMethod == null) {
            try {
                this.myGetMaxTimeMethod = this.myDesignTool.getClass().getMethod("getTransitionTimeMs", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (this.myGetMaxTimeMethod != null) {
            try {
                RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
                    try {
                        this.myCachedMaxTimeMs = (Long)this.myGetMaxTimeMethod.invoke(this.myDesignTool, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        this.myGetMaxTimeMethod = null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int motionLayoutAccess(int cmd, String type, Object view, float[] in, int inLength, float[] out, int outLength) {
        if (!this.isMyDesignToolAvailable()) {
            return -1;
        }
        if (this.motionLayoutAccess == null) {
            try {
                this.motionLayoutAccess = this.myDesignTool.getClass().getMethod("designAccess", Integer.TYPE, String.class, Object.class, float[].class, Integer.TYPE, float[].class, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                return -1;
            }
        }
        try {
            return (Integer)this.motionLayoutAccess.invoke(this.myDesignTool, cmd, type, view, in, inLength, out, outLength);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.myGetMaxTimeMethod = null;
            return -1;
        }
    }

    private void updateIds(@NotNull NlComponent component) {
        if (component == null) {
            MotionLayoutComponentHelper.$$$reportNull$$$0(2);
        }
        ResourceIdManager manager = ResourceIdManager.get((Module)component.getModel().getModule());
        this.updateId(manager, component);
        if (NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.CLASS_MOTION_LAYOUT)) {
            for (NlComponent child : component.getChildren()) {
                this.updateId(manager, child);
            }
        }
        if ((component = component.getParent()) != null && NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.CLASS_MOTION_LAYOUT)) {
            for (NlComponent child : component.getChildren()) {
                this.updateId(manager, child);
            }
        }
    }

    private void updateId(@NotNull ResourceIdManager manager, @NotNull NlComponent component) {
        ViewInfo view;
        String id2;
        ResourceReference reference2;
        Integer resolved;
        if (manager == null) {
            MotionLayoutComponentHelper.$$$reportNull$$$0(3);
        }
        if (component == null) {
            MotionLayoutComponentHelper.$$$reportNull$$$0(4);
        }
        if ((resolved = manager.getCompiledId(reference2 = new ResourceReference(ResourceNamespace.RES_AUTO, ResourceType.ID, id2 = component.getId()))) == null && (resolved = Integer.valueOf(manager.getOrGenerateId(reference2))) != null && (view = NlComponentHelperKt.getViewInfo(component)) != null && view.getViewObject() != null) {
            View androidView = (View)view.getViewObject();
            androidView.setId(resolved);
        }
    }

    public void updateLiveAttributes(NlComponent component, ComponentModification modification, String state) {
        Configuration configuration = modification.getComponent().getModel().getConfiguration();
        int dpiValue = configuration.getDensity().getDpiValue();
        ResourceIdManager manager = ResourceIdManager.get((Module)modification.getComponent().getModel().getModule());
        ViewInfo info = NlComponentHelperKt.getViewInfo(modification.getComponent());
        if (info == null || info != null && info.getViewObject() == null) {
            return;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Pair<String, String> key : modification.getAttributes().keySet()) {
            String value2 = modification.getAttributes().get(key);
            if (value2 != null) {
                if (value2.startsWith("@id/") || value2.startsWith("@+id/")) {
                    Integer resolved = manager.getCompiledId(new ResourceReference(ResourceNamespace.RES_AUTO, ResourceType.ID, value2 = value2.substring(value2.indexOf(47) + 1)));
                    if (resolved == null) {
                        this.updateIds(modification.getComponent());
                        resolved = manager.getOrGenerateId(new ResourceReference(ResourceNamespace.RES_AUTO, ResourceType.ID, value2));
                    }
                    if (resolved != null) {
                        value2 = resolved.toString();
                    }
                } else if (value2.equalsIgnoreCase("parent")) {
                    value2 = "0";
                }
            }
            attributes.put((String)key.getSecond(), value2);
        }
        this.setAttributes(dpiValue, state, info.getViewObject(), attributes);
    }

    public int getKeyframePos(NlComponent component, int[] type, float[] pos) {
        this.cachedGetKeyframePos(component, type, pos);
        if (this.myCachedKeyframePos.containsKey(component.getId())) {
            KeyframePos tmpPos = this.myCachedKeyframePos.get(component.getId());
            for (int i = 0; i < tmpPos.myLength; ++i) {
                type[i] = tmpPos.myType[i];
                pos[i * 2] = tmpPos.myPos[i * 2];
                pos[i * 2 + 1] = tmpPos.myPos[i * 2 + 1];
            }
            return tmpPos.myLength;
        }
        return -1;
    }

    private void cachedGetKeyframePos(NlComponent component, int[] type, float[] pos) {
        if (!this.isMyDesignToolAvailable()) {
            return;
        }
        ViewInfo info = NlComponentHelperKt.getViewInfo(component);
        if (info == null || info != null && info.getViewObject() == null) {
            return;
        }
        if (this.myGetKeyFramePositionsMethod == null) {
            try {
                this.myGetKeyFramePositionsMethod = this.myDesignTool.getClass().getMethod("getKeyFramePositions", Object.class, int[].class, float[].class);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        if (this.myGetKeyFramePositionsMethod != null) {
            try {
                RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
                    try {
                        int[] tmpType = Arrays.copyOf(type, type.length);
                        float[] tmpPos = Arrays.copyOf(pos, pos.length);
                        int framePosition = (Integer)this.myGetKeyFramePositionsMethod.invoke(this.myDesignTool, info.getViewObject(), tmpType, tmpPos);
                        this.myCachedKeyframePos.put(component.getId(), new KeyframePos(tmpType, tmpPos, framePosition));
                    }
                    catch (Exception e) {
                        this.myGetKeyFramePositionsMethod = null;
                        e.printStackTrace();
                    }
                }).get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getKeyframeInfo(NlComponent component, int type, int[] keyInfo) {
        this.cachedGetKeyframeInfo(component, type, keyInfo);
        if (this.myCachedKeyframeInfo.containsKey(component.getId())) {
            KeyframeInfo tmpInfo = this.myCachedKeyframeInfo.get(component.getId());
            for (int i = 0; i < tmpInfo.myKeyInfo.length; ++i) {
                keyInfo[i] = tmpInfo.myKeyInfo[i];
            }
            return tmpInfo.myNoOfKeyPosition;
        }
        return -1;
    }

    private void cachedGetKeyframeInfo(NlComponent component, int type, int[] keyInfo) {
        if (!this.isMyDesignToolAvailable()) {
            return;
        }
        ViewInfo info = NlComponentHelperKt.getViewInfo(component);
        if (info == null || info != null && info.getViewObject() == null) {
            return;
        }
        if (this.myGetKeyFrameInfoMethod == null) {
            try {
                this.myGetKeyFrameInfoMethod = this.myDesignTool.getClass().getMethod("getKeyFrameInfo", Object.class, Integer.TYPE, int[].class);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        if (this.myGetKeyFrameInfoMethod != null) {
            try {
                RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
                    try {
                        int[] tmpKeyInfo = Arrays.copyOf(keyInfo, keyInfo.length);
                        int noOfKeyPosition = (Integer)this.myGetKeyFrameInfoMethod.invoke(this.myDesignTool, info.getViewObject(), type, tmpKeyInfo);
                        this.myCachedKeyframeInfo.put(component.getId(), new KeyframeInfo(tmpKeyInfo, noOfKeyPosition));
                    }
                    catch (Exception e) {
                        this.myGetKeyFrameInfoMethod = null;
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setShowPaths(boolean show2) {
        mShowPaths = show2;
    }

    public boolean getShowPaths() {
        return mShowPaths;
    }

    public static void refresh(NlComponent component) {
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(component);
        if (viewInfo != null) {
            ((View)viewInfo.getViewObject()).forceLayout();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/MotionLayoutComponentHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateIds";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class KeyframeInfo {
        int[] myKeyInfo;
        int myNoOfKeyPosition;

        KeyframeInfo(int[] keyInfo, int noOfKeyPosition) {
            this.myKeyInfo = keyInfo;
            this.myNoOfKeyPosition = noOfKeyPosition;
        }
    }

    public static class KeyInfo {
        int[] myInfo;
        int myKeyInfoCount;
        int myOffsetCursor = 0;
        int myCursor = 0;
        public static final int KEY_TYPE_ATTRIBUTES = 1;
        public static final int KEY_TYPE_POSITION = 2;
        public static final int KEY_TYPE_TIME_CYCLE = 3;
        public static final int KEY_TYPE_CYCLE = 4;
        public static final int KEY_TYPE_TRIGGER = 5;
        private static final int OFF_TYPE = 1;
        private static final int OFF_FRAME_POS = 2;
        private static final int OFF_LOC_X = 3;
        private static final int OFF_LOC_Y = 4;
        private static final int OFF_KEY_POS_TYPE = 5;
        private static final int OFF_KEY_POS_PERCENT_X = 6;
        private static final int OFF_KEY_POS_PERCENT_Y = 7;

        public int getIndex() {
            return this.myCursor;
        }

        public static void dumpInfo(int[] info, int count) {
            Debug.println(3, "dumpInfo ");
            KeyInfo ki = new KeyInfo();
            ki.setInfo(info, count);
            ki.dumpInfo();
        }

        public void dumpInfo() {
            while (this.next()) {
                Debug.println("---------record# =" + this.myCursor + " (" + this.myOffsetCursor + ")----------");
                Debug.println("          length =" + this.getRecordLength());
                Debug.println("            Type =" + this.getType());
                Debug.println("  FramePosition =" + this.getFramePosition());
                Debug.println("       Location =" + this.getLocationX() + ", " + this.getLocationY());
                if (this.getType() != 2) continue;
                Debug.println("   getKeyPosType =" + this.getKeyPosType());
                Debug.println("        PercentX =" + this.getKeyPosPercentX());
                Debug.println("        PercentY =" + this.getKeyPosPercentY());
            }
            this.reset();
        }

        public void setInfo(int[] info, int count) {
            this.myOffsetCursor = 0;
            this.myKeyInfoCount = count;
            this.myInfo = info;
            this.reset();
        }

        public void reset() {
            this.myCursor = -1;
            this.myOffsetCursor = 0;
        }

        public boolean next() {
            ++this.myCursor;
            if (this.myCursor > 0) {
                int len = this.myInfo[this.myOffsetCursor];
                this.myOffsetCursor += len;
            }
            return this.myCursor < this.myKeyInfoCount;
        }

        int getRecordLength() {
            return this.myInfo[this.myOffsetCursor];
        }

        public int getType() {
            return this.myInfo[this.myOffsetCursor + 1];
        }

        public int getFramePosition() {
            return this.myInfo[this.myOffsetCursor + 2];
        }

        public float getLocationX() {
            return Float.intBitsToFloat(this.myInfo[this.myOffsetCursor + 3]);
        }

        public float getLocationY() {
            return Float.intBitsToFloat(this.myInfo[this.myOffsetCursor + 4]);
        }

        public int getKeyPosType() {
            return this.myInfo[this.myOffsetCursor + 5];
        }

        public float getKeyPosPercentX() {
            return Float.intBitsToFloat(this.myInfo[this.myOffsetCursor + 6]);
        }

        public float getKeyPosPercentY() {
            return Float.intBitsToFloat(this.myInfo[this.myOffsetCursor + 7]);
        }
    }

    private static class KeyframePos {
        int[] myType;
        float[] myPos;
        int myLength;

        KeyframePos(int[] type, float[] pos, int length) {
            this.myType = Arrays.copyOf(type, type.length);
            this.myPos = Arrays.copyOf(pos, pos.length);
            this.myLength = length;
        }
    }

    private class InvokeMethod<T> {
        String myMethodName;
        Method myMethod = null;
        Object myDesignTool = null;
        Class[] myParameters = null;

        public InvokeMethod(String methodName, Class ... parameters) {
            this.myMethodName = methodName;
            this.myParameters = (Class[])ArrayUtil.copyOf((Object[])parameters);
        }

        public void update(Object designTool) {
            if (designTool == null) {
                return;
            }
            this.myDesignTool = designTool;
            try {
                this.myMethod = designTool.getClass().getMethod(this.myMethodName, this.myParameters);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }

        public T invoke(Object ... parameters) {
            if (this.myMethod != null) {
                try {
                    return RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
                        try {
                            Object result = this.myMethod.invoke(this.myDesignTool, parameters);
                            return result;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return null;
                        }
                    }).get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

