/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.targets;

import com.android.SdkConstants;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.DragBaseTarget;
import com.android.tools.idea.common.scene.target.MultiComponentTarget;
import com.android.tools.idea.uibuilder.api.actions.ToggleAutoConnectAction;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ChainChecker;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstraintDragTarget
extends DragBaseTarget
implements MultiComponentTarget {
    protected int myOffsetX;
    protected int myOffsetY;
    private static final int ourSnapMarginDistance = 4;
    private ConstraintDropHandler myDropHandler;

    @Override
    public void setComponent(@NotNull SceneComponent component) {
        if (component == null) {
            ConstraintDragTarget.$$$reportNull$$$0(0);
        }
        super.setComponent(component);
        this.myDropHandler = new ConstraintDropHandler(this.myComponent);
    }

    @Override
    protected boolean isAutoConnectionEnabled() {
        return !SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE.isEqualsIgnoreCase(this.myComponent.getNlComponent().getTagName()) && ToggleAutoConnectAction.isAutoconnectOn();
    }

    @Override
    protected void updateAttributes(@NotNull NlAttributesHolder attributes, int x, int y) {
        if (attributes == null) {
            ConstraintDragTarget.$$$reportNull$$$0(1);
        }
        SceneComponent constraintLayoutComponent = this.myComponent.getParent();
        assert (constraintLayoutComponent != null);
        this.myDropHandler.updateAttributes(attributes, constraintLayoutComponent, x, y);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/targets/ConstraintDragTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateAttributes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ConstraintDropHandler {
        @NotNull
        private final SceneComponent myComponent;
        private final ChainChecker myChainChecker;

        public ConstraintDropHandler(@NotNull SceneComponent component) {
            if (component == null) {
                ConstraintDropHandler.$$$reportNull$$$0(0);
            }
            this.myChainChecker = new ChainChecker();
            this.myComponent = component;
        }

        public void updateAttributes(@NotNull NlAttributesHolder attributes, @NotNull SceneComponent parent, int x, int y) {
            int dx;
            if (attributes == null) {
                ConstraintDropHandler.$$$reportNull$$$0(1);
            }
            if (parent == null) {
                ConstraintDropHandler.$$$reportNull$$$0(2);
            }
            SceneComponent targetStartComponent = this.getTargetComponent(parent, ConstraintComponentUtilities.ourStartAttributes);
            SceneComponent targetEndComponent = this.getTargetComponent(parent, ConstraintComponentUtilities.ourEndAttributes);
            SceneComponent targetLeftComponent = this.getTargetComponent(parent, ConstraintComponentUtilities.ourLeftAttributes);
            SceneComponent targetRightComponent = this.getTargetComponent(parent, ConstraintComponentUtilities.ourRightAttributes);
            String targetStartMargin = "layout_marginStart";
            String targetEndMargin = "layout_marginEnd";
            boolean useStartEnd = this.myComponent.useRtlAttributes();
            boolean isInRTL = this.myComponent.getScene().isInRTL();
            int dx1 = 0;
            int dx2 = 0;
            if (targetStartComponent == null && targetEndComponent == null) {
                targetStartComponent = targetLeftComponent;
                targetEndComponent = targetRightComponent;
                targetStartMargin = "layout_marginLeft";
                targetEndMargin = "layout_marginRight";
                useStartEnd = false;
                isInRTL = false;
                if (targetStartComponent != null) {
                    dx1 = this.getLeftTargetOrigin(targetStartComponent) + this.getMarginValue(targetStartMargin);
                }
                if (targetEndComponent != null) {
                    dx2 = this.getRightTargetOrigin(targetEndComponent) - this.getMarginValue(targetEndMargin);
                }
            } else {
                int margin;
                if (targetStartComponent != null) {
                    dx1 = this.getStartTargetOrigin(targetStartComponent, isInRTL);
                    margin = this.getMarginValue(targetStartMargin);
                    dx1 = isInRTL ? (dx1 -= margin) : (dx1 += margin);
                }
                if (targetEndComponent != null) {
                    dx2 = this.getEndTargetOrigin(targetEndComponent, isInRTL);
                    margin = this.getMarginValue(targetEndMargin);
                    dx2 = isInRTL ? (dx2 += margin) : (dx2 -= margin);
                }
            }
            this.myChainChecker.checkIsInChain(this.myComponent);
            if (targetStartComponent != null && targetEndComponent != null) {
                if (!this.myChainChecker.isInHorizontalChain()) {
                    float dw = dx2 - dx1 - this.myComponent.getDrawWidth();
                    float bias = (float)(x - dx1) / dw;
                    if (useStartEnd && isInRTL) {
                        dw = dx1 - dx2 - this.myComponent.getDrawWidth();
                        bias = (dw - (float)(x - dx2)) / dw;
                    }
                    if (bias < 0.0f) {
                        bias = 0.0f;
                    }
                    if (bias > 1.0f) {
                        bias = 1.0f;
                    }
                    String biasValue = null;
                    if ((int)(bias * 1000.0f) != 500 && (biasValue = String.valueOf(bias = (float)((int)(bias * 1000.0f)) / 1000.0f)).equalsIgnoreCase("NaN")) {
                        biasValue = null;
                    }
                    attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", biasValue);
                }
            } else if (targetStartComponent != null) {
                dx = x - this.getLeftTargetOrigin(targetStartComponent);
                if (useStartEnd) {
                    dx = isInRTL ? this.getStartTargetOrigin(targetStartComponent, true) - (x + this.myComponent.getDrawWidth()) : x - this.getStartTargetOrigin(targetStartComponent, false);
                }
                this.applyMargin(attributes, targetStartMargin, dx);
            } else if (targetEndComponent != null) {
                dx = this.getRightTargetOrigin(targetEndComponent) - (x + this.myComponent.getDrawWidth());
                if (useStartEnd) {
                    dx = isInRTL ? x - this.getEndTargetOrigin(targetEndComponent, true) : this.getEndTargetOrigin(targetEndComponent, false) - (x + this.myComponent.getDrawWidth());
                }
                this.applyMargin(attributes, targetEndMargin, dx);
            } else {
                String positionX = String.format("%ddp", x - parent.getDrawX());
                attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", positionX);
            }
            SceneComponent targetTopComponent = this.getTargetComponent(parent, ConstraintComponentUtilities.ourTopAttributes);
            SceneComponent targetBottomComponent = this.getTargetComponent(parent, ConstraintComponentUtilities.ourBottomAttributes);
            if (targetTopComponent != null && targetBottomComponent != null) {
                if (!this.myChainChecker.isInVerticalChain()) {
                    int dy2;
                    float dh;
                    int dy1 = this.getTopTargetOrigin(targetTopComponent) + this.getMarginValue("layout_marginTop");
                    float bias = (float)(y - dy1) / (dh = (float)((dy2 = this.getBottomTargetOrigin(targetBottomComponent) - this.getMarginValue("layout_marginBottom")) - dy1 - this.myComponent.getDrawHeight()));
                    if (bias < 0.0f) {
                        bias = 0.0f;
                    }
                    if (bias > 1.0f) {
                        bias = 1.0f;
                    }
                    String biasValue = null;
                    if ((int)(bias * 1000.0f) != 500 && (biasValue = String.valueOf(bias = (float)((int)(bias * 1000.0f)) / 1000.0f)).equalsIgnoreCase("NaN")) {
                        biasValue = null;
                    }
                    attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", biasValue);
                }
            } else if (targetTopComponent != null) {
                int dy = y - this.getTopTargetOrigin(targetTopComponent);
                this.applyMargin(attributes, "layout_marginTop", dy);
            } else if (targetBottomComponent != null) {
                int dy = this.getBottomTargetOrigin(targetBottomComponent) - (y + this.myComponent.getDrawHeight());
                this.applyMargin(attributes, "layout_marginBottom", dy);
            } else {
                String positionY = String.format("%ddp", y - parent.getDrawY());
                attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", positionY);
            }
            ConstraintComponentUtilities.cleanup(attributes, this.myComponent.getNlComponent());
        }

        @Nullable
        private SceneComponent getTargetComponent(@NotNull SceneComponent parent, @NotNull ArrayList<String> attributes) {
            if (parent == null) {
                ConstraintDropHandler.$$$reportNull$$$0(3);
            }
            if (attributes == null) {
                ConstraintDropHandler.$$$reportNull$$$0(4);
            }
            NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
            int count = attributes.size();
            for (int i = 0; i < count; ++i) {
                String target = nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", attributes.get(i));
                if (target == null) continue;
                if (target.equalsIgnoreCase("parent")) {
                    return parent;
                }
                if ((target = NlComponent.extractId(target)) == null) continue;
                return this.myComponent.getScene().getSceneComponent(target);
            }
            return null;
        }

        private void applyMargin(NlAttributesHolder attributes, String attribute, int currentValue) {
            currentValue = Math.max(0, currentValue);
            currentValue = currentValue / 4 * 4;
            String marginString = this.myComponent.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res/android", attribute);
            int marginValue = -1;
            if (marginString != null) {
                marginValue = this.getMarginValue(attribute);
            }
            if (currentValue == 0) {
                attributes.removeAttribute("http://schemas.android.com/apk/res/android", attribute);
                if ("layout_marginEnd".equals(attribute)) {
                    attributes.removeAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight");
                } else if ("layout_marginStart".equals(attribute)) {
                    attributes.removeAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft");
                }
            } else if (marginValue != -1 && marginValue == currentValue) {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", attribute, marginString);
                if ("layout_marginEnd".equals(attribute)) {
                    attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", marginString);
                } else if ("layout_marginStart".equals(attribute)) {
                    attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", marginString);
                }
            } else {
                String marginY = String.format("%ddp", currentValue);
                attributes.setAttribute("http://schemas.android.com/apk/res/android", attribute, marginY);
                if ("layout_marginEnd".equals(attribute)) {
                    attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", marginY);
                } else if ("layout_marginStart".equals(attribute)) {
                    attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", marginY);
                }
            }
        }

        private int getStartTargetOrigin(@NotNull SceneComponent target, boolean isInRtl) {
            NlComponent nlComponent;
            if (target == null) {
                ConstraintDropHandler.$$$reportNull$$$0(5);
            }
            int origin = target.getDrawX();
            if (isInRtl) {
                origin += target.getDrawWidth();
            }
            if ((nlComponent = this.myComponent.getAuthoritativeNlComponent()).getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintStart_toEndOf") != null) {
                origin = isInRtl ? target.getDrawX() : (origin += target.getDrawWidth());
            }
            return origin;
        }

        private int getEndTargetOrigin(@NotNull SceneComponent target, boolean isInRtl) {
            NlComponent nlComponent;
            if (target == null) {
                ConstraintDropHandler.$$$reportNull$$$0(6);
            }
            int origin = target.getDrawX();
            if (isInRtl) {
                origin += target.getDrawWidth();
            }
            if ((nlComponent = this.myComponent.getAuthoritativeNlComponent()).getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintEnd_toEndOf") != null) {
                origin = isInRtl ? target.getDrawX() : (origin += target.getDrawWidth());
            }
            return origin;
        }

        private int getLeftTargetOrigin(@NotNull SceneComponent target) {
            if (target == null) {
                ConstraintDropHandler.$$$reportNull$$$0(7);
            }
            int origin = target.getDrawX();
            NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
            if (nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toRightOf") != null) {
                origin += target.getDrawWidth();
            }
            return origin;
        }

        private int getRightTargetOrigin(@NotNull SceneComponent target) {
            if (target == null) {
                ConstraintDropHandler.$$$reportNull$$$0(8);
            }
            int origin = target.getDrawX();
            NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
            if (nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toRightOf") != null) {
                origin += target.getDrawWidth();
            }
            return origin;
        }

        protected int getTopTargetOrigin(@NotNull SceneComponent target) {
            if (target == null) {
                ConstraintDropHandler.$$$reportNull$$$0(9);
            }
            int origin = target.getDrawY();
            NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
            if (nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toBottomOf") != null) {
                origin += target.getDrawHeight();
            }
            return origin;
        }

        private int getBottomTargetOrigin(@NotNull SceneComponent target) {
            if (target == null) {
                ConstraintDropHandler.$$$reportNull$$$0(10);
            }
            int origin = target.getDrawY();
            NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
            if (nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toBottomOf") != null) {
                origin += target.getDrawHeight();
            }
            return origin;
        }

        private int getMarginValue(String attribute) {
            NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
            return ConstraintComponentUtilities.getDpValue(nlComponent, nlComponent.getAttribute("http://schemas.android.com/apk/res/android", attribute));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/targets/ConstraintDragTarget$ConstraintDropHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateAttributes";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTargetComponent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getStartTargetOrigin";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getEndTargetOrigin";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getLeftTargetOrigin";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRightTargetOrigin";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTopTargetOrigin";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getBottomTargetOrigin";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

