/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnectionUtils;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

public class DrawGuidelineCycle
extends DrawRegion {
    public static final int BEGIN = 0;
    public static final int END = 1;
    public static final int PERCENT = 16;
    int myMode;
    boolean myIsHorizontal;
    boolean myIsSelected;
    protected Font mFont = new Font("Helvetica", 0, 14);
    int[] xPoints = new int[3];
    int[] yPoints = new int[3];

    @Override
    public int getLevel() {
        return 1010;
    }

    public DrawGuidelineCycle(String s) {
        super(s);
        String[] sp = s.split(",");
        int c = 0;
        c = super.parse(sp, c);
        this.myMode = Integer.parseInt(sp[c++]);
        this.myIsHorizontal = Boolean.parseBoolean(sp[c++]);
        this.myIsSelected = Boolean.parseBoolean(sp[c++]);
    }

    public DrawGuidelineCycle(boolean isHorizontal, int x, int y, int width, int height, int mode, boolean selected) {
        super(x, y, width, height);
        this.myIsHorizontal = isHorizontal;
        this.myMode = mode;
        this.myIsSelected = selected;
    }

    @Override
    public String serialize() {
        return this.getClass().getSimpleName() + "," + this.x + "," + this.y + "," + this.width + "," + this.height + "," + this.myMode + "," + this.myIsHorizontal + "," + this.myIsSelected;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet colorSet = sceneContext.getColorSet();
        g.setColor(colorSet.getFrames());
        g.fillOval(this.x, this.y, this.width, this.height);
        if (this.myIsSelected) {
            g.setColor(colorSet.getSelectedFrames());
            g.setStroke(colorSet.getOutlineStroke());
        }
        g.drawOval(this.x, this.y, this.width, this.height);
        g.setColor(colorSet.getText());
        if (this.myMode == 16) {
            String text = "%";
            g.setFont(this.mFont);
            FontMetrics fontMetrics = g.getFontMetrics();
            int tx = this.x + (this.width - fontMetrics.stringWidth(text)) / 2;
            int ty = this.y + this.height / 2 + fontMetrics.getDescent();
            g.drawString(text, tx + 1, ty + 1);
        } else if (this.myMode == 0) {
            int gap = 4;
            if (this.myIsHorizontal) {
                DrawConnectionUtils.getArrow(3, this.x + this.width / 2, this.y + this.height / 2 - gap, this.xPoints, this.yPoints);
            } else {
                DrawConnectionUtils.getArrow(1, this.x + this.width / 2 - gap, this.y + this.height / 2, this.xPoints, this.yPoints);
            }
            g.fillPolygon(this.xPoints, this.yPoints, 3);
        } else {
            int gap = 4;
            if (this.myIsHorizontal) {
                DrawConnectionUtils.getArrow(2, this.x + this.width / 2, this.y + this.height / 2 + gap, this.xPoints, this.yPoints);
            } else {
                DrawConnectionUtils.getArrow(0, this.x + this.width / 2 + gap, this.y + this.height / 2, this.xPoints, this.yPoints);
            }
            g.fillPolygon(this.xPoints, this.yPoints, 3);
        }
    }

    public static void add(DisplayList list, SceneContext transform, boolean isHorizontal, float left, float top, float right2, float bottom2, int mode, boolean selected) {
        int l = transform.getSwingXDip(left);
        int t = transform.getSwingYDip(top);
        int w = transform.getSwingDimensionDip(right2 - left);
        int h = transform.getSwingDimensionDip(bottom2 - top);
        list.add(new DrawGuidelineCycle(isHorizontal, l, t, w, h, mode, selected));
    }
}

