/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.resources.LayoutDirection;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstraintUtilities {
    private static HashMap<String, Integer> alignmentMap_ltr = new HashMap();
    private static HashMap<String, Integer> alignmentMap_rtl = new HashMap();
    static String[] mode = new String[]{"0", "1", "2", "3", "center", "START", "END"};
    private static final String[][] CHARS_MAP = new String[][]{{"&quot;", "\""}, {"&apos;", "'"}, {"&lt;", "<"}, {"&gt;", ">"}, {"&amp;", "&"}};

    public static int getAlignment(String s, boolean rtl) {
        HashMap<String, Integer> alignmentMap;
        HashMap<String, Integer> hashMap = alignmentMap = rtl ? alignmentMap_rtl : alignmentMap_ltr;
        if (alignmentMap.containsKey(s)) {
            return alignmentMap.get(s);
        }
        return 5;
    }

    static int getMargin(@NotNull NlComponent component, @NotNull String attr2) {
        String margin;
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(0);
        }
        if (attr2 == null) {
            ConstraintUtilities.$$$reportNull$$$0(1);
        }
        if ((margin = component.getLiveAttribute("http://schemas.android.com/apk/res/android", attr2)) == null) {
            if (attr2 == "layout_marginStart") {
                margin = component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft");
            } else if (attr2 == "layout_marginEnd") {
                margin = component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight");
            }
        }
        if (margin != null) {
            return ConstraintUtilities.getDpValue(component, margin);
        }
        return 0;
    }

    public static boolean isInRTL(@NotNull NlComponent component) {
        Configuration configuration;
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(2);
        }
        if ((configuration = component.getModel().getConfiguration()) == null) {
            return false;
        }
        LayoutDirectionQualifier qualifier = configuration.getFullConfig().getLayoutDirectionQualifier();
        if (qualifier == null) {
            return false;
        }
        return qualifier.getValue() == LayoutDirection.RTL;
    }

    public static int getDpValue(@NotNull NlComponent component, String value2) {
        Configuration configuration;
        ResourceResolver resourceResolver;
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(3);
        }
        if (value2 != null && (resourceResolver = (configuration = component.getModel().getConfiguration()).getResourceResolver()) != null) {
            Integer px = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver, value2, configuration);
            return px == null ? 0 : Coordinates.pxToDp(component.getModel(), (int)px);
        }
        return 0;
    }

    @NotNull
    static String resolveStringResource(@NotNull NlComponent component, @NotNull String text) {
        Configuration configuration;
        ResourceResolver resourceResolver;
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(4);
        }
        if (text == null) {
            ConstraintUtilities.$$$reportNull$$$0(5);
        }
        if ((resourceResolver = (configuration = component.getModel().getConfiguration()).getResourceResolver()) != null) {
            String string2 = IdeResourcesUtil.resolveStringValue((RenderResources)resourceResolver, (String)text);
            if (string2 == null) {
                ConstraintUtilities.$$$reportNull$$$0(6);
            }
            return string2;
        }
        return "";
    }

    @NotNull
    public static String getResolvedText(@NotNull NlComponent component) {
        String text;
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(7);
        }
        if ((text = ConstraintUtilities.getResolvedAttribute(component, "text")) == null) {
            return "";
        }
        String string2 = text;
        if (string2 == null) {
            ConstraintUtilities.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @NotNull
    public static String getResolvedToggleText(@NotNull NlComponent component) {
        String checkedText;
        String toggleTextAttr;
        String text;
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(9);
        }
        if ((text = ConstraintUtilities.getResolvedAttribute(component, toggleTextAttr = (checkedText = ConstraintUtilities.getResolvedAttribute(component, "checked")) != null && checkedText.equals("true") ? "textOn" : "textOff")) == null) {
            return "";
        }
        String string2 = text;
        if (string2 == null) {
            ConstraintUtilities.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @Nullable
    private static String getResolvedAttribute(@NotNull NlComponent component, @NotNull String attribute) {
        String resolvedAttribute;
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(11);
        }
        if (attribute == null) {
            ConstraintUtilities.$$$reportNull$$$0(12);
        }
        if ((resolvedAttribute = component.getAttribute("http://schemas.android.com/tools", attribute)) == null) {
            resolvedAttribute = component.getAttribute("http://schemas.android.com/apk/res/android", attribute);
        }
        if (resolvedAttribute != null && resolvedAttribute.startsWith("@")) {
            resolvedAttribute = ConstraintUtilities.resolveStringResource(component, resolvedAttribute);
        }
        return ConstraintUtilities.replaceSpecialChars(resolvedAttribute);
    }

    @VisibleForTesting
    @Nullable
    static String replaceSpecialChars(@Nullable String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        int offset2 = 0;
        int pos = 0;
        if (text.indexOf("&") >= 0) {
            boolean notDone = true;
            while (notDone) {
                char part;
                int end;
                int begin;
                notDone = false;
                for (int i = 0; i < CHARS_MAP.length; ++i) {
                    pos = text.indexOf(CHARS_MAP[i][0], offset2);
                    if (pos < 0) continue;
                    notDone = true;
                    text = text.replace(CHARS_MAP[i][0], CHARS_MAP[i][1]);
                    offset2 = pos + CHARS_MAP[i][0].length();
                }
                if (offset2 < text.length() && text.substring(offset2).matches(".*&#[0-9]+;.*")) {
                    begin = text.indexOf("&#");
                    end = text.indexOf(";", begin);
                    part = (char)Integer.parseInt(text.substring(begin + 2, end));
                    text = text.replace(text.substring(begin, end + 1), "" + part);
                    notDone = true;
                    offset2 = end;
                }
                if (offset2 >= text.length() || !text.substring(offset2).matches(".*&#x[a-fA-F0-9]+;.*")) continue;
                begin = text.indexOf("&#x");
                end = text.indexOf(";", begin);
                part = (char)Integer.parseInt(text.substring(begin + 3, end), 16);
                text = text.replace(text.substring(begin, end + 1), "" + part);
                notDone = true;
                offset2 = end;
            }
        }
        return text;
    }

    static {
        alignmentMap_rtl.put("center", 4);
        alignmentMap_rtl.put("textStart", 2);
        alignmentMap_rtl.put("textEnd", 3);
        alignmentMap_rtl.put("viewStart", 6);
        alignmentMap_rtl.put("viewEnd", 5);
        alignmentMap_ltr.put("center", 4);
        alignmentMap_ltr.put("textStart", 2);
        alignmentMap_ltr.put("textEnd", 3);
        alignmentMap_ltr.put("viewStart", 5);
        alignmentMap_ltr.put("viewEnd", 6);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveStringResource";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedToggleText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMargin";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInRTL";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDpValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveStringResource";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedToggleText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedAttribute";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

