/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.AttributeBrowser;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.google.common.collect.ImmutableList;
import icons.StudioIcons;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewTagHandler
extends ViewHandler {
    private static final String DIVIDER_BACKGROUND = "?android:attr/listDivider";
    public static final Predicate<String> SUITABLE_LAYOUT_CLASS = ViewTagHandler::isViewSuitableForLayout;

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        ImmutableList immutableList = ImmutableList.of((Object)"class", (Object)"style");
        if (immutableList == null) {
            ViewTagHandler.$$$reportNull$$$0(0);
        }
        return immutableList;
    }

    @Override
    @Nullable
    public AttributeBrowser getBrowser(@NotNull String attributeName) {
        if (attributeName == null) {
            ViewTagHandler.$$$reportNull$$$0(1);
        }
        if (!attributeName.equals("class")) {
            return null;
        }
        return ViewTagHandler::browseClasses;
    }

    @Override
    @NotNull
    public String getTitle(@NotNull String tagName) {
        if (tagName == null) {
            ViewTagHandler.$$$reportNull$$$0(2);
        }
        return "<view>";
    }

    @Override
    @NotNull
    public String getTitle(@NotNull NlComponent component) {
        if (component == null) {
            ViewTagHandler.$$$reportNull$$$0(3);
        }
        return "<view>";
    }

    @Override
    @Language(value="XML")
    @NotNull
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        if (tagName == null) {
            ViewTagHandler.$$$reportNull$$$0(4);
        }
        if (xmlType == null) {
            ViewTagHandler.$$$reportNull$$$0(5);
        }
        switch (xmlType) {
            case COMPONENT_CREATION: {
                return "<view/>";
            }
            case PREVIEW_ON_PALETTE: 
            case DRAG_PREVIEW: {
                return "";
            }
        }
        String string2 = super.getXml(tagName, xmlType);
        if (string2 == null) {
            ViewTagHandler.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Override
    public boolean onCreate(@NotNull ViewEditor editor2, @Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (editor2 == null) {
            ViewTagHandler.$$$reportNull$$$0(7);
        }
        if (newChild == null) {
            ViewTagHandler.$$$reportNull$$$0(8);
        }
        if (insertType == null) {
            ViewTagHandler.$$$reportNull$$$0(9);
        }
        if (insertType == InsertType.CREATE && newChild.getAttribute(null, "class") == null && !ViewTagHandler.isVerticalDivider(newChild) && !ViewTagHandler.isHorizontalDivider(newChild)) {
            String src = ViewTagHandler.browseClasses(editor2, null);
            if (src != null) {
                NlWriteCommandActionUtil.run(newChild, "Setting layout attribute", () -> newChild.setAttribute(null, "class", src));
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull NlComponent component) {
        if (component == null) {
            ViewTagHandler.$$$reportNull$$$0(10);
        }
        if (!component.getTagName().equals("view")) {
            Icon icon2 = super.getIcon(component);
            if (icon2 == null) {
                ViewTagHandler.$$$reportNull$$$0(11);
            }
            return icon2;
        }
        if (ViewTagHandler.isVerticalDivider(component)) {
            Icon icon3 = StudioIcons.LayoutEditor.Palette.VERTICAL_DIVIDER;
            if (icon3 == null) {
                ViewTagHandler.$$$reportNull$$$0(12);
            }
            return icon3;
        }
        if (ViewTagHandler.isHorizontalDivider(component)) {
            Icon icon4 = StudioIcons.LayoutEditor.Palette.HORIZONTAL_DIVIDER;
            if (icon4 == null) {
                ViewTagHandler.$$$reportNull$$$0(13);
            }
            return icon4;
        }
        Icon icon5 = StudioIcons.LayoutEditor.Palette.VIEW;
        if (icon5 == null) {
            ViewTagHandler.$$$reportNull$$$0(14);
        }
        return icon5;
    }

    private static boolean isVerticalDivider(@NotNull NlComponent component) {
        if (component == null) {
            ViewTagHandler.$$$reportNull$$$0(15);
        }
        return DIVIDER_BACKGROUND.equals(component.getAttribute("http://schemas.android.com/apk/res/android", "background")) && ViewTagHandler.hasShortWidth(component, "layout_width");
    }

    private static boolean isHorizontalDivider(@NotNull NlComponent component) {
        if (component == null) {
            ViewTagHandler.$$$reportNull$$$0(16);
        }
        return DIVIDER_BACKGROUND.equals(component.getAttribute("http://schemas.android.com/apk/res/android", "background")) && ViewTagHandler.hasShortWidth(component, "layout_height");
    }

    private static boolean hasShortWidth(@NotNull NlComponent component, @NotNull String attributeName) {
        String value2;
        if (component == null) {
            ViewTagHandler.$$$reportNull$$$0(17);
        }
        if (attributeName == null) {
            ViewTagHandler.$$$reportNull$$$0(18);
        }
        if ((value2 = component.getAttribute("http://schemas.android.com/apk/res/android", attributeName)) == null) {
            return false;
        }
        switch (value2) {
            case "1": 
            case "1px": 
            case "1dp": 
            case "1dip": {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static String browseClasses(@NotNull ViewEditor editor2, @Nullable String existingValue) {
        if (editor2 == null) {
            ViewTagHandler.$$$reportNull$$$0(19);
        }
        return editor2.displayClassInput("Views", Collections.singleton("android.view.View"), SUITABLE_LAYOUT_CLASS, existingValue);
    }

    private static boolean isViewSuitableForLayout(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            ViewTagHandler.$$$reportNull$$$0(20);
        }
        return !qualifiedName.startsWith("android.") || qualifiedName.startsWith("android.support.") || qualifiedName.startsWith("androidx.");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/ViewTagHandler";
                break;
            }
            case 1: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 3: 
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlType";
                break;
            }
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectorProperties";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/ViewTagHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getXml";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBrowser";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getXml";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "onCreate";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isVerticalDivider";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isHorizontalDivider";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasShortWidth";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "browseClasses";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isViewSuitableForLayout";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

