/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.adtui.util.ActionToolbarUtil;
import com.android.tools.idea.actions.MockupDeleteAction;
import com.android.tools.idea.actions.MockupEditAction;
import com.android.tools.idea.common.actions.GotoComponentAction;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.editor.ActionManager;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.idea.ui.designer.overlays.OverlayConfiguration;
import com.android.tools.idea.ui.designer.overlays.OverlayMenuAction;
import com.android.tools.idea.uibuilder.actions.ConvertToConstraintLayoutAction;
import com.android.tools.idea.uibuilder.actions.DisableToolsVisibilityAndPositionInPreviewAction;
import com.android.tools.idea.uibuilder.actions.MorphComponentAction;
import com.android.tools.idea.uibuilder.actions.SelectAllAction;
import com.android.tools.idea.uibuilder.actions.SelectNextAction;
import com.android.tools.idea.uibuilder.actions.SelectParentAction;
import com.android.tools.idea.uibuilder.actions.SelectPreviousAction;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.DirectViewAction;
import com.android.tools.idea.uibuilder.api.actions.NestedViewActionMenu;
import com.android.tools.idea.uibuilder.api.actions.ToggleViewAction;
import com.android.tools.idea.uibuilder.api.actions.ToggleViewActionGroup;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewActionMenu;
import com.android.tools.idea.uibuilder.api.actions.ViewActionPresentation;
import com.android.tools.idea.uibuilder.api.actions.ViewActionSeparator;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.type.LayoutFileType;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlActionManager
extends ActionManager<NlDesignSurface> {
    public static final DataKey<NlDesignSurface> LAYOUT_EDITOR = DataKey.create((String)(NlDesignSurface.class.getName() + "_LayoutEditor"));
    private AnAction mySelectAllAction;
    private AnAction mySelectParent;
    private GotoComponentAction myGotoComponentAction;
    private AnAction mySelectNextAction;
    private AnAction mySelectPreviousAction;

    public NlActionManager(@NotNull NlDesignSurface surface2) {
        if (surface2 == null) {
            NlActionManager.$$$reportNull$$$0(0);
        }
        super(surface2);
    }

    @Override
    public void registerActionsShortcuts(@NotNull JComponent component) {
        if (component == null) {
            NlActionManager.$$$reportNull$$$0(1);
        }
        if (this.mySelectAllAction == null) {
            this.mySelectAllAction = new SelectAllAction(this.mySurface);
            this.myGotoComponentAction = new GotoComponentAction(this.mySurface);
            this.mySelectParent = new SelectParentAction((NlDesignSurface)this.mySurface);
            this.mySelectNextAction = new SelectNextAction(this.mySurface);
            this.mySelectPreviousAction = new SelectPreviousAction(this.mySurface);
        }
        NlActionManager.registerAction(this.mySelectAllAction, "$SelectAll", component);
        NlActionManager.registerAction((AnAction)this.myGotoComponentAction, "GotoDeclaration", component);
        NlActionManager.registerAction(this.mySelectParent, KeyStroke.getKeyStroke(27, 0), component);
        JComponent focusablePane = ((NlDesignSurface)this.mySurface).getLayeredPane();
        NlActionManager.registerAction(this.mySelectNextAction, KeyStroke.getKeyStroke(39, 0), focusablePane);
        NlActionManager.registerAction(this.mySelectPreviousAction, KeyStroke.getKeyStroke(37, 0), focusablePane);
        NlActionManager.registerAction(this.mySelectNextAction, KeyStroke.getKeyStroke(40, 0), focusablePane);
        NlActionManager.registerAction(this.mySelectPreviousAction, KeyStroke.getKeyStroke(38, 0), focusablePane);
    }

    @NotNull
    private static ActionGroup createRefactoringMenu() {
        DefaultActionGroup group = DefaultActionGroup.createPopupGroup(() -> "_Refactor");
        com.intellij.openapi.actionSystem.ActionManager manager = com.intellij.openapi.actionSystem.ActionManager.getInstance();
        AnAction action2 = manager.getAction("AndroidExtractStyleAction");
        group.add((AnAction)new AndroidRefactoringActionWrapper("_Extract Style...", action2));
        action2 = manager.getAction("AndroidInlineStyleReferenceAction");
        group.add((AnAction)new AndroidRefactoringActionWrapper("_Inline Style...", action2));
        action2 = manager.getAction("AndroidExtractAsIncludeAction");
        group.add((AnAction)new AndroidRefactoringActionWrapper("E_xtract Layout...", action2));
        action2 = manager.getAction("AndroidInlineIncludeAction");
        group.add((AnAction)new AndroidRefactoringActionWrapper("I_nline Layout...", action2));
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            NlActionManager.$$$reportNull$$$0(2);
        }
        return defaultActionGroup;
    }

    @Override
    @NotNull
    public DefaultActionGroup getPopupMenuActions(@Nullable NlComponent leafComponent) {
        DefaultActionGroup group = new DefaultActionGroup();
        SceneView screenView = ((NlDesignSurface)this.mySurface).getFocusedSceneView();
        if (screenView != null) {
            if (leafComponent != null) {
                int prevCount = group.getChildrenCount();
                this.addActions(group, leafComponent.getParent(), leafComponent, screenView.getSelectionModel().getSelection(), false);
                if (group.getChildrenCount() > prevCount) {
                    group.addSeparator();
                }
            }
            group.addSeparator();
        }
        if (((NlDesignSurface)this.mySurface).getLayoutType() == LayoutFileType.INSTANCE) {
            this.createLayoutOnlyActions(leafComponent, group);
        }
        group.add(NlActionManager.getRegisteredActionByName("$Cut"));
        group.add(NlActionManager.getRegisteredActionByName("$Copy"));
        group.add(NlActionManager.getRegisteredActionByName("$Paste"));
        group.addSeparator();
        group.add(NlActionManager.getRegisteredActionByName("$Delete"));
        group.addSeparator();
        group.add((AnAction)this.myGotoComponentAction);
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            NlActionManager.$$$reportNull$$$0(3);
        }
        return defaultActionGroup;
    }

    private void createLayoutOnlyActions(@Nullable NlComponent leafComponent, @NotNull DefaultActionGroup group) {
        if (group == null) {
            NlActionManager.$$$reportNull$$$0(4);
        }
        if (leafComponent != null && ((Boolean)StudioFlags.NELE_CONVERT_VIEW.get()).booleanValue()) {
            group.add((AnAction)new MorphComponentAction(leafComponent));
        }
        group.add((AnAction)new ConvertToConstraintLayoutAction((NlDesignSurface)this.mySurface));
        group.add((AnAction)NlActionManager.createRefactoringMenu());
        if (((Boolean)StudioFlags.NELE_MOCKUP_EDITOR.get()).booleanValue()) {
            group.add((AnAction)new MockupEditAction((NlDesignSurface)this.mySurface));
        }
        if (leafComponent != null && ((Boolean)StudioFlags.NELE_MOCKUP_EDITOR.get()).booleanValue() && Mockup.hasMockupAttribute(leafComponent)) {
            group.add((AnAction)new MockupDeleteAction(leafComponent));
        }
        group.addSeparator();
    }

    @Nullable
    private static NlComponent findSharedParent(@NotNull List<NlComponent> newSelection) {
        if (newSelection == null) {
            NlActionManager.$$$reportNull$$$0(5);
        }
        NlComponent parent = null;
        for (NlComponent selected : newSelection) {
            if (parent == null) {
                parent = selected.getParent();
                if (newSelection.size() != 1 || !selected.isRoot() || parent != null && !parent.isRoot()) continue;
                return selected;
            }
            if (parent == selected.getParent()) continue;
            parent = null;
            break;
        }
        return parent;
    }

    private void addActions(@NotNull DefaultActionGroup group, @Nullable NlComponent parent, @Nullable NlComponent leafComponent, @NotNull List<NlComponent> selection, boolean toolbar) {
        ViewHandler handler;
        SceneView screenView;
        if (group == null) {
            NlActionManager.$$$reportNull$$$0(6);
        }
        if (selection == null) {
            NlActionManager.$$$reportNull$$$0(7);
        }
        if ((screenView = ((NlDesignSurface)this.mySurface).getFocusedSceneView()) == null) {
            return;
        }
        Project project = ((NlDesignSurface)this.mySurface).getProject();
        if (project.isDisposed()) {
            return;
        }
        ViewEditorImpl editor2 = new ViewEditorImpl(screenView);
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>();
        if (leafComponent != null && (handler = ViewHandlerManager.get(project).getHandler(leafComponent)) != null) {
            actions2.addAll(this.getViewActionsForHandler(leafComponent, selection, editor2, handler, toolbar));
        }
        if (parent != null && (handler = ViewHandlerManager.get(project).getHandler(parent)) != null) {
            ArrayList selectedChildren = Lists.newArrayListWithCapacity((int)selection.size());
            for (NlComponent selected : selection) {
                if (selected.getParent() != parent) continue;
                selectedChildren.add(selected);
            }
            actions2.addAll(this.getViewActionsForHandler(parent, selectedChildren, editor2, handler, toolbar));
        }
        boolean lastWasSeparator = false;
        for (AnAction action2 : actions2) {
            boolean isSeparator = action2 instanceof Separator;
            if (isSeparator && lastWasSeparator) continue;
            group.add(action2);
            lastWasSeparator = isSeparator;
        }
    }

    @Override
    @NotNull
    public DefaultActionGroup getToolbarActions(@NotNull List<NlComponent> selection) {
        if (selection == null) {
            NlActionManager.$$$reportNull$$$0(8);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        NlComponent sharedParent = NlActionManager.findSharedParent(selection);
        this.addActions(group, sharedParent, null, selection, true);
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            NlActionManager.$$$reportNull$$$0(9);
        }
        return defaultActionGroup;
    }

    @Override
    @Nullable
    public JComponent getSceneViewContextToolbar(@NotNull SceneView sceneView) {
        if (sceneView == null) {
            NlActionManager.$$$reportNull$$$0(10);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)DisableToolsVisibilityAndPositionInPreviewAction.INSTANCE);
        ActionToolbar actionToolbar = com.intellij.openapi.actionSystem.ActionManager.getInstance().createActionToolbar("SceneView", (ActionGroup)group, true);
        actionToolbar.setTargetComponent((JComponent)((Object)this.mySurface));
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        JComponent toolbarComponent = actionToolbar.getComponent();
        toolbarComponent.setOpaque(false);
        toolbarComponent.setBorder((Border)JBUI.Borders.empty());
        return toolbarComponent;
    }

    @Override
    @Nullable
    public JComponent getSceneViewLeftBar(@NotNull SceneView sceneView) {
        if (sceneView == null) {
            NlActionManager.$$$reportNull$$$0(11);
        }
        if (OverlayConfiguration.EP_NAME.hasAnyExtensions()) {
            DefaultActionGroup group = new DefaultActionGroup();
            group.add((AnAction)new OverlayMenuAction.ToggleCachedOverlayAction((EditorDesignSurface)sceneView.getSurface()));
            group.add((AnAction)new OverlayMenuAction.UpdateOverlayAction((EditorDesignSurface)sceneView.getSurface()));
            group.add((AnAction)new OverlayMenuAction.CancelOverlayAction((EditorDesignSurface)sceneView.getSurface()));
            ActionToolbar actionToolbar = com.intellij.openapi.actionSystem.ActionManager.getInstance().createActionToolbar("SceneView", (ActionGroup)group, false);
            actionToolbar.setTargetComponent((JComponent)((Object)this.mySurface));
            actionToolbar.setReservePlaceAutoPopupIcon(false);
            JComponent toolbarComponent = actionToolbar.getComponent();
            toolbarComponent.setOpaque(false);
            toolbarComponent.setBorder((Border)JBUI.Borders.empty());
            return toolbarComponent;
        }
        return null;
    }

    @NotNull
    private List<AnAction> getViewActionsForHandler(@NotNull NlComponent component, @NotNull List<NlComponent> newSelection, @NotNull ViewEditor editor2, @NotNull ViewHandler handler, boolean toolbar) {
        if (component == null) {
            NlActionManager.$$$reportNull$$$0(12);
        }
        if (newSelection == null) {
            NlActionManager.$$$reportNull$$$0(13);
        }
        if (editor2 == null) {
            NlActionManager.$$$reportNull$$$0(14);
        }
        if (handler == null) {
            NlActionManager.$$$reportNull$$$0(15);
        }
        ArrayList<ViewAction> viewActions = new ArrayList<ViewAction>();
        if (toolbar) {
            viewActions.addAll(ViewHandlerManager.get(((NlDesignSurface)this.mySurface).getProject()).getToolbarActions(handler));
        } else {
            SceneComponent sceneComponent = editor2.getScene().getSceneComponent(component);
            if (sceneComponent != null) {
                viewActions.addAll(ViewHandlerManager.get(((NlDesignSurface)this.mySurface).getProject()).getPopupMenuActions(sceneComponent, handler));
            }
        }
        ArrayList<AnAction> target = new ArrayList<AnAction>();
        for (ViewAction viewAction : viewActions) {
            this.addActions(target, toolbar, viewAction, editor2, handler, component, newSelection);
        }
        ArrayList<AnAction> arrayList = target;
        if (arrayList == null) {
            NlActionManager.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    void addActions(@NotNull List<AnAction> target, boolean toolbar, @NotNull ViewAction viewAction, @NotNull ViewEditor editor2, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> newSelection) {
        if (target == null) {
            NlActionManager.$$$reportNull$$$0(17);
        }
        if (viewAction == null) {
            NlActionManager.$$$reportNull$$$0(18);
        }
        if (editor2 == null) {
            NlActionManager.$$$reportNull$$$0(19);
        }
        if (handler == null) {
            NlActionManager.$$$reportNull$$$0(20);
        }
        if (parent == null) {
            NlActionManager.$$$reportNull$$$0(21);
        }
        if (newSelection == null) {
            NlActionManager.$$$reportNull$$$0(22);
        }
        if (viewAction instanceof DirectViewAction) {
            target.add(new DirectViewActionWrapper((DirectViewAction)viewAction, editor2, handler, parent, newSelection));
        } else if (viewAction instanceof ViewActionSeparator) {
            if (((ViewActionSeparator)viewAction).isVisible(editor2, handler, parent, newSelection)) {
                target.add((AnAction)Separator.getInstance());
            }
        } else if (viewAction instanceof ToggleViewAction) {
            target.add(new ToggleViewActionWrapper((ToggleViewAction)viewAction, editor2, handler, parent, newSelection));
        } else if (viewAction instanceof ToggleViewActionGroup) {
            ArrayList<ToggleViewActionWrapper> actions2 = new ArrayList<ToggleViewActionWrapper>();
            for (ToggleViewAction action2 : ((ToggleViewActionGroup)viewAction).getActions()) {
                actions2.add(new ToggleViewActionWrapper(action2, editor2, handler, parent, newSelection));
            }
            if (!actions2.isEmpty()) {
                ToggleViewActionWrapper prev = null;
                for (ToggleViewActionWrapper action3 : actions2) {
                    target.add(action3);
                    if (prev != null) {
                        prev.myGroupSibling = action3;
                    }
                    prev = action3;
                }
                if (prev != null) {
                    prev.myGroupSibling = (ToggleViewActionWrapper)actions2.get(0);
                }
            }
        } else if (viewAction instanceof ViewActionMenu) {
            target.add((AnAction)new ViewActionMenuWrapper((ViewActionMenu)viewAction, editor2, handler, parent, newSelection));
        } else if (viewAction instanceof NestedViewActionMenu) {
            if (toolbar) {
                target.add((AnAction)new ViewActionToolbarMenuWrapper((NestedViewActionMenu)viewAction, editor2, handler, parent, newSelection));
            }
        } else {
            throw new UnsupportedOperationException(viewAction.getClass().getName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/editor/NlActionManager";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 5: 
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelection";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneView";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewAction";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlActionManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createRefactoringMenu";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupMenuActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarActions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewActionsForHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerActionsShortcuts";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createLayoutOnlyActions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findSharedParent";
                break;
            }
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addActions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getToolbarActions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSceneViewContextToolbar";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSceneViewLeftBar";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getViewActionsForHandler";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class ViewActionToolbarMenuWrapper
    extends DropDownAction
    implements ViewActionPresentation {
        private final NestedViewActionMenu myAction;
        private final ViewEditor myEditor;
        private final ViewHandler myHandler;
        private final NlComponent myComponent;
        private final List<NlComponent> mySelectedChildren;
        private Presentation myCurrentPresentation;

        private ViewActionToolbarMenuWrapper(@NotNull NestedViewActionMenu action2, @NotNull ViewEditor editor2, @NotNull ViewHandler handler, @NotNull NlComponent component, List<NlComponent> selectedChildren) {
            if (action2 == null) {
                ViewActionToolbarMenuWrapper.$$$reportNull$$$0(0);
            }
            if (editor2 == null) {
                ViewActionToolbarMenuWrapper.$$$reportNull$$$0(1);
            }
            if (handler == null) {
                ViewActionToolbarMenuWrapper.$$$reportNull$$$0(2);
            }
            if (component == null) {
                ViewActionToolbarMenuWrapper.$$$reportNull$$$0(3);
            }
            if (selectedChildren == null) {
                ViewActionToolbarMenuWrapper.$$$reportNull$$$0(4);
            }
            super(action2.getLabel(), action2.getLabel(), action2.getIcon());
            this.myAction = action2;
            this.myEditor = editor2;
            this.myHandler = handler;
            this.myComponent = component;
            this.mySelectedChildren = selectedChildren;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(action2.getIcon());
            presentation.setDescription(action2.getLabel());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ViewActionToolbarMenuWrapper.$$$reportNull$$$0(5);
            }
            this.myCurrentPresentation = e.getPresentation();
            try {
                this.myAction.updatePresentation(this, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, e.getModifiers());
            }
            finally {
                this.myCurrentPresentation = null;
            }
        }

        protected boolean updateActions(@NotNull DataContext context) {
            if (context == null) {
                ViewActionToolbarMenuWrapper.$$$reportNull$$$0(6);
            }
            this.removeAll();
            List<List<ViewAction>> rows = this.myAction.getActions();
            if (rows.size() == 1) {
                ArrayList<AnAction> actions2 = new ArrayList<AnAction>();
                for (ViewAction viewAction : rows.get(0)) {
                    NlActionManager.this.addActions(actions2, false, viewAction, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren);
                }
                this.addAll(actions2);
            }
            return true;
        }

        protected JPanel createCustomComponentPopup() {
            List<List<ViewAction>> rows = this.myAction.getActions();
            if (rows.size() == 1) {
                return null;
            }
            com.intellij.openapi.actionSystem.ActionManager actionManager = com.intellij.openapi.actionSystem.ActionManager.getInstance();
            JPanel panel2 = new JPanel((LayoutManager)new VerticalLayout(0));
            for (List<ViewAction> row : rows) {
                if (row.size() == 1 && row.get(0) instanceof ViewActionSeparator) {
                    if (!((ViewActionSeparator)row.get(0)).isVisible(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren)) continue;
                    panel2.add(new JSeparator());
                    continue;
                }
                ArrayList<AnAction> actions2 = new ArrayList<AnAction>();
                for (ViewAction viewAction : row) {
                    NlActionManager.this.addActions(actions2, false, viewAction, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren);
                }
                DefaultActionGroup group = new DefaultActionGroup(actions2);
                ActionToolbar toolbar = actionManager.createActionToolbar("DynamicToolbar", (ActionGroup)group, true);
                ActionToolbarUtil.makeToolbarNavigable((ActionToolbar)toolbar);
                panel2.add(toolbar.getComponent());
            }
            return panel2;
        }

        @Override
        public void setLabel(@NotNull String label) {
            if (label == null) {
                ViewActionToolbarMenuWrapper.$$$reportNull$$$0(7);
            }
            this.myCurrentPresentation.setText(label);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.myCurrentPresentation.setEnabled(enabled);
        }

        @Override
        public void setVisible(boolean visible) {
            this.myCurrentPresentation.setVisible(visible);
        }

        @Override
        public void setIcon(@Nullable Icon icon2) {
            this.myCurrentPresentation.setIcon(icon2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlActionManager$ViewActionToolbarMenuWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateActions";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setLabel";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ViewActionMenuWrapper
    extends ActionGroup
    implements ViewActionPresentation {
        private final ViewActionMenu myAction;
        private final ViewEditor myEditor;
        private final ViewHandler myHandler;
        private final NlComponent myComponent;
        private final List<NlComponent> mySelectedChildren;
        private Presentation myCurrentPresentation;

        private ViewActionMenuWrapper(@NotNull ViewActionMenu action2, @NotNull ViewEditor editor2, @NotNull ViewHandler handler, @NotNull NlComponent component, List<NlComponent> selectedChildren) {
            if (action2 == null) {
                ViewActionMenuWrapper.$$$reportNull$$$0(0);
            }
            if (editor2 == null) {
                ViewActionMenuWrapper.$$$reportNull$$$0(1);
            }
            if (handler == null) {
                ViewActionMenuWrapper.$$$reportNull$$$0(2);
            }
            if (component == null) {
                ViewActionMenuWrapper.$$$reportNull$$$0(3);
            }
            if (selectedChildren == null) {
                ViewActionMenuWrapper.$$$reportNull$$$0(4);
            }
            super(action2.getLabel(), true);
            this.myAction = action2;
            this.myEditor = editor2;
            this.myHandler = handler;
            this.myComponent = component;
            this.mySelectedChildren = selectedChildren;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(action2.getIcon());
            presentation.setText(action2.getLabel());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ViewActionMenuWrapper.$$$reportNull$$$0(5);
            }
            this.myCurrentPresentation = e.getPresentation();
            try {
                this.myAction.updatePresentation(this, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, e.getModifiers());
            }
            finally {
                this.myCurrentPresentation = null;
            }
        }

        @Override
        public void setLabel(@NotNull String label) {
            if (label == null) {
                ViewActionMenuWrapper.$$$reportNull$$$0(6);
            }
            this.myCurrentPresentation.setText(label);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.myCurrentPresentation.setEnabled(enabled);
        }

        @Override
        public void setVisible(boolean visible) {
            this.myCurrentPresentation.setVisible(visible);
        }

        @Override
        public void setIcon(@Nullable Icon icon2) {
            this.myCurrentPresentation.setIcon(icon2);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            ArrayList<AnAction> actions2 = new ArrayList<AnAction>();
            for (ViewAction viewAction : this.myAction.getActions()) {
                NlActionManager.this.addActions(actions2, false, viewAction, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren);
            }
            AnAction[] anActionArray = actions2.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                ViewActionMenuWrapper.$$$reportNull$$$0(7);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/editor/NlActionManager$ViewActionMenuWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlActionManager$ViewActionMenuWrapper";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setLabel";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ToggleViewActionWrapper
    extends AnAction
    implements ViewActionPresentation {
        private final ToggleViewAction myAction;
        private final ViewEditor myEditor;
        private final ViewHandler myHandler;
        private final NlComponent myComponent;
        private final List<NlComponent> mySelectedChildren;
        private Presentation myCurrentPresentation;
        private ToggleViewActionWrapper myGroupSibling;

        private ToggleViewActionWrapper(@NotNull ToggleViewAction action2, @NotNull ViewEditor editor2, @NotNull ViewHandler handler, @NotNull NlComponent component, List<NlComponent> selectedChildren) {
            if (action2 == null) {
                ToggleViewActionWrapper.$$$reportNull$$$0(0);
            }
            if (editor2 == null) {
                ToggleViewActionWrapper.$$$reportNull$$$0(1);
            }
            if (handler == null) {
                ToggleViewActionWrapper.$$$reportNull$$$0(2);
            }
            if (component == null) {
                ToggleViewActionWrapper.$$$reportNull$$$0(3);
            }
            if (selectedChildren == null) {
                ToggleViewActionWrapper.$$$reportNull$$$0(4);
            }
            this.myAction = action2;
            this.myEditor = editor2;
            this.myHandler = handler;
            this.myComponent = component;
            this.mySelectedChildren = selectedChildren;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(action2.getUnselectedLabel());
            presentation.setIcon(action2.getUnselectedIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            boolean newState2;
            if (e == null) {
                ToggleViewActionWrapper.$$$reportNull$$$0(5);
            }
            boolean bl = newState2 = !this.myAction.isSelected(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren);
            if (this.myAction.affectsUndo()) {
                NlWriteCommandActionUtil.run(this.myComponent, Strings.nullToEmpty((String)e.getPresentation().getText()), () -> this.applySelection(newState2));
            } else {
                try {
                    this.applySelection(newState2);
                }
                catch (Throwable t) {
                    throw new IncorrectOperationException("View Action required write lock: should not specify affectsUndo=false");
                }
            }
        }

        private void applySelection(boolean state) {
            this.myAction.setSelected(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, state);
            if (state) {
                ToggleViewActionWrapper groupSibling = this.myGroupSibling;
                while (groupSibling != null && groupSibling != this) {
                    groupSibling.myAction.setSelected(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, false);
                    groupSibling = groupSibling.myGroupSibling;
                }
            }
            ((NlDesignSurface)NlActionManager.this.mySurface).repaint();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleViewActionWrapper.$$$reportNull$$$0(6);
            }
            this.myCurrentPresentation = e.getPresentation();
            try {
                boolean selected = this.myAction.isSelected(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren);
                if (this.myAction.getSelectedLabel() != null) {
                    this.myCurrentPresentation.setText(selected ? this.myAction.getSelectedLabel() : this.myAction.getUnselectedLabel());
                }
                this.myAction.updatePresentation(this, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, e.getModifiers(), selected);
            }
            finally {
                this.myCurrentPresentation = null;
            }
        }

        @Override
        public void setLabel(@NotNull String label) {
            if (label == null) {
                ToggleViewActionWrapper.$$$reportNull$$$0(7);
            }
            this.myCurrentPresentation.setText(label);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.myCurrentPresentation.setEnabled(enabled);
        }

        @Override
        public void setVisible(boolean visible) {
            this.myCurrentPresentation.setVisible(visible);
        }

        @Override
        public void setIcon(@Nullable Icon icon2) {
            this.myCurrentPresentation.setIcon(icon2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlActionManager$ToggleViewActionWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setLabel";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class DirectViewActionWrapper
    extends AnAction
    implements ViewActionPresentation {
        private final DirectViewAction myAction;
        private final ViewHandler myHandler;
        private final ViewEditor myEditor;
        private final NlComponent myComponent;
        private final List<NlComponent> mySelectedChildren;
        private Presentation myCurrentPresentation;

        private DirectViewActionWrapper(@NotNull DirectViewAction action2, @NotNull ViewEditor editor2, @NotNull ViewHandler handler, @NotNull NlComponent component, List<NlComponent> selectedChildren) {
            if (action2 == null) {
                DirectViewActionWrapper.$$$reportNull$$$0(0);
            }
            if (editor2 == null) {
                DirectViewActionWrapper.$$$reportNull$$$0(1);
            }
            if (handler == null) {
                DirectViewActionWrapper.$$$reportNull$$$0(2);
            }
            if (component == null) {
                DirectViewActionWrapper.$$$reportNull$$$0(3);
            }
            if (selectedChildren == null) {
                DirectViewActionWrapper.$$$reportNull$$$0(4);
            }
            this.myAction = action2;
            this.myEditor = editor2;
            this.myHandler = handler;
            this.myComponent = component;
            this.mySelectedChildren = selectedChildren;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(action2.getIcon());
            presentation.setText(action2.getLabel());
        }

        public final void actionPerformed(@NotNull AnActionEvent e) {
            String confirmationMessage;
            if (e == null) {
                DirectViewActionWrapper.$$$reportNull$$$0(5);
            }
            if ((confirmationMessage = this.myAction.getConfirmationMessage()) != null && Messages.showYesNoDialog((Component)((Object)NlActionManager.this.mySurface), (String)confirmationMessage, (String)this.myAction.getLabel(), (Icon)this.myAction.getIcon()) != 0) {
                return;
            }
            if (this.myAction.affectsUndo()) {
                NlWriteCommandActionUtil.run(this.myComponent, Strings.nullToEmpty((String)e.getPresentation().getText()), () -> this.myAction.perform(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, e.getModifiers()));
            } else {
                try {
                    this.myAction.perform(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, e.getModifiers());
                }
                catch (Throwable t) {
                    throw new IncorrectOperationException("View Action required write lock: should not specify affectsUndo=false");
                }
            }
            ((NlDesignSurface)NlActionManager.this.mySurface).repaint();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DirectViewActionWrapper.$$$reportNull$$$0(6);
            }
            int modifiersEx = ((NlDesignSurface)NlActionManager.this.mySurface).getInteractionManager().getLastModifiersEx();
            this.myCurrentPresentation = e.getPresentation();
            try {
                this.myAction.updatePresentation(this, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, modifiersEx);
            }
            finally {
                this.myCurrentPresentation = null;
            }
        }

        @Override
        public void setLabel(@NotNull String label) {
            if (label == null) {
                DirectViewActionWrapper.$$$reportNull$$$0(7);
            }
            this.myCurrentPresentation.setText(label);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.myCurrentPresentation.setEnabled(enabled);
        }

        @Override
        public void setVisible(boolean visible) {
            this.myCurrentPresentation.setVisible(visible);
        }

        @Override
        public void setIcon(@Nullable Icon icon2) {
            this.myCurrentPresentation.setIcon(icon2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlActionManager$DirectViewActionWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setLabel";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AndroidRefactoringActionWrapper
    extends AnAction {
        private final AnAction myRefactoringAction;

        private AndroidRefactoringActionWrapper(@NotNull String text, @NotNull AnAction refactoringAction) {
            if (text == null) {
                AndroidRefactoringActionWrapper.$$$reportNull$$$0(0);
            }
            if (refactoringAction == null) {
                AndroidRefactoringActionWrapper.$$$reportNull$$$0(1);
            }
            super(text, null, null);
            this.myRefactoringAction = refactoringAction;
            this.getTemplatePresentation().setDescription(refactoringAction.getTemplatePresentation().getDescription());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AndroidRefactoringActionWrapper.$$$reportNull$$$0(2);
            }
            this.myRefactoringAction.actionPerformed(e);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AndroidRefactoringActionWrapper.$$$reportNull$$$0(3);
            }
            this.myRefactoringAction.update(e);
            Presentation p = e.getPresentation();
            if (!p.isVisible()) {
                p.setEnabled(false);
                p.setVisible(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refactoringAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlActionManager$AndroidRefactoringActionWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

