/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.SmallestScreenWidthQualifier;
import com.android.resources.ResourceFolderType;
import com.android.resources.ScreenOrientation;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.idea.uibuilder.editor.CreateVariationAction;
import com.android.tools.idea.uibuilder.editor.SwitchToVariationAction;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.NlScreenViewProvider;
import com.android.tools.idea.uibuilder.surface.ScreenViewProvider;
import com.google.common.collect.ImmutableCollection;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0012\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0014J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/uibuilder/editor/LayoutQualifierDropdownMenu;", "Lcom/android/tools/adtui/actions/DropDownAction;", "()V", "displayText", "", "(Ljava/lang/String;)V", "createVariationsActions", "", "configuration", "Lcom/android/tools/idea/configurations/Configuration;", "surface", "Lcom/android/tools/idea/ui/designer/EditorDesignSurface;", "displayTextInToolbar", "", "isPerformableWithoutActionButton", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "updateActions", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.android.designer"})
public final class LayoutQualifierDropdownMenu
extends DropDownAction {
    private final String displayText;

    public boolean displayTextInToolbar() {
        return true;
    }

    protected boolean isPerformableWithoutActionButton() {
        return true;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        NlDesignSurface nlDesignSurface = (NlDesignSurface)e.getDataContext().getData(DesignerDataKeys.DESIGN_SURFACE);
        ScreenViewProvider screenViewProvider = nlDesignSurface != null ? nlDesignSurface.getScreenViewProvider() : null;
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(screenViewProvider == NlScreenViewProvider.RENDER || screenViewProvider == NlScreenViewProvider.BLUEPRINT || screenViewProvider == NlScreenViewProvider.Companion.getDEFAULT_SCREEN_MODE());
        e.getPresentation().setText(this.displayText, false);
    }

    public boolean updateActions(@NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.removeAll();
        DesignSurface designSurface = (DesignSurface)((Object)context.getData(DesignerDataKeys.DESIGN_SURFACE));
        if (designSurface == null) {
            return true;
        }
        Intrinsics.checkNotNullExpressionValue((Object)((Object)designSurface), (String)"context.getData(DESIGN_SURFACE) ?: return true");
        DesignSurface surface2 = designSurface;
        ImmutableCollection<Configuration> immutableCollection = surface2.getConfigurations();
        Intrinsics.checkNotNullExpressionValue(immutableCollection, (String)"surface.configurations");
        Configuration configuration = (Configuration)CollectionsKt.firstOrNull((Iterable)((Iterable)immutableCollection));
        if (configuration == null) {
            return true;
        }
        Configuration config = configuration;
        this.createVariationsActions(config, surface2);
        return true;
    }

    private final void createVariationsActions(Configuration configuration, EditorDesignSurface surface2) {
        VirtualFile virtualFile = configuration.getFile();
        if (virtualFile != null) {
            Module module = configuration.getModule();
            if (module == null) {
                return;
            }
            Module module2 = module;
            Project project = module2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
            Project project2 = project;
            List variations = IdeResourcesUtil.getResourceVariations((VirtualFile)virtualFile, (boolean)true);
            for (VirtualFile file2 : variations) {
                String title;
                String parentFolderName;
                VirtualFile virtualFile2 = file2.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file.parent");
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2.getName(), (String)"file.parent.name");
                Intrinsics.checkNotNullExpressionValue((Object)(Intrinsics.areEqual((Object)parentFolderName, (Object)"layout") ? file2.getName() : parentFolderName + "/" + file2.getName()), (String)"if (parentFolderName == \u2026e/${file.name}\"\n        }");
                title = title;
                this.add(new SwitchToVariationAction(title, project2, file2, Intrinsics.areEqual((Object)virtualFile, (Object)file2)));
            }
            this.addSeparator();
            ResourceFolderType folderType = IdeResourcesUtil.getFolderType((VirtualFile)configuration.getFile());
            if (folderType == ResourceFolderType.LAYOUT) {
                boolean haveLandscape = false;
                boolean haveTablet = false;
                for (VirtualFile file3 : variations) {
                    SmallestScreenWidthQualifier size;
                    FolderConfiguration config;
                    String name;
                    VirtualFile virtualFile3 = file3.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"file.parent");
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile3.getName(), (String)"file.parent.name");
                    if (!StringsKt.startsWith$default((String)name, (String)"layout", (boolean)false, (int)2, null) || (config = FolderConfiguration.getConfigForFolder((String)name)) == null) continue;
                    ScreenOrientationQualifier orientation = config.getScreenOrientationQualifier();
                    if (orientation != null && orientation.getValue() == ScreenOrientation.LANDSCAPE) {
                        haveLandscape = true;
                        if (haveTablet) break;
                    }
                    if ((size = config.getSmallestScreenWidthQualifier()) == null || size.getValue() < 600) continue;
                    haveTablet = true;
                    if (!haveLandscape) continue;
                    break;
                }
                if (!haveLandscape) {
                    this.add(new CreateVariationAction(surface2, "Create Landscape Qualifier", "layout-land"));
                }
                if (!haveTablet) {
                    this.add(new CreateVariationAction(surface2, "Create Tablet Qualifier", "layout-sw600dp"));
                }
                this.add(new CreateVariationAction(surface2, "Add Resource Qualifier", null));
            } else {
                this.add(new CreateVariationAction(surface2, "Create Alternative...", null));
            }
        }
    }

    public LayoutQualifierDropdownMenu(@NotNull String displayText) {
        Intrinsics.checkNotNullParameter((Object)displayText, (String)"displayText");
        super(displayText, "Action to switch and create qualifiers for layout files", null);
        this.displayText = displayText;
    }

    private LayoutQualifierDropdownMenu() {
        this("Switch Layout Qualifier");
    }
}

