/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;

class AnimationToolbarSliderUI
extends BasicSliderUI {
    private static final int DEFAULT_FONT_SIZE = 10;
    private static final int THUMB_TIP_SIZE = 6;
    private final int[] myThumbPolygonX = new int[5];
    private final int[] myThumbPolygonY = new int[5];
    private int myThumbTipSize = JBUIScale.scale((int)6);
    private final JBColor myThumbFillColor = new JBColor(0xFFFFFF, 11514291);
    private final JBColor myThumbLineColor = JBColor.lightGray;
    private final JBColor myTrackBackgroundColor = JBColor.GRAY;
    private final Rectangle myTrackRectangle = new Rectangle();
    private final StringBuilder myProgress = new StringBuilder(10);
    private final JBLabel myProgressLabelComponent = new JBLabel("0%");
    private final Rectangle myProgressLabelBounds = new Rectangle();

    AnimationToolbarSliderUI(JSlider b) {
        super(b);
        this.myProgressLabelComponent.setMinimumSize((Dimension)JBUI.size((int)30, (int)15));
        this.myProgressLabelComponent.setHorizontalAlignment(4);
        this.myProgressLabelComponent.setFont((Font)JBUI.Fonts.label((float)10.0f));
        this.myProgressLabelComponent.setFontColor(UIUtil.FontColor.NORMAL);
    }

    @Override
    protected void calculateGeometry() {
        super.calculateGeometry();
        this.calculateProgressRect();
    }

    @Override
    protected void calculateTrackRect() {
        super.calculateTrackRect();
        if (this.slider.getOrientation() == 1) {
            return;
        }
        Dimension progressLabelSize = this.getProgressLabelSize();
        int trackHeight = this.thumbRect.height / 3;
        this.trackRect.width -= progressLabelSize.width + JBUIScale.scale((int)10);
        this.myTrackRectangle.x = this.trackRect.x;
        this.myTrackRectangle.y = this.trackRect.y + this.trackRect.height / 2 - trackHeight / 2;
        this.myTrackRectangle.width = this.trackRect.width;
        this.myTrackRectangle.height = trackHeight;
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        this.updateTrackProgress();
    }

    protected void updateTrackProgress() {
        int current = this.slider.getValue();
        this.myProgress.setLength(0);
        this.myProgress.append(current);
        this.myProgress.append("%");
        this.myProgressLabelComponent.setText(this.myProgress.toString());
        this.myProgressLabelComponent.setFont((Font)JBUI.Fonts.label((float)10.0f));
    }

    protected void calculateProgressRect() {
        Dimension progressLabelSize = this.getProgressLabelSize();
        this.myProgressLabelBounds.x = this.myTrackRectangle.x + this.myTrackRectangle.width + JBUIScale.scale((int)10);
        this.myProgressLabelBounds.y = (int)((float)this.myTrackRectangle.y + (float)this.myTrackRectangle.height / 2.0f - (float)progressLabelSize.height / 2.0f);
        this.myProgressLabelBounds.width = progressLabelSize.width;
        this.myProgressLabelBounds.height = progressLabelSize.height;
        this.myProgressLabelComponent.setBounds(this.myProgressLabelBounds);
    }

    @Override
    public void paintThumb(Graphics g) {
        if (this.slider.getOrientation() == 1) {
            super.paintThumb(g);
            return;
        }
        this.myThumbPolygonX[0] = this.myThumbPolygonX[1] = this.thumbRect.x;
        this.myThumbPolygonX[4] = this.myThumbPolygonX[3] = this.thumbRect.x + this.thumbRect.width;
        this.myThumbPolygonX[2] = (int)((float)this.thumbRect.x + (float)this.thumbRect.width / 2.0f);
        this.myThumbPolygonY[0] = this.myThumbPolygonY[4] = this.thumbRect.y;
        this.myThumbPolygonY[1] = this.myThumbPolygonY[3] = this.thumbRect.y + this.thumbRect.height - this.myThumbTipSize;
        this.myThumbPolygonY[2] = this.thumbRect.y + this.thumbRect.height;
        g.setColor((Color)this.myThumbFillColor);
        g.fillPolygon(this.myThumbPolygonX, this.myThumbPolygonY, 5);
        g.setColor((Color)this.myThumbLineColor);
        g.drawPolygon(this.myThumbPolygonX, this.myThumbPolygonY, 5);
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    private void paintHorizontalTrack(Graphics g) {
        int thumbMidX = this.thumbRect.x + this.thumbRect.width / 2;
        int playedX = thumbMidX - this.trackRect.x;
        int arc = this.myTrackRectangle.height / 2;
        g.setColor(ColorUtil.toAlpha((Color)this.myTrackBackgroundColor, (int)100));
        g.fillRoundRect(this.myTrackRectangle.x, this.myTrackRectangle.y, this.myTrackRectangle.width, this.myTrackRectangle.height, arc, arc);
        g.drawRoundRect(this.myTrackRectangle.x, this.myTrackRectangle.y, this.myTrackRectangle.width, this.myTrackRectangle.height, arc, arc);
        g.setColor((Color)this.myTrackBackgroundColor);
        g.fillRoundRect(this.myTrackRectangle.x, this.myTrackRectangle.y, playedX, this.myTrackRectangle.height, arc, arc);
        g.drawRoundRect(this.myTrackRectangle.x, this.myTrackRectangle.y, playedX, this.myTrackRectangle.height, arc, arc);
        int offsetTranslateX = this.myProgressLabelBounds.x;
        int offsetTranslateY = this.myProgressLabelBounds.y;
        g.translate(offsetTranslateX, offsetTranslateY);
        this.myProgressLabelComponent.paint(g);
        g.translate(-offsetTranslateX, -offsetTranslateY);
    }

    @Override
    protected void calculateThumbSize() {
        JBDimension size = new JBDimension(12, 9);
        this.myThumbTipSize = JBUIScale.scale((int)6);
        this.thumbRect.width = size.width;
        this.thumbRect.height = size.height;
    }

    @Override
    public void paintTrack(Graphics g) {
        if (this.slider.getOrientation() == 1) {
            super.paintTrack(g);
            return;
        }
        this.paintHorizontalTrack(g);
    }

    @Override
    public void paintTicks(Graphics g) {
        if (this.slider.getOrientation() == 1) {
            super.paintTicks(g);
        }
    }

    private Dimension getProgressLabelSize() {
        Dimension progressLabelSize = this.myProgressLabelComponent.getPreferredSize();
        Dimension minSize = this.myProgressLabelComponent.getMinimumSize();
        progressLabelSize.width = Math.max(minSize.width, progressLabelSize.width);
        progressLabelSize.height = Math.max(minSize.height, progressLabelSize.height);
        return progressLabelSize;
    }
}

