/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.editor.AnimatedVectorListener;
import com.android.tools.idea.uibuilder.editor.AnimationController;
import com.android.tools.idea.uibuilder.editor.AnimationListListener;
import com.android.tools.idea.uibuilder.editor.AnimationListener;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/uibuilder/editor/AnimatedSelectorListener;", "Lcom/android/tools/idea/uibuilder/editor/AnimationListener;", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "(Lcom/android/tools/idea/common/surface/DesignSurface;)V", "animatedVectorDelegate", "Lcom/android/tools/idea/uibuilder/editor/AnimatedVectorListener;", "animationListDelegate", "Lcom/android/tools/idea/uibuilder/editor/AnimationListListener;", "getSurface", "()Lcom/android/tools/idea/common/surface/DesignSurface;", "animateTo", "", "controller", "Lcom/android/tools/idea/uibuilder/editor/AnimationController;", "framePositionMs", "", "intellij.android.designer"})
final class AnimatedSelectorListener
implements AnimationListener {
    private final AnimatedVectorListener animatedVectorDelegate;
    private final AnimationListListener animationListDelegate;
    @NotNull
    private final DesignSurface surface;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void animateTo(@NotNull AnimationController controller, long framePositionMs) {
        Unit unit;
        LayoutlibSceneManager layoutlibSceneManager;
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        SceneManager sceneManager = this.surface.getSceneManager();
        if (!(sceneManager instanceof LayoutlibSceneManager)) {
            sceneManager = null;
        }
        LayoutlibSceneManager layoutlibSceneManager2 = (LayoutlibSceneManager)sceneManager;
        if (layoutlibSceneManager2 == null) return;
        LayoutlibSceneManager it = layoutlibSceneManager = layoutlibSceneManager2;
        boolean bl = false;
        NlModel nlModel = it.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"it.model");
        XmlFile xmlFile = nlModel.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"it.model.file");
        XmlTag xmlTag = xmlFile.getRootTag();
        String string2 = xmlTag != null ? xmlTag.getName() : null;
        if (string2 != null) {
            switch (string2) {
                case "animated-vector": {
                    this.animatedVectorDelegate.animateTo(controller, framePositionMs);
                    unit = Unit.INSTANCE;
                    return;
                }
                case "animation-list": {
                    this.animationListDelegate.animateTo(controller, framePositionMs);
                    unit = Unit.INSTANCE;
                    return;
                }
            }
        }
        it.setElapsedFrameTimeMs(framePositionMs);
        Unit unit2 = it.requestRenderAsync();
        unit = unit2;
        Intrinsics.checkNotNullExpressionValue(unit2, (String)"it.requestRenderAsync()");
    }

    @NotNull
    public final DesignSurface getSurface() {
        return this.surface;
    }

    public AnimatedSelectorListener(@NotNull DesignSurface surface2) {
        Intrinsics.checkNotNullParameter((Object)((Object)surface2), (String)"surface");
        this.surface = surface2;
        this.animatedVectorDelegate = new AnimatedVectorListener(this.surface);
        this.animationListDelegate = new AnimationListListener(this.surface);
    }
}

