/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.naveditor.analytics.NavUsageTracker;
import com.android.tools.idea.naveditor.dialogs.AddDeeplinkDialog;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.property.inspector.ComponentListInspectorBuilder;
import com.android.tools.idea.naveditor.property.ui.DeepLinkCellRenderer;
import com.google.wireless.android.sdk.stats.NavEditorEvent;
import com.intellij.ui.ColoredListCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0014J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/naveditor/property/inspector/DeepLinkInspectorBuilder;", "Lcom/android/tools/idea/naveditor/property/inspector/ComponentListInspectorBuilder;", "()V", "invokeDialog", "", "component", "Lcom/android/tools/idea/common/model/NlComponent;", "parent", "isApplicable", "", "onAdd", "onEdit", "title", "", "intellij.android.nav.editor"})
public final class DeepLinkInspectorBuilder
extends ComponentListInspectorBuilder {
    @Override
    @NotNull
    public String title(@NotNull NlComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return "Deep Links";
    }

    @Override
    protected void onAdd(@NotNull NlComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.invokeDialog(null, parent);
    }

    @Override
    protected void onEdit(@NotNull NlComponent component) {
        block0: {
            NlComponent nlComponent;
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            NlComponent nlComponent2 = component.getParent();
            if (nlComponent2 == null) break block0;
            NlComponent it = nlComponent = nlComponent2;
            boolean bl = false;
            NlComponent nlComponent3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)nlComponent3, (String)"it");
            this.invokeDialog(component, nlComponent3);
        }
    }

    @Override
    protected boolean isApplicable(@NotNull NlComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return NavComponentHelperKt.getSupportsDeeplinks(component);
    }

    private final void invokeDialog(NlComponent component, NlComponent parent) {
        AddDeeplinkDialog dialog = new AddDeeplinkDialog(component, parent);
        if (dialog.showAndGet()) {
            dialog.save();
            NavUsageTracker.Companion.getInstance(parent.getModel()).createEvent(component == null ? NavEditorEvent.NavEditorEventType.CREATE_DEEP_LINK : NavEditorEvent.NavEditorEventType.EDIT_DEEP_LINK).withSource(NavEditorEvent.Source.PROPERTY_INSPECTOR).log();
        }
    }

    public DeepLinkInspectorBuilder() {
        super("deepLink", (ColoredListCellRenderer<NlComponent>)((ColoredListCellRenderer)new DeepLinkCellRenderer()));
    }
}

