/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.editor;

import com.android.resources.ResourceType;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.Device;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.draw.DrawCommandBaseKt;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.naveditor.editor.Destination;
import com.android.tools.idea.naveditor.editor.DestinationKt;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.model.NavModelHelperKt;
import com.android.tools.idea.naveditor.scene.NavColors;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ui.StartupUiUtil;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0006)*+,-.B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001c\u001a\u00020\u001dH&J\u0011\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0000H\u0096\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00032\u0006\u0010!\u001a\u00020\u0016H\u0004J\"\u0010\"\u001a\u00020#2\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0%H&R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0012\u0010\u001a\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0018\u0082\u0001\u0002/0\u00a8\u00061"}, d2={"Lcom/android/tools/idea/naveditor/editor/Destination;", "", "parent", "Lcom/android/tools/idea/common/model/NlComponent;", "(Lcom/android/tools/idea/common/model/NlComponent;)V", "component", "getComponent", "()Lcom/android/tools/idea/common/model/NlComponent;", "setComponent", "destinationOrder", "Lcom/android/tools/idea/naveditor/editor/Destination$DestinationOrder;", "getDestinationOrder", "()Lcom/android/tools/idea/naveditor/editor/Destination$DestinationOrder;", "iconWidth", "", "getIconWidth", "()I", "inProject", "", "getInProject", "()Z", "label", "", "getLabel", "()Ljava/lang/String;", "getParent", "typeLabel", "getTypeLabel", "addToGraph", "", "compareTo", "other", "createComponent", "tagName", "thumbnail", "Ljava/awt/Image;", "iconCallback", "Lkotlin/Function2;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/awt/Dimension;", "Ljavax/swing/ImageIcon;", "Companion", "DestinationOrder", "IncludeDestination", "PlaceholderDestination", "RegularDestination", "ScreenShapedDestination", "Lcom/android/tools/idea/naveditor/editor/Destination$ScreenShapedDestination;", "Lcom/android/tools/idea/naveditor/editor/Destination$IncludeDestination;", "intellij.android.nav.editor"})
public abstract class Destination
implements Comparable<Destination> {
    @Nullable
    private NlComponent component;
    @NotNull
    private final NlComponent parent;
    private static final Comparator<Destination> comparator;
    @NotNull
    public static final Companion Companion;

    public abstract void addToGraph();

    @NotNull
    public abstract String getLabel();

    @NotNull
    public abstract Image thumbnail(@NotNull Function2<? super VirtualFile, ? super Dimension, ? extends ImageIcon> var1);

    @NotNull
    public abstract String getTypeLabel();

    @NotNull
    public abstract DestinationOrder getDestinationOrder();

    public abstract boolean getInProject();

    public abstract int getIconWidth();

    @Nullable
    public NlComponent getComponent() {
        return this.component;
    }

    public void setComponent(@Nullable NlComponent nlComponent) {
        this.component = nlComponent;
    }

    @Override
    public int compareTo(@NotNull Destination other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return comparator.compare(this, other);
    }

    @Nullable
    protected final NlComponent createComponent(@NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        NlComponent newComponent = NlComponentHelperKt.createChild$default(this.getParent(), tagName, true, null, null, null, null, null, 124, null);
        if (newComponent == null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(this){
                final /* synthetic */ Destination this$0;

                public final void run() {
                    NlModel nlModel = this.this$0.getParent().getModel();
                    Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"parent.model");
                    Messages.showErrorDialog((Project)nlModel.getProject(), (String)"Failed to create Destination!", (String)"Error");
                }
                {
                    this.this$0 = destination;
                }
            });
        }
        return newComponent;
    }

    @NotNull
    protected NlComponent getParent() {
        return this.parent;
    }

    private Destination(NlComponent parent) {
        this.parent = parent;
    }

    static {
        Companion = new Companion(null);
        comparator = Comparator.comparing(Companion.comparator.1.INSTANCE).thenComparingInt(Companion.comparator.2.INSTANCE).thenComparing(Companion.comparator.3.INSTANCE);
    }

    public /* synthetic */ Destination(NlComponent parent, DefaultConstructorMarker $constructor_marker) {
        this(parent);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/naveditor/editor/Destination$DestinationOrder;", "", "(Ljava/lang/String;I)V", "PLACEHOLDER", "FRAGMENT", "INCLUDE", "ACTIVITY", "OTHER", "intellij.android.nav.editor"})
    public static final class DestinationOrder
    extends Enum<DestinationOrder> {
        public static final /* enum */ DestinationOrder PLACEHOLDER;
        public static final /* enum */ DestinationOrder FRAGMENT;
        public static final /* enum */ DestinationOrder INCLUDE;
        public static final /* enum */ DestinationOrder ACTIVITY;
        public static final /* enum */ DestinationOrder OTHER;
        private static final /* synthetic */ DestinationOrder[] $VALUES;

        static {
            DestinationOrder[] destinationOrderArray = new DestinationOrder[5];
            DestinationOrder[] destinationOrderArray2 = destinationOrderArray;
            destinationOrderArray[0] = PLACEHOLDER = new DestinationOrder();
            destinationOrderArray[1] = FRAGMENT = new DestinationOrder();
            destinationOrderArray[2] = INCLUDE = new DestinationOrder();
            destinationOrderArray[3] = ACTIVITY = new DestinationOrder();
            destinationOrderArray[4] = OTHER = new DestinationOrder();
            $VALUES = destinationOrderArray;
        }

        public static DestinationOrder[] values() {
            return (DestinationOrder[])$VALUES.clone();
        }

        public static DestinationOrder valueOf(String string2) {
            return Enum.valueOf(DestinationOrder.class, string2);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J:\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00170\u0015H&J\"\u0010\u0018\u001a\u00020\u00192\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00170\u0015H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/naveditor/editor/Destination$ScreenShapedDestination;", "Lcom/android/tools/idea/naveditor/editor/Destination;", "parent", "Lcom/android/tools/idea/common/model/NlComponent;", "(Lcom/android/tools/idea/common/model/NlComponent;)V", "iconWidth", "", "getIconWidth", "()I", "thumbnailDimension", "Ljava/awt/Dimension;", "getThumbnailDimension", "()Ljava/awt/Dimension;", "drawBackground", "", "graphics", "Ljava/awt/Graphics2D;", "drawThumbnailContents", "model", "Lcom/android/tools/idea/common/model/NlModel;", "iconCallback", "Lkotlin/Function2;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljavax/swing/ImageIcon;", "thumbnail", "Ljava/awt/Image;", "intellij.android.nav.editor"})
    public static abstract class ScreenShapedDestination
    extends Destination {
        @Override
        public int getIconWidth() {
            return this.getThumbnailDimension().width;
        }

        private final Dimension getThumbnailDimension() {
            Object object;
            block3: {
                String string2;
                block2: {
                    NlModel nlModel = this.getParent().getModel();
                    Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"parent.model");
                    NlModel model2 = nlModel;
                    Configuration configuration = model2.getConfiguration();
                    Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"model.configuration");
                    object = configuration.getDeviceState();
                    if (object == null || (object = object.getOrientation()) == null) break block2;
                    String it = string2 = object;
                    boolean bl = false;
                    Configuration configuration2 = model2.getConfiguration();
                    Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"model.configuration");
                    Device device = configuration2.getCachedDevice();
                    object = device != null ? device.getScreenSize((ScreenOrientation)it) : null;
                    if (object != null) break block3;
                }
                string2 = "No device in configuration!";
                throw new IllegalStateException(string2.toString());
            }
            Object screenSize = object;
            int n = screenSize.height;
            int n2 = screenSize.width;
            float ratio = 60.0f / (float)Math.max(n, n2);
            return new Dimension((int)((float)screenSize.width * ratio - 2.0f), (int)((float)screenSize.height * ratio - 2.0f));
        }

        @Override
        @NotNull
        public Image thumbnail(@NotNull Function2<? super VirtualFile, ? super Dimension, ? extends ImageIcon> iconCallback2) {
            Intrinsics.checkNotNullParameter(iconCallback2, (String)"iconCallback");
            NlModel nlModel = this.getParent().getModel();
            Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"parent.model");
            NlModel model2 = nlModel;
            BufferedImage result = new BufferedImage(this.getThumbnailDimension().width + 2, this.getThumbnailDimension().height + 2, 2);
            Graphics2D graphics = result.createGraphics();
            RoundRectangle2D.Float roundRect = new RoundRectangle2D.Float(1.0f, 1.0f, this.getThumbnailDimension().width, this.getThumbnailDimension().height, 3.0f, 3.0f);
            Graphics2D graphics2D = graphics;
            Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"graphics");
            Shape oldClip = graphics2D.getClip();
            graphics.setClip(roundRect);
            graphics.setRenderingHints(DrawCommandBaseKt.getHQ_RENDERING_HINTS());
            this.drawThumbnailContents(model2, this.getThumbnailDimension(), graphics, iconCallback2);
            graphics.setClip(oldClip);
            graphics.setColor((Color)NavColors.INSTANCE.getPLACEHOLDER_BORDER());
            graphics.setStroke(DestinationKt.access$getTHUMBNAIL_BORDER_STROKE$p());
            roundRect.width += 1.0f;
            roundRect.height += 1.0f;
            roundRect.x = 0.5f;
            roundRect.y = 0.5f;
            roundRect.archeight = 5.0f;
            roundRect.arcwidth = 5.0f;
            graphics.draw(roundRect);
            return result;
        }

        public abstract void drawThumbnailContents(@NotNull NlModel var1, @NotNull Dimension var2, @NotNull Graphics2D var3, @NotNull Function2<? super VirtualFile, ? super Dimension, ? extends ImageIcon> var4);

        protected final void drawBackground(@NotNull Dimension thumbnailDimension, @NotNull Graphics2D graphics) {
            Intrinsics.checkNotNullParameter((Object)thumbnailDimension, (String)"thumbnailDimension");
            Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
            graphics.setColor((Color)NavColors.INSTANCE.getPLACEHOLDER_BACKGROUND());
            graphics.fillRect((int)1.0f, (int)1.0f, thumbnailDimension.width, thumbnailDimension.height);
        }

        public ScreenShapedDestination(@NotNull NlComponent parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(parent, null);
        }
    }

    @VisibleForTesting
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001BW\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\"\u001a\u00020#H\u0016J\t\u0010$\u001a\u00020\u0003H\u00c4\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u0005H\u00c2\u0003J\t\u0010'\u001a\u00020\bH\u00c6\u0003J\t\u0010(\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u000bH\u00c2\u0003J\t\u0010*\u001a\u00020\rH\u00c6\u0003J\u000b\u0010+\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J_\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J:\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0018\u00104\u001a\u0014\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020705H\u0016J\u0013\u00108\u001a\u00020\r2\b\u00109\u001a\u0004\u0018\u00010:H\u00d6\u0003J\t\u0010;\u001a\u00020<H\u00d6\u0001J\t\u0010=\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0017R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017R\u0014\u0010 \u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0017\u00a8\u0006>"}, d2={"Lcom/android/tools/idea/naveditor/editor/Destination$RegularDestination;", "Lcom/android/tools/idea/naveditor/editor/Destination$ScreenShapedDestination;", "parent", "Lcom/android/tools/idea/common/model/NlComponent;", "tag", "", "destinationLabel", "destinationClass", "Lcom/intellij/psi/PsiClass;", "idBase", "layoutFile", "Lcom/intellij/psi/xml/XmlFile;", "inProject", "", "dynamicModuleName", "(Lcom/android/tools/idea/common/model/NlComponent;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/psi/PsiClass;Ljava/lang/String;Lcom/intellij/psi/xml/XmlFile;ZLjava/lang/String;)V", "getDestinationClass", "()Lcom/intellij/psi/PsiClass;", "destinationOrder", "Lcom/android/tools/idea/naveditor/editor/Destination$DestinationOrder;", "getDestinationOrder", "()Lcom/android/tools/idea/naveditor/editor/Destination$DestinationOrder;", "getDynamicModuleName", "()Ljava/lang/String;", "getIdBase", "getInProject", "()Z", "label", "getLabel", "getParent", "()Lcom/android/tools/idea/common/model/NlComponent;", "getTag", "typeLabel", "getTypeLabel", "addToGraph", "", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "drawThumbnailContents", "model", "Lcom/android/tools/idea/common/model/NlModel;", "thumbnailDimension", "Ljava/awt/Dimension;", "graphics", "Ljava/awt/Graphics2D;", "iconCallback", "Lkotlin/Function2;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljavax/swing/ImageIcon;", "equals", "other", "", "hashCode", "", "toString", "intellij.android.nav.editor"})
    public static final class RegularDestination
    extends ScreenShapedDestination {
        @NotNull
        private final DestinationOrder destinationOrder;
        @NotNull
        private final String label;
        @NotNull
        private final NlComponent parent;
        @NotNull
        private final String tag;
        private final String destinationLabel;
        @NotNull
        private final PsiClass destinationClass;
        @NotNull
        private final String idBase;
        private final XmlFile layoutFile;
        private final boolean inProject;
        @Nullable
        private final String dynamicModuleName;

        @Override
        public void drawThumbnailContents(@NotNull NlModel model2, @NotNull Dimension thumbnailDimension, @NotNull Graphics2D graphics, @NotNull Function2<? super VirtualFile, ? super Dimension, ? extends ImageIcon> iconCallback2) {
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Intrinsics.checkNotNullParameter((Object)thumbnailDimension, (String)"thumbnailDimension");
            Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
            Intrinsics.checkNotNullParameter(iconCallback2, (String)"iconCallback");
            if (this.layoutFile != null) {
                VirtualFile virtualFile = this.layoutFile.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"layoutFile.virtualFile");
                ImageIcon icon2 = (ImageIcon)iconCallback2.invoke((Object)virtualFile, (Object)thumbnailDimension);
                StartupUiUtil.drawImage((Graphics)graphics, (Image)ImageUtils.iconToImage((Icon)icon2), (Rectangle)new Rectangle((int)1.0f, (int)1.0f, thumbnailDimension.width, thumbnailDimension.height), null);
            } else {
                this.drawBackground(thumbnailDimension, graphics);
                graphics.setFont(graphics.getFont().deriveFont(13).deriveFont(1));
                String unknownString = "?";
                int stringWidth = graphics.getFontMetrics().charWidth('?');
                graphics.setColor((Color)NavColors.INSTANCE.getPLACEHOLDER_TEXT());
                float f = (float)((thumbnailDimension.width - stringWidth) / 2) + 1.0f;
                int n = thumbnailDimension.height;
                FontMetrics fontMetrics = graphics.getFontMetrics();
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"graphics.fontMetrics");
                graphics.drawString(unknownString, f, (float)((n + fontMetrics.getAscent()) / 2) + 1.0f);
            }
        }

        @Override
        @NotNull
        public String getTypeLabel() {
            NlModel nlModel = this.getParent().getModel();
            Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"parent.model");
            String string2 = NavModelHelperKt.getSchema(nlModel).getTagLabel(this.tag);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parent.model.schema.getTagLabel(tag)");
            return string2;
        }

        @Override
        @NotNull
        public DestinationOrder getDestinationOrder() {
            return this.destinationOrder;
        }

        @Override
        @NotNull
        public String getLabel() {
            return this.label;
        }

        @Override
        public void addToGraph() {
            NlComponent nlComponent = this.createComponent(this.tag);
            if (nlComponent == null) {
                return;
            }
            NlComponent newComponent = nlComponent;
            newComponent.assignId(this.idBase);
            newComponent.setAndroidAttribute("name", this.destinationClass.getQualifiedName());
            newComponent.setAttribute("http://schemas.android.com/apk/res-auto", "moduleName", this.dynamicModuleName);
            newComponent.setAndroidAttribute("label", this.getLabel());
            if (NavComponentHelperKt.getStartDestinationId(this.getParent()) == null) {
                NavComponentHelperKt.setAsStartDestination(newComponent);
            }
            XmlFile xmlFile = this.layoutFile;
            if (xmlFile != null) {
                XmlFile xmlFile2;
                XmlFile it = xmlFile2 = xmlFile;
                boolean bl = false;
                String layoutId = "@" + ResourceType.LAYOUT.getName() + "/" + FileUtil.getNameWithoutExtension((String)it.getName());
                newComponent.setAttribute("http://schemas.android.com/tools", "layout", layoutId);
            }
            this.setComponent(newComponent);
        }

        @Override
        @NotNull
        protected NlComponent getParent() {
            return this.parent;
        }

        @NotNull
        public final String getTag() {
            return this.tag;
        }

        @NotNull
        public final PsiClass getDestinationClass() {
            return this.destinationClass;
        }

        @NotNull
        public final String getIdBase() {
            return this.idBase;
        }

        @Override
        public boolean getInProject() {
            return this.inProject;
        }

        @Nullable
        public final String getDynamicModuleName() {
            return this.dynamicModuleName;
        }

        @JvmOverloads
        public RegularDestination(@NotNull NlComponent parent, @NotNull String tag, @Nullable String destinationLabel, @NotNull PsiClass destinationClass, @NotNull String idBase, @Nullable XmlFile layoutFile, boolean inProject, @Nullable String dynamicModuleName) {
            String string2;
            String string3;
            Collection it;
            Object object;
            Collection collection;
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)destinationClass, (String)"destinationClass");
            Intrinsics.checkNotNullParameter((Object)idBase, (String)"idBase");
            super(parent);
            this.parent = parent;
            this.tag = tag;
            this.destinationLabel = destinationLabel;
            this.destinationClass = destinationClass;
            this.idBase = idBase;
            this.layoutFile = layoutFile;
            this.inProject = inProject;
            this.dynamicModuleName = dynamicModuleName;
            NlModel nlModel = this.getParent().getModel();
            Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"parent.model");
            Collection collection2 = collection = NavModelHelperKt.getSchema(nlModel).getDestinationTypesForTag(this.tag);
            RegularDestination regularDestination = this;
            boolean bl = false;
            regularDestination.destinationOrder = object = it.contains(NavigationSchema.DestinationType.FRAGMENT) ? DestinationOrder.FRAGMENT : (it.contains(NavigationSchema.DestinationType.ACTIVITY) ? DestinationOrder.ACTIVITY : DestinationOrder.OTHER);
            RegularDestination regularDestination2 = this;
            Object object2 = this.destinationLabel;
            if (object2 == null) {
                XmlFile xmlFile = this.layoutFile;
                if (xmlFile != null) {
                    it = collection = xmlFile;
                    regularDestination = regularDestination2;
                    boolean bl2 = false;
                    object = FileUtil.getNameWithoutExtension((String)it.getName());
                    regularDestination2 = regularDestination;
                    object2 = object;
                } else {
                    object2 = string3 = null;
                }
            }
            if (object2 == null) {
                string3 = string2 = this.destinationClass.getName();
            }
            if (string3 == null) {
                string2 = this.tag;
            }
            regularDestination2.label = string2;
        }

        public /* synthetic */ RegularDestination(NlComponent nlComponent, String string2, String string3, PsiClass psiClass, String string4, XmlFile xmlFile, boolean bl, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
            String string6;
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0 && (string6 = psiClass.getName()) == null) {
                string6 = string4 = string2;
            }
            if ((n & 0x20) != 0) {
                xmlFile = null;
            }
            if ((n & 0x40) != 0) {
                bl = true;
            }
            if ((n & 0x80) != 0) {
                string5 = null;
            }
            this(nlComponent, string2, string3, psiClass, string4, xmlFile, bl, string5);
        }

        @JvmOverloads
        public RegularDestination(@NotNull NlComponent parent, @NotNull String tag, @Nullable String destinationLabel, @NotNull PsiClass destinationClass, @NotNull String idBase, @Nullable XmlFile layoutFile, boolean inProject) {
            this(parent, tag, destinationLabel, destinationClass, idBase, layoutFile, inProject, null, 128, null);
        }

        @JvmOverloads
        public RegularDestination(@NotNull NlComponent parent, @NotNull String tag, @Nullable String destinationLabel, @NotNull PsiClass destinationClass, @NotNull String idBase, @Nullable XmlFile layoutFile) {
            this(parent, tag, destinationLabel, destinationClass, idBase, layoutFile, false, null, 192, null);
        }

        @JvmOverloads
        public RegularDestination(@NotNull NlComponent parent, @NotNull String tag, @Nullable String destinationLabel, @NotNull PsiClass destinationClass, @NotNull String idBase) {
            this(parent, tag, destinationLabel, destinationClass, idBase, null, false, null, 224, null);
        }

        @JvmOverloads
        public RegularDestination(@NotNull NlComponent parent, @NotNull String tag, @Nullable String destinationLabel, @NotNull PsiClass destinationClass) {
            this(parent, tag, destinationLabel, destinationClass, null, null, false, null, 240, null);
        }

        @JvmOverloads
        public RegularDestination(@NotNull NlComponent parent, @NotNull String tag, @NotNull PsiClass destinationClass) {
            this(parent, tag, null, destinationClass, null, null, false, null, 244, null);
        }

        @NotNull
        protected final NlComponent component1() {
            return this.getParent();
        }

        @NotNull
        public final String component2() {
            return this.tag;
        }

        private final String component3() {
            return this.destinationLabel;
        }

        @NotNull
        public final PsiClass component4() {
            return this.destinationClass;
        }

        @NotNull
        public final String component5() {
            return this.idBase;
        }

        private final XmlFile component6() {
            return this.layoutFile;
        }

        public final boolean component7() {
            return this.getInProject();
        }

        @Nullable
        public final String component8() {
            return this.dynamicModuleName;
        }

        @NotNull
        public final RegularDestination copy(@NotNull NlComponent parent, @NotNull String tag, @Nullable String destinationLabel, @NotNull PsiClass destinationClass, @NotNull String idBase, @Nullable XmlFile layoutFile, boolean inProject, @Nullable String dynamicModuleName) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)destinationClass, (String)"destinationClass");
            Intrinsics.checkNotNullParameter((Object)idBase, (String)"idBase");
            return new RegularDestination(parent, tag, destinationLabel, destinationClass, idBase, layoutFile, inProject, dynamicModuleName);
        }

        public static /* synthetic */ RegularDestination copy$default(RegularDestination regularDestination, NlComponent nlComponent, String string2, String string3, PsiClass psiClass, String string4, XmlFile xmlFile, boolean bl, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                nlComponent = regularDestination.getParent();
            }
            if ((n & 2) != 0) {
                string2 = regularDestination.tag;
            }
            if ((n & 4) != 0) {
                string3 = regularDestination.destinationLabel;
            }
            if ((n & 8) != 0) {
                psiClass = regularDestination.destinationClass;
            }
            if ((n & 0x10) != 0) {
                string4 = regularDestination.idBase;
            }
            if ((n & 0x20) != 0) {
                xmlFile = regularDestination.layoutFile;
            }
            if ((n & 0x40) != 0) {
                bl = regularDestination.getInProject();
            }
            if ((n & 0x80) != 0) {
                string5 = regularDestination.dynamicModuleName;
            }
            return regularDestination.copy(nlComponent, string2, string3, psiClass, string4, xmlFile, bl, string5);
        }

        @NotNull
        public String toString() {
            return "RegularDestination(parent=" + this.getParent() + ", tag=" + this.tag + ", destinationLabel=" + this.destinationLabel + ", destinationClass=" + this.destinationClass + ", idBase=" + this.idBase + ", layoutFile=" + this.layoutFile + ", inProject=" + this.getInProject() + ", dynamicModuleName=" + this.dynamicModuleName + ")";
        }

        public int hashCode() {
            NlComponent nlComponent = this.getParent();
            String string2 = this.tag;
            String string3 = this.destinationLabel;
            PsiClass psiClass = this.destinationClass;
            String string4 = this.idBase;
            XmlFile xmlFile = this.layoutFile;
            int n = ((((((nlComponent != null ? nlComponent.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (psiClass != null ? psiClass.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (xmlFile != null ? xmlFile.hashCode() : 0)) * 31;
            int n2 = this.getInProject() ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            String string5 = this.dynamicModuleName;
            return (n + n2) * 31 + (string5 != null ? string5.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RegularDestination)) break block3;
                    RegularDestination regularDestination = (RegularDestination)object;
                    if (!Intrinsics.areEqual((Object)this.getParent(), (Object)regularDestination.getParent()) || !Intrinsics.areEqual((Object)this.tag, (Object)regularDestination.tag) || !Intrinsics.areEqual((Object)this.destinationLabel, (Object)regularDestination.destinationLabel) || !Intrinsics.areEqual((Object)this.destinationClass, (Object)regularDestination.destinationClass) || !Intrinsics.areEqual((Object)this.idBase, (Object)regularDestination.idBase) || !Intrinsics.areEqual((Object)this.layoutFile, (Object)regularDestination.layoutFile) || this.getInProject() != regularDestination.getInProject() || !Intrinsics.areEqual((Object)this.dynamicModuleName, (Object)regularDestination.dynamicModuleName)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c4\u0003J\u001d\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010 \u001a\u00020\u00122\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020\u000eH\u00d6\u0001J\"\u0010$\u001a\u00020%2\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0'H\u0016J\t\u0010+\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\f\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/naveditor/editor/Destination$IncludeDestination;", "Lcom/android/tools/idea/naveditor/editor/Destination;", "graph", "", "parent", "Lcom/android/tools/idea/common/model/NlComponent;", "(Ljava/lang/String;Lcom/android/tools/idea/common/model/NlComponent;)V", "destinationOrder", "Lcom/android/tools/idea/naveditor/editor/Destination$DestinationOrder;", "getDestinationOrder", "()Lcom/android/tools/idea/naveditor/editor/Destination$DestinationOrder;", "getGraph", "()Ljava/lang/String;", "iconWidth", "", "getIconWidth", "()I", "inProject", "", "getInProject", "()Z", "label", "getLabel", "getParent", "()Lcom/android/tools/idea/common/model/NlComponent;", "typeLabel", "getTypeLabel", "addToGraph", "", "component1", "component2", "copy", "equals", "other", "", "hashCode", "thumbnail", "Ljava/awt/Image;", "iconCallback", "Lkotlin/Function2;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/awt/Dimension;", "Ljavax/swing/ImageIcon;", "toString", "intellij.android.nav.editor"})
    public static final class IncludeDestination
    extends Destination {
        private final int iconWidth;
        @NotNull
        private final String label;
        @NotNull
        private final DestinationOrder destinationOrder;
        private final boolean inProject;
        @NotNull
        private final String graph;
        @NotNull
        private final NlComponent parent;

        @Override
        public void addToGraph() {
            NlComponent nlComponent = this.createComponent("include");
            if (nlComponent == null) {
                return;
            }
            NlComponent newComponent = nlComponent;
            newComponent.setAttribute("http://schemas.android.com/apk/res-auto", "graph", "@" + ResourceType.NAVIGATION.getName() + "/" + FileUtil.getNameWithoutExtension((String)this.graph));
            this.setComponent(newComponent);
        }

        @Override
        public int getIconWidth() {
            return this.iconWidth;
        }

        @Override
        @NotNull
        public String getLabel() {
            return this.label;
        }

        @Override
        @NotNull
        public Image thumbnail(@NotNull Function2<? super VirtualFile, ? super Dimension, ? extends ImageIcon> iconCallback2) {
            Intrinsics.checkNotNullParameter(iconCallback2, (String)"iconCallback");
            Image image = ImageUtils.iconToImage((Icon)StudioIcons.NavEditor.ExistingDestinations.NESTED).getScaledInstance(45, 60, 4);
            Intrinsics.checkNotNullExpressionValue((Object)image, (String)"iconToImage(StudioIcons.\u2026IGHT, Image.SCALE_SMOOTH)");
            return image;
        }

        @Override
        @NotNull
        public String getTypeLabel() {
            NlModel nlModel = this.getParent().getModel();
            Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"parent.model");
            String string2 = NavModelHelperKt.getSchema(nlModel).getTagLabel("include");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parent.model.schema.getT\u2026SdkConstants.TAG_INCLUDE)");
            return string2;
        }

        @Override
        @NotNull
        public DestinationOrder getDestinationOrder() {
            return this.destinationOrder;
        }

        @Override
        public boolean getInProject() {
            return this.inProject;
        }

        @NotNull
        public final String getGraph() {
            return this.graph;
        }

        @Override
        @NotNull
        protected NlComponent getParent() {
            return this.parent;
        }

        public IncludeDestination(@NotNull String graph, @NotNull NlComponent parent) {
            Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(parent, null);
            this.graph = graph;
            this.parent = parent;
            this.iconWidth = 45;
            this.label = this.graph;
            this.destinationOrder = DestinationOrder.INCLUDE;
            this.inProject = true;
        }

        @NotNull
        public final String component1() {
            return this.graph;
        }

        @NotNull
        protected final NlComponent component2() {
            return this.getParent();
        }

        @NotNull
        public final IncludeDestination copy(@NotNull String graph, @NotNull NlComponent parent) {
            Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            return new IncludeDestination(graph, parent);
        }

        public static /* synthetic */ IncludeDestination copy$default(IncludeDestination includeDestination, String string2, NlComponent nlComponent, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = includeDestination.graph;
            }
            if ((n & 2) != 0) {
                nlComponent = includeDestination.getParent();
            }
            return includeDestination.copy(string2, nlComponent);
        }

        @NotNull
        public String toString() {
            return "IncludeDestination(graph=" + this.graph + ", parent=" + this.getParent() + ")";
        }

        public int hashCode() {
            String string2 = this.graph;
            NlComponent nlComponent = this.getParent();
            return (string2 != null ? string2.hashCode() : 0) * 31 + (nlComponent != null ? nlComponent.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IncludeDestination)) break block3;
                    IncludeDestination includeDestination = (IncludeDestination)object;
                    if (!Intrinsics.areEqual((Object)this.graph, (Object)includeDestination.graph) || !Intrinsics.areEqual((Object)this.getParent(), (Object)includeDestination.getParent())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c4\u0003J\u0013\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J:\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020#0!H\u0016J\u0013\u0010$\u001a\u00020\n2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\u000eH\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006*"}, d2={"Lcom/android/tools/idea/naveditor/editor/Destination$PlaceholderDestination;", "Lcom/android/tools/idea/naveditor/editor/Destination$ScreenShapedDestination;", "parent", "Lcom/android/tools/idea/common/model/NlComponent;", "(Lcom/android/tools/idea/common/model/NlComponent;)V", "destinationOrder", "Lcom/android/tools/idea/naveditor/editor/Destination$DestinationOrder;", "getDestinationOrder", "()Lcom/android/tools/idea/naveditor/editor/Destination$DestinationOrder;", "inProject", "", "getInProject", "()Z", "label", "", "getLabel", "()Ljava/lang/String;", "getParent", "()Lcom/android/tools/idea/common/model/NlComponent;", "typeLabel", "getTypeLabel", "addToGraph", "", "component1", "copy", "drawThumbnailContents", "model", "Lcom/android/tools/idea/common/model/NlModel;", "thumbnailDimension", "Ljava/awt/Dimension;", "graphics", "Ljava/awt/Graphics2D;", "iconCallback", "Lkotlin/Function2;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljavax/swing/ImageIcon;", "equals", "other", "", "hashCode", "", "toString", "intellij.android.nav.editor"})
    public static final class PlaceholderDestination
    extends ScreenShapedDestination {
        @NotNull
        private final String label;
        @NotNull
        private final String typeLabel;
        @NotNull
        private final DestinationOrder destinationOrder;
        private final boolean inProject;
        @NotNull
        private final NlComponent parent;

        @Override
        public void addToGraph() {
            NlComponent nlComponent = this.createComponent("fragment");
            if (nlComponent == null) {
                return;
            }
            NlComponent newComponent = nlComponent;
            newComponent.assignId("placeholder");
            if (NavComponentHelperKt.getStartDestinationId(this.getParent()) == null) {
                NavComponentHelperKt.setAsStartDestination(newComponent);
            }
            this.setComponent(newComponent);
        }

        @Override
        @NotNull
        public String getLabel() {
            return this.label;
        }

        @Override
        public void drawThumbnailContents(@NotNull NlModel model2, @NotNull Dimension thumbnailDimension, @NotNull Graphics2D graphics, @NotNull Function2<? super VirtualFile, ? super Dimension, ? extends ImageIcon> iconCallback2) {
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Intrinsics.checkNotNullParameter((Object)thumbnailDimension, (String)"thumbnailDimension");
            Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
            Intrinsics.checkNotNullParameter(iconCallback2, (String)"iconCallback");
            this.drawBackground(thumbnailDimension, graphics);
            graphics.setColor((Color)NavColors.INSTANCE.getPLACEHOLDER_BORDER());
            graphics.drawLine(0, 0, thumbnailDimension.width, thumbnailDimension.height);
            graphics.drawLine(thumbnailDimension.width, 0, 0, thumbnailDimension.height);
        }

        @Override
        @NotNull
        public String getTypeLabel() {
            return this.typeLabel;
        }

        @Override
        @NotNull
        public DestinationOrder getDestinationOrder() {
            return this.destinationOrder;
        }

        @Override
        public boolean getInProject() {
            return this.inProject;
        }

        @Override
        @NotNull
        protected NlComponent getParent() {
            return this.parent;
        }

        public PlaceholderDestination(@NotNull NlComponent parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(parent);
            this.parent = parent;
            this.label = "placeholder";
            this.typeLabel = "Empty destination";
            this.destinationOrder = DestinationOrder.PLACEHOLDER;
            this.inProject = true;
        }

        @NotNull
        protected final NlComponent component1() {
            return this.getParent();
        }

        @NotNull
        public final PlaceholderDestination copy(@NotNull NlComponent parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            return new PlaceholderDestination(parent);
        }

        public static /* synthetic */ PlaceholderDestination copy$default(PlaceholderDestination placeholderDestination, NlComponent nlComponent, int n, Object object) {
            if ((n & 1) != 0) {
                nlComponent = placeholderDestination.getParent();
            }
            return placeholderDestination.copy(nlComponent);
        }

        @NotNull
        public String toString() {
            return "PlaceholderDestination(parent=" + this.getParent() + ")";
        }

        public int hashCode() {
            NlComponent nlComponent = this.getParent();
            return nlComponent != null ? nlComponent.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PlaceholderDestination)) break block3;
                    PlaceholderDestination placeholderDestination = (PlaceholderDestination)object;
                    if (!Intrinsics.areEqual((Object)this.getParent(), (Object)placeholderDestination.getParent())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/naveditor/editor/Destination$Companion;", "", "()V", "comparator", "Ljava/util/Comparator;", "Lcom/android/tools/idea/naveditor/editor/Destination;", "kotlin.jvm.PlatformType", "intellij.android.nav.editor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

