/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.dialogs;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.adtui.model.stdui.CommonTextFieldModel;
import com.android.tools.adtui.stdui.CommonTextField;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlDependencyManager;
import com.android.tools.idea.naveditor.dialogs.ActionTextFieldModel;
import com.android.tools.idea.naveditor.dialogs.MimeTypeTextFieldModel;
import com.android.tools.idea.naveditor.dialogs.UriTextFieldModel;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.ui.EnabledProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.NavEditorEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddDeeplinkDialog
extends DialogWrapper {
    @VisibleForTesting
    CommonTextField<UriTextFieldModel> myUriField;
    @VisibleForTesting
    JCheckBox myAutoVerify;
    @VisibleForTesting
    CommonTextField<MimeTypeTextFieldModel> myMimeTypeField;
    @VisibleForTesting
    CommonTextField<ActionTextFieldModel> myActionField;
    JBLabel myMimeTypeLabel;
    JBLabel myActionLabel;
    private JPanel myContentPanel;
    @Nullable
    private final NlComponent myExistingComponent;
    @NotNull
    private final NlComponent myParent;
    private final BindingsManager myBindings;
    private final boolean myIsExtended;
    private static final GradleVersion EXTENDED_VERSION = GradleVersion.parse((String)"2.3.0-alpha06");

    public AddDeeplinkDialog(@Nullable NlComponent existing, @NotNull NlComponent parent) {
        if (parent == null) {
            AddDeeplinkDialog.$$$reportNull$$$0(0);
        }
        super(false);
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        List<String> argumentNames = NavComponentHelperKt.getArgumentNames(parent);
        ((UriTextFieldModel)this.myUriField.getEditorModel()).setArgumentNames(argumentNames);
        ((ActionTextFieldModel)this.myActionField.getEditorModel()).populateCompletions(parent.getModel().getModule());
        if (existing != null) {
            this.myUriField.setText(NavComponentHelperKt.getUri(existing));
            this.myAutoVerify.setSelected(Boolean.parseBoolean(existing.getAttribute("http://schemas.android.com/apk/res/android", "autoVerify")));
            this.myMimeTypeField.setText(NavComponentHelperKt.getDeepLinkMimeType(existing));
            this.myActionField.setText(NavComponentHelperKt.getDeepLinkAction(existing));
        }
        this.init();
        if (existing == null) {
            this.myOKAction.putValue("Name", "Add");
            this.setTitle("Add Deep Link");
        } else {
            this.myOKAction.putValue("Name", "Update");
            this.setTitle("Update Deep Link");
        }
        this.myExistingComponent = existing;
        this.myParent = parent;
        this.myIsExtended = AddDeeplinkDialog.isExtended(parent);
        if (this.myIsExtended) {
            ObservableBool isNotEmpty = new TextProperty(this.myUriField).isEmpty().not();
            this.myBindings.bind((SettableValue)new EnabledProperty((JComponent)this.myAutoVerify), (ObservableValue)isNotEmpty);
        } else {
            this.myMimeTypeField.setVisible(false);
            this.myActionField.setVisible(false);
            this.myMimeTypeLabel.setVisible(false);
            this.myActionLabel.setVisible(false);
        }
    }

    @Nullable
    protected ValidationInfo doValidate() {
        int index;
        String mimeType;
        String uri = this.myUriField.getText();
        if (!uri.isEmpty()) {
            try {
                new URI(uri.replaceAll("\\{[^}]*}", "dummy"));
            }
            catch (URISyntaxException e) {
                return new ValidationInfo("Invalid URI!", this.myUriField);
            }
        }
        if (!((mimeType = this.myMimeTypeField.getText()).isEmpty() || (index = mimeType.indexOf(47)) >= 1 && index != mimeType.length() - 1)) {
            return new ValidationInfo("Invalid MIME type.");
        }
        if (uri.isEmpty() && mimeType.isEmpty() && this.myActionField.getText().isEmpty()) {
            String text = this.myIsExtended ? "Uri, MIME type, and action cannot all be empty." : "URI must be set!";
            return new ValidationInfo(text, this.myUriField);
        }
        return null;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    @VisibleForTesting
    String getUri() {
        return this.myUriField.getText();
    }

    @VisibleForTesting
    public boolean getAutoVerify() {
        return this.myAutoVerify.isSelected();
    }

    @VisibleForTesting
    public String getMimeType() {
        return this.myMimeTypeField.getText();
    }

    @VisibleForTesting
    public String getAction() {
        return this.myActionField.getText();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            AddDeeplinkDialog.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myUriField;
    }

    public void save() {
        String name = this.myExistingComponent == null ? "Add Deep Link" : "Update Deep Link";
        NlWriteCommandActionUtil.run(this.myParent, name, () -> {
            NlComponent realComponent = this.myExistingComponent;
            if (realComponent == null) {
                realComponent = NlComponentHelperKt.createChild(this.myParent, "deepLink", false, null, null, null, null, InsertType.CREATE);
                if (realComponent == null) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)this.myParent.getModel().getProject(), (String)"Failed to create Deep Link!", (String)"Error"));
                    return;
                }
                realComponent.ensureId();
            }
            NavComponentHelperKt.setUriAndLog(realComponent, this.getUri(), NavEditorEvent.Source.PROPERTY_INSPECTOR);
            NavComponentHelperKt.setAutoVerifyAndLog(realComponent, this.getAutoVerify() && !this.getUri().isEmpty(), NavEditorEvent.Source.PROPERTY_INSPECTOR);
            NavComponentHelperKt.setDeeplinkMimeTypeAndLog(realComponent, this.getMimeType(), NavEditorEvent.Source.PROPERTY_INSPECTOR);
            NavComponentHelperKt.setDeeplinkActionAndLog(realComponent, this.getAction(), NavEditorEvent.Source.PROPERTY_INSPECTOR);
        });
    }

    private void createUIComponents() {
        this.myUriField = new CommonTextField((CommonTextFieldModel)new UriTextFieldModel());
        this.myMimeTypeField = new CommonTextField((CommonTextFieldModel)new MimeTypeTextFieldModel());
        this.myActionField = new CommonTextField((CommonTextFieldModel)new ActionTextFieldModel());
    }

    private static boolean isExtended(@NotNull NlComponent parent) {
        GradleVersion version;
        if (parent == null) {
            AddDeeplinkDialog.$$$reportNull$$$0(2);
        }
        if ((version = NlDependencyManager.getInstance().getModuleDependencyVersion(GoogleMavenArtifactId.ANDROIDX_NAVIGATION_COMMON, parent.getModel().getFacet())) == null) {
            return true;
        }
        return version.compareTo(EXTENDED_VERSION) >= 0;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(15, 7, 0, 7), -1, -1, false, false));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("URI");
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Auto Verify");
        jPanel.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMimeTypeLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("MIME type");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myActionLabel = jBLabel = new JBLabel();
        jBLabel.setText("Action");
        jPanel.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, new Dimension(20, -1), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        CommonTextField<UriTextFieldModel> commonTextField = this.myUriField;
        commonTextField.setText("");
        jPanel2.add((Component)commonTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(320, -1), null));
        this.myAutoVerify = jCheckBox = new JCheckBox();
        jCheckBox.setText("");
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(2, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        CommonTextField<MimeTypeTextFieldModel> commonTextField2 = this.myMimeTypeField;
        jPanel3.add((Component)commonTextField2, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(320, -1), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(3, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        CommonTextField<ActionTextFieldModel> commonTextField3 = this.myActionField;
        jPanel4.add((Component)commonTextField3, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(320, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/dialogs/AddDeeplinkDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/dialogs/AddDeeplinkDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isExtended";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

