/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.analytics;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.naveditor.analytics.NavLogEvent$WhenMappings;
import com.android.tools.idea.naveditor.analytics.NavUsageTracker;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.model.NavModelHelperKt;
import com.google.wireless.android.sdk.stats.NavActionInfo;
import com.google.wireless.android.sdk.stats.NavDestinationInfo;
import com.google.wireless.android.sdk.stats.NavEditorEvent;
import com.google.wireless.android.sdk.stats.NavPropertyInfo;
import com.google.wireless.android.sdk.stats.NavSchemaInfo;
import com.google.wireless.android.sdk.stats.NavigationContents;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0015J\u0006\u0010\u001c\u001a\u00020\u0000J\u0006\u0010\u001d\u001a\u00020\u0000J\u0010\u0010\u001e\u001a\u00020\u00002\b\u0010\u001f\u001a\u0004\u0018\u00010 R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/naveditor/analytics/NavLogEvent;", "", "event", "Lcom/google/wireless/android/sdk/stats/NavEditorEvent$NavEditorEventType;", "tracker", "Lcom/android/tools/idea/naveditor/analytics/NavUsageTracker;", "(Lcom/google/wireless/android/sdk/stats/NavEditorEvent$NavEditorEventType;Lcom/android/tools/idea/naveditor/analytics/NavUsageTracker;)V", "navEventBuilder", "Lcom/google/wireless/android/sdk/stats/NavEditorEvent$Builder;", "schema", "Lorg/jetbrains/android/dom/navigation/NavigationSchema;", "convertTag", "Lcom/google/wireless/android/sdk/stats/NavPropertyInfo$TagType;", "tagName", "", "getProtoForTest", "Lcom/google/wireless/android/sdk/stats/NavEditorEvent;", "log", "", "withActionInfo", "actionComponent", "Lcom/android/tools/idea/common/model/NlComponent;", "withAttributeInfo", "attrName", "wasEmpty", "", "withDestinationInfo", "destination", "withNavigationContents", "withSchemaInfo", "withSource", "source", "Lcom/google/wireless/android/sdk/stats/NavEditorEvent$Source;", "intellij.android.nav.editor"})
public final class NavLogEvent {
    private final NavEditorEvent.Builder navEventBuilder;
    private final NavigationSchema schema;
    private final NavUsageTracker tracker;

    public final void log() {
        NavEditorEvent navEditorEvent = this.navEventBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)navEditorEvent, (String)"navEventBuilder.build()");
        this.tracker.logEvent(navEditorEvent);
    }

    @TestOnly
    @NotNull
    public final NavEditorEvent getProtoForTest() {
        NavEditorEvent navEditorEvent = this.navEventBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)navEditorEvent, (String)"navEventBuilder.build()");
        return navEditorEvent;
    }

    @NotNull
    public final NavLogEvent withAttributeInfo(@NotNull String attrName, @Nullable String tagName, boolean wasEmpty) {
        NavPropertyInfo.Property property;
        NavPropertyInfo.Builder builder2;
        Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
        NavPropertyInfo.Builder builder3 = builder2 = this.navEventBuilder.getPropertyInfoBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"builder");
        switch (attrName) {
            case "action": {
                property = NavPropertyInfo.Property.ACTION;
                break;
            }
            case "argType": {
                property = NavPropertyInfo.Property.ARG_TYPE;
                break;
            }
            case "autoVerify": {
                property = NavPropertyInfo.Property.AUTO_VERIFY;
                break;
            }
            case "data": {
                property = NavPropertyInfo.Property.DATA;
                break;
            }
            case "dataPattern": {
                property = NavPropertyInfo.Property.DATA_PATTERN;
                break;
            }
            case "defaultNavHost": {
                property = NavPropertyInfo.Property.DEFAULT_NAV_HOST;
                break;
            }
            case "defaultValue": {
                property = NavPropertyInfo.Property.DEFAULT_VALUE;
                break;
            }
            case "destination": {
                property = NavPropertyInfo.Property.DESTINATION;
                break;
            }
            case "enterAnim": {
                property = NavPropertyInfo.Property.ENTER_ANIM;
                break;
            }
            case "exitAnim": {
                property = NavPropertyInfo.Property.EXIT_ANIM;
                break;
            }
            case "graph": {
                property = NavPropertyInfo.Property.GRAPH;
                break;
            }
            case "id": {
                property = NavPropertyInfo.Property.ID;
                break;
            }
            case "label": {
                property = NavPropertyInfo.Property.LABEL;
                break;
            }
            case "launchSingleTop": {
                property = NavPropertyInfo.Property.LAUNCH_SINGLE_TOP;
                break;
            }
            case "name": {
                property = NavPropertyInfo.Property.NAME;
                break;
            }
            case "navGraph": {
                property = NavPropertyInfo.Property.NAV_GRAPH;
                break;
            }
            case "nullable": {
                property = NavPropertyInfo.Property.NULLABLE;
                break;
            }
            case "popEnterAnim": {
                property = NavPropertyInfo.Property.POP_ENTER_ANIM;
                break;
            }
            case "popExitAnim": {
                property = NavPropertyInfo.Property.POP_EXIT_ANIM;
                break;
            }
            case "popUpTo": {
                property = NavPropertyInfo.Property.POP_UP_TO;
                break;
            }
            case "popUpToInclusive": {
                property = NavPropertyInfo.Property.POP_UP_TO_INCLUSIVE;
                break;
            }
            case "startDestination": {
                property = NavPropertyInfo.Property.START_DESTINATION;
                break;
            }
            case "uri": {
                property = NavPropertyInfo.Property.URI;
                break;
            }
            case "mimeType": {
                property = NavPropertyInfo.Property.MIME_TYPE;
                break;
            }
            default: {
                property = NavPropertyInfo.Property.CUSTOM;
            }
        }
        builder3.setProperty(property);
        String string2 = tagName;
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            builder2.setContainingTag(this.convertTag(it));
        }
        builder2.setWasEmpty(wasEmpty);
        this.navEventBuilder.setPropertyInfo(builder2);
        return this;
    }

    private final NavPropertyInfo.TagType convertTag(String tagName) {
        Object object;
        Object object2;
        Object object3 = this.schema;
        return (object3 != null && (object3 = object3.isFragmentTag(tagName)) != null ? (Boolean)object3 : false) ? NavPropertyInfo.TagType.FRAGMENT_TAG : (((object2 = this.schema) != null && (object2 = object2.isActivityTag(tagName)) != null ? (Boolean)object2 : false) ? NavPropertyInfo.TagType.ACTIVITY_TAG : (Intrinsics.areEqual((Object)"include", (Object)tagName) ? NavPropertyInfo.TagType.INCLUDE_TAG : (((object = this.schema) != null && (object = object.isNavigationTag(tagName)) != null ? (Boolean)object : false) ? NavPropertyInfo.TagType.NAVIGATION_TAG : (Intrinsics.areEqual((Object)"action", (Object)tagName) ? NavPropertyInfo.TagType.ACTION_TAG : (Intrinsics.areEqual((Object)"argument", (Object)tagName) ? NavPropertyInfo.TagType.ARGUMENT_TAG : (Intrinsics.areEqual((Object)"deepLink", (Object)tagName) ? NavPropertyInfo.TagType.DEEPLINK_TAG : NavPropertyInfo.TagType.CUSTOM_TAG))))));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final NavLogEvent withActionInfo(@NotNull NlComponent actionComponent) {
        NlComponent destinationParent;
        int n;
        NavActionInfo.ActionType actionType;
        NlComponent nlComponent;
        Intrinsics.checkNotNullParameter((Object)actionComponent, (String)"actionComponent");
        NavActionInfo.Builder builder2 = this.navEventBuilder.getActionInfoBuilder();
        NlComponent nlComponent2 = actionComponent.getParent();
        if (nlComponent2 == null) {
            return this;
        }
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent2, (String)"actionComponent.parent ?: return this");
        NlComponent source = nlComponent2;
        NlComponent destination = NavComponentHelperKt.getActionDestination(actionComponent);
        NlComponent nlComponent3 = actionComponent.getParent();
        if (nlComponent3 != null && NavComponentHelperKt.isNavigation(nlComponent3)) {
            nlComponent = actionComponent.getParent();
        } else {
            NlComponent nlComponent4 = actionComponent.getParent();
            nlComponent = nlComponent4 != null ? nlComponent4.getParent() : null;
        }
        NlComponent root = nlComponent;
        NavActionInfo.Builder builder3 = builder2;
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"builder");
        switch (NavLogEvent$WhenMappings.$EnumSwitchMapping$0[NavComponentHelperKt.getActionType(actionComponent, root).ordinal()]) {
            case 1: {
                actionType = NavActionInfo.ActionType.GLOBAL;
                break;
            }
            case 2: {
                actionType = NavActionInfo.ActionType.EXIT;
                break;
            }
            case 3: {
                actionType = NavActionInfo.ActionType.REGULAR;
                break;
            }
            case 4: {
                actionType = NavActionInfo.ActionType.SELF;
                break;
            }
            default: {
                actionType = NavActionInfo.ActionType.UNKNOWN;
            }
        }
        builder3.setType(actionType);
        if (NavComponentHelperKt.getPopUpTo(actionComponent) != null) {
            builder2.setHasPop(true);
        }
        if (Intrinsics.areEqual((Object)NavComponentHelperKt.getInclusive(actionComponent), (Object)true)) {
            builder2.setInclusive(true);
        }
        NavActionInfo.Builder builder4 = builder2;
        Object object = actionComponent.getParent();
        if (object != null && (object = ((NlComponent)object).getChildren()) != null) {
            int n2;
            void $this$count$iv;
            Iterable iterable = (Iterable)object;
            NavActionInfo.Builder builder5 = builder4;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    NlComponent it = (NlComponent)element$iv;
                    boolean bl = false;
                    NlComponent nlComponent5 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)nlComponent5, (String)"it");
                    if (!NavComponentHelperKt.isAction(nlComponent5) || (it = ++count$iv) >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            int n3 = n2;
            builder4 = builder5;
            n = n3;
        } else {
            n = 0;
        }
        builder4.setCountFromSource(n);
        NlComponent nlComponent6 = destination;
        if (nlComponent6 == null || (nlComponent6 = nlComponent6.getParent()) == null) {
            nlComponent6 = destinationParent = destination;
        }
        if (destinationParent != null) {
            Object element$iv;
            int countToDestination = 0;
            int countSame = 0;
            LinkedList<NlComponent> destinationQueue = new LinkedList<NlComponent>();
            destinationQueue.add(destinationParent);
            while (!(element$iv = (Collection)destinationQueue).isEmpty()) {
                NlComponent d = (NlComponent)destinationQueue.removeFirst();
                if (Intrinsics.areEqual((Object)d, (Object)source) ^ true) {
                    NlComponent nlComponent7 = d;
                    Intrinsics.checkNotNullExpressionValue((Object)nlComponent7, (String)"d");
                    if (Intrinsics.areEqual((Object)nlComponent7.getId(), (Object)source.getId())) continue;
                }
                NlComponent nlComponent8 = d;
                Intrinsics.checkNotNullExpressionValue((Object)nlComponent8, (String)"d");
                List<NlComponent> list = nlComponent8.getChildren();
                Intrinsics.checkNotNullExpressionValue(list, (String)"d.children");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    NlComponent child = (NlComponent)element$iv2;
                    boolean bl = false;
                    NlComponent nlComponent9 = child;
                    Intrinsics.checkNotNullExpressionValue((Object)nlComponent9, (String)"child");
                    if (NavComponentHelperKt.isAction(nlComponent9) && Intrinsics.areEqual((Object)NavComponentHelperKt.getActionDestination(child), (Object)destination)) {
                        int n4 = countToDestination;
                        countToDestination = n4 + 1;
                        if (Intrinsics.areEqual((Object)child.getParent(), (Object)source)) {
                            n4 = countSame;
                            countSame = n4 + 1;
                        }
                    }
                    if (!NavComponentHelperKt.isDestination(child)) continue;
                    destinationQueue.add(child);
                }
            }
            builder2.setCountToDestination(countToDestination);
            builder2.setCountSame(countSame);
        }
        this.navEventBuilder.setActionInfo(builder2);
        return this;
    }

    @NotNull
    public final NavLogEvent withDestinationInfo(@NotNull NlComponent destination) {
        NavDestinationInfo.Builder builder2;
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        NavDestinationInfo.Builder builder3 = builder2 = this.navEventBuilder.getDestinationInfoBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"builder");
        builder3.setType(NavComponentHelperKt.isFragment(destination) ? NavDestinationInfo.DestinationType.FRAGMENT : (NavComponentHelperKt.isActivity(destination) ? NavDestinationInfo.DestinationType.ACTIVITY : NavDestinationInfo.DestinationType.OTHER));
        CharSequence charSequence = NavComponentHelperKt.getClassName(destination);
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            builder2.setHasClass(true);
        }
        if (!((charSequence = (CharSequence)NavComponentHelperKt.getLayout(destination)) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            builder2.setHasLayout(true);
        }
        this.navEventBuilder.setDestinationInfo(builder2);
        return this;
    }

    @NotNull
    public final NavLogEvent withSchemaInfo() {
        NavSchemaInfo.Builder builder2;
        NavSchemaInfo.Builder builder3 = builder2 = this.navEventBuilder.getSchemaInfoBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"builder");
        NavigationSchema navigationSchema = this.schema;
        builder3.setCustomNavigators(navigationSchema != null ? navigationSchema.getCustomNavigatorCount() : 0);
        NavigationSchema navigationSchema2 = this.schema;
        builder2.setCustomTags(navigationSchema2 != null ? navigationSchema2.getCustomTagCount() : 0);
        NavigationSchema navigationSchema3 = this.schema;
        builder2.setCustomDestinations(navigationSchema3 != null ? navigationSchema3.getCustomDestinationCount() : 0);
        this.navEventBuilder.setSchemaInfo(builder2);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final NavLogEvent withNavigationContents() {
        NavigationContents.Builder builder2 = this.navEventBuilder.getContentsBuilder();
        NlModel nlModel = this.tracker.getModel();
        if (nlModel == null) {
            return this;
        }
        NlModel model2 = nlModel;
        int fragments = 0;
        int activities = 0;
        int customDestinations = 0;
        int regularActions = 0;
        int exitActions = 0;
        int globalActions = 0;
        int selfActions = 0;
        int includes = 0;
        int nestedGraphs = 0;
        int placeholders = 0;
        Iterator iterator = model2.flattenComponents().iterator();
        while (true) {
            NlComponent nlComponent;
            NlComponent component;
            if (!iterator.hasNext()) {
                NavigationContents.Builder builder3 = builder2;
                Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"builder");
                builder3.setFragments(fragments);
                builder2.setActivities(activities);
                builder2.setCustomDestinations(customDestinations);
                builder2.setRegularActions(regularActions);
                builder2.setExitActions(exitActions);
                builder2.setGlobalActions(globalActions);
                builder2.setSelfActions(selfActions);
                builder2.setIncludes(includes);
                builder2.setNestedGraphs(nestedGraphs);
                builder2.setPlaceholders(placeholders);
                this.navEventBuilder.setContents(builder2);
                return this;
            }
            NlComponent nlComponent2 = component = (NlComponent)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)nlComponent2, (String)"component");
            if (NavComponentHelperKt.isDestination(nlComponent2)) {
                if (NavComponentHelperKt.isFragment(component)) {
                    ++fragments;
                }
                if (NavComponentHelperKt.isActivity(component)) {
                    ++activities;
                }
                if (NavComponentHelperKt.getDestinationType(component) == NavigationSchema.DestinationType.OTHER) {
                    ++customDestinations;
                }
                if (NavComponentHelperKt.isInclude(component)) {
                    ++includes;
                }
                if (component.getParent() != null && NavComponentHelperKt.isNavigation(component) && !NavComponentHelperKt.isInclude(component)) {
                    ++nestedGraphs;
                }
                if (NavComponentHelperKt.getDestinationType(component) != NavigationSchema.DestinationType.NAVIGATION && NavComponentHelperKt.getClassName(component) == null) {
                    ++placeholders;
                }
            }
            if (!NavComponentHelperKt.isAction(component)) continue;
            NlComponent nlComponent3 = component.getParent();
            if (nlComponent3 != null && NavComponentHelperKt.isNavigation(nlComponent3)) {
                nlComponent = component.getParent();
            } else {
                NlComponent nlComponent4 = component.getParent();
                nlComponent = nlComponent4 != null ? nlComponent4.getParent() : null;
            }
            NlComponent actionRoot = nlComponent;
            switch (NavLogEvent$WhenMappings.$EnumSwitchMapping$1[NavComponentHelperKt.getActionType(component, actionRoot).ordinal()]) {
                case 1: {
                    ++globalActions;
                    break;
                }
                case 2: {
                    ++selfActions;
                    break;
                }
                case 3: {
                    ++regularActions;
                    break;
                }
                case 4: {
                    ++exitActions;
                    break;
                }
            }
        }
    }

    @NotNull
    public final NavLogEvent withSource(@Nullable NavEditorEvent.Source source) {
        block0: {
            NavEditorEvent.Source source2;
            NavEditorEvent.Source source3 = source;
            if (source3 == null) break block0;
            NavEditorEvent.Source it = source2 = source3;
            boolean bl = false;
            this.navEventBuilder.setSource(source);
        }
        return this;
    }

    public NavLogEvent(@NotNull NavEditorEvent.NavEditorEventType event, @NotNull NavUsageTracker tracker2) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)tracker2, (String)"tracker");
        this.tracker = tracker2;
        NavEditorEvent.Builder builder2 = NavEditorEvent.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"NavEditorEvent.newBuilder()");
        this.navEventBuilder = builder2;
        NlModel nlModel = this.tracker.getModel();
        this.schema = nlModel != null ? NavModelHelperKt.getSchema(nlModel) : null;
        this.navEventBuilder.setType(event);
    }
}

