/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.util;

import com.android.tools.idea.compose.preview.util.FilteredPsiRecursiveElementWalkingVisitor;
import com.android.tools.idea.compose.preview.util.NaivePsiFileChangeDetector;
import com.android.tools.idea.compose.preview.util.PsiFileChangeDetector;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001dB\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0010\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00110\u00110\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/compose/preview/util/HashPsiFileChangeDetector;", "Lcom/android/tools/idea/compose/preview/util/PsiFileChangeDetector;", "elementFilter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "", "(Lkotlin/jvm/functions/Function1;)V", "lastCalculatedHashValueMarker", "Lcom/intellij/openapi/util/Key;", "Lcom/android/tools/idea/compose/preview/util/HashPsiFileChangeDetector$CalculatedHashValue;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "naiveDetector", "Lcom/android/tools/idea/compose/preview/util/NaivePsiFileChangeDetector;", "upToDateMarker", "", "calculateAndCheckFileHash", "file", "Lcom/intellij/psi/PsiFile;", "updateOnCheck", "calculateFileHash", "root", "clearMarks", "", "hasFileChanged", "isFileTooLarge", "markFileAsUpToDate", "CalculatedHashValue", "intellij.android.compose-designer"})
public final class HashPsiFileChangeDetector
implements PsiFileChangeDetector {
    private final Logger log;
    private final NaivePsiFileChangeDetector naiveDetector;
    private final Key<Integer> upToDateMarker;
    private final Key<CalculatedHashValue> lastCalculatedHashValueMarker;
    private final Function1<PsiElement, Boolean> elementFilter;

    /*
     * WARNING - void declaration
     */
    private final int calculateFileHash(PsiFile root) {
        CalculatedHashValue calculatedHashValue = (CalculatedHashValue)root.getCopyableUserData(this.lastCalculatedHashValueMarker);
        if (calculatedHashValue != null) {
            void lastPsiModificationCheck;
            CalculatedHashValue calculatedHashValue2;
            CalculatedHashValue $dstr$lastPsiModificationCheck$cachedHash = calculatedHashValue2 = calculatedHashValue;
            boolean bl = false;
            long l = $dstr$lastPsiModificationCheck$cachedHash.component1();
            int cachedHash = $dstr$lastPsiModificationCheck$cachedHash.component2();
            if (lastPsiModificationCheck == root.getModificationStamp()) {
                return cachedHash;
            }
        }
        Object object = ReadAction.compute((ThrowableComputable)new ThrowableComputable(this, root){
            final /* synthetic */ HashPsiFileChangeDetector this$0;
            final /* synthetic */ PsiFile $root;

            /*
             * WARNING - void declaration
             */
            public final Integer compute() {
                void fileHash;
                Ref.IntRef intRef = new Ref.IntRef();
                intRef.element = 0;
                this.$root.accept((PsiElementVisitor)new FilteredPsiRecursiveElementWalkingVisitor((Function1<? super PsiElement, Boolean>)HashPsiFileChangeDetector.access$getElementFilter$p(this.this$0), (Function2<? super PsiElement, ? super Integer, Boolean>)((Function2)new Function2<PsiElement, Integer, Boolean>((Ref.IntRef)fileHash){
                    final /* synthetic */ Ref.IntRef $fileHash;

                    public final boolean invoke(@NotNull PsiElement $noName_0, int elementKey) {
                        Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                        this.$fileHash.element = 31 * this.$fileHash.element + elementKey;
                        return true;
                    }
                    {
                        this.$fileHash = intRef;
                        super(2);
                    }
                })));
                this.$root.putCopyableUserData(HashPsiFileChangeDetector.access$getLastCalculatedHashValueMarker$p(this.this$0), (Object)new CalculatedHashValue(this.$root.getModificationStamp(), fileHash.element));
                return fileHash.element;
            }
            {
                this.this$0 = hashPsiFileChangeDetector;
                this.$root = psiFile2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ReadAction.compute<Int, \u2026rn@compute fileHash\n    }");
        return ((Number)object).intValue();
    }

    private final boolean isFileTooLarge(PsiFile file2) {
        VirtualFile virtualFile = file2.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file.virtualFile");
        return virtualFile.getLength() > (long)20000;
    }

    private final boolean calculateAndCheckFileHash(PsiFile file2, boolean updateOnCheck) {
        Integer currentHash = (Integer)file2.getCopyableUserData(this.upToDateMarker);
        int newHash = this.calculateFileHash(file2);
        if (updateOnCheck) {
            file2.putCopyableUserData(this.upToDateMarker, (Object)newHash);
        }
        Integer n = currentHash;
        return n == null || newHash != n;
    }

    @Override
    public boolean hasFileChanged(@NotNull PsiFile file2, boolean updateOnCheck) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        boolean isFileTooLarge = this.isFileTooLarge(file2);
        if (isFileTooLarge || PowerSaveMode.isEnabled()) {
            if (isFileTooLarge) {
                this.log.debug(file2 + " is too large to be evaluated via HashPsiFileChangeDetector");
            }
            return this.naiveDetector.hasFileChanged(file2, updateOnCheck);
        }
        return this.calculateAndCheckFileHash(file2, updateOnCheck);
    }

    @Override
    public void markFileAsUpToDate(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!this.naiveDetector.hasFileChanged(file2, false)) {
            return;
        }
        boolean isFileTooLarge = this.isFileTooLarge(file2);
        if (!isFileTooLarge && !PowerSaveMode.isEnabled()) {
            this.calculateAndCheckFileHash(file2, true);
        } else if (isFileTooLarge) {
            this.log.debug(file2 + " is too large to be evaluated via HashPsiFileChangeDetector");
        }
        this.naiveDetector.markFileAsUpToDate(file2);
    }

    @Override
    public void clearMarks(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        file2.putCopyableUserData(this.upToDateMarker, null);
        file2.putCopyableUserData(this.lastCalculatedHashValueMarker, null);
        this.naiveDetector.clearMarks(file2);
    }

    public HashPsiFileChangeDetector(@NotNull Function1<? super PsiElement, Boolean> elementFilter) {
        Intrinsics.checkNotNullParameter(elementFilter, (String)"elementFilter");
        this.elementFilter = elementFilter;
        Logger logger2 = Logger.getInstance(HashPsiFileChangeDetector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(HashP\u2026angeDetector::class.java)");
        this.log = logger2;
        this.naiveDetector = new NaivePsiFileChangeDetector(this.elementFilter.toString());
        Key key = Key.create((String)(HashPsiFileChangeDetector.class.getName() + "#" + this.elementFilter + "}"));
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<Int>(\"${HashP\u2026a.name}#$elementFilter}\")");
        this.upToDateMarker = key;
        Key key2 = Key.create((String)(HashPsiFileChangeDetector.class.getName() + "#hashMarker#" + this.elementFilter + "}"));
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"Key.create<CalculatedHas\u2026hMarker#$elementFilter}\")");
        this.lastCalculatedHashValueMarker = key2;
    }

    public /* synthetic */ HashPsiFileChangeDetector(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = 1.INSTANCE;
        }
        this((Function1<? super PsiElement, Boolean>)function1);
    }

    public HashPsiFileChangeDetector() {
        this(null, 1, null);
    }

    @Override
    public void forceMarkFileAsUpToDate(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        PsiFileChangeDetector.DefaultImpls.forceMarkFileAsUpToDate(this, file2);
    }

    public static final /* synthetic */ Function1 access$getElementFilter$p(HashPsiFileChangeDetector $this) {
        return $this.elementFilter;
    }

    public static final /* synthetic */ Key access$getLastCalculatedHashValueMarker$p(HashPsiFileChangeDetector $this) {
        return $this.lastCalculatedHashValueMarker;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/compose/preview/util/HashPsiFileChangeDetector$CalculatedHashValue;", "", "lastPsiModificationStamp", "", "lastHashValue", "", "(JI)V", "getLastHashValue", "()I", "getLastPsiModificationStamp", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.android.compose-designer"})
    private static final class CalculatedHashValue {
        private final long lastPsiModificationStamp;
        private final int lastHashValue;

        public final long getLastPsiModificationStamp() {
            return this.lastPsiModificationStamp;
        }

        public final int getLastHashValue() {
            return this.lastHashValue;
        }

        public CalculatedHashValue(long lastPsiModificationStamp, int lastHashValue) {
            this.lastPsiModificationStamp = lastPsiModificationStamp;
            this.lastHashValue = lastHashValue;
        }

        public final long component1() {
            return this.lastPsiModificationStamp;
        }

        public final int component2() {
            return this.lastHashValue;
        }

        @NotNull
        public final CalculatedHashValue copy(long lastPsiModificationStamp, int lastHashValue) {
            return new CalculatedHashValue(lastPsiModificationStamp, lastHashValue);
        }

        public static /* synthetic */ CalculatedHashValue copy$default(CalculatedHashValue calculatedHashValue, long l, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                l = calculatedHashValue.lastPsiModificationStamp;
            }
            if ((n2 & 2) != 0) {
                n = calculatedHashValue.lastHashValue;
            }
            return calculatedHashValue.copy(l, n);
        }

        @NotNull
        public String toString() {
            return "CalculatedHashValue(lastPsiModificationStamp=" + this.lastPsiModificationStamp + ", lastHashValue=" + this.lastHashValue + ")";
        }

        public int hashCode() {
            return Long.hashCode(this.lastPsiModificationStamp) * 31 + Integer.hashCode(this.lastHashValue);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CalculatedHashValue)) break block3;
                    CalculatedHashValue calculatedHashValue = (CalculatedHashValue)object;
                    if (this.lastPsiModificationStamp != calculatedHashValue.lastPsiModificationStamp || this.lastHashValue != calculatedHashValue.lastHashValue) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

