/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.util;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fR\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/compose/preview/util/FpsCalculator;", "", "timeNanosProvider", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "frameCounter", "startTimeNanos", "getDurationMs", "", "getFps", "incrementFrameCounter", "", "resetAndStart", "intellij.android.compose-designer"})
public final class FpsCalculator {
    private long startTimeNanos;
    private long frameCounter;
    private final Function0<Long> timeNanosProvider;

    public final synchronized void resetAndStart() {
        this.startTimeNanos = ((Number)this.timeNanosProvider.invoke()).longValue();
        this.frameCounter = 0L;
    }

    public final synchronized int getFps() {
        long timePeriodNanos = ((Number)this.timeNanosProvider.invoke()).longValue() - this.startTimeNanos;
        if (timePeriodNanos <= 0L) {
            return 0;
        }
        return (int)(this.frameCounter * (long)1000000000 / timePeriodNanos);
    }

    public final synchronized int getDurationMs() {
        return (int)Duration.ofNanos(((Number)this.timeNanosProvider.invoke()).longValue() - this.startTimeNanos).toMillis();
    }

    public final synchronized void incrementFrameCounter() {
        FpsCalculator fpsCalculator = this;
        ++fpsCalculator.frameCounter;
        long cfr_ignored_0 = fpsCalculator.frameCounter;
    }

    public FpsCalculator(@NotNull Function0<Long> timeNanosProvider) {
        Intrinsics.checkNotNullParameter(timeNanosProvider, (String)"timeNanosProvider");
        this.timeNanosProvider = timeNanosProvider;
    }
}

