/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ*\u0010\u0014\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0016\u001a\u00020\r2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u001c\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\b\u0010\u001a\u001a\u00020\u0003H\u0007J\u0018\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0002R \u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/compose/preview/util/DelayedLruActionQueue;", "", "maxLruPlaces", "", "delay", "Ljava/time/Duration;", "scheduledExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "(ILjava/time/Duration;Ljava/util/concurrent/ScheduledExecutorService;)V", "actionToDisposable", "Ljava/util/WeakHashMap;", "Lkotlin/Function0;", "", "Lcom/intellij/openapi/Disposable;", "actionToScheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "lruQueue", "Ljava/util/ArrayDeque;", "queueLock", "Ljava/util/concurrent/locks/ReentrantLock;", "addActionToQueue", "action", "actionDisposable", "scheduledFuture", "addDelayedAction", "parentDisposable", "queueSize", "removeActionFromQueue", "", "intellij.android.compose-designer"})
public final class DelayedLruActionQueue {
    private final ReentrantLock queueLock;
    private final ArrayDeque<Function0<Unit>> lruQueue;
    private final WeakHashMap<Function0<Unit>, Disposable> actionToDisposable;
    private final WeakHashMap<Function0<Unit>, ScheduledFuture<?>> actionToScheduledFuture;
    private final int maxLruPlaces;
    private final Duration delay;
    private final ScheduledExecutorService scheduledExecutorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TestOnly
    public final int queueSize() {
        Lock lock = this.queueLock;
        lock.lock();
        try {
            void var3_4;
            boolean bl;
            boolean bl2 = false;
            int queueSize = this.lruQueue.size();
            boolean bl3 = bl = queueSize == this.actionToDisposable.size();
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string2 = "actionToDisposable size must always match the size of the lruQueue";
                throw new AssertionError((Object)string2);
            }
            void var6_8 = var3_4;
            return (int)var6_8;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addActionToQueue(Function0<Unit> action2, Disposable actionDisposable, ScheduledFuture<?> scheduledFuture2) {
        Lock lock = this.queueLock;
        lock.lock();
        try {
            boolean bl = false;
            Map map2 = this.actionToDisposable;
            Function0<Unit> function0 = action2;
            if (map2.containsKey(function0)) {
                this.lruQueue.add(this.lruQueue.remove());
                ScheduledFuture<?> scheduledFuture3 = this.actionToScheduledFuture.get(action2);
                if (scheduledFuture3 != null) {
                    scheduledFuture3.cancel(false);
                }
                ((Map)this.actionToScheduledFuture).put(action2, scheduledFuture2);
                return;
            }
            if (this.lruQueue.size() == this.maxLruPlaces) {
                Function0<Unit> removedAction = this.lruQueue.remove();
                this.actionToDisposable.remove(removedAction);
                this.actionToScheduledFuture.remove(removedAction);
                removedAction.invoke();
            }
            this.lruQueue.add(action2);
            ((Map)this.actionToDisposable).put(action2, actionDisposable);
            ((Map)this.actionToScheduledFuture).put(action2, scheduledFuture2);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean removeActionFromQueue(Function0<Unit> action2) {
        if (action2 == null) {
            return false;
        }
        Lock lock = this.queueLock;
        lock.lock();
        try {
            boolean bl = false;
            boolean actionWasStillInTheQueue = this.lruQueue.remove(action2);
            ScheduledFuture<?> scheduledFuture2 = this.actionToScheduledFuture.remove(action2);
            if (scheduledFuture2 != null) {
                scheduledFuture2.cancel(false);
            }
            Disposable disposable2 = this.actionToDisposable.remove(action2);
            if (disposable2 != null) {
                Disposable disposable3;
                Disposable it = disposable3 = disposable2;
                boolean bl2 = false;
                Disposer.dispose((Disposable)it);
            }
            boolean bl3 = actionWasStillInTheQueue;
            return bl3;
        }
        finally {
            lock.unlock();
        }
    }

    public final void addDelayedAction(@NotNull Disposable parentDisposable, @NotNull Function0<Unit> action2) {
        ScheduledFuture<?> scheduledFuture2;
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        WeakReference<Function0<Unit>> weakActionRef = new WeakReference<Function0<Unit>>(action2);
        Disposable disposable2 = new Disposable(this, weakActionRef){
            final /* synthetic */ DelayedLruActionQueue this$0;
            final /* synthetic */ WeakReference $weakActionRef;

            public final void dispose() {
                Function0 function0 = (Function0)this.$weakActionRef.get();
                if (function0 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)function0, (String)"weakActionRef.get() ?: return@Disposable");
                Function0 actionToRemove = function0;
                DelayedLruActionQueue.access$removeActionFromQueue(this.this$0, actionToRemove);
            }
            {
                this.this$0 = delayedLruActionQueue;
                this.$weakActionRef = weakReference;
            }
        };
        Disposer.register((Disposable)parentDisposable, (Disposable)disposable2);
        ScheduledFuture<?> scheduledFuture3 = scheduledFuture2 = this.scheduledExecutorService.schedule(new Runnable(this, weakActionRef){
            final /* synthetic */ DelayedLruActionQueue this$0;
            final /* synthetic */ WeakReference $weakActionRef;

            public final void run() {
                Function0 function0 = (Function0)this.$weakActionRef.get();
                if (function0 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)function0, (String)"weakActionRef.get() ?: return@schedule");
                Function0 actionToRemove = function0;
                if (DelayedLruActionQueue.access$removeActionFromQueue(this.this$0, actionToRemove)) {
                    actionToRemove.invoke();
                }
            }
            {
                this.this$0 = delayedLruActionQueue;
                this.$weakActionRef = weakReference;
            }
        }, this.delay.toMillis(), TimeUnit.MILLISECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture3, (String)"scheduledFuture");
        this.addActionToQueue(action2, disposable2, scheduledFuture3);
    }

    public DelayedLruActionQueue(int maxLruPlaces, @NotNull Duration delay, @NotNull ScheduledExecutorService scheduledExecutorService) {
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        Intrinsics.checkNotNullParameter((Object)scheduledExecutorService, (String)"scheduledExecutorService");
        this.maxLruPlaces = maxLruPlaces;
        this.delay = delay;
        this.scheduledExecutorService = scheduledExecutorService;
        this.queueLock = new ReentrantLock();
        this.lruQueue = new ArrayDeque(this.maxLruPlaces);
        this.actionToDisposable = new WeakHashMap();
        this.actionToScheduledFuture = new WeakHashMap();
    }

    public /* synthetic */ DelayedLruActionQueue(int n, Duration duration, ScheduledExecutorService scheduledExecutorService, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            ScheduledExecutorService scheduledExecutorService2 = AppExecutorUtil.createBoundedScheduledExecutorService((String)"DelayedLruActionQueue", (int)1);
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"AppExecutorUtil.createBo\u2026elayedLruActionQueue\", 1)");
            scheduledExecutorService = scheduledExecutorService2;
        }
        this(n, duration, scheduledExecutorService);
    }

    public static final /* synthetic */ boolean access$removeActionFromQueue(DelayedLruActionQueue $this, Function0 action2) {
        return $this.removeActionFromQueue((Function0<Unit>)action2);
    }
}

