/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.pickers.properties.utils;

import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRound;
import com.android.resources.ScreenSize;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.Software;
import com.android.sdklib.devices.State;
import com.android.tools.idea.avdmanager.AvdScreenData;
import com.android.tools.idea.compose.preview.pickers.properties.DeviceConfig;
import com.android.tools.idea.compose.preview.pickers.properties.DeviceConfigKt;
import com.android.tools.idea.compose.preview.pickers.properties.DimUnit;
import com.android.tools.idea.compose.preview.pickers.properties.MutableDeviceConfig;
import com.android.tools.idea.compose.preview.pickers.properties.Shape;
import com.android.tools.idea.compose.preview.pickers.properties.utils.DeviceUtilsKt$WhenMappings;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0000\u001a&\u0010\u0007\u001a\u0004\u0018\u00010\u0005*\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\t\u001a\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0000\u001a&\u0010\f\u001a\u0004\u0018\u00010\u0005*\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\t\u001a\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0000\u001a\f\u0010\r\u001a\u00020\u0006*\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"DEVICE_BY_ID_PREFIX", "", "DEVICE_BY_NAME_PREFIX", "DEVICE_BY_SPEC_PREFIX", "createDeviceInstance", "Lcom/android/sdklib/devices/Device;", "Lcom/android/tools/idea/compose/preview/pickers/properties/DeviceConfig;", "findByIdOrName", "", "deviceDefinition", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "findOrParseFromDefinition", "toDeviceConfig", "intellij.android.compose-designer"})
public final class DeviceUtilsKt {
    @NotNull
    public static final String DEVICE_BY_ID_PREFIX = "id:";
    @NotNull
    public static final String DEVICE_BY_NAME_PREFIX = "name:";
    @NotNull
    public static final String DEVICE_BY_SPEC_PREFIX = "spec:";

    @NotNull
    public static final DeviceConfig toDeviceConfig(@NotNull Device $this$toDeviceConfig) {
        Screen screen;
        State deviceState;
        MutableDeviceConfig mutableDeviceConfig;
        Intrinsics.checkNotNullParameter((Object)$this$toDeviceConfig, (String)"$this$toDeviceConfig");
        MutableDeviceConfig $this$apply = mutableDeviceConfig = new MutableDeviceConfig(0, 0, null, 0, null, 31, null);
        boolean bl = false;
        $this$apply.setDimUnit(DimUnit.px);
        MutableDeviceConfig config = mutableDeviceConfig;
        State state = deviceState = $this$toDeviceConfig.getDefaultState();
        Intrinsics.checkNotNullExpressionValue((Object)state, (String)"deviceState");
        Hardware hardware = state.getHardware();
        Intrinsics.checkNotNullExpressionValue((Object)hardware, (String)"deviceState.hardware");
        Screen screen2 = screen = hardware.getScreen();
        Intrinsics.checkNotNullExpressionValue((Object)screen2, (String)"screen");
        config.setWidth(screen2.getXDimension());
        config.setHeight(screen.getYDimension());
        Density density = screen.getPixelDensity();
        Intrinsics.checkNotNullExpressionValue((Object)density, (String)"screen.pixelDensity");
        config.setDpi(density.getDpiValue());
        if (screen.getScreenRound() == ScreenRound.ROUND) {
            config.setShape(screen.getChin() != 0 ? Shape.Square : Shape.Round);
        } else {
            config.setShape(Shape.Normal);
        }
        return config;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Device createDeviceInstance(@NotNull DeviceConfig $this$createDeviceInstance) {
        ScreenRound screenRound;
        void $this$apply;
        ScreenOrientation screenOrientation;
        Device customDevice;
        State $this$apply2;
        State state;
        Device.Builder builder2;
        Intrinsics.checkNotNullParameter((Object)$this$createDeviceInstance, (String)"$this$createDeviceInstance");
        MutableDeviceConfig deviceConfig = !($this$createDeviceInstance instanceof MutableDeviceConfig) ? DeviceConfigKt.toMutableConfig($this$createDeviceInstance) : (MutableDeviceConfig)$this$createDeviceInstance;
        Device.Builder $this$apply3 = builder2 = new Device.Builder();
        boolean bl = false;
        $this$apply3.setTagId("");
        $this$apply3.setName("Custom");
        $this$apply3.setId("Custom");
        $this$apply3.setManufacturer("");
        $this$apply3.addSoftware(new Software());
        State state2 = state = new State();
        Device.Builder builder3 = $this$apply3;
        boolean bl2 = false;
        $this$apply2.setDefaultState(true);
        Unit unit = Unit.INSTANCE;
        builder3.addState(state);
        Device device = customDevice = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)device, (String)"customDevice");
        $this$apply3 = builder2 = device.getDefaultState();
        boolean bl3 = false;
        switch (DeviceUtilsKt$WhenMappings.$EnumSwitchMapping$0[deviceConfig.getOrientation().ordinal()]) {
            case 1: {
                screenOrientation = ScreenOrientation.LANDSCAPE;
                break;
            }
            case 2: {
                screenOrientation = ScreenOrientation.PORTRAIT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        $this$apply3.setOrientation(screenOrientation);
        $this$apply2 = state = new Hardware();
        builder3 = $this$apply3;
        boolean bl4 = false;
        Unit unit2 = unit = new Screen();
        State state3 = $this$apply2;
        boolean bl5 = false;
        deviceConfig.setDimUnit(DimUnit.px);
        $this$apply.setXDimension(deviceConfig.getWidth());
        $this$apply.setYDimension(deviceConfig.getHeight());
        $this$apply.setPixelDensity(AvdScreenData.getScreenDensity(null, (boolean)false, (double)deviceConfig.getDpi(), (int)$this$apply.getYDimension()));
        double d = 1.0 * (double)$this$apply.getXDimension() * (double)$this$apply.getXDimension() + 1.0 * (double)$this$apply.getYDimension() * (double)$this$apply.getYDimension();
        double d2 = Math.sqrt(d);
        Density density = $this$apply.getPixelDensity();
        Intrinsics.checkNotNullExpressionValue((Object)density, (String)"pixelDensity");
        $this$apply.setDiagonalLength(d2 / (double)density.getDpiValue());
        switch (DeviceUtilsKt$WhenMappings.$EnumSwitchMapping$1[deviceConfig.getShape().ordinal()]) {
            case 1: 
            case 2: {
                screenRound = ScreenRound.ROUND;
                break;
            }
            default: {
                screenRound = ScreenRound.NOTROUND;
            }
        }
        $this$apply.setScreenRound(screenRound);
        $this$apply.setChin(deviceConfig.getShape() == Shape.Chin ? 30 : 0);
        $this$apply.setSize(ScreenSize.getScreenSize((Double)$this$apply.getDiagonalLength()));
        $this$apply.setRatio(AvdScreenData.getScreenRatio((int)$this$apply.getXDimension(), (int)$this$apply.getYDimension()));
        Unit unit3 = Unit.INSTANCE;
        state3.setScreen((Screen)unit);
        Unit unit4 = Unit.INSTANCE;
        builder3.setHardware((Hardware)state);
        return customDevice;
    }

    @Nullable
    public static final Device findOrParseFromDefinition(@NotNull Collection<Device> $this$findOrParseFromDefinition, @NotNull String deviceDefinition, @NotNull Logger logger2) {
        Device device;
        Intrinsics.checkNotNullParameter($this$findOrParseFromDefinition, (String)"$this$findOrParseFromDefinition");
        Intrinsics.checkNotNullParameter((Object)deviceDefinition, (String)"deviceDefinition");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        if (StringsKt.isBlank((CharSequence)deviceDefinition)) {
            device = null;
        } else {
            if (StringsKt.startsWith$default((String)deviceDefinition, (String)DEVICE_BY_SPEC_PREFIX, (boolean)false, (int)2, null)) {
                Device deviceBySpec;
                MutableDeviceConfig mutableDeviceConfig = DeviceConfig.Companion.toMutableDeviceConfigOrNull(deviceDefinition);
                Object object = deviceBySpec = mutableDeviceConfig != null ? DeviceUtilsKt.createDeviceInstance(mutableDeviceConfig) : null;
                if (deviceBySpec == null) {
                    logger2.warn("Unable to parse device configuration: " + deviceDefinition);
                }
                return deviceBySpec;
            }
            device = DeviceUtilsKt.findByIdOrName($this$findOrParseFromDefinition, deviceDefinition, logger2);
        }
        return device;
    }

    public static /* synthetic */ Device findOrParseFromDefinition$default(Collection collection, String string2, Logger logger2, int n, Object object) {
        if ((n & 2) != 0) {
            Logger logger3 = Logger.getInstance(MutableDeviceConfig.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"Logger.getInstance(Mutab\u2026DeviceConfig::class.java)");
            logger2 = logger3;
        }
        return DeviceUtilsKt.findOrParseFromDefinition(collection, string2, logger2);
    }

    @Nullable
    public static final Device findByIdOrName(@NotNull Collection<Device> $this$findByIdOrName, @NotNull String deviceDefinition, @NotNull Logger logger2) {
        Object v0;
        Intrinsics.checkNotNullParameter($this$findByIdOrName, (String)"$this$findByIdOrName");
        Intrinsics.checkNotNullParameter((Object)deviceDefinition, (String)"deviceDefinition");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Collection<Device> availableDevices = $this$findByIdOrName;
        if (StringsKt.isBlank((CharSequence)deviceDefinition)) {
            v0 = null;
        } else {
            if (StringsKt.startsWith$default((String)deviceDefinition, (String)DEVICE_BY_ID_PREFIX, (boolean)false, (int)2, null)) {
                Object v1;
                String id2;
                block8: {
                    id2 = StringsKt.removePrefix((String)deviceDefinition, (CharSequence)DEVICE_BY_ID_PREFIX);
                    Iterable $this$firstOrNull$iv = availableDevices;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Device it = (Device)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)id2)) continue;
                        v1 = element$iv;
                        break block8;
                    }
                    v1 = null;
                }
                Device deviceById = v1;
                if (deviceById == null) {
                    logger2.warn("Unable to find device with id '" + id2 + "'");
                }
                return deviceById;
            }
            if (StringsKt.startsWith$default((String)deviceDefinition, (String)DEVICE_BY_NAME_PREFIX, (boolean)false, (int)2, null)) {
                Object v2;
                String name;
                block9: {
                    name = StringsKt.removePrefix((String)deviceDefinition, (CharSequence)DEVICE_BY_NAME_PREFIX);
                    Iterable $this$firstOrNull$iv = availableDevices;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Device it = (Device)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)name)) continue;
                        v2 = element$iv;
                        break block9;
                    }
                    v2 = null;
                }
                Device deviceByName = v2;
                if (deviceByName == null) {
                    logger2.warn("Unable to find device with name '" + name + "'");
                }
                return deviceByName;
            }
            logger2.warn("Unsupported device definition: " + $this$findByIdOrName);
            v0 = null;
        }
        return v0;
    }

    public static /* synthetic */ Device findByIdOrName$default(Collection collection, String string2, Logger logger2, int n, Object object) {
        if ((n & 2) != 0) {
            Logger logger3 = Logger.getInstance(MutableDeviceConfig.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"Logger.getInstance(Mutab\u2026DeviceConfig::class.java)");
            logger2 = logger3;
        }
        return DeviceUtilsKt.findByIdOrName(collection, string2, logger2);
    }
}

