/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.pickers.properties.enumsupport.devices;

import com.android.resources.Density;
import com.android.tools.idea.avdmanager.AvdScreenData;
import com.android.tools.idea.compose.preview.pickers.properties.DeviceConfig;
import com.android.tools.idea.compose.preview.pickers.properties.DimUnit;
import com.android.tools.idea.compose.preview.pickers.properties.Shape;
import com.android.tools.idea.compose.preview.pickers.properties.enumsupport.DescriptionEnumValue;
import com.android.tools.idea.compose.preview.pickers.properties.enumsupport.devices.DeviceClass;
import com.android.tools.idea.compose.preview.pickers.properties.enumsupport.devices.DeviceClassesKt;
import com.android.tools.property.panel.api.EnumValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0005J \u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0002J4\u0010\u001a\u001a\u00020\u00002\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0016\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0016\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u001e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070$R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/compose/preview/pickers/properties/enumsupport/devices/DeviceEnumValueBuilder;", "", "()V", "deviceEnumValues", "", "Lcom/android/tools/idea/compose/preview/pickers/properties/enumsupport/devices/DeviceClass;", "", "Lcom/android/tools/property/panel/api/EnumValue;", "addAutoDevice", "widthPx", "", "heightPx", "diagonalIn", "", "addById", "displayName", "", "id", "type", "addCanonical", "name", "description", "immutableDeviceConfig", "Lcom/android/tools/idea/compose/preview/pickers/properties/DeviceConfig;", "addDefaultsIfMissing", "", "addDevicePx", "overrideDisplayName", "addGenericById", "addPhoneById", "addTabletById", "addTvDevice", "addWearDevice", "shape", "Lcom/android/tools/idea/compose/preview/pickers/properties/Shape;", "includeDefaultsAndBuild", "", "intellij.android.compose-designer"})
public final class DeviceEnumValueBuilder {
    private final Map<DeviceClass, List<EnumValue>> deviceEnumValues = MapsKt.mapOf((Pair[])new Pair[]{new Pair((Object)DeviceClass.Canonical, (Object)new ArrayList()), new Pair((Object)DeviceClass.Phone, (Object)new ArrayList()), new Pair((Object)DeviceClass.Tablet, (Object)new ArrayList()), new Pair((Object)DeviceClass.Wear, (Object)new ArrayList()), new Pair((Object)DeviceClass.Tv, (Object)new ArrayList()), new Pair((Object)DeviceClass.Auto, (Object)new ArrayList()), new Pair((Object)DeviceClass.Generic, (Object)new ArrayList())});

    @NotNull
    public final DeviceEnumValueBuilder addCanonical(@NotNull String name, @Nullable String description, @NotNull DeviceConfig immutableDeviceConfig) {
        DeviceEnumValueBuilder deviceEnumValueBuilder;
        block0: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)immutableDeviceConfig, (String)"immutableDeviceConfig");
            DeviceEnumValueBuilder $this$apply = deviceEnumValueBuilder = this;
            boolean bl = false;
            String deviceSpec = immutableDeviceConfig.deviceSpec();
            List<EnumValue> list = $this$apply.deviceEnumValues.get((Object)DeviceClass.Canonical);
            if (list == null) break block0;
            list.add(new DescriptionEnumValue(deviceSpec, name, description));
        }
        return deviceEnumValueBuilder;
    }

    private final DeviceEnumValueBuilder addDevicePx(String overrideDisplayName, DeviceClass type, int widthPx, int heightPx, double diagonalIn) {
        DeviceEnumValueBuilder deviceEnumValueBuilder;
        block1: {
            DeviceEnumValueBuilder $this$apply = deviceEnumValueBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            double d = 1.0 * (double)widthPx * (double)widthPx + 1.0 * (double)heightPx * (double)heightPx;
            double dpiCalc = Math.sqrt(d) / diagonalIn;
            d = dpiCalc * (double)100;
            double dpi = Math.rint(d) / 100.0;
            Density density = AvdScreenData.getScreenDensity(null, (boolean)true, (double)dpi, (int)heightPx);
            Intrinsics.checkNotNullExpressionValue((Object)density, (String)"AvdScreenData.getScreenD\u2026ull, true, dpi, heightPx)");
            Density density2 = density;
            String deviceSpec = new DeviceConfig(widthPx, heightPx, DimUnit.px, density2.getDpiValue(), null, 16, null).deviceSpec();
            Object object = overrideDisplayName;
            if (object == null) {
                double d2 = diagonalIn * (double)100;
                object = Math.rint(d2) / (double)100 + "\" " + type.name() + " " + heightPx + "p";
            }
            String display = object;
            EnumValue enumValue = EnumValue.Companion.indented(deviceSpec, display);
            List<EnumValue> list = $this$apply.deviceEnumValues.get((Object)type);
            if (list == null) break block1;
            list.add(enumValue);
        }
        return deviceEnumValueBuilder;
    }

    static /* synthetic */ DeviceEnumValueBuilder addDevicePx$default(DeviceEnumValueBuilder deviceEnumValueBuilder, String string2, DeviceClass deviceClass, int n, int n2, double d, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string2 = null;
        }
        return deviceEnumValueBuilder.addDevicePx(string2, deviceClass, n, n2, d);
    }

    @NotNull
    public final DeviceEnumValueBuilder addWearDevice(@NotNull Shape shape) {
        DeviceEnumValueBuilder deviceEnumValueBuilder;
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)shape), (String)"shape");
            DeviceEnumValueBuilder $this$apply = deviceEnumValueBuilder = this;
            boolean bl = false;
            Density density = AvdScreenData.getScreenDensity(null, (boolean)false, (double)224.0, (int)300);
            Intrinsics.checkNotNullExpressionValue((Object)density, (String)"AvdScreenData.getScreenD\u2026(null, false, 224.0, 300)");
            Density density2 = density;
            String deviceSpec = new DeviceConfig(300, 300, DimUnit.px, density2.getDpiValue(), shape).deviceSpec();
            List<EnumValue> list = $this$apply.deviceEnumValues.get((Object)DeviceClass.Wear);
            if (list == null) break block0;
            list.add(EnumValue.Companion.indented(deviceSpec, shape.getDisplay()));
        }
        return deviceEnumValueBuilder;
    }

    @NotNull
    public final DeviceEnumValueBuilder addTvDevice(int widthPx, int heightPx, double diagonalIn) {
        return DeviceEnumValueBuilder.addDevicePx$default(this, null, DeviceClass.Tv, widthPx, heightPx, diagonalIn, 1, null);
    }

    @NotNull
    public final DeviceEnumValueBuilder addAutoDevice(int widthPx, int heightPx, double diagonalIn) {
        return DeviceEnumValueBuilder.addDevicePx$default(this, null, DeviceClass.Auto, widthPx, heightPx, diagonalIn, 1, null);
    }

    @NotNull
    public final DeviceEnumValueBuilder addPhoneById(@NotNull String displayName, @NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return this.addById(displayName, id2, DeviceClass.Phone);
    }

    @NotNull
    public final DeviceEnumValueBuilder addTabletById(@NotNull String displayName, @NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return this.addById(displayName, id2, DeviceClass.Tablet);
    }

    @NotNull
    public final DeviceEnumValueBuilder addGenericById(@NotNull String displayName, @NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return this.addById(displayName, id2, DeviceClass.Generic);
    }

    @NotNull
    public final DeviceEnumValueBuilder addById(@NotNull String displayName, @NotNull String id2, @NotNull DeviceClass type) {
        DeviceEnumValueBuilder deviceEnumValueBuilder;
        block0: {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            DeviceEnumValueBuilder $this$apply = deviceEnumValueBuilder = this;
            boolean bl = false;
            List<EnumValue> list = $this$apply.deviceEnumValues.get((Object)type);
            if (list == null) break block0;
            list.add(EnumValue.Companion.indented("id:" + id2, displayName));
        }
        return deviceEnumValueBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EnumValue> includeDefaultsAndBuild() {
        this.addDefaultsIfMissing();
        List enumValues = new ArrayList();
        Iterable $this$forEach$iv = this.deviceEnumValues.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            List<EnumValue> values2;
            DeviceClass type = (DeviceClass)((Object)element$iv);
            boolean bl = false;
            List<EnumValue> list = values2 = this.deviceEnumValues.get((Object)type);
            if (list == null) continue;
            Iterable iterable = list;
            if (!(!iterable.isEmpty())) continue;
            enumValues.add(EnumValue.Companion.header(type.getDisplay(), type.getIcon()));
            iterable = values2;
            List list2 = enumValues;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                EnumValue p1 = (EnumValue)element$iv2;
                boolean bl2 = false;
                list2.add(p1);
            }
        }
        return enumValues;
    }

    private final void addDefaultsIfMissing() {
        block11: {
            block10: {
                DeviceClass deviceClass;
                Map<DeviceClass, List<EnumValue>> map2;
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        map2 = this.deviceEnumValues;
                                        deviceClass = DeviceClass.Canonical;
                                        if (!map2.containsKey((Object)deviceClass)) break block4;
                                        List<EnumValue> list = this.deviceEnumValues.get((Object)DeviceClass.Canonical);
                                        if (list == null) break block5;
                                        if (!list.isEmpty()) break block5;
                                    }
                                    this.addCanonical("Phone", "This reference device uses the COMPACT width size class, which represents 99% of Android phones in portrait orientation.", DeviceClassesKt.getReferencePhoneConfig());
                                    this.addCanonical("Foldable", "This reference device uses the MEDIUM width size class, which represents foldables in unfolded portrait orientation, or 94% of all tablets in portrait orientation.", DeviceClassesKt.getReferenceFoldableConfig());
                                    this.addCanonical("Tablet", "This reference device uses the EXPANDED width size class, which represents 97% of Android tablets in landscape orientation.", DeviceClassesKt.getReferenceTabletConfig());
                                    this.addCanonical("Desktop", "This reference device uses the EXPANDED width size class, which represents 97% of Android desktops in landscape orientation.", DeviceClassesKt.getReferenceDesktopConfig());
                                }
                                if (!(map2 = this.deviceEnumValues).containsKey((Object)(deviceClass = DeviceClass.Wear))) break block6;
                                List<EnumValue> list = this.deviceEnumValues.get((Object)DeviceClass.Wear);
                                if (list == null) break block7;
                                if (!list.isEmpty()) break block7;
                            }
                            this.addWearDevice(Shape.Square);
                            this.addWearDevice(Shape.Round);
                            this.addWearDevice(Shape.Chin);
                        }
                        if (!(map2 = this.deviceEnumValues).containsKey((Object)(deviceClass = DeviceClass.Tv))) break block8;
                        List<EnumValue> list = this.deviceEnumValues.get((Object)DeviceClass.Tv);
                        if (list == null) break block9;
                        if (!list.isEmpty()) break block9;
                    }
                    this.addTvDevice(3840, 2160, 55.0);
                    this.addTvDevice(1920, 1080, 55.0);
                    this.addTvDevice(1280, 720, 55.0);
                }
                if (!(map2 = this.deviceEnumValues).containsKey((Object)(deviceClass = DeviceClass.Auto))) break block10;
                List<EnumValue> list = this.deviceEnumValues.get((Object)DeviceClass.Auto);
                if (list == null) break block11;
                if (!list.isEmpty()) break block11;
            }
            this.addAutoDevice(1024, 768, 8.4);
        }
    }
}

