/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.pickers.properties.editingsupport;

import com.android.tools.adtui.model.stdui.EditingErrorCategory;
import com.android.tools.adtui.model.stdui.EditingSupportKt;
import com.android.tools.idea.compose.preview.ComposePreviewBundle;
import com.android.tools.idea.compose.preview.pickers.properties.editingsupport.FloatValidationKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002/\u0012\u0015\u0012\u0013\u0018\u00010\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00020\u00060\u0001j\u0002`\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\tJ\u001f\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002H\u0096\u0002\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/compose/preview/pickers/properties/editingsupport/FloatValidator;", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "editedValue", "Lkotlin/Pair;", "Lcom/android/tools/adtui/model/stdui/EditingErrorCategory;", "Lcom/android/tools/adtui/model/stdui/EditingValidation;", "()V", "invoke", "intellij.android.compose-designer"})
public final class FloatValidator
implements Function1<String, Pair<? extends EditingErrorCategory, ? extends String>> {
    @NotNull
    public static final FloatValidator INSTANCE;

    @NotNull
    public Pair<EditingErrorCategory, String> invoke(@Nullable String editedValue) {
        CharSequence charSequence = editedValue;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return EditingSupportKt.EDITOR_NO_ERROR;
        }
        String string2 = editedValue;
        String trimmedValue = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        Float f = StringsKt.toFloatOrNull((String)trimmedValue);
        if (f == null) {
            return new Pair((Object)EditingErrorCategory.ERROR, (Object)ComposePreviewBundle.message("picker.preview.input.validation.float.nan", new Object[0]));
        }
        float numberValue = f.floatValue();
        if (numberValue <= 0.0f) {
            return new Pair((Object)EditingErrorCategory.ERROR, (Object)ComposePreviewBundle.message("picker.preview.input.validation.positive.value", new Object[0]));
        }
        if (!FloatValidationKt.access$isValidFormat(trimmedValue)) {
            return new Pair((Object)EditingErrorCategory.WARNING, (Object)ComposePreviewBundle.message("picker.preview.input.validation.float.format", new Object[0]));
        }
        return EditingSupportKt.EDITOR_NO_ERROR;
    }

    private FloatValidator() {
    }

    static {
        FloatValidator floatValidator;
        INSTANCE = floatValidator = new FloatValidator();
    }
}

