/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.navigation;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.compose.preview.navigation.PreviewNavigation;
import com.android.tools.idea.compose.preview.navigation.PreviewNavigationKt;
import com.android.tools.idea.compose.preview.navigation.SourceLocation;
import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u001e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012R&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/compose/preview/navigation/PreviewNavigationHandler;", "Lcom/android/tools/idea/uibuilder/surface/NlDesignSurface$NavigationHandler;", "()V", "defaultNavigationMap", "Ljava/util/WeakHashMap;", "Lcom/android/tools/idea/common/model/NlModel;", "Lkotlin/Pair;", "", "Lcom/intellij/pom/Navigatable;", "dispose", "", "handleNavigate", "", "sceneView", "Lcom/android/tools/idea/common/surface/SceneView;", "sceneComponent", "Lcom/android/tools/idea/common/scene/SceneComponent;", "hitX", "", "hitY", "requestFocus", "navigateToDefault", "setDefaultLocation", "model", "psiFile", "Lcom/intellij/psi/PsiFile;", "offset", "intellij.android.compose-designer"})
public final class PreviewNavigationHandler
implements NlDesignSurface.NavigationHandler {
    private final WeakHashMap<NlModel, Pair<String, Navigatable>> defaultNavigationMap = new WeakHashMap();

    public final void setDefaultLocation(@NotNull NlModel model2, @NotNull PsiFile psiFile2, int offset2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        Logger $this$debug$iv = PreviewNavigation.INSTANCE.getLOG();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger2 = $this$debug$iv;
            boolean bl = false;
            String string2 = "Default location set to " + psiFile2.getName() + ":" + offset2;
            logger2.debug(string2, (Throwable)e$iv);
        }
        Map map2 = this.defaultNavigationMap;
        String string3 = psiFile2.getName();
        PsiNavigationSupport psiNavigationSupport = PsiNavigationSupport.getInstance();
        Project project = model2.getProject();
        VirtualFile virtualFile = psiFile2.getVirtualFile();
        Intrinsics.checkNotNull((Object)virtualFile);
        map2.put(model2, TuplesKt.to((Object)string3, (Object)psiNavigationSupport.createNavigatable(project, virtualFile, offset2)));
    }

    @Override
    public boolean handleNavigate(@NotNull SceneView sceneView, @NotNull SceneComponent sceneComponent, int hitX, int hitY, boolean requestFocus) {
        NlComponent root;
        String string2;
        Logger logger2;
        Intrinsics.checkNotNullParameter((Object)sceneView, (String)"sceneView");
        Intrinsics.checkNotNullParameter((Object)sceneComponent, (String)"sceneComponent");
        int x = Coordinates.getAndroidX(sceneView, hitX);
        int y = Coordinates.getAndroidY(sceneView, hitY);
        Logger $this$debug$iv = PreviewNavigation.INSTANCE.getLOG();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            logger2 = $this$debug$iv;
            boolean bl = false;
            string2 = "handleNavigate x=" + x + ", y=" + y;
            logger2.debug(string2, (Throwable)e$iv);
        }
        SceneManager sceneManager = sceneView.getSceneManager();
        Intrinsics.checkNotNullExpressionValue((Object)sceneManager, (String)"sceneView.sceneManager");
        NlModel nlModel = sceneManager.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"sceneView.sceneManager.model");
        NlModel model2 = nlModel;
        NlComponent nlComponent = root = (NlComponent)model2.getComponents().get(0);
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"root");
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(nlComponent);
        if (viewInfo == null) {
            return false;
        }
        ViewInfo viewInfo2 = viewInfo;
        Object object = this.defaultNavigationMap.get(model2);
        if (object == null || (object = (String)object.getFirst()) == null) {
            object = "";
        }
        Object fileName = object;
        Module module = model2.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"model.module");
        Navigatable navigatable = PreviewNavigationKt.findNavigatableComponentHit(module, viewInfo2, x, y, (Function1<? super SourceLocation, Boolean>)((Function1)new Function1<SourceLocation, Boolean>(requestFocus, fileName){
            final /* synthetic */ boolean $requestFocus;
            final /* synthetic */ String $fileName;

            public final boolean invoke(@NotNull SourceLocation it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$requestFocus || Intrinsics.areEqual((Object)it.getFileName(), (Object)this.$fileName);
            }
            {
                this.$requestFocus = bl;
                this.$fileName = string2;
                super(1);
            }
        }));
        if (navigatable != null) {
            Navigatable bl;
            Navigatable it = bl = navigatable;
            boolean bl2 = false;
            BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, requestFocus){
                int label;
                final /* synthetic */ Navigatable $it;
                final /* synthetic */ boolean $requestFocus$inlined;
                {
                    this.$it = navigatable;
                    this.$requestFocus$inlined = bl;
                    super(2, continuation);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.$it.navigate(this.$requestFocus$inlined);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> completion2) {
                    Intrinsics.checkNotNullParameter(completion2, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            return true;
        }
        if (!requestFocus) {
            return true;
        }
        boolean navigatedToDefault = this.navigateToDefault(sceneView, requestFocus);
        Logger $this$debug$iv2 = PreviewNavigation.INSTANCE.getLOG();
        Exception e$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug$iv2.isDebugEnabled()) {
            logger2 = $this$debug$iv2;
            boolean bl = false;
            string2 = "Navigated to default? " + navigatedToDefault;
            logger2.debug(string2, (Throwable)e$iv2);
        }
        return navigatedToDefault;
    }

    private final boolean navigateToDefault(SceneView sceneView, boolean requestFocus) {
        SceneManager sceneManager = sceneView.getSceneManager();
        Intrinsics.checkNotNullExpressionValue((Object)sceneManager, (String)"sceneView.sceneManager");
        Navigatable navigatable = this.defaultNavigationMap.get(sceneManager.getModel());
        if (navigatable == null || (navigatable = (Navigatable)navigatable.getSecond()) == null) {
            return false;
        }
        navigatable.navigate(requestFocus);
        return true;
    }

    public void dispose() {
        this.defaultNavigationMap.clear();
    }
}

