/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.animation;

import com.android.tools.idea.compose.preview.animation.InspectorPainter;
import com.android.tools.idea.compose.preview.animation.TimelinePanelKt;
import com.intellij.ui.JBColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\u0006H\u0014J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/compose/preview/animation/TimelinePanel;", "Ljavax/swing/plaf/basic/BasicSliderUI;", "slider", "Ljavax/swing/JSlider;", "(Ljavax/swing/JSlider;)V", "calculateLabelRect", "", "calculateTickRect", "getThumbSize", "Ljava/awt/Dimension;", "labelsAndTicksHeight", "", "paintFocus", "g", "Ljava/awt/Graphics;", "paintLabels", "paintMajorTicks", "Ljava/awt/Graphics2D;", "paintThumb", "paintTrack", "intellij.android.compose-designer"})
public class TimelinePanel
extends BasicSliderUI {
    @Override
    @NotNull
    protected Dimension getThumbSize() {
        Dimension dimension;
        Dimension originalSize = super.getThumbSize();
        JSlider jSlider = this.slider;
        Intrinsics.checkNotNullExpressionValue((Object)jSlider, (String)"slider");
        if (jSlider.getParent() == null) {
            Dimension dimension2 = originalSize;
            dimension = dimension2;
            Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"originalSize");
        } else {
            int n = originalSize.width;
            JSlider jSlider2 = this.slider;
            Intrinsics.checkNotNullExpressionValue((Object)jSlider2, (String)"slider");
            Container container = jSlider2.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)container, (String)"slider.parent");
            dimension = new Dimension(n, container.getHeight() - this.labelsAndTicksHeight());
        }
        return dimension;
    }

    @Override
    protected void calculateTickRect() {
        this.tickRect.x = this.thumbRect.x;
        this.tickRect.y = this.thumbRect.y;
        this.tickRect.width = this.thumbRect.width;
        this.tickRect.height = this.thumbRect.height + this.labelsAndTicksHeight();
    }

    @Override
    protected void calculateLabelRect() {
        super.calculateLabelRect();
        this.labelRect.y = 5;
    }

    @Override
    public void paintTrack(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        this.paintMajorTicks((Graphics2D)g);
    }

    @Override
    public void paintFocus(@Nullable Graphics g) {
    }

    @Override
    public void paintLabels(@Nullable Graphics g) {
        super.paintLabels(g);
        Graphics graphics = g;
        if (graphics == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D cfr_ignored_0 = (Graphics2D)graphics;
        ((Graphics2D)g).setColor(JBColor.border());
        ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
        int borderHeight = 24;
        JSlider jSlider = this.slider;
        Intrinsics.checkNotNullExpressionValue((Object)jSlider, (String)"slider");
        g.drawLine(0, borderHeight, jSlider.getWidth(), borderHeight);
    }

    @Override
    public void paintThumb(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        InspectorPainter.Thumb.INSTANCE.paintThumbForHorizSlider((Graphics2D)g, this.thumbRect.x + this.thumbRect.width / 2, this.thumbRect.y + 25, this.thumbRect.height);
    }

    /*
     * WARNING - void declaration
     */
    private final void paintMajorTicks(Graphics2D g) {
        g.setColor((Color)TimelinePanelKt.access$getTIMELINE_BACKGROUND_COLOR$p());
        JSlider jSlider = this.slider;
        Intrinsics.checkNotNullExpressionValue((Object)jSlider, (String)"slider");
        int n = jSlider.getWidth();
        JSlider jSlider2 = this.slider;
        Intrinsics.checkNotNullExpressionValue((Object)jSlider2, (String)"slider");
        g.fillRect(0, 25, n, jSlider2.getHeight() - 25);
        g.setColor((Color)TimelinePanelKt.access$getTIMELINE_TICK_COLOR$p());
        int n2 = 1;
        JSlider jSlider3 = this.slider;
        Intrinsics.checkNotNullExpressionValue((Object)jSlider3, (String)"slider");
        int n3 = jSlider3.getMajorTickSpacing() / 5;
        int tickIncrement = Math.max(n2, n3);
        int n4 = 0;
        JSlider jSlider4 = this.slider;
        Intrinsics.checkNotNullExpressionValue((Object)jSlider4, (String)"slider");
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)new IntRange(n4, jSlider4.getMaximum())), (int)tickIncrement);
        n2 = intProgression.getFirst();
        n3 = intProgression.getLast();
        int n5 = intProgression.getStep();
        int n6 = n2;
        int n7 = n3;
        if (n5 >= 0 ? n6 <= n7 : n6 >= n7) {
            while (true) {
                void tick;
                int xPos = this.xPositionForValue((int)tick);
                g.drawLine(xPos, this.tickRect.y + 25, xPos, this.tickRect.height);
                if (tick == n3) break;
                n2 = tick + n5;
            }
        }
    }

    private final int labelsAndTicksHeight() {
        return this.getTickLength() + this.getHeightOfTallestLabel();
    }

    public TimelinePanel(@NotNull JSlider slider2) {
        Intrinsics.checkNotNullParameter((Object)slider2, (String)"slider");
        super(slider2);
    }
}

