/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.animation;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.util.ActionToolbarUtil;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.compose.preview.ComposePreviewBundle;
import com.android.tools.idea.compose.preview.animation.ComposeUnit;
import com.google.wireless.android.sdk.stats.ComposeAnimationToolingEvent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextLayout;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\t\u001a\u001b\u001c\u001d\u001e\u001f !\"B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\r\u0012\t\u0012\u00070\r\u00a2\u0006\u0002\b\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/compose/preview/animation/InspectorPainter;", "", "()V", "DASHED_STROKE", "Ljava/awt/Stroke;", "GRAPH_COLORS", "Ljava/util/ArrayList;", "Lcom/intellij/ui/JBColor;", "Lkotlin/collections/ArrayList;", "getGRAPH_COLORS", "()Ljava/util/ArrayList;", "GRAPH_COLORS_WITH_ALPHA", "", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "SIMPLE_STROKE", "Ljava/awt/BasicStroke;", "paintCurve", "", "g", "Ljava/awt/Graphics2D;", "curveInfo", "Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$CurveInfo;", "colorIndex", "", "rowHeight", "AnimatedVisibilityComboBox", "BoxedLabel", "CurveInfo", "Diamond", "EmptyComboBox", "Slider", "StartEndComboBox", "StateComboBox", "Thumb", "intellij.android.compose-designer"})
public final class InspectorPainter {
    @NotNull
    private static final ArrayList<JBColor> GRAPH_COLORS;
    private static final List<Color> GRAPH_COLORS_WITH_ALPHA;
    private static Stroke DASHED_STROKE;
    private static BasicStroke SIMPLE_STROKE;
    @NotNull
    public static final InspectorPainter INSTANCE;

    @NotNull
    public final ArrayList<JBColor> getGRAPH_COLORS() {
        return GRAPH_COLORS;
    }

    public final void paintCurve(@NotNull Graphics2D g, @NotNull CurveInfo curveInfo, int colorIndex, int rowHeight) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)curveInfo, (String)"curveInfo");
        g.setColor((Color)GRAPH_COLORS.get(colorIndex % GRAPH_COLORS.size()));
        g.setStroke(SIMPLE_STROKE);
        g.drawLine(curveInfo.getMinX(), curveInfo.getY(), curveInfo.getMaxX(), curveInfo.getY());
        if (curveInfo.getLinkedToNextCurve()) {
            g.setStroke(DASHED_STROKE);
            g.drawLine(curveInfo.getMinX(), curveInfo.getY(), curveInfo.getMinX(), curveInfo.getY() + rowHeight - 6);
            g.drawLine(curveInfo.getMaxX(), curveInfo.getY(), curveInfo.getMaxX(), curveInfo.getY() + rowHeight - 6);
            g.setStroke(SIMPLE_STROKE);
        }
        g.setColor(GRAPH_COLORS_WITH_ALPHA.get(colorIndex % GRAPH_COLORS.size()));
        Object prevAntiAliasHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.fill(curveInfo.getCurve());
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, prevAntiAliasHint);
        Diamond.INSTANCE.paintDiamond(g, curveInfo.getMinX(), curveInfo.getY(), colorIndex);
        Diamond.INSTANCE.paintDiamond(g, curveInfo.getMaxX(), curveInfo.getY(), colorIndex);
    }

    private InspectorPainter() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$mapTo$iv$iv;
        InspectorPainter inspectorPainter;
        INSTANCE = inspectorPainter = new InspectorPainter();
        GRAPH_COLORS = CollectionsKt.arrayListOf((Object[])new JBColor[]{new JBColor(10927305, 9284026), new JBColor(11461630, 8836606), new JBColor(16296321, 16158555), new JBColor(9037466, 6807421), new JBColor(11770846, 10255572), new JBColor(15369642, 14967697), new JBColor(7203286, 4842701), new JBColor(14930603, 14271116), new JBColor(701695, 38358), new JBColor(1816226, 1278323), new JBColor(9659363, 8077533), new JBColor(14838567, 12670746), new JBColor(4223167, 3365529), new JBColor(13026638, 11381816), new JBColor(13325219, 12073102), new JBColor(4034303, 1341439)});
        Iterable $this$map$iv = GRAPH_COLORS;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JBColor jBColor = (JBColor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Color color2 = ColorUtil.withAlpha((Color)((Color)it), (double)0.7);
            collection.add(color2);
        }
        GRAPH_COLORS_WITH_ALPHA = (List)destination$iv$iv;
        DASHED_STROKE = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{JBUI.scale((int)3)}, 0.0f);
        SIMPLE_STROKE = new BasicStroke(1.0f);
    }

    public static final /* synthetic */ BasicStroke access$getSIMPLE_STROKE$p(InspectorPainter $this) {
        InspectorPainter inspectorPainter = $this;
        return SIMPLE_STROKE;
    }

    public static final /* synthetic */ void access$setSIMPLE_STROKE$p(InspectorPainter $this, BasicStroke basicStroke) {
        InspectorPainter inspectorPainter = $this;
        SIMPLE_STROKE = basicStroke;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$CurveInfo;", "", "minX", "", "maxX", "y", "curve", "Ljava/awt/geom/Path2D;", "linkedToNextCurve", "", "(IIILjava/awt/geom/Path2D;Z)V", "getCurve", "()Ljava/awt/geom/Path2D;", "getLinkedToNextCurve", "()Z", "getMaxX", "()I", "getMinX", "getY", "intellij.android.compose-designer"})
    public static final class CurveInfo {
        private final int minX;
        private final int maxX;
        private final int y;
        @NotNull
        private final Path2D curve;
        private final boolean linkedToNextCurve;

        public final int getMinX() {
            return this.minX;
        }

        public final int getMaxX() {
            return this.maxX;
        }

        public final int getY() {
            return this.y;
        }

        @NotNull
        public final Path2D getCurve() {
            return this.curve;
        }

        public final boolean getLinkedToNextCurve() {
            return this.linkedToNextCurve;
        }

        public CurveInfo(int minX, int maxX, int y, @NotNull Path2D curve, boolean linkedToNextCurve) {
            Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
            this.minX = minX;
            this.maxX = maxX;
            this.y = y;
            this.curve = curve;
            this.linkedToNextCurve = linkedToNextCurve;
        }

        public /* synthetic */ CurveInfo(int n, int n2, int n3, Path2D path2D, boolean bl, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 0x10) != 0) {
                bl = false;
            }
            this(n, n2, n3, path2D, bl);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$BoxedLabel;", "", "()V", "BOX_COLOR", "Lcom/intellij/ui/JBColor;", "COLOR_BOX_ARC", "", "COLOR_BOX_SIZE", "COLOR_OUTLINE", "Lcom/intellij/ui/Gray;", "kotlin.jvm.PlatformType", "LABEL_COLOR", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "OFFSET", "VALUE_COLOR", "paintBoxedLabel", "", "g", "Ljava/awt/Graphics2D;", "timelineUnit", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$TimelineUnit;", "componentId", "grouped", "", "x", "y", "intellij.android.compose-designer"})
    public static final class BoxedLabel {
        private static final int OFFSET = 6;
        private static final int COLOR_BOX_SIZE = 10;
        private static final int COLOR_BOX_ARC = 4;
        private static final JBColor BOX_COLOR;
        private static final Gray COLOR_OUTLINE;
        private static final Color LABEL_COLOR;
        private static final Color VALUE_COLOR;
        @NotNull
        public static final BoxedLabel INSTANCE;

        public final void paintBoxedLabel(@NotNull Graphics2D g, @NotNull ComposeUnit.TimelineUnit timelineUnit, int componentId, boolean grouped, int x, int y) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)timelineUnit, (String)"timelineUnit");
            String label = timelineUnit.getProperty().getLabel() + " :  ";
            if (grouped) {
                ComposeUnit.Unit<?> unit = timelineUnit.getUnit();
                string2 = unit != null ? unit.toString() : null;
            } else {
                ComposeUnit.Unit<?> unit = timelineUnit.getUnit();
                string2 = unit != null ? unit.toString(componentId) : null;
            }
            String value2 = string2;
            Color color2 = timelineUnit.getUnit() instanceof ComposeUnit.Color ? ((ComposeUnit.Color)timelineUnit.getUnit()).getColor() : null;
            g.setFont(UIUtil.getFont((UIUtil.FontSize)UIUtil.FontSize.NORMAL, null));
            TextLayout labelLayout = new TextLayout(label, g.getFont(), g.getFontRenderContext());
            TextLayout valueLayout = new TextLayout(value2, g.getFont(), g.getFontRenderContext());
            Rectangle2D rectangle2D = labelLayout.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"labelLayout.bounds");
            int textBoxHeight = (int)(rectangle2D.getHeight() + (double)12);
            int extraColorOffset = color2 != null ? 16 : 0;
            Rectangle2D rectangle2D2 = labelLayout.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle2D2, (String)"labelLayout.bounds");
            double d = rectangle2D2.getWidth();
            Rectangle2D rectangle2D3 = valueLayout.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle2D3, (String)"valueLayout.bounds");
            int textBoxWidth = (int)(d + rectangle2D3.getWidth() + (double)18 + (double)extraColorOffset);
            g.setColor((Color)BOX_COLOR);
            g.fillRoundRect(x - 6, y, textBoxWidth, textBoxHeight, 6, 6);
            g.setColor(LABEL_COLOR);
            g.drawString(label, x, y - 6 + textBoxHeight);
            Rectangle2D rectangle2D4 = labelLayout.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle2D4, (String)"labelLayout.bounds");
            int xPos = x + 6 + (int)rectangle2D4.getWidth();
            Color color3 = color2;
            if (color3 != null) {
                Color color4;
                Color it = color4 = color3;
                boolean bl = false;
                g.setColor(color2);
                g.fillRoundRect(xPos, y + 6, 10, 10, 4, 4);
                g.setColor((Color)COLOR_OUTLINE);
                g.drawRoundRect(xPos, y + 6, 10, 10, 4, 4);
            }
            g.setColor(VALUE_COLOR);
            g.drawString(value2, xPos + extraColorOffset, y - 6 + textBoxHeight);
        }

        private BoxedLabel() {
        }

        static {
            BoxedLabel boxedLabel;
            INSTANCE = boxedLabel = new BoxedLabel();
            BOX_COLOR = new JBColor((Color)Gray._225, UIUtil.getToolTipActionBackground());
            COLOR_OUTLINE = Gray._194;
            Color color2 = UIUtil.getContextHelpForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"UIUtil.getContextHelpForeground()");
            LABEL_COLOR = color2;
            Color color3 = UIUtil.getLabelDisabledForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"UIUtil.getLabelDisabledForeground()");
            VALUE_COLOR = color3;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$Slider;", "", "()V", "MINIMUM_TICK_DISTANCE", "", "TICK_INCREMENTS", "", "[Ljava/lang/Integer;", "getTickIncrement", "slider", "Ljavax/swing/JSlider;", "minimumTickSize", "intellij.android.compose-designer"})
    public static final class Slider {
        private static final int MINIMUM_TICK_DISTANCE = 150;
        private static final Integer[] TICK_INCREMENTS;
        @NotNull
        public static final Slider INSTANCE;

        public final int getTickIncrement(@NotNull JSlider slider2, int minimumTickSize) {
            Intrinsics.checkNotNullParameter((Object)slider2, (String)"slider");
            if (slider2.getMaximum() == 0 || slider2.getWidth() == 0) {
                return slider2.getMaximum();
            }
            int increment = (int)((float)minimumTickSize / (float)slider2.getWidth() * (float)(slider2.getMaximum() - slider2.getMinimum()));
            Integer[] $this$forEach$iv = TICK_INCREMENTS;
            boolean $i$f$forEach = false;
            for (Integer element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                if (increment < it) continue;
                return increment / (it - 1) * it;
            }
            return 1;
        }

        public static /* synthetic */ int getTickIncrement$default(Slider slider2, JSlider jSlider, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 150;
            }
            return slider2.getTickIncrement(jSlider, n);
        }

        private Slider() {
        }

        static {
            Slider slider2;
            INSTANCE = slider2 = new Slider();
            TICK_INCREMENTS = new Integer[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 10000, 1000, 200, 50, 10, 5, 2};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$Thumb;", "", "()V", "HANDLE_HALF_HEIGHT", "", "HANDLE_HALF_WIDTH", "THUMB_COLOR", "Lcom/intellij/ui/JBColor;", "paintThumbForHorizSlider", "", "g", "Ljava/awt/Graphics2D;", "x", "y", "height", "intellij.android.compose-designer"})
    public static final class Thumb {
        private static final JBColor THUMB_COLOR;
        private static final int HANDLE_HALF_WIDTH = 5;
        private static final int HANDLE_HALF_HEIGHT = 5;
        @NotNull
        public static final Thumb INSTANCE;

        public final void paintThumbForHorizSlider(@NotNull Graphics2D g, int x, int y, int height) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            g.setColor((Color)THUMB_COLOR);
            g.setStroke(InspectorPainter.access$getSIMPLE_STROKE$p(INSTANCE));
            g.drawLine(x, y, x, y + height);
            int handleHeight = 10;
            int[] xPoints = new int[]{x, x - 5, x - 5, x + 5, x + 5};
            int[] yPoints = new int[]{y, y - 5, y - handleHeight, y - handleHeight, y - 5};
            g.fillPolygon(xPoints, yPoints, xPoints.length);
        }

        private Thumb() {
        }

        static {
            Thumb thumb;
            INSTANCE = thumb = new Thumb();
            THUMB_COLOR = new JBColor(4882943, 11851775);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$Diamond;", "", "()V", "DIAMOND_SIZE", "", "paintDiamond", "", "g", "Ljava/awt/Graphics2D;", "x", "y", "colorIndex", "intellij.android.compose-designer"})
    private static final class Diamond {
        public static final int DIAMOND_SIZE = 6;
        @NotNull
        public static final Diamond INSTANCE;

        public final void paintDiamond(@NotNull Graphics2D g, int x, int y, int colorIndex) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            var $fun$xArray$1 = new Function1<Integer, int[]>(x){
                final /* synthetic */ int $x;

                @NotNull
                public final int[] invoke(int size) {
                    return new int[]{this.$x, this.$x + size, this.$x, this.$x - size};
                }
                {
                    this.$x = n;
                    super(1);
                }
            };
            var $fun$yArray$2 = new Function1<Integer, int[]>(y){
                final /* synthetic */ int $y;

                @NotNull
                public final int[] invoke(int size) {
                    return new int[]{this.$y - size, this.$y, this.$y + size, this.$y};
                }
                {
                    this.$y = n;
                    super(1);
                }
            };
            g.setColor((Color)new JBColor(Color.white, JBColor.border().darker()));
            g.fillPolygon($fun$xArray$1.invoke(7), $fun$yArray$2.invoke(7), 4);
            g.setColor((Color)INSTANCE.getGRAPH_COLORS().get(colorIndex % INSTANCE.getGRAPH_COLORS().size()));
            g.fillPolygon($fun$xArray$1.invoke(6), $fun$yArray$2.invoke(6), 4);
        }

        private Diamond() {
        }

        static {
            Diamond diamond;
            INSTANCE = diamond = new Diamond();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0006\u001a\u00020\u00012\b\b\u0002\u0010\u0007\u001a\u00020\bH&J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H&J\b\u0010\f\u001a\u00020\nH&J\b\u0010\r\u001a\u00020\bH&J\u0016\u0010\u000e\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0010H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$StateComboBox;", "", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "getState", "index", "", "setStartState", "", "state", "setupListeners", "stateHashCode", "updateStates", "states", "", "intellij.android.compose-designer"})
    public static interface StateComboBox {
        @NotNull
        public JComponent getComponent();

        public void updateStates(@NotNull Set<? extends Object> var1);

        public void setupListeners();

        public int stateHashCode();

        @NotNull
        public Object getState(int var1);

        public void setStartState(@Nullable Object var1);

        @Metadata(mv={1, 5, 1}, k=3)
        public static final class DefaultImpls {
            public static /* synthetic */ Object getState$default(StateComboBox stateComboBox, int n, int n2, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getState");
                }
                if ((n2 & 1) != 0) {
                    n = 0;
                }
                return stateComboBox.getState(n);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016J\u0016\u0010\u0010\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0016R\u0014\u0010\u0004\u001a\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$EmptyComboBox;", "Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$StateComboBox;", "Ljavax/swing/JPanel;", "()V", "component", "getComponent", "()Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$EmptyComboBox;", "getState", "", "index", "", "setStartState", "", "state", "setupListeners", "stateHashCode", "updateStates", "states", "", "intellij.android.compose-designer"})
    public static final class EmptyComboBox
    extends JPanel
    implements StateComboBox {
        @NotNull
        private final EmptyComboBox component = this;

        @Override
        @NotNull
        public EmptyComboBox getComponent() {
            return this.component;
        }

        @Override
        public int stateHashCode() {
            return 0;
        }

        @Override
        public void setupListeners() {
        }

        @Override
        public void updateStates(@NotNull Set<? extends Object> states) {
            Intrinsics.checkNotNullParameter(states, (String)"states");
        }

        @Override
        @NotNull
        public Object getState(int index) {
            return 0;
        }

        @Override
        public void setStartState(@Nullable Object state) {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002BK\u0012!\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u0012!\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\u0016\u0010\u0019\u001a\u00020\n2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bH\u0016R)\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R)\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$AnimatedVisibilityComboBox;", "Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$StateComboBox;", "Lcom/intellij/openapi/ui/ComboBox;", "", "logger", "Lkotlin/Function1;", "Lcom/google/wireless/android/sdk/stats/ComposeAnimationToolingEvent$ComposeAnimationToolingEventType;", "Lkotlin/ParameterName;", "name", "type", "", "callback", "stateComboBox", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "getState", "index", "", "setStartState", "state", "setupListeners", "stateHashCode", "updateStates", "states", "", "intellij.android.compose-designer"})
    public static final class AnimatedVisibilityComboBox
    extends ComboBox<Object>
    implements StateComboBox {
        @NotNull
        private final JComponent component;
        private final Function1<ComposeAnimationToolingEvent.ComposeAnimationToolingEventType, Unit> logger;
        private final Function1<StateComboBox, Unit> callback;

        @Override
        @NotNull
        public JComponent getComponent() {
            return this.component;
        }

        @Override
        public void updateStates(@NotNull Set<? extends Object> states) {
            Intrinsics.checkNotNullParameter(states, (String)"states");
            Collection $this$toTypedArray$iv = states;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            this.setModel(new DefaultComboBoxModel<Object>(objectArray));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setStartState(@Nullable Object state) {
            String string2;
            Object object = state;
            if (!(object instanceof String)) {
                object = null;
            }
            String it = string2 = (String)object;
            boolean bl = false;
            int n = 0;
            int n2 = this.getItemCount();
            while (n < n2) {
                void i;
                Object item = this.getItemAt((int)i);
                if (Intrinsics.areEqual((Object)item.toString(), (Object)it)) {
                    this.setSelectedItem(item);
                }
                ++i;
            }
        }

        @Override
        public void setupListeners() {
            this.addActionListener(new ActionListener(this){
                final /* synthetic */ AnimatedVisibilityComboBox this$0;

                public final void actionPerformed(ActionEvent it) {
                    AnimatedVisibilityComboBox.access$getLogger$p(this.this$0).invoke((Object)ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.CHANGE_END_STATE);
                    AnimatedVisibilityComboBox.access$getCallback$p(this.this$0).invoke((Object)this.this$0);
                }
                {
                    this.this$0 = animatedVisibilityComboBox;
                }
            });
        }

        @Override
        public int stateHashCode() {
            return this.getSelectedItem().hashCode();
        }

        @Override
        @NotNull
        public Object getState(int index) {
            Object object = this.getSelectedItem();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"selectedItem");
            return object;
        }

        public AnimatedVisibilityComboBox(@NotNull Function1<? super ComposeAnimationToolingEvent.ComposeAnimationToolingEventType, Unit> logger2, @NotNull Function1<? super StateComboBox, Unit> callback2) {
            Intrinsics.checkNotNullParameter(logger2, (String)"logger");
            Intrinsics.checkNotNullParameter(callback2, (String)"callback");
            super((ComboBoxModel)new DefaultComboBoxModel<Object>(new Object[0]));
            this.logger = logger2;
            this.callback = callback2;
            this.component = (JComponent)((Object)this);
            this.setModel(new DefaultComboBoxModel<String>(new String[]{ComposePreviewBundle.message("animation.inspector.animated.visibility.combobox.placeholder.message", new Object[0])}));
        }

        public static final /* synthetic */ Function1 access$getLogger$p(AnimatedVisibilityComboBox $this) {
            return $this.logger;
        }

        public static final /* synthetic */ Function1 access$getCallback$p(AnimatedVisibilityComboBox $this) {
            return $this.callback;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001#BS\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012!\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006\u0012!\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u00020\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u001e\u001a\u00020\u000bH\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016J\u0016\u0010 \u001a\u00020\u000b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140\"H\u0016R)\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R)\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$StartEndComboBox;", "Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$StateComboBox;", "Ljavax/swing/JPanel;", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "logger", "Lkotlin/Function1;", "Lcom/google/wireless/android/sdk/stats/ComposeAnimationToolingEvent$ComposeAnimationToolingEventType;", "Lkotlin/ParameterName;", "name", "type", "", "callback", "stateComboBox", "(Lcom/android/tools/idea/common/surface/DesignSurface;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "component", "getComponent", "()Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$StartEndComboBox;", "endStateComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "", "kotlin.jvm.PlatformType", "isSwappingStates", "", "startStateComboBox", "getState", "index", "", "setStartState", "state", "setupListeners", "stateHashCode", "updateStates", "states", "", "SwapStartEndStatesAction", "intellij.android.compose-designer"})
    public static final class StartEndComboBox
    extends JPanel
    implements StateComboBox {
        private final ComboBox<Object> startStateComboBox;
        private final ComboBox<Object> endStateComboBox;
        @NotNull
        private final StartEndComboBox component;
        private boolean isSwappingStates;
        private final DesignSurface surface;
        private final Function1<ComposeAnimationToolingEvent.ComposeAnimationToolingEventType, Unit> logger;
        private final Function1<StateComboBox, Unit> callback;

        @Override
        @NotNull
        public StartEndComboBox getComponent() {
            return this.component;
        }

        @Override
        public int stateHashCode() {
            Object object = this.startStateComboBox.getSelectedItem();
            Object object2 = this.endStateComboBox.getSelectedItem();
            return new Pair((Object)(object != null ? Integer.valueOf(object.hashCode()) : null), (Object)(object2 != null ? Integer.valueOf(object2.hashCode()) : null)).hashCode();
        }

        @Override
        public void setupListeners() {
            this.startStateComboBox.addActionListener(new ActionListener(this){
                final /* synthetic */ StartEndComboBox this$0;

                public final void actionPerformed(ActionEvent it) {
                    if (StartEndComboBox.access$isSwappingStates$p(this.this$0)) {
                        return;
                    }
                    StartEndComboBox.access$getLogger$p(this.this$0).invoke((Object)ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.CHANGE_START_STATE);
                    StartEndComboBox.access$getCallback$p(this.this$0).invoke((Object)this.this$0);
                }
                {
                    this.this$0 = startEndComboBox;
                }
            });
            this.endStateComboBox.addActionListener(new ActionListener(this){
                final /* synthetic */ StartEndComboBox this$0;

                public final void actionPerformed(ActionEvent it) {
                    if (!StartEndComboBox.access$isSwappingStates$p(this.this$0)) {
                        StartEndComboBox.access$getLogger$p(this.this$0).invoke((Object)ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.CHANGE_END_STATE);
                    }
                    StartEndComboBox.access$getCallback$p(this.this$0).invoke((Object)this.this$0);
                }
                {
                    this.this$0 = startEndComboBox;
                }
            });
        }

        @Override
        public void updateStates(@NotNull Set<? extends Object> states) {
            Intrinsics.checkNotNullParameter(states, (String)"states");
            Collection $this$toTypedArray$iv = states;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            this.startStateComboBox.setModel((ComboBoxModel)new DefaultComboBoxModel<Object>(objectArray));
            $this$toTypedArray$iv = states;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray2 = thisCollection$iv.toArray(new Object[0]);
            if (objectArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            this.endStateComboBox.setModel((ComboBoxModel)new DefaultComboBoxModel<Object>(objectArray2));
        }

        @Override
        @NotNull
        public Object getState(int index) {
            Object object;
            switch (index) {
                case 0: {
                    object = this.startStateComboBox.getSelectedItem();
                    break;
                }
                case 1: {
                    object = this.endStateComboBox.getSelectedItem();
                    break;
                }
                default: {
                    object = 0;
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"when (index) {\n      0 -\u2026tem\n      else -> 0\n    }");
            return object;
        }

        @Override
        public void setStartState(@Nullable Object state) {
            this.startStateComboBox.setSelectedItem(state);
            if (this.startStateComboBox.getSelectedIndex() == this.endStateComboBox.getSelectedIndex() && this.endStateComboBox.getItemCount() > 1) {
                this.endStateComboBox.setSelectedIndex((this.startStateComboBox.getSelectedIndex() + 1) % this.endStateComboBox.getItemCount());
            }
        }

        public StartEndComboBox(@NotNull DesignSurface surface2, @NotNull Function1<? super ComposeAnimationToolingEvent.ComposeAnimationToolingEventType, Unit> logger2, @NotNull Function1<? super StateComboBox, Unit> callback2) {
            ActionToolbarImpl actionToolbarImpl;
            Intrinsics.checkNotNullParameter((Object)((Object)surface2), (String)"surface");
            Intrinsics.checkNotNullParameter(logger2, (String)"logger");
            Intrinsics.checkNotNullParameter(callback2, (String)"callback");
            super((LayoutManager)new TabularLayout("Fit,Fit,Fit,Fit"));
            this.surface = surface2;
            this.logger = logger2;
            this.callback = callback2;
            this.startStateComboBox = new ComboBox((ComboBoxModel)new DefaultComboBoxModel<Object>(new Object[0]));
            this.endStateComboBox = new ComboBox((ComboBoxModel)new DefaultComboBoxModel<Object>(new Object[0]));
            this.component = this;
            String[] states = new String[]{ComposePreviewBundle.message("animation.inspector.states.combobox.placeholder.message", new Object[0])};
            this.startStateComboBox.setModel((ComboBoxModel)new DefaultComboBoxModel<String>(states));
            this.endStateComboBox.setModel((ComboBoxModel)new DefaultComboBoxModel<String>(states));
            ActionToolbarImpl $this$apply = actionToolbarImpl = new ActionToolbarImpl(this, "Swap States", (ActionGroup)new DefaultActionGroup(new AnAction[]{(AnAction)new SwapStartEndStatesAction()}), true){
                final /* synthetic */ StartEndComboBox this$0;

                @NotNull
                public JBDimension getPreferredSize() {
                    JBDimension jBDimension = JBUI.size((int)30, (int)30);
                    Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"JBUI.size(30, 30)");
                    return jBDimension;
                }
                {
                    this.this$0 = this$0;
                    super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                }
            };
            boolean bl = false;
            $this$apply.setTargetComponent((JComponent)((Object)this.surface));
            ActionToolbarUtil.makeToolbarNavigable((ActionToolbar)((ActionToolbar)$this$apply));
            ActionToolbarImpl swapStatesActionToolbar2 = actionToolbarImpl;
            this.add((Component)swapStatesActionToolbar2, new TabularLayout.Constraint(0, 0, 0, 4, null));
            this.add((Component)this.startStateComboBox, new TabularLayout.Constraint(0, 1, 0, 4, null));
            this.add((Component)new JBLabel(ComposePreviewBundle.message("animation.inspector.state.to.label", new Object[0])), new TabularLayout.Constraint(0, 2, 0, 4, null));
            this.add((Component)this.endStateComboBox, new TabularLayout.Constraint(0, 3, 0, 4, null));
        }

        public static final /* synthetic */ boolean access$isSwappingStates$p(StartEndComboBox $this) {
            return $this.isSwappingStates;
        }

        public static final /* synthetic */ Function1 access$getCallback$p(StartEndComboBox $this) {
            return $this.callback;
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$StartEndComboBox$SwapStartEndStatesAction;", "Lcom/intellij/ui/AnActionButton;", "(Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$StartEndComboBox;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "updateButton", "intellij.android.compose-designer"})
        private final class SwapStartEndStatesAction
        extends AnActionButton {
            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                StartEndComboBox.this.isSwappingStates = true;
                Object startState = StartEndComboBox.this.startStateComboBox.getSelectedItem();
                StartEndComboBox.this.startStateComboBox.setSelectedItem(StartEndComboBox.this.endStateComboBox.getSelectedItem());
                StartEndComboBox.this.endStateComboBox.setSelectedItem(startState);
                StartEndComboBox.this.isSwappingStates = false;
                StartEndComboBox.this.logger.invoke((Object)ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.TRIGGER_SWAP_STATES_ACTION);
            }

            public void updateButton(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.updateButton(e);
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                presentation.setEnabled(true);
            }

            public SwapStartEndStatesAction() {
                super(ComposePreviewBundle.message("animation.inspector.action.swap.states", new Object[0]), StudioIcons.LayoutEditor.Motion.PLAY_YOYO);
            }
        }
    }
}

