/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview;

import com.android.annotations.concurrency.AnyThread;
import com.android.tools.idea.compose.preview.NopPsiFileSnapshotFilter;
import com.android.tools.idea.compose.preview.ProjectBuildStatus;
import com.android.tools.idea.compose.preview.ProjectBuildStatusManager;
import com.android.tools.idea.compose.preview.ProjectBuildStatusManagerKt;
import com.android.tools.idea.compose.preview.ProjectStatus;
import com.android.tools.idea.compose.preview.PsiFileSnapshotFilter;
import com.android.tools.idea.compose.preview.util.BuildKt;
import com.android.tools.idea.compose.preview.util.NopPsiFileChangeDetector;
import com.android.tools.idea.compose.preview.util.PsiFileChangeDetector;
import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.android.tools.idea.editors.literals.LiveLiteralsApplicationConfiguration;
import com.android.tools.idea.projectsystem.ProjectSystemBuildManager;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.util.SyncUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001f\u001a\u00020\u0010H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/compose/preview/ProjectBuildStatusManagerImpl;", "Lcom/android/tools/idea/compose/preview/ProjectBuildStatusManager;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "editorFile", "Lcom/intellij/psi/PsiFile;", "psiFilter", "Lcom/android/tools/idea/compose/preview/PsiFileSnapshotFilter;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/psi/PsiFile;Lcom/android/tools/idea/compose/preview/PsiFileSnapshotFilter;Lkotlinx/coroutines/CoroutineScope;)V", "_isBuilding", "Ljava/util/concurrent/atomic/AtomicBoolean;", "fileChangeDetector", "Lcom/android/tools/idea/compose/preview/util/PsiFileChangeDetector;", "isBuilding", "", "()Z", "lastFilterModificationCount", "", "project", "Lcom/intellij/openapi/project/Project;", "value", "Lcom/android/tools/idea/compose/preview/ProjectBuildStatus;", "projectBuildStatus", "setProjectBuildStatus", "(Lcom/android/tools/idea/compose/preview/ProjectBuildStatus;)V", "status", "Lcom/android/tools/idea/compose/preview/ProjectStatus;", "getStatus", "()Lcom/android/tools/idea/compose/preview/ProjectStatus;", "isBuildOutOfDate", "intellij.android.compose-designer"})
final class ProjectBuildStatusManagerImpl
implements ProjectBuildStatusManager {
    private final Project project;
    private final PsiFileChangeDetector fileChangeDetector;
    private final AtomicBoolean _isBuilding;
    private ProjectBuildStatus projectBuildStatus;
    private long lastFilterModificationCount;
    private final PsiFile editorFile;
    private final PsiFileSnapshotFilter psiFilter;

    private final void setProjectBuildStatus(ProjectBuildStatus value2) {
        if (Intrinsics.areEqual((Object)this.projectBuildStatus, (Object)value2) ^ true) {
            ProjectBuildStatusManagerKt.access$getLOG$p().debug("Status change old = " + this.projectBuildStatus + ", new = " + value2);
            this.projectBuildStatus = value2;
        }
    }

    @Override
    @NotNull
    public ProjectStatus getStatus() {
        if (this.psiFilter.getModificationCount() != this.lastFilterModificationCount) {
            this.lastFilterModificationCount = this.psiFilter.getModificationCount();
            if (!(this.projectBuildStatus instanceof ProjectBuildStatus.NotReady)) {
                this.fileChangeDetector.forceMarkFileAsUpToDate(this.editorFile);
            }
        }
        return Intrinsics.areEqual((Object)this.projectBuildStatus, (Object)ProjectBuildStatus.NotReady.INSTANCE) ? (ProjectStatus)ProjectStatus.NotReady.INSTANCE : (this.isBuildOutOfDate() ? (ProjectStatus)ProjectStatus.OutOfDate.INSTANCE : (Intrinsics.areEqual((Object)this.projectBuildStatus, (Object)ProjectBuildStatus.NeedsBuild.INSTANCE) ? (ProjectStatus)ProjectStatus.NeedsBuild.INSTANCE : (ProjectStatus)ProjectStatus.Ready.INSTANCE));
    }

    @Override
    public boolean isBuilding() {
        return this._isBuilding.get();
    }

    private final boolean isBuildOutOfDate() {
        return PsiFileChangeDetector.DefaultImpls.hasFileChanged$default(this.fileChangeDetector, this.editorFile, false, 2, null);
    }

    public ProjectBuildStatusManagerImpl(@NotNull Disposable parentDisposable, @NotNull PsiFile editorFile, @NotNull PsiFileSnapshotFilter psiFilter, final @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)editorFile, (String)"editorFile");
        Intrinsics.checkNotNullParameter((Object)psiFilter, (String)"psiFilter");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.editorFile = editorFile;
        this.psiFilter = psiFilter;
        Project project = this.editorFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"editorFile.project");
        this.project = project;
        this.fileChangeDetector = LiveLiteralsApplicationConfiguration.Companion.getInstance().isEnabled() ? (PsiFileChangeDetector)PsiFileChangeDetector.Companion.getInstance((Function1<? super PsiElement, Boolean>)((Function1)new Function1<PsiElement, Boolean>(this){
            final /* synthetic */ ProjectBuildStatusManagerImpl this$0;

            public final boolean invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ProjectBuildStatusManagerImpl.access$getPsiFilter$p(this.this$0).accepts(it);
            }
            {
                this.this$0 = projectBuildStatusManagerImpl;
                super(1);
            }
        })) : (PsiFileChangeDetector)NopPsiFileChangeDetector.INSTANCE;
        this._isBuilding = new AtomicBoolean(false);
        this.projectBuildStatus = ProjectBuildStatus.NotReady.INSTANCE;
        this.lastFilterModificationCount = this.psiFilter.getModificationCount();
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public final void dispose() {
                fileChangeDetector.clearMarks(editorFile);
            }
        });
        ProjectSystemService.Companion.getInstance(this.project).getProjectSystem().getBuildManager().addBuildListener(parentDisposable, new ProjectSystemBuildManager.BuildListener(){

            public void buildStarted(@NotNull ProjectSystemBuildManager.BuildMode mode) {
                Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
                _isBuilding.set(true);
                ProjectBuildStatusManagerKt.access$getLOG$p().debug("buildStarted " + mode);
                if (mode == ProjectSystemBuildManager.BuildMode.CLEAN) {
                    this.setProjectBuildStatus(ProjectBuildStatus.NeedsBuild.INSTANCE);
                }
            }

            public void buildCompleted(@NotNull ProjectSystemBuildManager.BuildResult result) {
                ProjectBuildStatus projectBuildStatus;
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                _isBuilding.set(false);
                ProjectBuildStatusManagerKt.access$getLOG$p().debug("buildFinished " + result);
                if (result.getMode() == ProjectSystemBuildManager.BuildMode.CLEAN) {
                    fileChangeDetector.markFileAsUpToDate(editorFile);
                    return;
                }
                if (result.getStatus() == ProjectSystemBuildManager.BuildStatus.SUCCESS) {
                    fileChangeDetector.markFileAsUpToDate(editorFile);
                    projectBuildStatus = ProjectBuildStatus.Built.INSTANCE;
                } else {
                    ProjectBuildStatus projectBuildStatus2 = projectBuildStatus;
                    projectBuildStatus = Intrinsics.areEqual((Object)projectBuildStatus2, (Object)ProjectBuildStatus.Built.INSTANCE) ? (ProjectBuildStatus)ProjectBuildStatus.Built.INSTANCE : (ProjectBuildStatus)ProjectBuildStatus.NeedsBuild.INSTANCE;
                }
                this.setProjectBuildStatus(projectBuildStatus);
            }

            @AnyThread
            public void beforeBuildCompleted(@NotNull ProjectSystemBuildManager.BuildResult result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                ProjectSystemBuildManager.BuildListener.DefaultImpls.beforeBuildCompleted((ProjectSystemBuildManager.BuildListener)this, (ProjectSystemBuildManager.BuildResult)result);
            }
        });
        SyncUtil.runWhenSmartAndSyncedOnEdt$default((Project)this.project, (Disposable)parentDisposable, (Consumer)new Consumer(){

            public final void accept(@NotNull ProjectSystemSyncManager.SyncResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                fileChangeDetector.markFileAsUpToDate(editorFile);
                if (projectBuildStatus == ProjectBuildStatus.NotReady.INSTANCE) {
                    BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                        int label;
                        final /* synthetic */ 3 this$0;

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ProjectBuildStatus newState2;
                                    ResultKt.throwOnFailure((Object)object);
                                    ProjectBuildStatus projectBuildStatus = newState2 = BuildKt.hasBeenBuiltSuccessfully(project, (Function0<? extends PsiFile>)((Function0)new Function0<PsiFile>(this){
                                        final /* synthetic */ 1 this$0;

                                        @NotNull
                                        public final PsiFile invoke() {
                                            return ProjectBuildStatusManagerImpl.access$getEditorFile$p(this.this$0.this$0.this);
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            super(0);
                                        }
                                    })) ? (ProjectBuildStatus)ProjectBuildStatus.Built.INSTANCE : (ProjectBuildStatus)ProjectBuildStatus.NeedsBuild.INSTANCE;
                                    if (projectBuildStatus == ProjectBuildStatus.NotReady.INSTANCE) {
                                        this.this$0.this.setProjectBuildStatus(newState2);
                                    }
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                        {
                            this.this$0 = var1_1;
                            super(2, continuation);
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> completion2) {
                            Intrinsics.checkNotNullParameter(completion2, (String)"completion");
                            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                            return function2;
                        }

                        public final Object invoke(Object object, Object object2) {
                            return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            }
        }, null, (int)4, null);
    }

    public /* synthetic */ ProjectBuildStatusManagerImpl(Disposable disposable2, PsiFile psiFile2, PsiFileSnapshotFilter psiFileSnapshotFilter, CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            psiFileSnapshotFilter = NopPsiFileSnapshotFilter.INSTANCE;
        }
        if ((n & 8) != 0) {
            coroutineScope = CoroutinesUtilsKt.AndroidCoroutineScope$default((Disposable)disposable2, null, (int)2, null);
        }
        this(disposable2, psiFile2, psiFileSnapshotFilter, coroutineScope);
    }

    public static final /* synthetic */ PsiFileSnapshotFilter access$getPsiFilter$p(ProjectBuildStatusManagerImpl $this) {
        return $this.psiFilter;
    }
}

