/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.resources.ScreenRound;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.ScaleKt;
import com.android.tools.idea.common.model.SecondarySelectionModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneLayer;
import com.android.tools.idea.configurations.Configuration;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.JBInsets;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SceneView {
    public static final ShapePolicy DEVICE_CONFIGURATION_SHAPE_POLICY = sceneView -> {
        Device device = sceneView.getConfiguration().getCachedDevice();
        if (device == null) {
            return null;
        }
        Screen screen = device.getDefaultHardware().getScreen();
        if (screen.getScreenRound() != ScreenRound.ROUND) {
            return null;
        }
        Dimension size = sceneView.getScaledContentSize();
        int chin = screen.getChin();
        int originX = sceneView.getX();
        int originY = sceneView.getY();
        if (chin == 0) {
            return new Ellipse2D.Double(originX, originY, size.width, size.height);
        }
        int height = size.height * chin / screen.getYDimension();
        Area a1 = new Area(new Ellipse2D.Double(originX, originY, size.width, size.height + height));
        Area a2 = new Area(new Rectangle2D.Double(originX, originY + 2 * (size.height + height) - height, size.width, height));
        a1.subtract(a2);
        return a1;
    };
    public static final ShapePolicy SQUARE_SHAPE_POLICY = sceneView -> {
        Dimension size = sceneView.getScaledContentSize();
        return new Rectangle(sceneView.getX(), sceneView.getY(), size.width, size.height);
    };
    @NotNull
    private final DesignSurface mySurface;
    @NotNull
    private final SceneManager myManager;
    private final Object myLayersCacheLock;
    private ImmutableList<Layer> myLayersCache;
    private int x;
    private int y;
    private boolean myAnimated;
    private boolean myIsVisible;
    @NotNull
    private final ShapePolicy myShapePolicy;
    @NotNull
    private final SceneContext myContext;

    public SceneView(@NotNull DesignSurface surface2, @NotNull SceneManager manager, @NotNull ShapePolicy shapePolicy) {
        if (surface2 == null) {
            SceneView.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SceneView.$$$reportNull$$$0(1);
        }
        if (shapePolicy == null) {
            SceneView.$$$reportNull$$$0(2);
        }
        this.myLayersCacheLock = new Object();
        this.myAnimated = false;
        this.myIsVisible = true;
        this.myContext = new SceneViewTransform();
        this.mySurface = surface2;
        this.myManager = manager;
        this.myShapePolicy = shapePolicy;
    }

    @NotNull
    protected abstract ImmutableList<Layer> createLayers();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private ImmutableList<Layer> getLayers() {
        if (Disposer.isDisposed((Disposable)this.mySurface)) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList != null) return immutableList;
            SceneView.$$$reportNull$$$0(3);
            return immutableList;
        }
        Object object = this.myLayersCacheLock;
        // MONITORENTER : object
        if (this.myLayersCache == null) {
            this.myLayersCache = this.createLayers();
        }
        ImmutableList<Layer> immutableList = this.myLayersCache;
        // MONITOREXIT : object
        if (immutableList != null) return immutableList;
        SceneView.$$$reportNull$$$0(4);
        return immutableList;
    }

    @NotNull
    public final Scene getScene() {
        Scene scene = this.getSceneManager().getScene();
        if (scene == null) {
            SceneView.$$$reportNull$$$0(5);
        }
        return scene;
    }

    @NotNull
    public final Dimension getScaledContentSize(@Nullable Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension();
        }
        Dimension contentSize = this.getContentSize(dimension);
        Dimension dimension2 = ScaleKt.scaleBy(contentSize, this.getScale());
        if (dimension2 == null) {
            SceneView.$$$reportNull$$$0(6);
        }
        return dimension2;
    }

    @NotNull
    public final Dimension getScaledContentSize() {
        return this.getScaledContentSize(null);
    }

    @NotNull
    public Insets getMargin() {
        JBInsets jBInsets = JBInsets.emptyInsets();
        if (jBInsets == null) {
            SceneView.$$$reportNull$$$0(7);
        }
        return jBInsets;
    }

    @NotNull
    public abstract Dimension getContentSize(@Nullable Dimension var1);

    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.getSceneManager().getModel().getConfiguration();
        if (configuration == null) {
            SceneView.$$$reportNull$$$0(8);
        }
        return configuration;
    }

    @Deprecated
    @NotNull
    public NlModel getModel() {
        NlModel nlModel = this.myManager.getModel();
        if (nlModel == null) {
            SceneView.$$$reportNull$$$0(9);
        }
        return nlModel;
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        SelectionModel selectionModel = this.getSurface().getSelectionModel();
        if (selectionModel == null) {
            SceneView.$$$reportNull$$$0(10);
        }
        return selectionModel;
    }

    @NotNull
    public SecondarySelectionModel getSecondarySelectionModel() {
        SecondarySelectionModel secondarySelectionModel = this.getSurface().getSecondarySelectionModel();
        if (secondarySelectionModel == null) {
            SceneView.$$$reportNull$$$0(11);
        }
        return secondarySelectionModel;
    }

    @Nullable
    public Shape getScreenShape() {
        return this.myShapePolicy.getShape(this);
    }

    @NotNull
    public DesignSurface getSurface() {
        DesignSurface designSurface = this.mySurface;
        if (designSurface == null) {
            SceneView.$$$reportNull$$$0(12);
        }
        return designSurface;
    }

    public double getScale() {
        return this.getSurface().getScale();
    }

    public float getSceneScalingFactor() {
        return this.getSceneManager().getSceneScalingFactor();
    }

    public final void setLocation(int screenX, int screenY) {
        this.x = screenX;
        this.y = screenY;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getContentTranslationX() {
        return 0;
    }

    public int getContentTranslationY() {
        return 0;
    }

    @NotNull
    public SceneManager getSceneManager() {
        SceneManager sceneManager = this.myManager;
        if (sceneManager == null) {
            SceneView.$$$reportNull$$$0(13);
        }
        return sceneManager;
    }

    @NotNull
    public abstract ColorSet getColorSet();

    public boolean isResizeable() {
        return false;
    }

    @NotNull
    public final SceneContext getContext() {
        SceneContext sceneContext = this.myContext;
        if (sceneContext == null) {
            SceneView.$$$reportNull$$$0(14);
        }
        return sceneContext;
    }

    public void updateUI() {
    }

    final void paint(@NotNull Graphics2D graphics) {
        if (graphics == null) {
            SceneView.$$$reportNull$$$0(15);
        }
        if (!this.myIsVisible) {
            return;
        }
        for (Layer layer : this.getLayers()) {
            if (!layer.isVisible()) continue;
            layer.paint(graphics);
        }
    }

    final void onDragStart() {
        for (Layer layer : this.getLayers()) {
            SceneLayer sceneLayer;
            if (!(layer instanceof SceneLayer) || !(sceneLayer = (SceneLayer)layer).isShowOnHover()) continue;
            sceneLayer.setShowOnHover(true);
        }
    }

    final void onDragEnd() {
        for (Layer layer : this.getLayers()) {
            SceneLayer sceneLayer;
            if (!(layer instanceof SceneLayer) || !(sceneLayer = (SceneLayer)layer).isShowOnHover()) continue;
            sceneLayer.setShowOnHover(false);
        }
    }

    public boolean hasContentSize() {
        return this.isVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLayersCacheLock;
        synchronized (object) {
            if (this.myLayersCache != null) {
                this.myLayersCache.forEach(Disposer::dispose);
            }
        }
    }

    public final void onHover(int mouseX, int mouseY) {
        for (Layer layer : this.getLayers()) {
            layer.onHover(mouseX, mouseY);
        }
    }

    public final void setForceLayersRepaint(boolean value2) {
        for (Layer layer : this.getLayers()) {
            if (!(layer instanceof SceneLayer)) continue;
            SceneLayer sceneLayer = (SceneLayer)layer;
            sceneLayer.setTemporaryShow(value2);
        }
    }

    public void setAnimated(boolean animated) {
        this.myAnimated = animated;
    }

    public boolean isAnimated() {
        return this.myAnimated;
    }

    public void setVisible(boolean visibility) {
        this.myIsVisible = visibility;
    }

    public boolean isVisible() {
        return this.myIsVisible;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shapePolicy";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/surface/SceneView";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/surface/SceneView";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getScene";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getScaledContentSize";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMargin";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondarySelectionModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurface";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneManager";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class SceneViewTransform
    extends SceneContext {
        private SceneViewTransform() {
        }

        @Override
        @NotNull
        public ColorSet getColorSet() {
            ColorSet colorSet = SceneView.this.getColorSet();
            if (colorSet == null) {
                SceneViewTransform.$$$reportNull$$$0(0);
            }
            return colorSet;
        }

        @Override
        @NotNull
        public DesignSurface getSurface() {
            DesignSurface designSurface = SceneView.this.getSurface();
            if (designSurface == null) {
                SceneViewTransform.$$$reportNull$$$0(1);
            }
            return designSurface;
        }

        @Override
        public double getScale() {
            return SceneView.this.getScale();
        }

        @Override
        public int getSwingXDip(float x) {
            return Coordinates.getSwingX(SceneView.this, Coordinates.dpToPx(SceneView.this, x));
        }

        @Override
        public int getSwingYDip(float y) {
            return Coordinates.getSwingY(SceneView.this, Coordinates.dpToPx(SceneView.this, y));
        }

        @Override
        public int getSwingX(int x) {
            return Coordinates.getSwingX(SceneView.this, x);
        }

        @Override
        public int getSwingY(int y) {
            return Coordinates.getSwingY(SceneView.this, y);
        }

        @Override
        public float pxToDp(int px) {
            return Coordinates.pxToDp(SceneView.this, px);
        }

        @Override
        public void repaint() {
            this.getSurface().needsRepaint();
        }

        @Override
        public int getSwingDimensionDip(float dim) {
            return Coordinates.getSwingDimension(SceneView.this, Coordinates.dpToPx(SceneView.this, dim));
        }

        @Override
        public int getSwingDimension(int dim) {
            return Coordinates.getSwingDimension(SceneView.this, dim);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/idea/common/surface/SceneView$SceneViewTransform";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColorSet";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSurface";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static interface ShapePolicy {
        @Nullable
        public Shape getShape(@NotNull SceneView var1);
    }
}

