/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.ScaleKt;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.SceneView;
import java.awt.Dimension;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\b\u0018\u0000 '2\u00020\u0001:\u0001'B;\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u000bH\u00c6\u0003JI\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\bH\u00d6\u0001J\u000e\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%J\t\u0010&\u001a\u00020\u0005H\u00d6\u0001R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016\u00a8\u0006("}, d2={"Lcom/android/tools/idea/common/surface/LayoutData;", "", "scale", "", "modelName", "", "modelTooltip", "x", "", "y", "scaledSize", "Ljava/awt/Dimension;", "(DLjava/lang/String;Ljava/lang/String;IILjava/awt/Dimension;)V", "cachedDimension", "getModelName", "()Ljava/lang/String;", "getModelTooltip", "getScale", "()D", "getScaledSize", "()Ljava/awt/Dimension;", "getX", "()I", "getY", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "isValidFor", "sceneView", "Lcom/android/tools/idea/common/surface/SceneView;", "toString", "Companion", "intellij.android.designer"})
final class LayoutData {
    private final Dimension cachedDimension;
    private final double scale;
    @Nullable
    private final String modelName;
    @Nullable
    private final String modelTooltip;
    private final int x;
    private final int y;
    @NotNull
    private final Dimension scaledSize;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValidFor(@NotNull SceneView sceneView) {
        Intrinsics.checkNotNullParameter((Object)sceneView, (String)"sceneView");
        if (this.scale != sceneView.getScale()) return false;
        if (this.x != sceneView.getX()) return false;
        if (this.y != sceneView.getY()) return false;
        Scene scene = sceneView.getScene();
        Intrinsics.checkNotNullExpressionValue((Object)scene, (String)"sceneView.scene");
        SceneManager sceneManager = scene.getSceneManager();
        Intrinsics.checkNotNullExpressionValue((Object)sceneManager, (String)"sceneView.scene.sceneManager");
        NlModel nlModel = sceneManager.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"sceneView.scene.sceneManager.model");
        if (!Intrinsics.areEqual((Object)this.modelName, (Object)nlModel.getModelDisplayName())) return false;
        Dimension dimension = sceneView.getContentSize(this.cachedDimension);
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"sceneView.getContentSize(cachedDimension)");
        if (!Intrinsics.areEqual((Object)this.scaledSize, (Object)ScaleKt.scaleBy(dimension, sceneView.getScale()))) return false;
        return true;
    }

    public final double getScale() {
        return this.scale;
    }

    @Nullable
    public final String getModelName() {
        return this.modelName;
    }

    @Nullable
    public final String getModelTooltip() {
        return this.modelTooltip;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    @NotNull
    public final Dimension getScaledSize() {
        return this.scaledSize;
    }

    private LayoutData(double scale, String modelName, String modelTooltip, int x, int y, Dimension scaledSize) {
        this.scale = scale;
        this.modelName = modelName;
        this.modelTooltip = modelTooltip;
        this.x = x;
        this.y = y;
        this.scaledSize = scaledSize;
        this.cachedDimension = new Dimension();
    }

    public /* synthetic */ LayoutData(double scale, String modelName, String modelTooltip, int x, int y, Dimension scaledSize, DefaultConstructorMarker $constructor_marker) {
        this(scale, modelName, modelTooltip, x, y, scaledSize);
    }

    public final double component1() {
        return this.scale;
    }

    @Nullable
    public final String component2() {
        return this.modelName;
    }

    @Nullable
    public final String component3() {
        return this.modelTooltip;
    }

    public final int component4() {
        return this.x;
    }

    public final int component5() {
        return this.y;
    }

    @NotNull
    public final Dimension component6() {
        return this.scaledSize;
    }

    @NotNull
    public final LayoutData copy(double scale, @Nullable String modelName, @Nullable String modelTooltip, int x, int y, @NotNull Dimension scaledSize) {
        Intrinsics.checkNotNullParameter((Object)scaledSize, (String)"scaledSize");
        return new LayoutData(scale, modelName, modelTooltip, x, y, scaledSize);
    }

    public static /* synthetic */ LayoutData copy$default(LayoutData layoutData, double d, String string2, String string3, int n, int n2, Dimension dimension, int n3, Object object) {
        if ((n3 & 1) != 0) {
            d = layoutData.scale;
        }
        if ((n3 & 2) != 0) {
            string2 = layoutData.modelName;
        }
        if ((n3 & 4) != 0) {
            string3 = layoutData.modelTooltip;
        }
        if ((n3 & 8) != 0) {
            n = layoutData.x;
        }
        if ((n3 & 0x10) != 0) {
            n2 = layoutData.y;
        }
        if ((n3 & 0x20) != 0) {
            dimension = layoutData.scaledSize;
        }
        return layoutData.copy(d, string2, string3, n, n2, dimension);
    }

    @NotNull
    public String toString() {
        return "LayoutData(scale=" + this.scale + ", modelName=" + this.modelName + ", modelTooltip=" + this.modelTooltip + ", x=" + this.x + ", y=" + this.y + ", scaledSize=" + this.scaledSize + ")";
    }

    public int hashCode() {
        String string2 = this.modelName;
        String string3 = this.modelTooltip;
        Dimension dimension = this.scaledSize;
        return ((((Double.hashCode(this.scale) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + Integer.hashCode(this.x)) * 31 + Integer.hashCode(this.y)) * 31 + (dimension != null ? ((Object)dimension).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LayoutData)) break block3;
                LayoutData layoutData = (LayoutData)object;
                if (Double.compare(this.scale, layoutData.scale) != 0 || !Intrinsics.areEqual((Object)this.modelName, (Object)layoutData.modelName) || !Intrinsics.areEqual((Object)this.modelTooltip, (Object)layoutData.modelTooltip) || this.x != layoutData.x || this.y != layoutData.y || !Intrinsics.areEqual((Object)this.scaledSize, (Object)layoutData.scaledSize)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/common/surface/LayoutData$Companion;", "", "()V", "fromSceneView", "Lcom/android/tools/idea/common/surface/LayoutData;", "sceneView", "Lcom/android/tools/idea/common/surface/SceneView;", "intellij.android.designer"})
    public static final class Companion {
        @NotNull
        public final LayoutData fromSceneView(@NotNull SceneView sceneView) {
            Intrinsics.checkNotNullParameter((Object)sceneView, (String)"sceneView");
            double d = sceneView.getScale();
            Scene scene = sceneView.getScene();
            Intrinsics.checkNotNullExpressionValue((Object)scene, (String)"sceneView.scene");
            SceneManager sceneManager = scene.getSceneManager();
            Intrinsics.checkNotNullExpressionValue((Object)sceneManager, (String)"sceneView.scene.sceneManager");
            NlModel nlModel = sceneManager.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"sceneView.scene.sceneManager.model");
            String string2 = nlModel.getModelDisplayName();
            Scene scene2 = sceneView.getScene();
            Intrinsics.checkNotNullExpressionValue((Object)scene2, (String)"sceneView.scene");
            SceneManager sceneManager2 = scene2.getSceneManager();
            Intrinsics.checkNotNullExpressionValue((Object)sceneManager2, (String)"sceneView.scene.sceneManager");
            NlModel nlModel2 = sceneManager2.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)nlModel2, (String)"sceneView.scene.sceneManager.model");
            String string3 = nlModel2.getModelTooltip();
            int n = sceneView.getX();
            int n2 = sceneView.getY();
            Dimension dimension = sceneView.getContentSize(null);
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"sceneView.getContentSize(null)");
            return new LayoutData(d, string2, string3, n, n2, ScaleKt.scaleBy(dimension, sceneView.getScale()), null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

