/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DesignSurfaceActionHandler
implements DeleteProvider,
CutProvider,
CopyProvider,
PasteProvider {
    protected final DesignSurface mySurface;
    private final CopyPasteManager myCopyPasteManager;

    public DesignSurfaceActionHandler(@NotNull DesignSurface surface2) {
        if (surface2 == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(0);
        }
        this(surface2, CopyPasteManager.getInstance());
    }

    protected DesignSurfaceActionHandler(@NotNull DesignSurface surface2, @NotNull CopyPasteManager copyPasteManager) {
        if (surface2 == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(1);
        }
        if (copyPasteManager == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(2);
        }
        this.mySurface = surface2;
        this.myCopyPasteManager = copyPasteManager;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    @NotNull
    protected abstract DataFlavor getFlavor();

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(4);
        }
        if (!this.mySurface.getSelectionModel().isEmpty()) {
            this.myCopyPasteManager.setContents((Transferable)this.mySurface.getSelectionAsTransferable());
        }
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(5);
        }
        return this.hasNonEmptySelection();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(6);
        }
        return true;
    }

    public void performCut(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(7);
        }
        if (!this.mySurface.getSelectionModel().isEmpty()) {
            ItemTransferable transferable = this.mySurface.getSelectionAsTransferable();
            try {
                DnDTransferItem transferItem = (DnDTransferItem)transferable.getTransferData(this.getFlavor());
                transferItem.setIsCut();
                this.myCopyPasteManager.setContents((Transferable)transferable);
            }
            catch (UnsupportedFlavorException e) {
                this.performCopy(dataContext);
            }
            this.deleteElement(dataContext);
        }
    }

    public boolean isCutEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(8);
        }
        return this.hasNonEmptySelection();
    }

    public boolean isCutVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(9);
        }
        return true;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        NlModel model2;
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(10);
        }
        if ((model2 = this.mySurface.getModel()) == null) {
            return;
        }
        SelectionModel selectionModel = this.mySurface.getSelectionModel();
        model2.delete(selectionModel.getSelection());
        selectionModel.clear();
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(11);
        }
        return this.hasNonEmptySelection();
    }

    @Nullable
    @VisibleForTesting
    public abstract NlComponent getPasteTarget();

    @VisibleForTesting
    public abstract boolean canHandleChildren(@NotNull NlComponent var1, @NotNull List<NlComponent> var2);

    public void performPaste(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(12);
        }
        this.pasteOperation(false);
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(13);
        }
        return this.getPasteTarget() != null && this.getClipboardData() != null;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(14);
        }
        return this.pasteOperation(true);
    }

    private boolean hasNonEmptySelection() {
        return !this.mySurface.getSelectionModel().isEmpty();
    }

    private boolean pasteOperation(boolean checkOnly) {
        NlComponent receiver = this.getPasteTarget();
        if (receiver == null) {
            return false;
        }
        NlModel model2 = receiver.getModel();
        DnDTransferItem transferItem = this.getClipboardData();
        if (transferItem == null) {
            return false;
        }
        DragType dragType = transferItem.isCut() ? DragType.MOVE : DragType.PASTE;
        InsertType insertType = model2.determineInsertType(dragType, transferItem, checkOnly);
        List<NlComponent> pasted = model2.createComponents(transferItem, insertType, this.mySurface);
        NlComponent before = null;
        if (this.canHandleChildren(receiver, pasted)) {
            before = receiver.getChild(0);
        } else {
            while (!this.canHandleChildren(receiver, pasted)) {
                before = receiver.getNextSibling();
                if ((receiver = receiver.getParent()) != null) continue;
                return false;
            }
        }
        if (!model2.canAddComponents(pasted, receiver, before, checkOnly)) {
            return false;
        }
        if (checkOnly) {
            return true;
        }
        transferItem.consumeCut();
        model2.addComponents(pasted, receiver, before, insertType, this.mySurface);
        if (insertType == InsertType.PASTE) {
            this.mySurface.getSelectionModel().setSelection(pasted);
        }
        return true;
    }

    @Nullable
    private DnDTransferItem getClipboardData() {
        CopyPasteManager instance = CopyPasteManager.getInstance();
        Transferable contents = instance.getContents();
        if (contents == null) {
            return null;
        }
        try {
            return (DnDTransferItem)contents.getTransferData(this.getFlavor());
        }
        catch (UnsupportedFlavorException | IOException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyPasteManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/surface/DesignSurfaceActionHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/surface/DesignSurfaceActionHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCopyEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCopyVisible";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "performCut";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isCutEnabled";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isCutVisible";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performPaste";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isPastePossible";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isPasteEnabled";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

