/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.Pannable;
import com.android.tools.adtui.PannableKt;
import com.android.tools.adtui.Zoomable;
import com.android.tools.adtui.ZoomableKt;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.editor.PanZoomListener;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.common.analytics.DesignerAnalyticsManager;
import com.android.tools.idea.common.editor.ActionManager;
import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.error.IssuePanel;
import com.android.tools.idea.common.error.LintIssueProvider;
import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.DefaultSelectionModel;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SecondarySelectionModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurfaceActionHandler;
import com.android.tools.idea.common.surface.DesignSurfaceIssueListenerImpl;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.DesignSurfaceScrollPane;
import com.android.tools.idea.common.surface.DesignSurfaceSettings;
import com.android.tools.idea.common.surface.InteractionHandler;
import com.android.tools.idea.common.surface.InteractionManager;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.LayoutScannerControl;
import com.android.tools.idea.common.surface.MouseClickDisplayPanel;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.SceneViewPanel;
import com.android.tools.idea.common.surface.SurfaceState;
import com.android.tools.idea.common.surface.layout.DesignSurfaceViewport;
import com.android.tools.idea.common.surface.layout.MatchParentLayoutManager;
import com.android.tools.idea.common.surface.layout.NonScrollableDesignSurfaceViewport;
import com.android.tools.idea.common.surface.layout.ScrollableDesignSurfaceViewport;
import com.android.tools.idea.common.type.DefaultDesignerFileType;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.idea.uibuilder.surface.layout.PositionableContent;
import com.android.tools.idea.uibuilder.surface.layout.PositionableContentLayoutManager;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.components.ZoomableViewport;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import kotlin.jvm.functions.Function0;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class DesignSurface
extends EditorDesignSurface
implements Disposable,
DataProvider,
Zoomable,
Pannable,
ZoomableViewport {
    protected static final double SCALING_THRESHOLD = 0.005;
    private static final Predicate<NlModel> FILTER_DISPOSED_MODELS = input -> input != null && !input.getModule().isDisposed();
    private static final Predicate<SceneManager> FILTER_DISPOSED_SCENE_MANAGERS = input -> input != null && FILTER_DISPOSED_MODELS.apply((Object)input.getModel());
    private static final Integer LAYER_PROGRESS = JLayeredPane.POPUP_LAYER + 10;
    private static final Integer LAYER_MOUSE_CLICK = LAYER_PROGRESS + 10;
    private final Project myProject;
    private double myScale;
    private double myMagnificationStartedScale;
    @Nullable
    private final JScrollPane myScrollPane;
    @NotNull
    private final JComponent myContentContainerPane;
    @NotNull
    private final DesignSurfaceViewport myViewport;
    @NotNull
    private final JLayeredPane myLayeredPane;
    @NotNull
    private final SceneViewPanel mySceneViewPanel;
    @NotNull
    private final MouseClickDisplayPanel myMouseClickDisplayPanel;
    private final InteractionManager myInteractionManager;
    private final Object myListenersLock;
    protected final ArrayList<DesignSurfaceListener> myListeners;
    @NotNull
    private ArrayList<PanZoomListener> myZoomListeners;
    private final ActionManager myActionManager;
    @NotNull
    private WeakReference<FileEditor> myFileEditorDelegate;
    private final ReentrantReadWriteLock myModelToSceneManagersLock;
    private final LinkedHashMap<NlModel, SceneManager> myModelToSceneManagers;
    private final SelectionModel mySelectionModel;
    private final ModelListener myModelListener;
    @NotNull
    private final List<CompletableFuture<Void>> myRenderFutures;
    protected final IssueModel myIssueModel;
    private final IssuePanel myIssuePanel;
    private final Object myErrorQueueLock;
    private MergingUpdateQueue myErrorQueue;
    private boolean myIsActive;
    private LintIssueProvider myLintIssueProvider;
    @NotNull
    private final DesignerAnalyticsManager myAnalyticsManager;
    private double myMaxFitIntoScale;
    private boolean myIsInitialZoomLevelDetermined;
    private final Timer myRepaintTimer;
    @NotNull
    private final Function<DesignSurface, DesignSurfaceActionHandler> myActionHandlerProvider;
    @NotNull
    private final ZoomControlsPolicy myZoomControlsPolicy;
    @NotNull
    private final AWTEventListener myOnHoverListener;
    private final Set<ProgressIndicator> myProgressIndicators;
    private final MyProgressPanel myProgressPanel;

    public DesignSurface(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull Function<DesignSurface, ActionManager<? extends DesignSurface>> actionManagerProvider, @NotNull Function<DesignSurface, InteractionHandler> interactionProviderCreator, @NotNull Function<DesignSurface, PositionableContentLayoutManager> positionableLayoutManagerProvider, @NotNull Function<DesignSurface, DesignSurfaceActionHandler> designSurfaceActionHandlerProvider, @NotNull ZoomControlsPolicy zoomControlsPolicy) {
        if (project == null) {
            DesignSurface.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            DesignSurface.$$$reportNull$$$0(1);
        }
        if (actionManagerProvider == null) {
            DesignSurface.$$$reportNull$$$0(2);
        }
        if (interactionProviderCreator == null) {
            DesignSurface.$$$reportNull$$$0(3);
        }
        if (positionableLayoutManagerProvider == null) {
            DesignSurface.$$$reportNull$$$0(4);
        }
        if (designSurfaceActionHandlerProvider == null) {
            DesignSurface.$$$reportNull$$$0(5);
        }
        if (zoomControlsPolicy == null) {
            DesignSurface.$$$reportNull$$$0(6);
        }
        this(project, parentDisposable, actionManagerProvider, interactionProviderCreator, positionableLayoutManagerProvider, designSurfaceActionHandlerProvider, new DefaultSelectionModel(), zoomControlsPolicy);
    }

    public DesignSurface(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull Function<DesignSurface, ActionManager<? extends DesignSurface>> actionManagerProvider, @NotNull Function<DesignSurface, InteractionHandler> interactionProviderCreator, @NotNull Function<DesignSurface, PositionableContentLayoutManager> positionableLayoutManagerProvider, @NotNull Function<DesignSurface, DesignSurfaceActionHandler> actionHandlerProvider, @NotNull SelectionModel selectionModel, @NotNull ZoomControlsPolicy zoomControlsPolicy) {
        if (project == null) {
            DesignSurface.$$$reportNull$$$0(7);
        }
        if (parentDisposable == null) {
            DesignSurface.$$$reportNull$$$0(8);
        }
        if (actionManagerProvider == null) {
            DesignSurface.$$$reportNull$$$0(9);
        }
        if (interactionProviderCreator == null) {
            DesignSurface.$$$reportNull$$$0(10);
        }
        if (positionableLayoutManagerProvider == null) {
            DesignSurface.$$$reportNull$$$0(11);
        }
        if (actionHandlerProvider == null) {
            DesignSurface.$$$reportNull$$$0(12);
        }
        if (selectionModel == null) {
            DesignSurface.$$$reportNull$$$0(13);
        }
        if (zoomControlsPolicy == null) {
            DesignSurface.$$$reportNull$$$0(14);
        }
        super((LayoutManager)new BorderLayout());
        this.myScale = 1.0;
        this.myListenersLock = new Object();
        this.myListeners = new ArrayList();
        this.myZoomListeners = new ArrayList();
        this.myFileEditorDelegate = new WeakReference<Object>(null);
        this.myModelToSceneManagersLock = new ReentrantReadWriteLock();
        this.myModelToSceneManagers = new LinkedHashMap();
        this.myModelListener = new ModelListener(){

            @Override
            public void modelDerivedDataChanged(@NotNull NlModel model2) {
                if (model2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                DesignSurface.this.updateNotifications();
            }

            @Override
            public void modelChanged(@NotNull NlModel model2) {
                if (model2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                DesignSurface.this.updateNotifications();
            }

            @Override
            public void modelChangedOnLayout(@NotNull NlModel model2, boolean animate) {
                if (model2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                DesignSurface.this.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "model";
                objectArray2[1] = "com/android/tools/idea/common/surface/DesignSurface$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modelDerivedDataChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modelChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modelChangedOnLayout";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myRenderFutures = new ArrayList<CompletableFuture<Void>>();
        this.myIssueModel = new IssueModel();
        this.myErrorQueueLock = new Object();
        this.myIsActive = false;
        this.myMaxFitIntoScale = Double.MAX_VALUE;
        this.myIsInitialZoomLevelDetermined = false;
        this.myRepaintTimer = new Timer(15, actionEvent -> this.repaint());
        this.myProgressIndicators = new HashSet<ProgressIndicator>();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myProject = project;
        this.mySelectionModel = selectionModel;
        this.myZoomControlsPolicy = zoomControlsPolicy;
        boolean hasZoomControls = this.myZoomControlsPolicy != ZoomControlsPolicy.HIDDEN;
        this.setOpaque(true);
        this.setFocusable(false);
        this.myAnalyticsManager = new DesignerAnalyticsManager(this);
        this.myActionHandlerProvider = actionHandlerProvider;
        SelectionListener selectionListener = (model2, selection) -> {
            if (this.getFocusedSceneView() != null) {
                this.notifySelectionListeners(selection);
            } else {
                this.notifySelectionListeners(Collections.emptyList());
            }
        };
        this.mySelectionModel.addListener(selectionListener);
        this.myInteractionManager = new InteractionManager(this, interactionProviderCreator.apply(this));
        this.myProgressPanel = new MyProgressPanel();
        this.myProgressPanel.setName("Layout Editor Progress Panel");
        this.mySceneViewPanel = new SceneViewPanel((Function0<? extends Collection<? extends SceneView>>)((Function0)this::getSceneViews), (Function0<? extends Collection<? extends Layer>>)((Function0)() -> this.getInteractionManager().getLayers()), positionableLayoutManagerProvider.apply(this));
        this.mySceneViewPanel.setBackground(this.getBackground());
        this.myScrollPane = hasZoomControls ? DesignSurfaceScrollPane.createDefaultScrollPane(this.mySceneViewPanel, this.getBackground(), this::notifyPanningChanged) : null;
        this.myMouseClickDisplayPanel = new MouseClickDisplayPanel(this);
        this.myLayeredPane = new JLayeredPane();
        this.myLayeredPane.setFocusable(true);
        if (this.myScrollPane != null) {
            this.myLayeredPane.setLayout(new MatchParentLayoutManager());
            this.myLayeredPane.add((Component)this.myScrollPane, JLayeredPane.POPUP_LAYER);
            this.myContentContainerPane = this.myScrollPane;
            this.myViewport = new ScrollableDesignSurfaceViewport(this.myScrollPane.getViewport());
        } else {
            this.myLayeredPane.setLayout(new OverlayLayout(this.myLayeredPane));
            this.mySceneViewPanel.setAlignmentX(0.5f);
            this.myLayeredPane.add((Component)this.mySceneViewPanel, JLayeredPane.POPUP_LAYER);
            this.myContentContainerPane = this.mySceneViewPanel;
            this.myViewport = new NonScrollableDesignSurfaceViewport(this);
        }
        this.myLayeredPane.add((Component)this.myProgressPanel, LAYER_PROGRESS);
        this.myLayeredPane.add((Component)this.myMouseClickDisplayPanel, LAYER_MOUSE_CLICK);
        this.myIssuePanel = new IssuePanel(this.myIssueModel, new DesignSurfaceIssueListenerImpl(this));
        Disposer.register((Disposable)this, (Disposable)this.myIssuePanel);
        this.add(this.myLayeredPane);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (componentEvent.getID() == 101) {
                    if (!DesignSurface.this.myIsInitialZoomLevelDetermined && DesignSurface.this.isShowing() && DesignSurface.this.getWidth() > 0 && DesignSurface.this.getHeight() > 0) {
                        NlModel model2 = (NlModel)Iterables.getFirst(DesignSurface.this.getModels(), null);
                        if (model2 == null) {
                            return;
                        }
                        if (!DesignSurface.this.restorePreviousScale(model2)) {
                            DesignSurface.this.zoomToFit();
                        }
                        DesignSurface.this.myIsInitialZoomLevelDetermined = true;
                    }
                    DesignSurface.this.getSceneManagers().forEach(manager -> {
                        Scene scene = manager.getScene();
                        scene.needsRebuildList();
                    });
                    DesignSurface.this.repaint();
                }
            }
        });
        this.myInteractionManager.startListening();
        this.myActionManager = actionManagerProvider.apply(this);
        this.myActionManager.registerActionsShortcuts(this.myLayeredPane);
        if (hasZoomControls) {
            JPanel zoomControlsLayerPane2 = new JPanel();
            zoomControlsLayerPane2.setBorder(JBUI.Borders.empty((int)UIUtil.getScrollBarWidth()));
            zoomControlsLayerPane2.setOpaque(false);
            zoomControlsLayerPane2.setLayout(new BorderLayout());
            zoomControlsLayerPane2.setFocusable(false);
            this.myOnHoverListener = event -> {
                if (event.getID() == 504 || event.getID() == 505) {
                    zoomControlsLayerPane2.setVisible(SwingUtilities.isDescendingFrom(((MouseEvent)event).getComponent(), (Component)((Object)this)));
                }
            };
            this.myLayeredPane.add((Component)zoomControlsLayerPane2, JLayeredPane.DRAG_LAYER);
            zoomControlsLayerPane2.add((Component)this.myActionManager.createDesignSurfaceToolbar(), "East");
            if (this.myZoomControlsPolicy == ZoomControlsPolicy.AUTO_HIDE) {
                zoomControlsLayerPane2.setVisible(false);
                Toolkit.getDefaultToolkit().addAWTEventListener(this.myOnHoverListener, 16L);
            }
        } else {
            this.myOnHoverListener = event -> {};
        }
    }

    @NotNull
    protected DesignSurfaceViewport getViewport() {
        DesignSurfaceViewport designSurfaceViewport = this.myViewport;
        if (designSurfaceViewport == null) {
            DesignSurface.$$$reportNull$$$0(15);
        }
        return designSurfaceViewport;
    }

    protected void setSurfaceAutoscrolls(boolean enabled) {
        if (this.myScrollPane != null) {
            this.myScrollPane.setAutoscrolls(enabled);
        }
    }

    public double getScreenScalingFactor() {
        return 1.0;
    }

    @NotNull
    protected abstract SceneManager createSceneManager(@NotNull NlModel var1);

    public JPanel getAccessoryPanel() {
        return null;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DesignSurface.$$$reportNull$$$0(16);
        }
        return project;
    }

    @NotNull
    public DesignerEditorFileType getLayoutType() {
        NlModel model2 = this.getModel();
        DesignerEditorFileType designerEditorFileType = model2 == null ? DefaultDesignerFileType.INSTANCE : model2.getType();
        if (designerEditorFileType == null) {
            DesignSurface.$$$reportNull$$$0(17);
        }
        return designerEditorFileType;
    }

    @NotNull
    public ActionManager getActionManager() {
        ActionManager actionManager = this.myActionManager;
        if (actionManager == null) {
            DesignSurface.$$$reportNull$$$0(18);
        }
        return actionManager;
    }

    @NotNull
    public Function<DesignSurface, DesignSurfaceActionHandler> getActionHandlerProvider() {
        Function<DesignSurface, DesignSurfaceActionHandler> function = this.myActionHandlerProvider;
        if (function == null) {
            DesignSurface.$$$reportNull$$$0(19);
        }
        return function;
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        SelectionModel selectionModel = this.mySelectionModel;
        if (selectionModel == null) {
            DesignSurface.$$$reportNull$$$0(20);
        }
        return selectionModel;
    }

    @NotNull
    public SecondarySelectionModel getSecondarySelectionModel() {
        SelectionModel selectionModel = this.mySelectionModel;
        if (selectionModel == null) {
            DesignSurface.$$$reportNull$$$0(21);
        }
        return selectionModel;
    }

    @NotNull
    public abstract ItemTransferable getSelectionAsTransferable();

    @Deprecated
    @Nullable
    public NlModel getModel() {
        return (NlModel)Iterables.getFirst(this.getModels(), null);
    }

    @NotNull
    public ImmutableList<NlModel> getModels() {
        this.myModelToSceneManagersLock.readLock().lock();
        ImmutableList immutableList = ImmutableList.copyOf((Collection)Sets.filter(this.myModelToSceneManagers.keySet(), FILTER_DISPOSED_MODELS));
        ImmutableList immutableList2 = immutableList;
        if (immutableList2 == null) {
            DesignSurface.$$$reportNull$$$0(22);
        }
        return immutableList2;
        finally {
            this.myModelToSceneManagersLock.readLock().unlock();
        }
    }

    @NotNull
    public ImmutableList<SceneManager> getSceneManagers() {
        this.myModelToSceneManagersLock.readLock().lock();
        ImmutableList immutableList = ImmutableList.copyOf((Collection)Collections2.filter(this.myModelToSceneManagers.values(), FILTER_DISPOSED_SCENE_MANAGERS));
        ImmutableList immutableList2 = immutableList;
        if (immutableList2 == null) {
            DesignSurface.$$$reportNull$$$0(23);
        }
        return immutableList2;
        finally {
            this.myModelToSceneManagersLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private SceneManager addModel(@NotNull NlModel model2) {
        SceneManager manager;
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(24);
        }
        if ((manager = this.getSceneManager(model2)) != null) {
            this.myModelToSceneManagersLock.writeLock().lock();
            try {
                SceneManager managerToMove = (SceneManager)this.myModelToSceneManagers.remove(model2);
                if (managerToMove != null) {
                    this.myModelToSceneManagers.put(model2, managerToMove);
                }
            }
            finally {
                this.myModelToSceneManagersLock.writeLock().unlock();
            }
            SceneManager sceneManager = manager;
            if (sceneManager == null) {
                DesignSurface.$$$reportNull$$$0(25);
            }
            return sceneManager;
        }
        model2.addListener(this.myModelListener);
        manager = this.createSceneManager(model2);
        this.myModelToSceneManagersLock.writeLock().lock();
        try {
            this.myModelToSceneManagers.put(model2, manager);
        }
        finally {
            this.myModelToSceneManagersLock.writeLock().unlock();
        }
        this.mySceneViewPanel.invalidate();
        if (this.myIsActive) {
            manager.activate((Object)this);
        }
        SceneManager sceneManager = manager;
        if (sceneManager == null) {
            DesignSurface.$$$reportNull$$$0(26);
        }
        return sceneManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private ImmutableList<DesignSurfaceListener> getListeners() {
        Object object = this.myListenersLock;
        // MONITORENTER : object
        ImmutableList immutableList = ImmutableList.copyOf(this.myListeners);
        // MONITOREXIT : object
        if (immutableList != null) return immutableList;
        DesignSurface.$$$reportNull$$$0(27);
        return immutableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private ImmutableList<PanZoomListener> getZoomListeners() {
        Object object = this.myListenersLock;
        // MONITORENTER : object
        ImmutableList immutableList = ImmutableList.copyOf(this.myZoomListeners);
        // MONITOREXIT : object
        if (immutableList != null) return immutableList;
        DesignSurface.$$$reportNull$$$0(28);
        return immutableList;
    }

    @NotNull
    public final CompletableFuture<Void> addAndRenderModel(@NotNull NlModel model2) {
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(29);
        }
        SceneManager modelSceneManager = this.addModel(model2);
        CompletionStage completionStage = modelSceneManager.requestRenderAsync().whenCompleteAsync((result, ex) -> {
            this.reactivateInteractionManager();
            this.revalidateScrollArea();
            for (DesignSurfaceListener listener2 : this.getListeners()) {
                listener2.modelChanged(this, model2);
            }
        }, (Executor)EdtExecutorService.getInstance());
        if (completionStage == null) {
            DesignSurface.$$$reportNull$$$0(30);
        }
        return completionStage;
    }

    @NotNull
    public final SceneManager addModelWithoutRender(@NotNull NlModel model2) {
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(31);
        }
        SceneManager manager = this.addModel(model2);
        EdtExecutorService.getInstance().execute(() -> {
            for (DesignSurfaceListener listener2 : this.getListeners()) {
                listener2.modelChanged(this, model2);
            }
        });
        this.reactivateInteractionManager();
        SceneManager sceneManager = manager;
        if (sceneManager == null) {
            DesignSurface.$$$reportNull$$$0(32);
        }
        return sceneManager;
    }

    private boolean removeModelImpl(@NotNull NlModel model2) {
        SceneManager manager;
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(33);
        }
        this.myModelToSceneManagersLock.writeLock().lock();
        try {
            manager = (SceneManager)this.myModelToSceneManagers.remove(model2);
        }
        finally {
            this.myModelToSceneManagersLock.writeLock().unlock();
        }
        this.mySceneViewPanel.invalidate();
        if (manager == null) {
            return false;
        }
        model2.deactivate((Object)this);
        model2.removeListener(this.myModelListener);
        Disposer.dispose((Disposable)manager);
        UIUtil.invokeLaterIfNeeded(() -> this.revalidateScrollArea());
        return true;
    }

    public void removeModel(@NotNull NlModel model2) {
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(34);
        }
        if (!this.removeModelImpl(model2)) {
            return;
        }
        this.reactivateInteractionManager();
    }

    public CompletableFuture<Void> setModel(@Nullable NlModel model2) {
        NlModel oldModel = this.getModel();
        if (model2 == oldModel) {
            return CompletableFuture.completedFuture(null);
        }
        if (oldModel != null) {
            this.removeModelImpl(oldModel);
        }
        if (model2 == null) {
            return CompletableFuture.completedFuture(null);
        }
        this.addModel(model2);
        return this.requestRender().whenCompleteAsync((result, ex) -> {
            this.reactivateInteractionManager();
            if (!this.restorePreviousScale(model2)) {
                this.zoomToFit();
            }
            this.revalidateScrollArea();
            for (DesignSurfaceListener listener2 : this.getListeners()) {
                listener2.modelChanged(this, model2);
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    private void reactivateInteractionManager() {
        if (this.isEditable()) {
            this.myInteractionManager.startListening();
        } else {
            this.myInteractionManager.stopListening();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List<CompletableFuture<Void>> list = this.myListenersLock;
        synchronized (list) {
            this.myListeners.clear();
            this.myZoomListeners.clear();
        }
        this.myInteractionManager.stopListening();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.myOnHoverListener);
        list = this.myRenderFutures;
        synchronized (list) {
            for (CompletableFuture<Void> future2 : this.myRenderFutures) {
                try {
                    future2.cancel(true);
                }
                catch (CancellationException cancellationException) {}
            }
            this.myRenderFutures.clear();
        }
        if (this.myRepaintTimer.isRunning()) {
            this.myRepaintTimer.stop();
        }
        this.getModels().forEach(this::removeModelImpl);
    }

    @UiThread
    public void validateScrollArea() {
        this.mySceneViewPanel.invalidate();
        this.myContentContainerPane.invalidate();
        this.myContentContainerPane.validate();
        this.mySceneViewPanel.repaint();
    }

    @UiThread
    public void revalidateScrollArea() {
        this.mySceneViewPanel.invalidate();
        this.myContentContainerPane.revalidate();
        this.mySceneViewPanel.repaint();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.getInteractionPane();
    }

    public void needsRepaint() {
        if (!this.myRepaintTimer.isRunning()) {
            this.myRepaintTimer.setRepeats(false);
            this.myRepaintTimer.start();
        }
    }

    @Nullable
    public SceneView getFocusedSceneView() {
        NlComponent primary;
        SceneManager manager;
        ImmutableList<SceneManager> managers = this.getSceneManagers();
        if (managers.size() == 1) {
            SceneManager manager2 = this.getSceneManager();
            assert (manager2 != null);
            return (SceneView)Iterables.getFirst(manager2.getSceneViews(), null);
        }
        List<NlComponent> selection = this.mySelectionModel.getSelection();
        if (!selection.isEmpty() && (manager = this.getSceneManager((primary = selection.get(0)).getModel())) != null) {
            return (SceneView)Iterables.getFirst(manager.getSceneViews(), null);
        }
        return null;
    }

    @NotNull
    protected ImmutableCollection<SceneView> getSceneViews() {
        ImmutableCollection immutableCollection = (ImmutableCollection)this.getSceneManagers().stream().flatMap(sceneManager -> sceneManager.getSceneViews().stream()).collect(ImmutableList.toImmutableList());
        if (immutableCollection == null) {
            DesignSurface.$$$reportNull$$$0(35);
        }
        return immutableCollection;
    }

    public void startDragDropInteraction() {
        for (SceneView sceneView : this.getSceneViews()) {
            sceneView.onDragStart();
        }
        this.repaint();
    }

    public void stopDragDropInteraction() {
        for (SceneView sceneView : this.getSceneViews()) {
            sceneView.onDragEnd();
        }
        this.repaint();
    }

    @UiThread
    public final boolean zoom(@NotNull ZoomType type) {
        if (type == null) {
            DesignSurface.$$$reportNull$$$0(36);
        }
        return this.zoom(type, -1, -1);
    }

    @Nullable
    public Magnificator getMagnificator() {
        if (!this.getSupportPinchAndZoom()) {
            return null;
        }
        return (scale, at) -> null;
    }

    public void magnificationStarted(Point at) {
        this.myMagnificationStartedScale = this.getScale();
    }

    public void magnificationFinished(double magnification) {
    }

    public void magnify(double magnification) {
        Point mouse;
        if (Double.compare(magnification, 0.0) == 0) {
            return;
        }
        if (!GraphicsEnvironment.isHeadless()) {
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            if (pointerInfo == null) {
                return;
            }
            mouse = pointerInfo.getLocation();
            SwingUtilities.convertPointFromScreen(mouse, this.getViewport().getViewportComponent());
        } else {
            mouse = new Point(this.getWidth() / 2, this.getHeight() / 2);
        }
        double sensitivity = AndroidEditorSettings.getInstance().getGlobalState().getMagnifySensitivity();
        double newScale = this.myMagnificationStartedScale + magnification * sensitivity;
        this.setScale(newScale, mouse.x, mouse.y);
    }

    public void setPanning(boolean isPanning) {
        this.myInteractionManager.setPanning(isPanning);
    }

    @UiThread
    public boolean zoom(@NotNull ZoomType type, int x, int y) {
        boolean scaled;
        SceneComponent component;
        Scene scene;
        if (type == null) {
            DesignSurface.$$$reportNull$$$0(37);
        }
        this.getAnalyticsManager().trackZoom(type);
        SceneView view = this.getFocusedSceneView();
        if (!(type != ZoomType.IN || x >= 0 && y >= 0 || view == null || this.getSelectionModel().isEmpty() || (scene = this.getScene()) == null || (component = scene.getSceneComponent(this.getSelectionModel().getPrimary())) == null)) {
            x = Coordinates.getSwingXDip(view, component.getCenterX());
            y = Coordinates.getSwingYDip(view, component.getCenterY());
        }
        switch (type) {
            case IN: {
                double currentScale = this.myScale * this.getScreenScalingFactor();
                int current = (int)Math.round(currentScale * 100.0);
                double scale = (double)ZoomType.zoomIn((int)current) / 100.0 / this.getScreenScalingFactor();
                scaled = this.setScale(scale, x, y);
                break;
            }
            case OUT: {
                double currentScale = this.myScale * this.getScreenScalingFactor();
                int current = (int)(currentScale * 100.0);
                double scale = (double)ZoomType.zoomOut((int)current) / 100.0 / this.getScreenScalingFactor();
                scaled = this.setScale(scale, x, y);
                break;
            }
            case ACTUAL: {
                scaled = this.setScale(1.0 / this.getScreenScalingFactor());
                break;
            }
            case FIT: 
            case FIT_INTO: {
                scaled = this.setScale(this.getFitScale(type == ZoomType.FIT_INTO));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not yet implemented: " + type);
            }
        }
        return scaled;
    }

    public double getFitScale(boolean fitInto) {
        int availableWidth = this.getExtentSize().width;
        int availableHeight = this.getExtentSize().height;
        return this.getFitScale(this.getPreferredContentSize(availableWidth, availableHeight), fitInto);
    }

    protected double getFitScale(Dimension size, boolean fitInto) {
        int availableWidth = this.getExtentSize().width;
        int availableHeight = this.getExtentSize().height;
        Dimension padding = this.getDefaultOffset();
        double scaleX = size.width == 0 ? 1.0 : (double)(availableWidth -= padding.width) / (double)size.width;
        double scaleY = size.height == 0 ? 1.0 : (double)(availableHeight -= padding.height) / (double)size.height;
        double scale = Math.min(scaleX, scaleY);
        if (fitInto) {
            double min = 1.0 / this.getScreenScalingFactor();
            scale = Math.min(min, scale);
        }
        scale = Math.min(scale, this.myMaxFitIntoScale);
        return scale;
    }

    protected abstract Dimension getDefaultOffset();

    @NotNull
    protected abstract Dimension getPreferredContentSize(int var1, int var2);

    @UiThread
    public final boolean zoomToFit() {
        return this.zoom(ZoomType.FIT, -1, -1);
    }

    public double getScale() {
        return this.myScale;
    }

    public boolean isPanning() {
        return this.myInteractionManager.isPanning();
    }

    public boolean isPannable() {
        return true;
    }

    public boolean canZoomIn() {
        return this.getScale() < this.getMaxScale();
    }

    public boolean canZoomOut() {
        return this.getScale() > this.getMinScale();
    }

    public abstract boolean canZoomToFit();

    public boolean canZoomToActual() {
        double currentScale = this.getScale();
        return currentScale > 1.0 && this.canZoomOut() || currentScale < 1.0 && this.canZoomIn();
    }

    public abstract void scrollToCenter(@NotNull List<NlComponent> var1);

    public final void scrollToVisible(@NotNull SceneView sceneView, boolean forceScroll) {
        Rectangle rectangle;
        if (sceneView == null) {
            DesignSurface.$$$reportNull$$$0(38);
        }
        if ((rectangle = this.mySceneViewPanel.findSceneViewRectangle(sceneView)) != null && (forceScroll || !this.getViewport().getViewRect().intersects(rectangle))) {
            Dimension defaultOffset = this.getDefaultOffset();
            this.setScrollPosition(rectangle.x - defaultOffset.width, rectangle.y - defaultOffset.height);
        }
    }

    public final void scrollToVisible(@NotNull NlModel model2, boolean forceScroll) {
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(39);
        }
        this.getSceneViews().stream().filter(sceneView -> sceneView.getSceneManager().getModel() == model2).findFirst().ifPresent(sceneView -> this.scrollToVisible((SceneView)sceneView, forceScroll));
    }

    public void setScrollPosition(int x, int y) {
        this.setScrollPosition(new Point(x, y));
    }

    public void setScrollPosition(Point p) {
        p.setLocation(Math.max(0, p.x), Math.max(0, p.y));
        Dimension extent = this.getExtentSize();
        Dimension view = this.getViewSize();
        int minX = Math.min(p.x, view.width - extent.width);
        int minY = Math.min(p.y, view.height - extent.height);
        p.setLocation(minX, minY);
        this.getViewport().setViewPosition(p);
    }

    public Point getScrollPosition() {
        return this.getViewport().getViewPosition();
    }

    @NotNull
    public Dimension getExtentSize() {
        Dimension dimension = this.getViewport().getExtentSize();
        if (dimension == null) {
            DesignSurface.$$$reportNull$$$0(40);
        }
        return dimension;
    }

    @NotNull
    public Dimension getViewSize() {
        Dimension dimension = this.getViewport().getViewSize();
        if (dimension == null) {
            DesignSurface.$$$reportNull$$$0(41);
        }
        return dimension;
    }

    public boolean setScale(double scale) {
        return this.setScale(scale, -1, -1);
    }

    public boolean setScale(double scale, int x, int y) {
        double newScale = Math.min(Math.max(scale, this.getMinScale()), this.getMaxScale());
        if (Math.abs(newScale - this.myScale) < 0.005 / this.getScreenScalingFactor()) {
            return false;
        }
        double previousScale = this.myScale;
        this.myScale = newScale;
        NlModel model2 = (NlModel)Iterables.getFirst(this.getModels(), null);
        if (model2 != null) {
            this.storeCurrentScale(model2);
        }
        this.revalidateScrollArea();
        this.notifyScaleChanged(previousScale, this.myScale);
        return true;
    }

    protected boolean isKeepingScaleWhenReopen() {
        return true;
    }

    private void storeCurrentScale(@NotNull NlModel model2) {
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(42);
        }
        if (!this.isKeepingScaleWhenReopen()) {
            return;
        }
        SurfaceState state = DesignSurfaceSettings.getInstance(model2.getProject()).getSurfaceState();
        state.saveFileScale((PsiFile)model2.getFile(), this.myScale);
    }

    private boolean restorePreviousScale(@NotNull NlModel model2) {
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(43);
        }
        if (!this.isKeepingScaleWhenReopen()) {
            return false;
        }
        SurfaceState state = DesignSurfaceSettings.getInstance(model2.getProject()).getSurfaceState();
        Double previousScale = state.loadFileScale((PsiFile)model2.getFile());
        if (previousScale != null) {
            this.setScale(previousScale);
            return true;
        }
        return false;
    }

    protected double getMinScale() {
        return 0.0;
    }

    protected double getMaxScale() {
        return 1.0;
    }

    private void notifyScaleChanged(double previousScale, double newScale) {
        for (PanZoomListener myZoomListener : this.getZoomListeners()) {
            myZoomListener.zoomChanged(previousScale, newScale);
        }
    }

    private void notifyPanningChanged(AdjustmentEvent adjustmentEvent) {
        for (PanZoomListener myZoomListener : this.getZoomListeners()) {
            myZoomListener.panningChanged(adjustmentEvent);
        }
    }

    @NotNull
    public JComponent getLayeredPane() {
        JLayeredPane jLayeredPane = this.myLayeredPane;
        if (jLayeredPane == null) {
            DesignSurface.$$$reportNull$$$0(44);
        }
        return jLayeredPane;
    }

    @NotNull
    public JComponent getInteractionPane() {
        SceneViewPanel sceneViewPanel = this.mySceneViewPanel;
        if (sceneViewPanel == null) {
            DesignSurface.$$$reportNull$$$0(45);
        }
        return sceneViewPanel;
    }

    @NotNull
    public DesignerAnalyticsManager getAnalyticsManager() {
        DesignerAnalyticsManager designerAnalyticsManager = this.myAnalyticsManager;
        if (designerAnalyticsManager == null) {
            DesignSurface.$$$reportNull$$$0(46);
        }
        return designerAnalyticsManager;
    }

    @Nullable
    public LayoutScannerControl getLayoutScannerControl() {
        return null;
    }

    protected void notifySelectionListeners(@NotNull List<NlComponent> newSelection) {
        if (newSelection == null) {
            DesignSurface.$$$reportNull$$$0(47);
        }
        ArrayList listeners = Lists.newArrayList(this.myListeners);
        for (DesignSurfaceListener listener2 : listeners) {
            listener2.componentSelectionChanged(this, newSelection);
        }
    }

    public void notifyComponentActivate(@NotNull NlComponent component, int x, int y) {
        if (component == null) {
            DesignSurface.$$$reportNull$$$0(48);
        }
        this.notifyComponentActivate(component);
    }

    public void notifyComponentActivate(@NotNull NlComponent component) {
        if (component == null) {
            DesignSurface.$$$reportNull$$$0(49);
        }
        this.activatePreferredEditor(component);
    }

    protected void activatePreferredEditor(@NotNull NlComponent component) {
        DesignSurfaceListener listener2;
        if (component == null) {
            DesignSurface.$$$reportNull$$$0(50);
        }
        UnmodifiableIterator unmodifiableIterator = this.getListeners().iterator();
        while (unmodifiableIterator.hasNext() && !(listener2 = (DesignSurfaceListener)unmodifiableIterator.next()).activatePreferredEditor(this, component)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull DesignSurfaceListener listener2) {
        if (listener2 == null) {
            DesignSurface.$$$reportNull$$$0(51);
        }
        Object object = this.myListenersLock;
        synchronized (object) {
            this.myListeners.remove(listener2);
            this.myListeners.add(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NotNull DesignSurfaceListener listener2) {
        if (listener2 == null) {
            DesignSurface.$$$reportNull$$$0(52);
        }
        Object object = this.myListenersLock;
        synchronized (object) {
            this.myListeners.remove(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPanZoomListener(PanZoomListener listener2) {
        Object object = this.myListenersLock;
        synchronized (object) {
            this.myZoomListeners.remove(listener2);
            this.myZoomListeners.add(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePanZoomListener(PanZoomListener listener2) {
        Object object = this.myListenersLock;
        synchronized (object) {
            this.myZoomListeners.remove(listener2);
        }
    }

    public void activate() {
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        if (!this.myIsActive) {
            for (SceneManager manager : this.getSceneManagers()) {
                manager.activate((Object)this);
            }
            if (this.myZoomControlsPolicy == ZoomControlsPolicy.AUTO_HIDE) {
                Toolkit.getDefaultToolkit().addAWTEventListener(this.myOnHoverListener, 16L);
            }
        }
        this.myIsActive = true;
    }

    public void deactivate() {
        if (this.myIsActive) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.myOnHoverListener);
            for (SceneManager manager : this.getSceneManagers()) {
                manager.deactivate((Object)this);
            }
        }
        this.myIsActive = false;
        this.myInteractionManager.cancelInteraction();
    }

    public void setFileEditorDelegate(@Nullable FileEditor fileEditor) {
        this.myFileEditorDelegate = new WeakReference<FileEditor>(fileEditor);
    }

    @Nullable
    public FileEditor getFileEditorDelegate() {
        return (FileEditor)this.myFileEditorDelegate.get();
    }

    @Deprecated
    @Nullable
    public SceneView getSceneViewAtOrPrimary(int x, int y) {
        SceneManager manager;
        SceneView view = this.getSceneViewAt(x, y);
        if (view == null && (manager = this.getSceneManager()) != null) {
            view = manager.getSceneView();
        }
        return view;
    }

    @Nullable
    public SceneView getSceneViewAt(int x, int y) {
        ImmutableCollection<SceneView> sceneViews = this.getSceneViews();
        Dimension scaledSize = new Dimension();
        for (SceneView view : sceneViews) {
            view.getScaledContentSize(scaledSize);
            if (view.getX() > x || x > view.getX() + scaledSize.width || view.getY() > y || y > view.getY() + scaledSize.height) continue;
            return view;
        }
        return null;
    }

    @Nullable
    public SceneView getSceneViewAtMousePosition() {
        Point mouseLocation;
        Point point = mouseLocation = !GraphicsEnvironment.isHeadless() ? MouseInfo.getPointerInfo().getLocation() : null;
        if (mouseLocation == null || this.contains(mouseLocation) || !this.isVisible() || !this.isEnabled()) {
            return null;
        }
        SwingUtilities.convertPointFromScreen(mouseLocation, (Component)((Object)this));
        return this.getSceneViewAt(mouseLocation.x, mouseLocation.y);
    }

    @Deprecated
    @Nullable
    public Scene getScene() {
        SceneManager sceneManager = this.getSceneManager();
        return sceneManager != null ? sceneManager.getScene() : null;
    }

    @Nullable
    public SceneManager getSceneManager() {
        NlModel model2 = this.getModel();
        return model2 != null ? this.getSceneManager(model2) : null;
    }

    @Nullable
    public SceneManager getSceneManager(@NotNull NlModel model2) {
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(53);
        }
        if (model2.getModule().isDisposed()) {
            return null;
        }
        this.myModelToSceneManagersLock.readLock().lock();
        try {
            SceneManager sceneManager = this.myModelToSceneManagers.get(model2);
            return sceneManager;
        }
        finally {
            this.myModelToSceneManagersLock.readLock().unlock();
        }
    }

    public CompletableFuture<?> goingToSetModel(NlModel model2) {
        return CompletableFuture.completedFuture(null);
    }

    @NotNull
    public InteractionManager getInteractionManager() {
        InteractionManager interactionManager = this.myInteractionManager;
        if (interactionManager == null) {
            DesignSurface.$$$reportNull$$$0(54);
        }
        return interactionManager;
    }

    protected boolean getSupportPinchAndZoom() {
        return true;
    }

    public boolean isEditable() {
        return this.getLayoutType().isEditable();
    }

    @NotNull
    protected Collection<PositionableContent> getPositionableContent() {
        Collection<PositionableContent> collection = this.mySceneViewPanel.getPositionableContent();
        if (collection == null) {
            DesignSurface.$$$reportNull$$$0(55);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            DesignSurface.$$$reportNull$$$0(56);
        }
        if (this.myProject.isDisposed() || Disposer.isDisposed((Disposable)this)) {
            return;
        }
        Set<ProgressIndicator> set = this.myProgressIndicators;
        synchronized (set) {
            if (this.myProgressIndicators.add(indicator)) {
                this.myProgressPanel.showProgressIcon();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            DesignSurface.$$$reportNull$$$0(57);
        }
        Set<ProgressIndicator> set = this.myProgressIndicators;
        synchronized (set) {
            this.myProgressIndicators.remove(indicator);
            if (this.myProgressIndicators.isEmpty()) {
                this.myProgressPanel.hideProgressIcon();
            }
        }
    }

    protected boolean useSmallProgressIcon() {
        return true;
    }

    @NotNull
    public CompletableFuture<Void> requestRender() {
        ImmutableList<SceneManager> managers = this.getSceneManagers();
        if (managers.isEmpty()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                DesignSurface.$$$reportNull$$$0(58);
            }
            return completableFuture;
        }
        CompletableFuture<Void> completableFuture = this.requestSequentialRender(manager -> manager.requestLayoutAndRenderAsync(false));
        if (completableFuture == null) {
            DesignSurface.$$$reportNull$$$0(59);
        }
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected CompletableFuture<Void> requestSequentialRender(@NotNull Function<SceneManager, CompletableFuture<Void>> renderRequest) {
        if (renderRequest == null) {
            DesignSurface.$$$reportNull$$$0(60);
        }
        CompletableFuture<Void> callback2 = new CompletableFuture<Void>();
        List<CompletableFuture<Void>> list = this.myRenderFutures;
        synchronized (list) {
            if (!this.myRenderFutures.isEmpty()) {
                this.myRenderFutures.add(callback2);
                CompletableFuture<Void> completableFuture = callback2;
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                if (completableFuture == null) {
                    DesignSurface.$$$reportNull$$$0(61);
                }
                return completableFuture;
            }
            this.myRenderFutures.add(callback2);
        }
        CompletionStage<Object> renderFuture = CompletableFuture.completedFuture(null);
        for (SceneManager manager : this.getSceneManagers()) {
            renderFuture = renderFuture.thenCompose(it -> {
                CompletableFuture future2 = (CompletableFuture)renderRequest.apply(manager);
                this.invalidate();
                return future2;
            });
        }
        renderFuture.thenRun(() -> {
            List<CompletableFuture<Void>> list = this.myRenderFutures;
            synchronized (list) {
                this.myRenderFutures.forEach(future2 -> future2.complete(null));
                this.myRenderFutures.clear();
            }
            this.updateNotifications();
        });
        CompletableFuture<Void> completableFuture = callback2;
        if (completableFuture == null) {
            DesignSurface.$$$reportNull$$$0(62);
        }
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRefreshing() {
        List<CompletableFuture<Void>> list = this.myRenderFutures;
        synchronized (list) {
            return !this.myRenderFutures.isEmpty();
        }
    }

    @TestOnly
    @NotNull
    public Point getCoordinatesOnViewport(@NotNull Point viewCoordinates) {
        if (viewCoordinates == null) {
            DesignSurface.$$$reportNull$$$0(63);
        }
        Point point = SwingUtilities.convertPoint(this.mySceneViewPanel, viewCoordinates.x, viewCoordinates.y, this.getViewport().getViewportComponent());
        if (point == null) {
            DesignSurface.$$$reportNull$$$0(64);
        }
        return point;
    }

    @TestOnly
    public void setScrollViewSizeAndValidate(int width, int height) {
        if (this.myScrollPane != null) {
            this.myScrollPane.setSize(width, height);
            this.myScrollPane.doLayout();
            UIUtil.invokeAndWaitIfNeeded(this::validateScrollArea);
        }
    }

    public void setDesignToolTip(@Nullable String text) {
        this.mySceneViewPanel.setToolTipText(text);
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            DesignSurface.$$$reportNull$$$0(65);
        }
        if (DesignerDataKeys.DESIGN_SURFACE.is(dataId) || ZoomableKt.ZOOMABLE_KEY.is(dataId) || PannableKt.PANNABLE_KEY.is(dataId)) {
            return this;
        }
        if (PlatformCoreDataKeys.FILE_EDITOR.is(dataId)) {
            return this.myFileEditorDelegate.get();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.getActionHandlerProvider().apply(this);
        }
        if (PlatformDataKeys.CONTEXT_MENU_POINT.is(dataId)) {
            SceneView view = this.getFocusedSceneView();
            NlComponent selection = this.getSelectionModel().getPrimary();
            Scene scene = this.getScene();
            if (view == null || scene == null || selection == null) {
                return null;
            }
            SceneComponent sceneComponent = scene.getSceneComponent(selection);
            if (sceneComponent == null) {
                return null;
            }
            return new Point(Coordinates.getSwingXDip(view, sceneComponent.getCenterX()), Coordinates.getSwingYDip(view, sceneComponent.getCenterY()));
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            SelectionModel selectionModel;
            NlComponent primary;
            SceneView view = this.getFocusedSceneView();
            if (view != null && (primary = (selectionModel = view.getSelectionModel()).getPrimary()) != null) {
                return primary.getTagDeprecated();
            }
        } else if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            SceneView view = this.getFocusedSceneView();
            if (view != null) {
                SelectionModel selectionModel = view.getSelectionModel();
                List<NlComponent> selection = selectionModel.getSelection();
                ArrayList list = Lists.newArrayListWithCapacity((int)selection.size());
                for (NlComponent component : selection) {
                    list.add(component.getTagDeprecated());
                }
                return list.toArray(XmlTag.EMPTY);
            }
        } else {
            NlModel model2 = this.getModel();
            if (PlatformCoreDataKeys.MODULE.is(dataId) && model2 != null) {
                return model2.getModule();
            }
        }
        return null;
    }

    public abstract boolean isLayoutDisabled();

    @NotNull
    public ImmutableCollection<Configuration> getConfigurations() {
        ImmutableCollection immutableCollection = (ImmutableCollection)this.getModels().stream().map(NlModel::getConfiguration).collect(ImmutableList.toImmutableList());
        if (immutableCollection == null) {
            DesignSurface.$$$reportNull$$$0(66);
        }
        return immutableCollection;
    }

    @NotNull
    public IssueModel getIssueModel() {
        IssueModel issueModel = this.myIssueModel;
        if (issueModel == null) {
            DesignSurface.$$$reportNull$$$0(67);
        }
        return issueModel;
    }

    public void setLintAnnotationsModel(@NotNull LintAnnotationsModel model2) {
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(68);
        }
        if (this.myLintIssueProvider != null) {
            this.myLintIssueProvider.setLintAnnotationsModel(model2);
        } else {
            this.myLintIssueProvider = new LintIssueProvider(model2);
            this.getIssueModel().addIssueProvider(this.myLintIssueProvider);
        }
    }

    @NotNull
    public IssuePanel getIssuePanel() {
        IssuePanel issuePanel = this.myIssuePanel;
        if (issuePanel == null) {
            DesignSurface.$$$reportNull$$$0(69);
        }
        return issuePanel;
    }

    public void setShowIssuePanel(boolean show2, boolean userInvoked) {
        if (((Boolean)StudioFlags.NELE_SHOW_ISSUE_PANEL_IN_PROBLEMS.get()).booleanValue()) {
            Logger.getInstance(DesignSurface.class).error("DesignSurface.setShowIssuePanel() should not be called when showing issue panel in IJ's problems panel");
        } else {
            UIUtil.invokeLaterIfNeeded(() -> {
                this.myIssuePanel.setMinimized(!show2);
                if (userInvoked) {
                    this.myIssuePanel.disableAutoSize();
                }
                this.revalidate();
                this.repaint();
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected MergingUpdateQueue getErrorQueue() {
        Object object = this.myErrorQueueLock;
        // MONITORENTER : object
        if (this.myErrorQueue == null) {
            this.myErrorQueue = new MergingUpdateQueue("android.error.computation", 200, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        }
        MergingUpdateQueue mergingUpdateQueue = this.myErrorQueue;
        // MONITOREXIT : object
        if (mergingUpdateQueue != null) return mergingUpdateQueue;
        DesignSurface.$$$reportNull$$$0(70);
        return mergingUpdateQueue;
    }

    @NotNull
    public ConfigurationManager getConfigurationManager(@NotNull AndroidFacet facet) {
        if (facet == null) {
            DesignSurface.$$$reportNull$$$0(71);
        }
        ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance((AndroidFacet)facet);
        if (configurationManager == null) {
            DesignSurface.$$$reportNull$$$0(72);
        }
        return configurationManager;
    }

    public void updateUI() {
        super.updateUI();
        if (this.myModelToSceneManagers != null) {
            for (SceneManager manager : this.getSceneManagers()) {
                manager.getSceneViews().forEach(SceneView::updateUI);
            }
        }
    }

    @NotNull
    public abstract List<NlComponent> getSelectableComponents();

    public void setMaxFitIntoZoomLevel(double maxFitIntoZoomLevel) {
        this.myMaxFitIntoScale = maxFitIntoZoomLevel / this.getScreenScalingFactor();
    }

    public void enableMouseClickDisplay() {
        this.myMouseClickDisplayPanel.setEnabled(true);
    }

    public void disableMouseClickDisplay() {
        this.myMouseClickDisplayPanel.setEnabled(false);
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.mySceneViewPanel != null) {
            this.mySceneViewPanel.setBackground(bg);
        }
    }

    @NotNull
    public final PositionableContentLayoutManager getSceneViewLayoutManager() {
        PositionableContentLayoutManager positionableContentLayoutManager = (PositionableContentLayoutManager)this.mySceneViewPanel.getLayout();
        if (positionableContentLayoutManager == null) {
            DesignSurface.$$$reportNull$$$0(73);
        }
        return positionableContentLayoutManager;
    }

    public final void setSceneViewAlignment(@NotNull SceneViewAlignment sceneViewAlignment) {
        if (sceneViewAlignment == null) {
            DesignSurface.$$$reportNull$$$0(74);
        }
        this.mySceneViewPanel.setSceneViewAlignment(sceneViewAlignment.mySwingAlignmentXValue);
    }

    protected void updateNotifications() {
        VirtualFile file2;
        FileEditor fileEditor = (FileEditor)this.myFileEditorDelegate.get();
        VirtualFile virtualFile = file2 = fileEditor != null ? fileEditor.getFile() : null;
        if (file2 == null) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> EditorNotifications.getInstance((Project)this.myProject).updateNotifications(file2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: 
            case 73: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: 
            case 73: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManagerProvider";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interactionProviderCreator";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "positionableLayoutManagerProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designSurfaceActionHandlerProvider";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zoomControlsPolicy";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionHandlerProvider";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/surface/DesignSurface";
                break;
            }
            case 24: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 42: 
            case 43: 
            case 53: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneView";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelection";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderRequest";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewCoordinates";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneViewAlignment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/surface/DesignSurface";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewport";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionManager";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionHandlerProvider";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondarySelectionModel";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getModels";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneManagers";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "addModel";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getListeners";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getZoomListeners";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "addAndRenderModel";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "addModelWithoutRender";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneViews";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtentSize";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewSize";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayeredPane";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getInteractionPane";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalyticsManager";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getInteractionManager";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getPositionableContent";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "requestRender";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "requestSequentialRender";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoordinatesOnViewport";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssueModel";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssuePanel";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorQueue";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationManager";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneViewLayoutManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: 
            case 73: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addModel";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addAndRenderModel";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addModelWithoutRender";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "removeModelImpl";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "removeModel";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "zoom";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "scrollToVisible";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "storeCurrentScale";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "restorePreviousScale";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "notifySelectionListeners";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "notifyComponentActivate";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "activatePreferredEditor";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getSceneManager";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "registerIndicator";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "unregisterIndicator";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "requestSequentialRender";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getCoordinatesOnViewport";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "setLintAnnotationsModel";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationManager";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "setSceneViewAlignment";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: 
            case 73: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyProgressPanel
    extends JPanel {
        private AsyncProcessIcon mySmallProgressIcon;
        private AsyncProcessIcon myLargeProgressIcon;
        private boolean mySmall;
        private boolean myProgressVisible;

        private MyProgressPanel() {
            super(new BorderLayout());
            this.setOpaque(false);
            this.setVisible(false);
        }

        private void setSmallIcon(boolean small) {
            if (small != this.mySmall) {
                if (this.myProgressVisible && this.getComponentCount() != 0) {
                    AsyncProcessIcon oldIcon = this.getProgressIcon();
                    oldIcon.suspend();
                }
                this.mySmall = true;
                this.removeAll();
                AsyncProcessIcon icon2 = this.getProgressIcon();
                this.add((Component)icon2, "Center");
                if (this.myProgressVisible) {
                    icon2.setVisible(true);
                    icon2.resume();
                }
            }
        }

        public void showProgressIcon() {
            if (!this.myProgressVisible) {
                this.setSmallIcon(DesignSurface.this.useSmallProgressIcon());
                this.myProgressVisible = true;
                this.setVisible(true);
                AsyncProcessIcon icon2 = this.getProgressIcon();
                if (this.getComponentCount() == 0) {
                    this.add((Component)this.getProgressIcon(), "Center");
                } else {
                    icon2.setVisible(true);
                }
                icon2.resume();
            }
        }

        public void hideProgressIcon() {
            if (this.myProgressVisible) {
                this.myProgressVisible = false;
                this.setVisible(false);
                AsyncProcessIcon icon2 = this.getProgressIcon();
                icon2.setVisible(false);
                icon2.suspend();
            }
        }

        @Override
        public void doLayout() {
            super.doLayout();
            this.setBackground((Color)JBColor.RED);
            if (!this.myProgressVisible) {
                return;
            }
            AsyncProcessIcon icon2 = this.getProgressIcon();
            Dimension size = icon2.getPreferredSize();
            if (this.mySmall) {
                icon2.setBounds(this.getWidth() - size.width - 1, 1, size.width, size.height);
            } else {
                icon2.setBounds(this.getWidth() / 2 - size.width / 2, this.getHeight() / 2 - size.height / 2, size.width, size.height);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getProgressIcon().getPreferredSize();
        }

        @NotNull
        private AsyncProcessIcon getProgressIcon() {
            return this.getProgressIcon(this.mySmall);
        }

        @NotNull
        private AsyncProcessIcon getProgressIcon(boolean small) {
            if (small) {
                if (this.mySmallProgressIcon == null) {
                    this.mySmallProgressIcon = new AsyncProcessIcon("Android layout rendering");
                    Disposer.register((Disposable)DesignSurface.this, (Disposable)this.mySmallProgressIcon);
                }
                AsyncProcessIcon asyncProcessIcon = this.mySmallProgressIcon;
                if (asyncProcessIcon == null) {
                    MyProgressPanel.$$$reportNull$$$0(0);
                }
                return asyncProcessIcon;
            }
            if (this.myLargeProgressIcon == null) {
                this.myLargeProgressIcon = new AsyncProcessIcon.Big("Android layout rendering");
                Disposer.register((Disposable)DesignSurface.this, (Disposable)this.myLargeProgressIcon);
            }
            AsyncProcessIcon asyncProcessIcon = this.myLargeProgressIcon;
            if (asyncProcessIcon == null) {
                MyProgressPanel.$$$reportNull$$$0(1);
            }
            return asyncProcessIcon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/common/surface/DesignSurface$MyProgressPanel", "getProgressIcon"));
        }
    }

    public static enum ZoomControlsPolicy {
        VISIBLE,
        HIDDEN,
        AUTO_HIDE;

    }

    public static enum SceneViewAlignment {
        LEFT(0.0f),
        RIGHT(1.0f),
        CENTER(0.5f);

        private final float mySwingAlignmentXValue;

        private SceneViewAlignment(float swingValue) {
            this.mySwingAlignmentXValue = swingValue;
        }
    }
}

