/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.target;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawLasso;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.google.common.collect.ImmutableList;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LassoTarget
extends BaseTarget {
    private static final boolean DEBUG_RENDERER = false;
    private float myOriginX;
    private float myOriginY;
    private float myLastX;
    private float myLastY;
    private boolean myShowRect;
    private final boolean mySelectWhileDragging;
    private final boolean myShowMargins;
    private final boolean myRecurse;
    private final HashSet<SceneComponent> myIntersectingComponents = new HashSet();
    private boolean myHasChanged;
    private boolean myHasDragged;

    public LassoTarget() {
        this(false, true, false);
    }

    public LassoTarget(boolean selectWhileDragging, boolean showMargins, boolean recurse) {
        this.mySelectWhileDragging = selectWhileDragging;
        this.myShowMargins = showMargins;
        this.myRecurse = recurse;
    }

    public boolean getSelectWhileDragging() {
        return this.mySelectWhileDragging;
    }

    public boolean getHasChanged() {
        return this.myHasChanged;
    }

    public void clearHasChanged() {
        this.myHasChanged = false;
    }

    public boolean getHasDragged() {
        return this.myHasDragged;
    }

    public HashSet<SceneComponent> getIntersectingComponents() {
        return this.myIntersectingComponents;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        if (sceneTransform == null) {
            LassoTarget.$$$reportNull$$$0(0);
        }
        this.myLeft = l;
        this.myTop = t;
        this.myRight = r;
        this.myBottom = b;
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (list == null) {
            LassoTarget.$$$reportNull$$$0(1);
        }
        if (sceneContext == null) {
            LassoTarget.$$$reportNull$$$0(2);
        }
        if (this.myShowRect) {
            float x1 = Math.min(this.myOriginX, this.myLastX);
            float x2 = Math.max(this.myOriginX, this.myLastX);
            float y1 = Math.min(this.myOriginY, this.myLastY);
            float y2 = Math.max(this.myOriginY, this.myLastY);
            DrawLasso.add(list, sceneContext, x1, y1, x2, y2, this.myLastX, this.myLastY, this.myShowMargins);
        }
    }

    @Override
    protected boolean isHittable() {
        return !this.myComponent.isSelected() || !this.myComponent.isDragging();
    }

    @Override
    public int getPreferenceLevel() {
        return 10;
    }

    @Override
    public void mouseDown(int x, int y) {
        this.myOriginX = x;
        this.myOriginY = y;
        this.myLastX = x;
        this.myLastY = y;
        this.myIntersectingComponents.clear();
        this.myHasChanged = true;
        this.myHasDragged = false;
    }

    @Override
    public void mouseDrag(int x, int y, @NotNull List<Target> closestTargets, @NotNull SceneContext context) {
        if (closestTargets == null) {
            LassoTarget.$$$reportNull$$$0(3);
        }
        if (context == null) {
            LassoTarget.$$$reportNull$$$0(4);
        }
        this.myLastX = x;
        this.myLastY = y;
        this.myShowRect = true;
        this.myHasDragged = true;
        this.fillSelectedComponents(context);
        this.myComponent.getScene().needsRebuildList();
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTargets) {
        if (closestTargets == null) {
            LassoTarget.$$$reportNull$$$0(5);
        }
        this.myShowRect = false;
        this.myComponent.getScene().needsRebuildList();
    }

    private void fillSelectedComponents(@NotNull SceneContext sceneTransform) {
        if (sceneTransform == null) {
            LassoTarget.$$$reportNull$$$0(6);
        }
        float x1 = Math.min(this.myOriginX, this.myLastX);
        float x2 = Math.max(this.myOriginX, this.myLastX);
        float y1 = Math.min(this.myOriginY, this.myLastY);
        float y2 = Math.max(this.myOriginY, this.myLastY);
        if ((int)(x2 - x1) == 0 && (int)(y2 - y1) == 0) {
            return;
        }
        Rectangle bounds2 = new Rectangle((int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1));
        this.fillSelectedComponents(this.myComponent, bounds2, sceneTransform);
    }

    private void fillSelectedComponents(@NotNull SceneComponent parent, @NotNull Rectangle bounds2, @NotNull SceneContext sceneTransform) {
        if (parent == null) {
            LassoTarget.$$$reportNull$$$0(7);
        }
        if (bounds2 == null) {
            LassoTarget.$$$reportNull$$$0(8);
        }
        if (sceneTransform == null) {
            LassoTarget.$$$reportNull$$$0(9);
        }
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            boolean contains;
            boolean intersects;
            SceneComponent component = parent.getChild(i);
            if (this.myRecurse) {
                this.fillSelectedComponents(component, bounds2, sceneTransform);
            }
            if ((intersects = component.intersects(sceneTransform, bounds2)) == (contains = this.myIntersectingComponents.contains(component))) continue;
            this.myHasChanged = true;
            if (contains) {
                this.myIntersectingComponents.remove(component);
                continue;
            }
            this.myIntersectingComponents.add(component);
        }
    }

    @Override
    @Nullable
    public List<SceneComponent> newSelection() {
        if (this.getHasDragged()) {
            return ImmutableList.copyOf(this.getIntersectingComponents());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneTransform";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closestTargets";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/common/scene/target/LassoTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "layout";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseDrag";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseRelease";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "fillSelectedComponents";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

