/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw.test;

import com.android.tools.idea.common.scene.draw.FancyStroke;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnectionUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CheckFancyStroke
extends JPanel {
    public static final Color BLUEPRINT_BG_COLOR = new Color(1123698);
    public static final Color BLUEPRINT_FG_COLOR = new Color(16774594);
    int[] xp = new int[100];
    int[] yp = new int[this.xp.length];
    public static final int CURVE = 30;

    public CheckFancyStroke() {
        this.fill();
        this.setBackground(Color.BLUE);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CheckFancyStroke.this.fill();
                CheckFancyStroke.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(BLUEPRINT_BG_COLOR);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.fillRect(0, 0, w, h);
        GeneralPath p = new GeneralPath();
        float cx = (float)w / 2.0f;
        float cy = (float)h / 2.0f;
        g.setColor(BLUEPRINT_FG_COLOR);
        Random r = new Random();
        for (int n = 0; n < 7; ++n) {
            this.fill();
            float size = 1.0f + (float)Math.random() * 4.0f;
            int spacing = 2 + r.nextInt(20);
            float width = 1.0f;
            int type = r.nextInt(4);
            switch (type) {
                case 0: {
                    g2d.setStroke(new FancyStroke(FancyStroke.Type.SINE, size, spacing, width));
                    break;
                }
                case 1: {
                    g2d.setStroke(new FancyStroke(FancyStroke.Type.SPRING, size, spacing, width));
                    break;
                }
                case 2: {
                    g2d.setStroke(new FancyStroke(FancyStroke.Type.ROPE, size, spacing, width));
                    break;
                }
                case 3: {
                    g2d.setStroke(new FancyStroke(FancyStroke.Type.CHAIN, size, spacing, width));
                }
            }
            p.reset();
            p.moveTo(this.xp[0], this.yp[0]);
            DrawConnectionUtils.drawRound((Path2D.Float)p, this.xp, this.yp, 30, 4 + r.nextInt(100));
            g2d.draw(p);
        }
    }

    private void fill() {
        if (this.getWidth() < 60 || this.getHeight() < 60) {
            return;
        }
        Random r = new Random();
        int seed = r.nextInt();
        System.out.println("seed =" + seed);
        r.setSeed(seed);
        this.xp[0] = r.nextInt(this.getWidth());
        this.yp[0] = r.nextInt(this.getHeight());
        for (int i = 1; i < this.xp.length; ++i) {
            int rand;
            if ((i & 1) == 0) {
                while (Math.abs(rand = r.nextInt(this.getWidth()) - this.getWidth() / 2) <= 30) {
                }
                this.xp[i] = this.xp[i - 1] + rand;
                this.yp[i] = this.yp[i - 1];
            } else {
                while (Math.abs(rand = r.nextInt(this.getHeight()) - this.getHeight() / 2) <= 30) {
                }
                this.yp[i] = this.yp[i - 1] + rand;
                this.xp[i] = this.xp[i - 1];
            }
            if (this.xp[i] < this.getWidth() && this.xp[i] >= 0 && this.yp[i] < this.getHeight() && this.yp[i] >= 0) continue;
            --i;
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("CheckFancyStroke");
        f.setBounds(new Rectangle(1400, 900));
        f.setDefaultCloseOperation(3);
        CheckFancyStroke p = new CheckFancyStroke();
        f.setContentPane(p);
        f.validate();
        f.setVisible(true);
    }
}

