/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import org.jetbrains.annotations.NotNull;

public class DrawNlComponentFrame
extends DrawRegion {
    private static final Stroke myNormalStroke = new BasicStroke(1.0f);
    private static final Stroke myWrapStroke = new BasicStroke(1.0f);
    private static final Stroke myMatchParentStroke = new BasicStroke(1.0f);
    private static final Stroke myDragReceiverStroke = new BasicStroke(3.0f);
    private static final Stroke myMatchConstraintStroke = new BasicStroke(1.0f);
    @NotNull
    private SceneComponent.DrawState myMode;
    private int myLayoutWidth;
    private int myLayoutHeight;
    private int myLevel;

    public DrawNlComponentFrame(String s) {
        this.myLevel = 20;
        String[] sp = s.split(",");
        int c = 0;
        c = super.parse(sp, c);
        this.myMode = SceneComponent.DrawState.values()[Integer.parseInt(sp[c++])];
        this.myLayoutWidth = Integer.parseInt(sp[c++]);
        this.myLayoutHeight = Integer.parseInt(sp[c++]);
    }

    @Override
    public int getLevel() {
        return this.myLevel;
    }

    public DrawNlComponentFrame(int x, int y, int width, int height, @NotNull SceneComponent.DrawState mode, int layout_width, int layout_height) {
        if (mode == null) {
            DrawNlComponentFrame.$$$reportNull$$$0(0);
        }
        super(x, y, width, height);
        this.myLevel = 20;
        this.myMode = mode;
        this.myLayoutWidth = layout_width;
        this.myLayoutHeight = layout_height;
        if (mode == SceneComponent.DrawState.SELECTED) {
            this.myLevel = 30;
        }
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet colorSet = sceneContext.getColorSet();
        Stroke previousStroke = g.getStroke();
        Color previousColor = g.getColor();
        g.setStroke(myNormalStroke);
        g.setColor(DrawNlComponentFrame.getFrameColor(colorSet, this.myMode));
        if (this.myMode == SceneComponent.DrawState.DRAG) {
            g.setStroke(myDragReceiverStroke);
            g.drawRect(this.x, this.y, this.width, this.height);
        } else {
            Shape clipping = g.getClip();
            if (clipping != null && !clipping.contains(this.x, this.y, this.x + this.width, this.x + this.height)) {
                g.setClip(sceneContext.getRenderableBounds());
                g.setStroke(ColorSet.sDashedStroke);
                g.drawLine(this.x, this.y, this.x, this.y + this.height);
                g.drawLine(this.x + this.width, this.y, this.x + this.width, this.y + this.height);
                g.drawLine(this.x, this.y, this.x + this.width, this.y);
                g.drawLine(this.x, this.y + this.height, this.x + this.width, this.y + this.height);
                g.setClip(clipping);
            }
            g.setStroke(DrawNlComponentFrame.getStroke(this.myLayoutHeight));
            g.drawLine(this.x, this.y, this.x, this.y + this.height);
            g.drawLine(this.x + this.width, this.y, this.x + this.width, this.y + this.height);
            g.setStroke(DrawNlComponentFrame.getStroke(this.myLayoutWidth));
            g.drawLine(this.x, this.y, this.x + this.width, this.y);
            g.drawLine(this.x, this.y + this.height, this.x + this.width, this.y + this.height);
        }
        g.setColor(previousColor);
        g.setStroke(previousStroke);
    }

    @NotNull
    private static Color getFrameColor(@NotNull ColorSet colorSet, @NotNull SceneComponent.DrawState mode) {
        if (colorSet == null) {
            DrawNlComponentFrame.$$$reportNull$$$0(1);
        }
        if (mode == null) {
            DrawNlComponentFrame.$$$reportNull$$$0(2);
        }
        switch (mode) {
            case SUBDUED: {
                Color color2 = colorSet.getSubduedFrames();
                if (color2 == null) {
                    DrawNlComponentFrame.$$$reportNull$$$0(3);
                }
                return color2;
            }
            case NORMAL: {
                Color color3 = colorSet.getFrames();
                if (color3 == null) {
                    DrawNlComponentFrame.$$$reportNull$$$0(4);
                }
                return color3;
            }
            case HOVER: {
                Color color4 = colorSet.getHighlightedFrames();
                if (color4 == null) {
                    DrawNlComponentFrame.$$$reportNull$$$0(5);
                }
                return color4;
            }
            case SELECTED: {
                Color color5 = colorSet.getSelectedFrames();
                if (color5 == null) {
                    DrawNlComponentFrame.$$$reportNull$$$0(6);
                }
                return color5;
            }
            case DRAG: {
                Color color6 = colorSet.getDragReceiverFrames();
                if (color6 == null) {
                    DrawNlComponentFrame.$$$reportNull$$$0(7);
                }
                return color6;
            }
        }
        Color color7 = colorSet.getFrames();
        if (color7 == null) {
            DrawNlComponentFrame.$$$reportNull$$$0(8);
        }
        return color7;
    }

    @NotNull
    private static Stroke getStroke(int dim) {
        if (dim == 0) {
            Stroke stroke = myMatchConstraintStroke;
            if (stroke == null) {
                DrawNlComponentFrame.$$$reportNull$$$0(9);
            }
            return stroke;
        }
        if (dim == -1) {
            Stroke stroke = myMatchParentStroke;
            if (stroke == null) {
                DrawNlComponentFrame.$$$reportNull$$$0(10);
            }
            return stroke;
        }
        if (dim == -2) {
            Stroke stroke = myWrapStroke;
            if (stroke == null) {
                DrawNlComponentFrame.$$$reportNull$$$0(11);
            }
            return stroke;
        }
        Stroke stroke = myNormalStroke;
        if (stroke == null) {
            DrawNlComponentFrame.$$$reportNull$$$0(12);
        }
        return stroke;
    }

    @Override
    public String serialize() {
        return super.serialize() + "," + this.myMode.ordinal() + "," + this.myLayoutHeight + "," + this.myLayoutHeight;
    }

    public static void add(DisplayList list, SceneContext sceneContext, Rectangle rect, @NotNull SceneComponent.DrawState mode, int layout_width, int layout_height) {
        if (mode == null) {
            DrawNlComponentFrame.$$$reportNull$$$0(13);
        }
        int l = sceneContext.getSwingXDip(rect.x);
        int t = sceneContext.getSwingYDip(rect.y);
        int w = sceneContext.getSwingDimensionDip(rect.width);
        int h = sceneContext.getSwingDimensionDip(rect.height);
        list.add(new DrawNlComponentFrame(l, t, w, h, mode, layout_width, layout_height));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorSet";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/scene/draw/DrawNlComponentFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/scene/draw/DrawNlComponentFrame";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameColor";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStroke";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFrameColor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

