/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.DefaultHitProvider;
import com.android.tools.idea.common.scene.DefaultSceneManagerHierarchyProvider;
import com.android.tools.idea.common.scene.HitProvider;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderUtils;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SceneManager
implements Disposable,
ResourceNotificationManager.ResourceChangeListener {
    public static final boolean SUPPORTS_LOCKING = false;
    @NotNull
    private final NlModel myModel;
    @NotNull
    private final DesignSurface myDesignSurface;
    @NotNull
    private final Scene myScene;
    @Nullable
    private SceneView mySceneView;
    @NotNull
    private final HitProvider myHitProvider;
    @NotNull
    private final SceneComponentHierarchyProvider mySceneComponentProvider;
    @NotNull
    private final SceneUpdateListener mySceneUpdateListener;
    @NotNull
    private final Object myActivationLock;
    private boolean myIsActivated;

    public SceneManager(@NotNull NlModel model2, @NotNull DesignSurface surface2, @Nullable SceneComponentHierarchyProvider sceneComponentProvider, @Nullable SceneUpdateListener sceneUpdateListener) {
        if (model2 == null) {
            SceneManager.$$$reportNull$$$0(0);
        }
        if (surface2 == null) {
            SceneManager.$$$reportNull$$$0(1);
        }
        this.myHitProvider = new DefaultHitProvider();
        this.myActivationLock = new Object();
        this.myIsActivated = false;
        this.myModel = model2;
        this.myDesignSurface = surface2;
        Disposer.register((Disposable)model2, (Disposable)this);
        this.mySceneComponentProvider = sceneComponentProvider == null ? new DefaultSceneManagerHierarchyProvider() : sceneComponentProvider;
        this.mySceneUpdateListener = sceneUpdateListener == null ? new DefaultSceneUpdateListener() : sceneUpdateListener;
        this.myScene = new Scene(this, this.myDesignSurface);
    }

    protected void createSceneView() {
        if (this.mySceneView != null) {
            this.mySceneView.dispose();
        }
        this.mySceneView = this.doCreateSceneView();
    }

    @NotNull
    protected abstract SceneView doCreateSceneView();

    public final void updateSceneView() {
        this.createSceneView();
    }

    @Deprecated
    @NotNull
    public SceneView getSceneView() {
        assert (this.mySceneView != null) : "createSceneView was not called";
        SceneView sceneView = this.mySceneView;
        if (sceneView == null) {
            SceneManager.$$$reportNull$$$0(2);
        }
        return sceneView;
    }

    @NotNull
    public List<SceneView> getSceneViews() {
        ImmutableList immutableList = ImmutableList.of((Object)this.getSceneView());
        if (immutableList == null) {
            SceneManager.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    public abstract float getSceneScalingFactor();

    public void dispose() {
        this.deactivate(this);
        for (SceneView sceneView : this.getSceneViews()) {
            sceneView.dispose();
        }
    }

    public void update() {
        SceneComponent root;
        ImmutableList<NlComponent> components = this.getModel().getComponents();
        Scene scene = this.getScene();
        if (components.isEmpty()) {
            scene.removeAllComponents();
            scene.setRoot(null);
            return;
        }
        HashSet<SceneComponent> usedComponents = new HashSet<SceneComponent>();
        HashSet<SceneComponent> oldComponents = new HashSet<SceneComponent>(scene.getSceneComponents());
        NlComponent rootComponent = this.getRoot();
        if (this.myScene.getRoot() != null && rootComponent != this.myScene.getRoot().getNlComponent()) {
            scene.removeAllComponents();
            scene.setRoot(null);
        }
        this.mySceneUpdateListener.onUpdate(rootComponent, this.myDesignSurface);
        List<SceneComponent> hierarchy = this.mySceneComponentProvider.createHierarchy(this, rootComponent);
        if (hierarchy.isEmpty()) {
            root = null;
        } else if (hierarchy.size() == 1) {
            root = hierarchy.get(0);
        } else {
            root = new SceneComponent(scene, rootComponent, scene.getSceneManager().getHitProvider(rootComponent));
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxX = 0;
            int maxY = 0;
            for (SceneComponent child : hierarchy) {
                minX = Math.min(minX, child.getDrawX());
                minY = Math.min(minY, child.getDrawY());
                maxX = Math.max(maxX, child.getDrawX() + child.getDrawWidth());
                maxY = Math.max(maxY, child.getDrawY() + child.getDrawHeight());
                root.addChild(child);
            }
            root.setPosition(minX, minY);
            root.setSize(maxX - minX, maxY - minY);
        }
        scene.setRoot(root);
        if (root != null) {
            this.updateFromComponent(root, usedComponents);
        }
        oldComponents.removeAll(usedComponents);
        oldComponents.removeIf(component -> component instanceof TemporarySceneComponent);
        oldComponents.forEach(scene::removeComponent);
        scene.needsRebuildList();
    }

    @NotNull
    protected NlComponent getRoot() {
        NlComponent nlComponent = ((NlComponent)this.getModel().getComponents().get(0)).getRoot();
        if (nlComponent == null) {
            SceneManager.$$$reportNull$$$0(4);
        }
        return nlComponent;
    }

    public static boolean isComponentLocked(@NotNull NlComponent component) {
        if (component == null) {
            SceneManager.$$$reportNull$$$0(5);
        }
        return false;
    }

    protected final void updateFromComponent(@NotNull SceneComponent component, @NotNull Set<SceneComponent> seenComponents) {
        if (component == null) {
            SceneManager.$$$reportNull$$$0(6);
        }
        if (seenComponents == null) {
            SceneManager.$$$reportNull$$$0(7);
        }
        seenComponents.add(component);
        this.syncFromNlComponent(component);
        for (SceneComponent child : component.getChildren()) {
            this.updateFromComponent(child, seenComponents);
        }
    }

    @NotNull
    public abstract TemporarySceneComponent createTemporaryComponent(@NotNull NlComponent var1);

    protected final void syncFromNlComponent(SceneComponent sceneComponent) {
        this.mySceneComponentProvider.syncFromNlComponent(sceneComponent);
    }

    @NotNull
    protected DesignSurface getDesignSurface() {
        DesignSurface designSurface = this.myDesignSurface;
        if (designSurface == null) {
            SceneManager.$$$reportNull$$$0(8);
        }
        return designSurface;
    }

    @NotNull
    public NlModel getModel() {
        NlModel nlModel = this.myModel;
        if (nlModel == null) {
            SceneManager.$$$reportNull$$$0(9);
        }
        return nlModel;
    }

    @NotNull
    public Scene getScene() {
        Scene scene = this.myScene;
        if (scene == null) {
            SceneManager.$$$reportNull$$$0(10);
        }
        return scene;
    }

    @NotNull
    public abstract CompletableFuture<Void> requestRenderAsync();

    @NotNull
    public CompletableFuture<Void> requestLayoutAndRenderAsync(boolean animate) {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            SceneManager.$$$reportNull$$$0(11);
        }
        return completableFuture;
    }

    @NotNull
    public abstract CompletableFuture<Void> requestLayoutAsync(boolean var1);

    public abstract void layout(boolean var1);

    @NotNull
    public abstract SceneDecoratorFactory getSceneDecoratorFactory();

    public abstract Map<Object, Map<ResourceReference, ResourceValue>> getDefaultProperties();

    public abstract Map<Object, ResourceReference> getDefaultStyles();

    @NotNull
    protected HitProvider getHitProvider(@NotNull NlComponent component) {
        if (component == null) {
            SceneManager.$$$reportNull$$$0(12);
        }
        HitProvider hitProvider = this.myHitProvider;
        if (hitProvider == null) {
            SceneManager.$$$reportNull$$$0(13);
        }
        return hitProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activate(@NotNull Object source) {
        if (source == null) {
            SceneManager.$$$reportNull$$$0(14);
        }
        Object object = this.myActivationLock;
        synchronized (object) {
            if (!this.myIsActivated) {
                AndroidFacet facet = this.myModel.getFacet();
                VirtualFile file2 = this.myModel.getVirtualFile();
                Configuration config = this.myModel.getConfiguration();
                ResourceNotificationManager manager = ResourceNotificationManager.getInstance((Project)this.myModel.getProject());
                manager.addListener((ResourceNotificationManager.ResourceChangeListener)this, facet, file2, config);
                this.myIsActivated = true;
            }
        }
        return this.getModel().activate(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deactivate(@NotNull Object source) {
        if (source == null) {
            SceneManager.$$$reportNull$$$0(15);
        }
        Object object = this.myActivationLock;
        synchronized (object) {
            if (this.myIsActivated) {
                AndroidFacet facet = this.myModel.getFacet();
                VirtualFile file2 = this.myModel.getVirtualFile();
                Configuration config = this.myModel.getConfiguration();
                ResourceNotificationManager manager = ResourceNotificationManager.getInstance((Project)this.myModel.getProject());
                manager.removeListener((ResourceNotificationManager.ResourceChangeListener)this, facet, file2, config);
                this.myIsActivated = false;
            }
        }
        return this.getModel().deactivate(source);
    }

    public boolean isOutOfDate() {
        return false;
    }

    public void resourcesChanged(@NotNull Set<ResourceNotificationManager.Reason> reasons) {
        if (reasons == null) {
            SceneManager.$$$reportNull$$$0(16);
        }
        for (ResourceNotificationManager.Reason reason : reasons) {
            switch (reason) {
                case RESOURCE_EDIT: {
                    this.myModel.notifyModifiedViaUpdateQueue(NlModel.ChangeType.RESOURCE_EDIT);
                    break;
                }
                case EDIT: {
                    this.myModel.notifyModifiedViaUpdateQueue(NlModel.ChangeType.EDIT);
                    break;
                }
                case IMAGE_RESOURCE_CHANGED: {
                    RenderUtils.clearCache((ImmutableCollection)ImmutableList.of((Object)this.myModel.getConfiguration()));
                    this.myModel.notifyModified(NlModel.ChangeType.RESOURCE_CHANGED);
                    break;
                }
                case GRADLE_SYNC: 
                case PROJECT_BUILD: 
                case VARIANT_CHANGED: 
                case SDK_CHANGED: {
                    RenderUtils.clearCache((ImmutableCollection)ImmutableList.of((Object)this.myModel.getConfiguration()));
                    this.myModel.notifyModified(NlModel.ChangeType.BUILD);
                    break;
                }
                case CONFIGURATION_CHANGED: {
                    this.myModel.notifyModified(NlModel.ChangeType.CONFIGURATION_CHANGE);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/scene/SceneManager";
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seenComponents";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reasons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/scene/SceneManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneViews";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesignSurface";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getScene";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "requestLayoutAndRenderAsync";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getHitProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isComponentLocked";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateFromComponent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getHitProvider";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "activate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "deactivate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resourcesChanged";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DefaultSceneUpdateListener
    implements SceneUpdateListener {
        @Override
        public void onUpdate(@NotNull NlComponent component, @NotNull DesignSurface designSurface) {
            if (component == null) {
                DefaultSceneUpdateListener.$$$reportNull$$$0(0);
            }
            if (designSurface == null) {
                DefaultSceneUpdateListener.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "designSurface";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/common/scene/SceneManager$DefaultSceneUpdateListener";
            objectArray[2] = "onUpdate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface SceneUpdateListener {
        public void onUpdate(@NotNull NlComponent var1, @NotNull DesignSurface var2);
    }

    public static interface SceneComponentHierarchyProvider {
        @NotNull
        public List<SceneComponent> createHierarchy(@NotNull SceneManager var1, @NotNull NlComponent var2);

        public void syncFromNlComponent(@NotNull SceneComponent var1);
    }
}

