/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.ide.common.resources.ResourcesUtil;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.AttributesHelperKt;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponentBackend;
import com.android.tools.idea.common.model.NlComponentBackendXml;
import com.android.tools.idea.common.model.NlComponentModificationDelegate;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.QualifiedName;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class NlComponent
implements NlAttributesHolder {
    @Nullable
    private XmlModelComponentMixin myMixin;
    private final List<NlComponent> children;
    @Nullable
    private List<NlComponent> cachedChildrenCopy;
    private NlComponent myParent;
    @NotNull
    private final NlModel myModel;
    @Nullable
    private TagSnapshot mySnapshot;
    @NotNull
    private NlComponentBackend myBackend;
    private final HashMap<Object, Object> myClientProperties;
    private final ListenerCollection<ChangeListener> myListeners;
    private final ChangeEvent myChangeEvent;
    private NlComponentModificationDelegate myComponentModificationDelegate;
    @Nullable
    AttributesTransaction myCurrentTransaction;

    public NlComponent(@NotNull NlModel model2, @NotNull XmlTag tag) {
        if (model2 == null) {
            NlComponent.$$$reportNull$$$0(0);
        }
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(1);
        }
        this.children = new ArrayList<NlComponent>();
        this.cachedChildrenCopy = null;
        this.myClientProperties = new HashMap();
        this.myListeners = ListenerCollection.createWithDirectExecutor();
        this.myChangeEvent = new ChangeEvent(this);
        this.myModel = model2;
        this.myBackend = new NlComponentBackendXml(model2.getProject(), tag);
    }

    @TestOnly
    public NlComponent(@NotNull NlModel model2, @NotNull XmlTag tag, @NotNull SmartPsiElementPointer<XmlTag> tagPointer) {
        if (model2 == null) {
            NlComponent.$$$reportNull$$$0(2);
        }
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(3);
        }
        if (tagPointer == null) {
            NlComponent.$$$reportNull$$$0(4);
        }
        this.children = new ArrayList<NlComponent>();
        this.cachedChildrenCopy = null;
        this.myClientProperties = new HashMap();
        this.myListeners = ListenerCollection.createWithDirectExecutor();
        this.myChangeEvent = new ChangeEvent(this);
        this.myModel = model2;
        this.myBackend = new NlComponentBackendXml(model2.getProject(), tag, tagPointer);
    }

    public void setComponentModificationDelegate(@Nullable NlComponentModificationDelegate delegate) {
        this.myComponentModificationDelegate = delegate;
    }

    @Nullable
    public NlComponentModificationDelegate getComponentModificationDelegate() {
        return this.myComponentModificationDelegate;
    }

    public void setMixin(@NotNull XmlModelComponentMixin mixin) {
        if (mixin == null) {
            NlComponent.$$$reportNull$$$0(5);
        }
        assert (this.myMixin == null);
        this.myMixin = mixin;
    }

    @Nullable
    public XmlModelComponentMixin getMixin() {
        return this.myMixin;
    }

    @Nullable
    public XmlTag getTag() {
        return this.myBackend.getTag();
    }

    @Deprecated
    @NotNull
    public XmlTag getTagDeprecated() {
        XmlTag xmlTag = this.myBackend.getTagDeprecated();
        if (xmlTag == null) {
            NlComponent.$$$reportNull$$$0(6);
        }
        return xmlTag;
    }

    @Deprecated
    @NotNull
    public SmartPsiElementPointer<XmlTag> getTagPointer() {
        SmartPsiElementPointer<XmlTag> smartPsiElementPointer = this.myBackend.getTagPointer();
        if (smartPsiElementPointer == null) {
            NlComponent.$$$reportNull$$$0(7);
        }
        return smartPsiElementPointer;
    }

    @NotNull
    public NlModel getModel() {
        NlModel nlModel = this.myModel;
        if (nlModel == null) {
            NlComponent.$$$reportNull$$$0(8);
        }
        return nlModel;
    }

    public void setTag(@NotNull XmlTag tag) {
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(9);
        }
        this.myBackend.setTagElement(tag);
    }

    @Deprecated
    @Nullable
    public TagSnapshot getSnapshot() {
        return this.mySnapshot;
    }

    public void setSnapshot(@Nullable TagSnapshot snapshot) {
        this.mySnapshot = snapshot;
    }

    public void addChild(@NotNull NlComponent component) {
        if (component == null) {
            NlComponent.$$$reportNull$$$0(10);
        }
        this.addChild(component, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(@NotNull NlComponent component, @Nullable NlComponent before) {
        if (component == null) {
            NlComponent.$$$reportNull$$$0(11);
        }
        if (component == this) {
            throw new IllegalArgumentException();
        }
        List<NlComponent> list = this.children;
        synchronized (list) {
            int index;
            this.cachedChildrenCopy = null;
            int n = index = before != null ? this.children.indexOf(before) : -1;
            if (index != -1) {
                this.children.add(index, component);
            } else {
                this.children.add(component);
            }
        }
        component.setParent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(@NotNull NlComponent component) {
        if (component == null) {
            NlComponent.$$$reportNull$$$0(12);
        }
        if (component == this) {
            throw new IllegalArgumentException();
        }
        List<NlComponent> list = this.children;
        synchronized (list) {
            this.cachedChildrenCopy = null;
            this.children.remove(component);
        }
        component.setParent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildren(@Nullable List<NlComponent> components) {
        List<NlComponent> list = this.children;
        synchronized (list) {
            this.cachedChildrenCopy = null;
            this.children.clear();
            if (components == null) {
                return;
            }
            this.children.addAll(components);
        }
        for (NlComponent component : components) {
            if (component == this) {
                throw new IllegalArgumentException();
            }
            component.setParent(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<NlComponent> getChildren() {
        ImmutableList childrenCopy = this.cachedChildrenCopy;
        if (childrenCopy == null) {
            List<NlComponent> list = this.children;
            synchronized (list) {
                this.cachedChildrenCopy = childrenCopy = ImmutableList.copyOf(this.children);
            }
        }
        ImmutableList immutableList = childrenCopy;
        if (immutableList == null) {
            NlComponent.$$$reportNull$$$0(13);
        }
        return immutableList;
    }

    public int getChildCount() {
        return this.getChildren().size();
    }

    @Nullable
    public NlComponent getChild(int index) {
        List<NlComponent> children = this.getChildren();
        return index >= 0 && index < children.size() ? children.get(index) : null;
    }

    @NotNull
    public Stream<NlComponent> flatten() {
        Stream<NlComponent> stream = Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(NlComponent::flatten));
        if (stream == null) {
            NlComponent.$$$reportNull$$$0(14);
        }
        return stream;
    }

    @Nullable
    public NlComponent getNextSibling() {
        if (this.myParent == null) {
            return null;
        }
        for (int index = 0; index < this.myParent.getChildCount(); ++index) {
            if (this.myParent.getChild(index) != this) continue;
            return this.myParent.getChild(index + 1);
        }
        return null;
    }

    @Nullable
    public NlComponent findViewByTag(@NotNull XmlTag tag) {
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(15);
        }
        if (this.getTagDeprecated() == tag) {
            return this;
        }
        for (NlComponent child : this.getChildren()) {
            NlComponent result = child.findViewByTag(tag);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void findViewsByTag(@NotNull XmlTag tag, @NotNull ImmutableList.Builder<NlComponent> builder2) {
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(16);
        }
        if (builder2 == null) {
            NlComponent.$$$reportNull$$$0(17);
        }
        for (NlComponent child : this.getChildren()) {
            child.findViewsByTag(tag, builder2);
        }
        if (this.getTagDeprecated() == tag) {
            builder2.add((Object)this);
        }
    }

    @NotNull
    public ImmutableList<NlComponent> findViewsByTag(@NotNull XmlTag tag) {
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(18);
        }
        ImmutableList.Builder builder2 = ImmutableList.builder();
        this.findViewsByTag(tag, (ImmutableList.Builder<NlComponent>)builder2);
        ImmutableList immutableList = builder2.build();
        if (immutableList == null) {
            NlComponent.$$$reportNull$$$0(19);
        }
        return immutableList;
    }

    public boolean isRoot() {
        return !(this.getTagDeprecated().getParent() instanceof XmlTag);
    }

    @NotNull
    public NlComponent getRoot() {
        NlComponent parent;
        NlComponent component = this;
        while (!component.isRoot() && (parent = component.getParent()) != null) {
            component = parent;
        }
        NlComponent nlComponent = component;
        if (nlComponent == null) {
            NlComponent.$$$reportNull$$$0(20);
        }
        return nlComponent;
    }

    @Nullable
    public String getId() {
        String id2 = this.myCurrentTransaction != null ? this.myCurrentTransaction.getAndroidAttribute("id") : this.resolveAttribute("http://schemas.android.com/apk/res/android", "id");
        return id2 != null ? ResourcesUtil.stripPrefixFromId((String)id2) : null;
    }

    public void clearTransaction() {
        if (this.myCurrentTransaction != null) {
            this.myCurrentTransaction.finishTransaction();
        }
    }

    @Nullable
    public NlComponent getParent() {
        return this.myParent;
    }

    private void setParent(@Nullable NlComponent parent) {
        this.myParent = parent;
    }

    @NotNull
    public String getTagName() {
        String string2 = this.myBackend.getTagName();
        if (string2 == null) {
            NlComponent.$$$reportNull$$$0(21);
        }
        return string2;
    }

    @NotNull
    public NlComponentBackend getBackend() {
        NlComponentBackend nlComponentBackend = this.myBackend;
        if (nlComponentBackend == null) {
            NlComponent.$$$reportNull$$$0(22);
        }
        return nlComponentBackend;
    }

    public String toString() {
        if (this.getMixin() != null) {
            return this.getMixin().toString();
        }
        return String.format("<%s>", this.myBackend.getTagName());
    }

    @Override
    public void setAttribute(@Nullable String namespace, @NotNull String attribute, @Nullable String value2) {
        TagSnapshot snapshot;
        String previous;
        XmlTag tag;
        if (attribute == null) {
            NlComponent.$$$reportNull$$$0(23);
        }
        if (!(tag = this.getTagDeprecated()).isValid()) {
            return;
        }
        String prefix = null;
        if (namespace != null) {
            this.transferNamespaces(this);
            prefix = IdeResourcesUtil.ensureNamespaceImported((XmlFile)((XmlFile)tag.getContainingFile()), (String)namespace, null);
        }
        if (!Objects.equals(previous = this.myBackend.getAttribute(attribute, namespace), value2)) {
            this.myBackend.setAttribute(attribute, namespace, value2);
        }
        if ((snapshot = this.mySnapshot) != null) {
            snapshot.setAttribute(attribute, namespace, prefix, value2);
        }
    }

    @NotNull
    public AttributesTransaction startAttributeTransaction() {
        if (this.myCurrentTransaction == null) {
            this.myCurrentTransaction = new AttributesTransaction(this);
        }
        AttributesTransaction attributesTransaction = this.myCurrentTransaction;
        if (attributesTransaction == null) {
            NlComponent.$$$reportNull$$$0(24);
        }
        return attributesTransaction;
    }

    @Nullable
    public AttributesTransaction getAttributeTransaction() {
        return this.myCurrentTransaction;
    }

    @Nullable
    public String getLiveAttribute(@Nullable String namespace, @NotNull String attribute) {
        if (attribute == null) {
            NlComponent.$$$reportNull$$$0(25);
        }
        if (this.myCurrentTransaction != null) {
            return this.myCurrentTransaction.getAttribute(namespace, attribute);
        }
        return this.getAttribute(namespace, attribute);
    }

    @Override
    @Nullable
    public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
        if (attribute == null) {
            NlComponent.$$$reportNull$$$0(26);
        }
        return this.getAttributeImpl(namespace, attribute);
    }

    @Nullable
    public String getAttributeImpl(@Nullable String namespace, @NotNull String attribute) {
        TagSnapshot snapshot;
        if (attribute == null) {
            NlComponent.$$$reportNull$$$0(27);
        }
        if ((snapshot = this.mySnapshot) != null) {
            return snapshot.getAttribute(attribute, namespace);
        }
        return this.myBackend.getAttribute(attribute, namespace);
    }

    @Nullable
    public String resolveAttribute(@Nullable String namespace, @NotNull String attribute) {
        String value2;
        if (attribute == null) {
            NlComponent.$$$reportNull$$$0(28);
        }
        if ((value2 = this.getAttribute(namespace, attribute)) != null) {
            return value2;
        }
        if (this.getMixin() != null) {
            return this.getMixin().getAttribute(namespace, attribute);
        }
        return null;
    }

    @NotNull
    public List<AttributeSnapshot> getAttributes() {
        List<AttributeSnapshot> list = this.getAttributesImpl();
        if (list == null) {
            NlComponent.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    public List<AttributeSnapshot> getAttributesImpl() {
        TagSnapshot snapshot = this.mySnapshot;
        if (snapshot != null) {
            List list = snapshot.attributes;
            if (list == null) {
                NlComponent.$$$reportNull$$$0(30);
            }
            return list;
        }
        XmlTag tag = this.getTagDeprecated();
        if (tag.isValid()) {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                List list = (List)application.runReadAction(() -> AttributeSnapshot.createAttributesForTag((XmlTag)tag));
                if (list == null) {
                    NlComponent.$$$reportNull$$$0(31);
                }
                return list;
            }
            List list = AttributeSnapshot.createAttributesForTag((XmlTag)tag);
            if (list == null) {
                NlComponent.$$$reportNull$$$0(32);
            }
            return list;
        }
        List<AttributeSnapshot> list = Collections.emptyList();
        if (list == null) {
            NlComponent.$$$reportNull$$$0(33);
        }
        return list;
    }

    @Nullable
    public String ensureNamespace(@NotNull String suggestedPrefix, @NotNull String namespace) {
        XmlTag tag;
        if (suggestedPrefix == null) {
            NlComponent.$$$reportNull$$$0(34);
        }
        if (namespace == null) {
            NlComponent.$$$reportNull$$$0(35);
        }
        if ((tag = this.getBackend().getTag()) == null) {
            return null;
        }
        this.transferNamespaces(this);
        return IdeResourcesUtil.ensureNamespaceImported((XmlFile)((XmlFile)tag.getContainingFile()), (String)namespace, (String)suggestedPrefix);
    }

    public boolean isShowing() {
        return this.mySnapshot != null;
    }

    @Nullable
    public static String extractId(@Nullable String str) {
        if (str == null) {
            return null;
        }
        int index = str.lastIndexOf("@id/");
        if (index != -1) {
            return str.substring(index + 4);
        }
        index = str.lastIndexOf("@+id/");
        if (index != -1) {
            return str.substring(index + 5);
        }
        return null;
    }

    public void removeObsoleteAttributes() {
        Set<QualifiedName> obsoleteAttributes = AttributesHelperKt.getObsoleteAttributes(this);
        AttributesTransaction transaction = this.startAttributeTransaction();
        obsoleteAttributes.forEach(qualifiedName -> transaction.removeAttribute(qualifiedName.getNamespace(), qualifiedName.getName()));
        transaction.commit();
    }

    public final void putClientProperty(Object key, Object value2) {
        this.myClientProperties.put(key, value2);
    }

    public final Object getClientProperty(Object key) {
        return this.myClientProperties.get(key);
    }

    public final Object removeClientProperty(Object key) {
        return this.myClientProperties.remove(key);
    }

    public void addLiveChangeListener(ChangeListener listener2) {
        this.myListeners.add((Object)listener2);
    }

    public void removeLiveChangeListener(ChangeListener listener2) {
        this.myListeners.remove((Object)listener2);
    }

    public void fireLiveChangeEvent() {
        this.myListeners.forEach(listener2 -> listener2.stateChanged(this.myChangeEvent));
    }

    @NotNull
    public String assignId() {
        String string2 = this.assignId(this.getTagName());
        if (string2 == null) {
            NlComponent.$$$reportNull$$$0(36);
        }
        return string2;
    }

    public String ensureId() {
        if (this.getId() != null) {
            return this.getId();
        }
        return this.assignId();
    }

    @NotNull
    public String assignId(@NotNull String baseName) {
        if (baseName == null) {
            NlComponent.$$$reportNull$$$0(37);
        }
        return this.assignId(baseName, this.getModel().getIds());
    }

    @NotNull
    private String assignId(@NotNull Set<String> ids) {
        ViewHandler handler;
        if (ids == null) {
            NlComponent.$$$reportNull$$$0(38);
        }
        String baseName = (handler = NlComponentHelperKt.getViewHandler(this)) != null ? handler.generateBaseId(this) : this.getTagName();
        return this.assignId(baseName, ids);
    }

    @NotNull
    private String assignId(@NotNull String baseName, @NotNull Set<String> ids) {
        if (baseName == null) {
            NlComponent.$$$reportNull$$$0(39);
        }
        if (ids == null) {
            NlComponent.$$$reportNull$$$0(40);
        }
        String newId = NlComponent.generateId(baseName, ids, ResourceFolderType.LAYOUT, this.getModel().getModule());
        NlAttributesHolder attributes = this.myCurrentTransaction == null ? this : this.myCurrentTransaction;
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "id", "@+id/" + newId);
        this.getModel().getPendingIds().add(newId);
        String string2 = newId;
        if (string2 == null) {
            NlComponent.$$$reportNull$$$0(41);
        }
        return string2;
    }

    public void incrementId(@NotNull Set<String> ids) {
        String id2;
        if (ids == null) {
            NlComponent.$$$reportNull$$$0(42);
        }
        if ((id2 = this.getId()) == null || id2.isEmpty()) {
            ids.add(this.assignId(ids));
        } else {
            String baseName = id2.replaceAll("[0-9]*$", "");
            if (baseName != null && !baseName.isEmpty()) {
                ids.add(this.assignId(baseName, ids));
            }
        }
    }

    @NotNull
    private static String generateId(@NotNull String baseName, @NotNull Set<String> ids, ResourceFolderType type, Module module) {
        if (baseName == null) {
            NlComponent.$$$reportNull$$$0(43);
        }
        if (ids == null) {
            NlComponent.$$$reportNull$$$0(44);
        }
        String idValue = StringUtil.decapitalize((String)baseName.substring(baseName.lastIndexOf(46) + 1));
        Project project = module.getProject();
        idValue = IdeResourcesUtil.prependResourcePrefix((Module)module, (String)idValue, (ResourceFolderType)type);
        Object nextIdValue = idValue;
        int index = 0;
        NamesValidator validator = LanguageNamesValidation.INSTANCE.forLanguage((Language)JavaLanguage.INSTANCE);
        while (ids.contains(nextIdValue) || validator.isKeyword((String)nextIdValue, project)) {
            if (++index == 1 && !validator.isKeyword((String)nextIdValue, project)) {
                nextIdValue = idValue;
                continue;
            }
            nextIdValue = idValue + index;
        }
        String string2 = idValue + (Serializable)(index == 0 ? "" : Integer.valueOf(index));
        if (string2 == null) {
            NlComponent.$$$reportNull$$$0(45);
        }
        return string2;
    }

    @Nullable
    public String getTooltipText() {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            return mixin.getTooltipText();
        }
        return null;
    }

    public boolean canAddTo(NlComponent receiver) {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            return mixin.canAddTo(receiver);
        }
        return true;
    }

    public void moveTo(@NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType type, @NotNull Set<String> ids, @Nullable DesignSurface surface2) {
        XmlModelComponentMixin mixin;
        if (receiver == null) {
            NlComponent.$$$reportNull$$$0(46);
        }
        if (type == null) {
            NlComponent.$$$reportNull$$$0(47);
        }
        if (ids == null) {
            NlComponent.$$$reportNull$$$0(48);
        }
        if ((mixin = this.getMixin()) != null) {
            mixin.beforeMove(type, receiver, ids);
        }
        NlComponent oldParent = this.getParent();
        this.addTags(receiver, before, type);
        if (mixin != null) {
            mixin.afterMove(type, oldParent, receiver, surface2);
        }
    }

    public void addTags(@NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType type) {
        XmlTag beforeTag;
        NlComponent parent;
        if (receiver == null) {
            NlComponent.$$$reportNull$$$0(49);
        }
        if (type == null) {
            NlComponent.$$$reportNull$$$0(50);
        }
        if ((parent = this.getParent()) != null) {
            parent.removeChild(this);
        }
        XmlTag tag = this.getBackend().getTag();
        XmlTag receiverTag = receiver.getBackend().getTag();
        XmlTag xmlTag = beforeTag = before != null ? before.getBackend().getTag() : null;
        if (receiverTag == null || tag == null) {
            return;
        }
        if (receiverTag == tag) {
            return;
        }
        receiver.addChild(this, before);
        this.transferNamespaces(receiver);
        if (beforeTag != null) {
            this.setTag((XmlTag)receiverTag.addBefore((PsiElement)tag, (PsiElement)beforeTag));
        } else {
            this.setTag(receiverTag.addSubTag(tag, false));
        }
        if (type == InsertType.MOVE) {
            tag.delete();
        }
    }

    public void postCreateFromTransferrable(@NotNull DnDTransferComponent dndComponent) {
        XmlModelComponentMixin mixin;
        if (dndComponent == null) {
            NlComponent.$$$reportNull$$$0(51);
        }
        if ((mixin = this.getMixin()) != null) {
            mixin.postCreateFromTransferrable(dndComponent);
        }
    }

    public boolean postCreate(@Nullable DesignSurface surface2, @NotNull InsertType insertType) {
        XmlModelComponentMixin mixin;
        if (insertType == null) {
            NlComponent.$$$reportNull$$$0(52);
        }
        if ((mixin = this.getMixin()) != null) {
            return mixin.postCreate(surface2, insertType);
        }
        return true;
    }

    private void transferNamespaces(@NotNull NlComponent receiver) {
        if (receiver == null) {
            NlComponent.$$$reportNull$$$0(53);
        }
        NlComponent root = receiver.getRoot();
        while (receiver != null && receiver != root) {
            XmlTag tag = receiver.getTag();
            if (tag != null && !tag.getLocalNamespaceDeclarations().isEmpty()) {
                receiver.transferLocalNamespaces(root);
            }
            receiver = receiver.getParent();
        }
        if (receiver != this) {
            this.transferLocalNamespaces(root);
        }
    }

    private void transferLocalNamespaces(@NotNull NlComponent root) {
        if (root == null) {
            NlComponent.$$$reportNull$$$0(54);
        }
        XmlTag rootTag = root.getTag();
        XmlTag tag = this.getTag();
        if (tag == null || rootTag == null || rootTag == tag) {
            return;
        }
        Map prefixToNamespace = rootTag.getLocalNamespaceDeclarations();
        HashMap<String, String> namespaceToPrefix = new HashMap<String, String>();
        for (Map.Entry entry : prefixToNamespace.entrySet()) {
            namespaceToPrefix.put((String)entry.getValue(), (String)entry.getKey());
        }
        HashMap<String, String> oldPrefixToPrefix = new HashMap<String, String>();
        for (Map.Entry entry : tag.getLocalNamespaceDeclarations().entrySet()) {
            String namespace = (String)entry.getValue();
            String prefix = (String)entry.getKey();
            String currentPrefix = (String)namespaceToPrefix.get(namespace);
            if (currentPrefix == null) {
                XmlFile file2 = this.getModel().getFile();
                String newPrefix = IdeResourcesUtil.ensureNamespaceImported((XmlFile)file2, (String)namespace, (String)prefix);
                if (prefix.equals(newPrefix)) continue;
                oldPrefixToPrefix.put(prefix, newPrefix);
                namespaceToPrefix.put(namespace, newPrefix);
                continue;
            }
            if (prefix.equals(currentPrefix)) continue;
            oldPrefixToPrefix.put(prefix, currentPrefix);
        }
        if (!oldPrefixToPrefix.isEmpty()) {
            NlComponent.updatePrefixes(tag, oldPrefixToPrefix);
        }
        this.removeNamespaceAttributes();
    }

    private static void updatePrefixes(@NotNull XmlTag tag, @NotNull Map<String, String> oldPrefixToPrefix) {
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(55);
        }
        if (oldPrefixToPrefix == null) {
            NlComponent.$$$reportNull$$$0(56);
        }
        for (XmlAttribute xmlAttribute : tag.getAttributes()) {
            String newPrefix;
            String prefix = xmlAttribute.getNamespacePrefix();
            if (prefix.isEmpty()) continue;
            if (prefix.equals("xmlns")) {
                newPrefix = oldPrefixToPrefix.get(xmlAttribute.getLocalName());
                if (newPrefix == null) continue;
                xmlAttribute.setName("xmlns:" + newPrefix);
                continue;
            }
            newPrefix = oldPrefixToPrefix.get(prefix);
            if (newPrefix == null) continue;
            xmlAttribute.setName(newPrefix + ":" + xmlAttribute.getLocalName());
        }
        for (XmlAttribute xmlAttribute : tag.getSubTags()) {
            NlComponent.updatePrefixes((XmlTag)xmlAttribute, oldPrefixToPrefix);
        }
    }

    private void removeNamespaceAttributes() {
        XmlTag tag = this.getTag();
        if (tag != null) {
            for (XmlAttribute attribute : tag.getAttributes()) {
                if (!attribute.getName().startsWith("xmlns:")) continue;
                attribute.delete();
            }
        }
    }

    public Set<String> getDependencies() {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            return mixin.getDependencies();
        }
        return ImmutableSet.of();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 41: 
            case 45: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 41: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 15: 
            case 16: 
            case 18: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagPointer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mixin";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/model/NlComponent";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedPrefix";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 37: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 46: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dndComponent";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPrefixToPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/model/NlComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagDeprecated";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagPointer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "flatten";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findViewsByTag";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackend";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "startAttributeTransaction";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributesImpl";
                break;
            }
            case 36: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "assignId";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "generateId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setMixin";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 41: 
            case 45: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setTag";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findViewByTag";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findViewsByTag";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setAttribute";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getLiveAttribute";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAttribute";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeImpl";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolveAttribute";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "ensureNamespace";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "assignId";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "incrementId";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "generateId";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "moveTo";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "addTags";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "postCreateFromTransferrable";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "postCreate";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "transferNamespaces";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "transferLocalNamespaces";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "updatePrefixes";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 41: 
            case 45: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class XmlModelComponentMixin {
        private final NlComponent myComponent;

        public XmlModelComponentMixin(@NotNull NlComponent component) {
            if (component == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(0);
            }
            this.myComponent = component;
        }

        @NotNull
        protected NlComponent getComponent() {
            NlComponent nlComponent = this.myComponent;
            if (nlComponent == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(1);
            }
            return nlComponent;
        }

        @Nullable
        public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
            if (attribute == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(2);
            }
            return null;
        }

        public String toString() {
            return String.format("<%s>", this.myComponent.getTagName());
        }

        @Nullable
        public String getTooltipText() {
            return null;
        }

        public boolean canAddTo(@NotNull NlComponent receiver) {
            if (receiver == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(3);
            }
            return true;
        }

        public Set<String> getDependencies() {
            return ImmutableSet.of();
        }

        public void beforeMove(@NotNull InsertType insertType, @NotNull NlComponent receiver, @NotNull Set<String> ids) {
            if (insertType == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(4);
            }
            if (receiver == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(5);
            }
            if (ids == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(6);
            }
        }

        public void afterMove(@NotNull InsertType insertType, @Nullable NlComponent previousParent, @NotNull NlComponent receiver, @Nullable DesignSurface surface2) {
            if (insertType == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(7);
            }
            if (receiver == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(8);
            }
        }

        public boolean postCreate(@Nullable DesignSurface surface2, @NotNull InsertType insertType) {
            if (insertType == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(9);
            }
            return true;
        }

        public void postCreateFromTransferrable(DnDTransferComponent dndComponent) {
        }

        public abstract boolean maybeHandleDeletion(@NotNull Collection<NlComponent> var1);

        @NotNull
        public abstract Icon getIcon();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/common/model/NlComponent$XmlModelComponentMixin";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 4: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insertType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ids";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/common/model/NlComponent$XmlModelComponentMixin";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getAttribute";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "canAddTo";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "beforeMove";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "afterMove";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "postCreate";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

