/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.ui.resourcemanager.ResourceManagerTracking;
import com.android.tools.idea.ui.resourcemanager.model.ResourceDataManagerKt;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DnDTransferItem {
    private final boolean myFromPalette;
    private final long myModelId;
    private final ImmutableList<DnDTransferComponent> myComponents;
    private boolean myIsCut;

    public DnDTransferItem(@NotNull DnDTransferComponent component) {
        if (component == null) {
            DnDTransferItem.$$$reportNull$$$0(0);
        }
        this(true, 0L, (ImmutableList<DnDTransferComponent>)ImmutableList.of((Object)component));
    }

    /*
     * WARNING - void declaration
     */
    public DnDTransferItem(long modelId, @NotNull ImmutableList<DnDTransferComponent> immutableList) {
        void components;
        if (immutableList == null) {
            DnDTransferItem.$$$reportNull$$$0(1);
        }
        this(false, modelId, (ImmutableList<DnDTransferComponent>)components);
    }

    /*
     * WARNING - void declaration
     */
    private DnDTransferItem(boolean fromPalette, long modelId, @NotNull ImmutableList<DnDTransferComponent> immutableList) {
        void components;
        if (immutableList == null) {
            DnDTransferItem.$$$reportNull$$$0(2);
        }
        this.myFromPalette = fromPalette;
        this.myModelId = modelId;
        this.myComponents = components;
    }

    @Nullable
    public static DnDTransferItem getTransferItem(@NotNull Transferable transferable, boolean allowPlaceholder) {
        if (transferable == null) {
            DnDTransferItem.$$$reportNull$$$0(3);
        }
        try {
            String xml2;
            ResourceUrl url;
            DnDTransferItem item;
            if (transferable.isDataFlavorSupported(ItemTransferable.DESIGNER_FLAVOR)) {
                return (DnDTransferItem)transferable.getTransferData(ItemTransferable.DESIGNER_FLAVOR);
            }
            if (transferable.isDataFlavorSupported(ResourceDataManagerKt.RESOURCE_URL_FLAVOR) && (item = DnDTransferItem.fromResourceUrl(url = (ResourceUrl)transferable.getTransferData(ResourceDataManagerKt.RESOURCE_URL_FLAVOR))) != null) {
                return item;
            }
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor) && !StringUtil.isEmpty((String)(xml2 = (String)transferable.getTransferData(DataFlavor.stringFlavor)))) {
                return new DnDTransferItem(new DnDTransferComponent("", xml2, 200, 100));
            }
        }
        catch (InvalidDnDOperationException ex) {
            if (!allowPlaceholder) {
                return null;
            }
            String defaultXml = "<placeholder xmlns:android=\"http://schemas.android.com/apk/res/android\"/>";
            return new DnDTransferItem(new DnDTransferComponent("", defaultXml, 200, 100));
        }
        catch (UnsupportedFlavorException | IOException ex) {
            Logger.getInstance(DnDTransferItem.class).warn((Throwable)ex);
        }
        return null;
    }

    @Nullable
    private static DnDTransferItem fromResourceUrl(@NotNull ResourceUrl url) {
        String tag;
        String representation2;
        if (url == null) {
            DnDTransferItem.$$$reportNull$$$0(4);
        }
        ResourceManagerTracking.INSTANCE.logDragOnViewGroup(url.type);
        if (url.type == ResourceType.LAYOUT) {
            representation2 = String.format("<include layout=\"%s\"/>", url.toString());
            tag = "include";
        } else if (url.type == ResourceType.COLOR || url.type == ResourceType.DRAWABLE || url.type == ResourceType.MIPMAP) {
            String size = url.type == ResourceType.COLOR ? "50dp" : "wrap_content";
            String xml2 = "<ImageView\n    android:layout_width=\"%1$s\"\n    android:layout_height=\"%1$s\"\n    android:src=\"%2$s\"/>";
            representation2 = String.format(xml2, size, url.toString());
            tag = "ImageView";
        } else {
            return null;
        }
        return new DnDTransferItem(new DnDTransferComponent(tag, representation2, 100, 100));
    }

    public boolean isFromPalette() {
        return this.myFromPalette;
    }

    public long getModelId() {
        return this.myModelId;
    }

    public void setIsCut() {
        this.myIsCut = true;
    }

    public boolean isCut() {
        return this.myIsCut;
    }

    public void consumeCut() {
        this.myIsCut = false;
    }

    public ImmutableList<DnDTransferComponent> getComponents() {
        return this.myComponents;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transferable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/common/model/DnDTransferItem";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getTransferItem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fromResourceUrl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

