/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.tools.idea.common.model.BaseSelectionModel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.util.ListenerCollection;
import com.android.utils.ImmutableCollectors;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultSelectionModel
extends BaseSelectionModel {
    @NotNull
    private ImmutableList<NlComponent> mySelection = ImmutableList.of();
    private NlComponent myPrimary;
    private final ListenerCollection<SelectionListener> myListeners = ListenerCollection.createWithDirectExecutor();
    @Nullable
    Object mySecondarySelection;
    @Nullable
    private ImmutableList<NlComponent> myHighlightSelection = null;

    @NotNull
    public ImmutableList<NlComponent> getSelection() {
        ImmutableList<NlComponent> immutableList = this.mySelection;
        if (immutableList == null) {
            DefaultSelectionModel.$$$reportNull$$$0(0);
        }
        return immutableList;
    }

    @Override
    @Nullable
    public NlComponent getPrimary() {
        return this.myPrimary;
    }

    @Override
    public void setSelection(@NotNull List<? extends NlComponent> components, @Nullable NlComponent primary) {
        if (components == null) {
            DefaultSelectionModel.$$$reportNull$$$0(1);
        }
        if (this.setSelectionInternal(components, primary)) {
            this.notifySelectionChanged();
        }
    }

    private boolean setSelectionInternal(@NotNull List<? extends NlComponent> components, @Nullable NlComponent primary) {
        if (components == null) {
            DefaultSelectionModel.$$$reportNull$$$0(2);
        }
        if (components.equals(this.mySelection)) {
            return false;
        }
        this.mySelection = ImmutableList.copyOf(components);
        this.myHighlightSelection = null;
        this.mySecondarySelection = null;
        this.myPrimary = primary;
        return true;
    }

    @Override
    public void clear() {
        if (this.mySelection.isEmpty()) {
            return;
        }
        this.mySelection = ImmutableList.of();
        this.myPrimary = null;
        this.mySecondarySelection = null;
        this.myHighlightSelection = null;
        this.notifySelectionChanged();
    }

    @Override
    public void clearSecondary() {
        if (this.mySecondarySelection == null) {
            return;
        }
        this.mySecondarySelection = null;
        this.notifySelectionChanged();
    }

    @Override
    public void toggle(@NotNull NlComponent component) {
        NlComponent newPrimary;
        ImmutableList newSelection;
        int size;
        if (component == null) {
            DefaultSelectionModel.$$$reportNull$$$0(3);
        }
        if ((size = this.mySelection.size()) == 0) {
            newSelection = ImmutableList.of((Object)component);
            newPrimary = component;
        } else if (this.mySelection.contains((Object)component)) {
            if (size == 1) {
                newSelection = ImmutableList.of();
                newPrimary = null;
            } else {
                newSelection = (ImmutableList)this.mySelection.stream().filter(selection -> !selection.equals(component)).collect(ImmutableCollectors.toImmutableList());
                newPrimary = this.myPrimary == component ? null : this.myPrimary;
            }
        } else {
            ImmutableList.Builder builder2 = ImmutableList.builder();
            builder2.addAll(this.mySelection);
            builder2.add((Object)component);
            newSelection = builder2.build();
            newPrimary = this.myPrimary;
        }
        this.myHighlightSelection = null;
        this.mySecondarySelection = null;
        this.setSelection((List<? extends NlComponent>)newSelection, newPrimary);
    }

    private void notifySelectionChanged() {
        this.myListeners.forEach(l -> l.selectionChanged(this, (List<NlComponent>)this.mySelection));
    }

    @Override
    public void addListener(@NotNull SelectionListener listener2) {
        if (listener2 == null) {
            DefaultSelectionModel.$$$reportNull$$$0(4);
        }
        this.myListeners.add((Object)listener2);
    }

    @Override
    public void removeListener(@Nullable SelectionListener listener2) {
        this.myListeners.remove((Object)listener2);
    }

    @Override
    public void setSecondarySelection(NlComponent component, Object secondary) {
        if (component == null) {
            this.mySelection = ImmutableList.of();
            this.myPrimary = null;
            this.mySecondarySelection = null;
        } else {
            this.mySecondarySelection = secondary;
            this.mySelection = ImmutableList.of((Object)component);
            this.myPrimary = component;
        }
        this.myHighlightSelection = null;
        this.notifySelectionChanged();
    }

    @Override
    @Nullable
    public Object getSecondarySelection() {
        return this.mySecondarySelection;
    }

    @Override
    public boolean isHighlighted(@NotNull NlComponent component) {
        if (component == null) {
            DefaultSelectionModel.$$$reportNull$$$0(5);
        }
        return this.myHighlightSelection != null && this.myHighlightSelection.contains((Object)component);
    }

    @Override
    public void setHighlightSelection(@NotNull List<? extends NlComponent> highlighted, @NotNull List<? extends NlComponent> selected) {
        boolean updated;
        if (highlighted == null) {
            DefaultSelectionModel.$$$reportNull$$$0(6);
        }
        if (selected == null) {
            DefaultSelectionModel.$$$reportNull$$$0(7);
        }
        if (!(updated = this.setSelectionInternal(selected, null)) && highlighted.equals(this.myHighlightSelection)) {
            return;
        }
        this.myHighlightSelection = ImmutableList.copyOf(highlighted);
        this.notifySelectionChanged();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/model/DefaultSelectionModel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighted";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/model/DefaultSelectionModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSelection";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setSelectionInternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toggle";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isHighlighted";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightSelection";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

