/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.tools.idea.common.error.DesignerCommonIssueNode;
import com.android.tools.idea.common.error.DesignerCommonIssueRoot;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssuedFileData;
import com.android.tools.idea.common.error.LayoutFileIssueNode;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.impl.CompoundIconProvider;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.LeafState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\f0\u0011\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/common/error/LayoutFileIssuedFileNode;", "Lcom/android/tools/idea/common/error/DesignerCommonIssueNode;", "fileData", "Lcom/android/tools/idea/common/error/IssuedFileData;", "parent", "(Lcom/android/tools/idea/common/error/IssuedFileData;Lcom/android/tools/idea/common/error/DesignerCommonIssueNode;)V", "getFileData", "()Lcom/android/tools/idea/common/error/IssuedFileData;", "equals", "", "other", "", "getChildren", "", "getLeafState", "Lcom/intellij/ui/tree/LeafState;", "getName", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getNavigatable", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "hashCode", "", "update", "", "project", "Lcom/intellij/openapi/project/Project;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.android.designer"})
public final class LayoutFileIssuedFileNode
extends DesignerCommonIssueNode {
    @NotNull
    private final IssuedFileData fileData;

    @NotNull
    public LeafState getLeafState() {
        return LeafState.NEVER;
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.fileData.getFile().getPresentableName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fileData.file.presentableName");
        return string2;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        return this.fileData.getFile();
    }

    @Nullable
    public OpenFileDescriptor getNavigatable() {
        OpenFileDescriptor openFileDescriptor;
        Project project = this.getProject();
        if (project != null) {
            Project project2;
            Project it = project2 = project;
            boolean bl = false;
            openFileDescriptor = new OpenFileDescriptor(it, this.fileData.getFile());
        } else {
            openFileDescriptor = null;
        }
        return openFileDescriptor;
    }

    @Override
    protected void update(@NotNull Project project, @NotNull PresentationData presentation) {
        int count;
        DesignerCommonIssueRoot root;
        Object object;
        DesignerCommonIssueNode designerCommonIssueNode;
        block5: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            presentation.addText(this.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            Icon icon2 = CompoundIconProvider.findIcon((PsiElement)((PsiElement)PsiUtilCore.findFileSystemItem((Project)project, (VirtualFile)this.fileData.getFile())), (int)0);
            if (icon2 == null) {
                boolean bl = this.fileData.getFile().isDirectory();
                icon2 = bl ? AllIcons.Nodes.Folder : AllIcons.FileTypes.Any_type;
            }
            presentation.setIcon(icon2);
            if (!(this.getParentDescriptor() instanceof LayoutFileIssuedFileNode)) {
                Object object2 = this.fileData.getFile().getParent();
                if (object2 == null || (object2 = object2.getPresentableUrl()) == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"fileData.file.parent?.presentableUrl ?: return");
                Object url = object2;
                presentation.addText("  " + FileUtil.getLocationRelativeToUserHome((String)url), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            DesignerCommonIssueNode this_$iv = this;
            boolean $i$f$findAncestor = false;
            for (NodeDescriptor parent$iv = this_$iv.getParentDescriptor(); parent$iv != null; parent$iv = parent$iv.getParentDescriptor()) {
                if (!(parent$iv instanceof DesignerCommonIssueRoot)) continue;
                designerCommonIssueNode = (DesignerCommonIssueNode)parent$iv;
                break block5;
            }
            designerCommonIssueNode = null;
        }
        int n = (object = (root = (DesignerCommonIssueRoot)designerCommonIssueNode)) != null && (object = ((DesignerCommonIssueRoot)((Object)object)).getIssueProvider()) != null && (object = object.getIssues(this.fileData)) != null ? object.size() : (count = 0);
        if (count > 0) {
            String text = "Has " + count + " problems";
            presentation.addText("  " + text, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<DesignerCommonIssueNode> getChildren() {
        Collection collection;
        DesignerCommonIssueRoot root;
        Object object;
        DesignerCommonIssueNode designerCommonIssueNode;
        Object parent$iv;
        block4: {
            DesignerCommonIssueNode this_$iv = this;
            boolean $i$f$findAncestor = false;
            for (parent$iv = this_$iv.getParentDescriptor(); parent$iv != null; parent$iv = parent$iv.getParentDescriptor()) {
                if (!(parent$iv instanceof DesignerCommonIssueRoot)) continue;
                designerCommonIssueNode = (DesignerCommonIssueNode)((Object)parent$iv);
                break block4;
            }
            designerCommonIssueNode = null;
        }
        if ((object = (root = (DesignerCommonIssueRoot)designerCommonIssueNode)) != null && (object = ((DesignerCommonIssueRoot)((Object)object)).getIssueProvider()) != null && (object = object.getIssues(this.fileData)) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            parent$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Issue issue = (Issue)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                LayoutFileIssueNode layoutFileIssueNode = new LayoutFileIssueNode(this.fileData, (Issue)it, this);
                collection2.add(layoutFileIssueNode);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    public int hashCode() {
        return Objects.hash(this.getProject(), this.fileData);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (!(object2 instanceof LayoutFileIssuedFileNode)) {
            object2 = null;
        }
        LayoutFileIssuedFileNode layoutFileIssuedFileNode = (LayoutFileIssuedFileNode)((Object)object2);
        if (layoutFileIssuedFileNode == null) {
            return false;
        }
        LayoutFileIssuedFileNode that = layoutFileIssuedFileNode;
        return Intrinsics.areEqual((Object)that.getProject(), (Object)this.getProject()) && Intrinsics.areEqual((Object)that.fileData, (Object)this.fileData);
    }

    @NotNull
    public final IssuedFileData getFileData() {
        return this.fileData;
    }

    public LayoutFileIssuedFileNode(@NotNull IssuedFileData fileData, @NotNull DesignerCommonIssueNode parent) {
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        Intrinsics.checkNotNullParameter((Object)((Object)parent), (String)"parent");
        super(parent.getProject(), (NodeDescriptor<DesignerCommonIssueNode>)((NodeDescriptor)parent));
        this.fileData = fileData;
    }
}

