/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.tools.idea.common.error.DesignerCommonIssueNode;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueSource;
import com.android.tools.idea.common.error.IssuedFileData;
import com.android.tools.idea.common.error.LayoutFileIssueDescriptionNode;
import com.android.tools.idea.common.error.LayoutFileIssueFixNode;
import com.android.tools.idea.common.error.LayoutFileIssuedFileNode;
import com.android.tools.idea.common.error.NlComponentIssueSource;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.LeafState;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\nH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0010H\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/common/error/LayoutFileIssueNode;", "Lcom/android/tools/idea/common/error/DesignerCommonIssueNode;", "fileData", "Lcom/android/tools/idea/common/error/IssuedFileData;", "issue", "Lcom/android/tools/idea/common/error/Issue;", "parent", "Lcom/android/tools/idea/common/error/LayoutFileIssuedFileNode;", "(Lcom/android/tools/idea/common/error/IssuedFileData;Lcom/android/tools/idea/common/error/Issue;Lcom/android/tools/idea/common/error/LayoutFileIssuedFileNode;)V", "description", "", "getFileData", "()Lcom/android/tools/idea/common/error/IssuedFileData;", "getIssue", "()Lcom/android/tools/idea/common/error/Issue;", "offset", "", "text", "equals", "", "other", "", "getChildren", "", "getLeafState", "Lcom/intellij/ui/tree/LeafState;", "getName", "getNavigatable", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "hashCode", "update", "", "project", "Lcom/intellij/openapi/project/Project;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.android.designer"})
public final class LayoutFileIssueNode
extends DesignerCommonIssueNode {
    private String text;
    private String description;
    private int offset;
    @NotNull
    private final IssuedFileData fileData;
    @NotNull
    private final Issue issue;

    @NotNull
    public LeafState getLeafState() {
        return LeafState.DEFAULT;
    }

    @Override
    @NotNull
    public String getName() {
        return this.text;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        return this.fileData.getFile();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<DesignerCommonIssueNode> getChildren() {
        void $this$mapTo$iv$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv2;
        CharSequence charSequence;
        String it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)this.issue.getDescription(), (String[])new String[]{"<BR/>"}, (boolean)true, (int)0, (int)4, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            charSequence = it;
            if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            charSequence = it;
            object = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
            collection.add(object);
        }
        List lines = (List)destination$iv$iv;
        Iterable $this$map$iv2 = lines;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            object = new LayoutFileIssueDescriptionNode(this.fileData, this.issue, (String)it2, this);
            collection.add(object);
        }
        List descriptionNodes = (List)destination$iv$iv2;
        Stream stream = this.issue.getFixes().map(new Function(this){
            final /* synthetic */ LayoutFileIssueNode this$0;

            public final LayoutFileIssueFixNode apply(Issue.Fix it) {
                IssuedFileData issuedFileData = this.this$0.getFileData();
                Issue issue = this.this$0.getIssue();
                Issue.Fix fix = it;
                Intrinsics.checkNotNullExpressionValue((Object)fix, (String)"it");
                return new LayoutFileIssueFixNode(issuedFileData, issue, fix, this.this$0);
            }
            {
                this.this$0 = layoutFileIssueNode;
            }
        });
        Intrinsics.checkNotNullExpressionValue(stream, (String)"issue.fixes.map { Layout\u2026is@LayoutFileIssueNode) }");
        List fixNodes2 = StreamsKt.toList(stream);
        return CollectionsKt.plus((Collection)descriptionNodes, (Iterable)fixNodes2);
    }

    @Nullable
    public OpenFileDescriptor getNavigatable() {
        OpenFileDescriptor openFileDescriptor;
        Project project = this.getProject();
        if (project != null) {
            Project project2;
            Project it = project2 = project;
            boolean bl = false;
            openFileDescriptor = new OpenFileDescriptor(it, this.fileData.getFile(), this.offset);
        } else {
            openFileDescriptor = null;
        }
        return openFileDescriptor;
    }

    @Override
    protected void update(@NotNull Project project, @NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        IssueSource source = this.issue.getSource();
        Object nodeDisplayText = null;
        if (source instanceof NlComponentIssueSource) {
            nodeDisplayText = source.getDisplayText() + ": " + this.issue.getSummary();
            XmlTag xmlTag = ((NlComponentIssueSource)source).getComponent().getTag();
            this.offset = xmlTag != null && (xmlTag = xmlTag.getTextRange()) != null ? xmlTag.getStartOffset() : -1;
        } else {
            nodeDisplayText = this.issue.getSummary();
        }
        this.text = nodeDisplayText;
        HighlightSeverity severity = this.issue.getSeverity();
        Icon icon2 = severity.myVal >= HighlightSeverity.ERROR.myVal ? StudioIcons.Common.ERROR : StudioIcons.Common.WARNING;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"if (severity.myVal >= Hi\u2026tudioIcons.Common.WARNING");
        Icon icon3 = icon2;
        presentation.setIcon(icon3);
        presentation.addText((String)nodeDisplayText, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.setTooltip(this.description);
    }

    public int hashCode() {
        return Objects.hash(this.getProject(), this.fileData, this.issue);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (!(object2 instanceof LayoutFileIssueNode)) {
            object2 = null;
        }
        LayoutFileIssueNode layoutFileIssueNode = (LayoutFileIssueNode)((Object)object2);
        if (layoutFileIssueNode == null) {
            return false;
        }
        LayoutFileIssueNode that = layoutFileIssueNode;
        return Intrinsics.areEqual((Object)that.getProject(), (Object)this.getProject()) && Intrinsics.areEqual((Object)that.fileData, (Object)this.fileData) && Intrinsics.areEqual((Object)that.issue, (Object)this.issue);
    }

    @NotNull
    public final IssuedFileData getFileData() {
        return this.fileData;
    }

    @NotNull
    public final Issue getIssue() {
        return this.issue;
    }

    public LayoutFileIssueNode(@NotNull IssuedFileData fileData, @NotNull Issue issue, @NotNull LayoutFileIssuedFileNode parent) {
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)((Object)parent), (String)"parent");
        super(parent.getProject(), (NodeDescriptor<DesignerCommonIssueNode>)((NodeDescriptor)parent));
        this.fileData = fileData;
        this.issue = issue;
        this.text = "";
        this.description = "";
        this.offset = -1;
    }
}

