/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssuePanel;
import com.android.utils.HtmlBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.RoundedLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.StyleSheetUtil;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssueView
extends JPanel {
    private static final int COLLAPSED_ROW_HEIGHT = 30;
    private static final int BORDER_THICKNESS = 1;
    private static final JBColor SELECTED_BG_COLOR = new JBColor(0xF2F2F2, 2303013);
    private final IssuePanel myContainerIssuePanel;
    private RoundedLineBorder mySelectedBorder;
    private Border myUnselectedBorder;
    private JPanel myContent;
    private JBLabel myExpandIcon;
    private JLabel myErrorIcon;
    private JLabel mySourceLabel;
    private JTextPane myErrorDescription;
    private JBLabel myErrorTitle;
    private JPanel myFixPanel;
    private JPanel myDetailPanel;
    private boolean myIsExpanded;
    private final int myDisplayPriority;
    private boolean myInitialized;
    @NotNull
    private String myErrorDescriptionContent;

    IssueView(@NotNull Issue issue, @NotNull IssuePanel container) {
        if (issue == null) {
            IssueView.$$$reportNull$$$0(0);
        }
        if (container == null) {
            IssueView.$$$reportNull$$$0(1);
        }
        this.$$$setupUI$$$();
        this.mySelectedBorder = IdeBorderFactory.createRoundedBorder((int)JBUIScale.scale((int)1));
        this.myUnselectedBorder = JBUI.Borders.empty((int)1);
        this.addMouseListener(this.createMouseListener());
        this.myContainerIssuePanel = container;
        this.myDisplayPriority = IssueView.getDisplayPriority(issue);
        this.mySelectedBorder.setColor(UIUtil.getTreeSelectionBorderColor());
        this.myErrorDescription.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.myErrorDescriptionContent = new HtmlBuilder().openHtmlBody().addHtml(issue.getDescription()).closeHtmlBody().getHtml();
        this.setupHeader(issue);
        this.setupDescriptionPanel(issue);
        this.setupFixPanel(issue);
        this.myInitialized = true;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setMaximumSize((Dimension)JBUI.size((int)Integer.MAX_VALUE, (int)30));
        this.setBackground(UIUtil.getEditorPaneBackground());
        if (this.myInitialized) {
            this.mySelectedBorder = IdeBorderFactory.createRoundedBorder((int)JBUIScale.scale((int)1));
            this.mySelectedBorder.setColor(UIUtil.getTreeSelectionBorderColor());
            this.myUnselectedBorder = JBUI.Borders.empty((int)1);
            this.myErrorDescription.putClientProperty("JEditorPane.honorDisplayProperties", true);
            this.myErrorTitle.setFont(StartupUiUtil.getLabelFont().deriveFont(1));
        }
    }

    private void setupHeader(@NotNull Issue issue) {
        if (issue == null) {
            IssueView.$$$reportNull$$$0(2);
        }
        this.myErrorIcon.setIcon(IssueView.getSeverityIcon(issue.getSeverity()));
        this.myExpandIcon.setIcon(UIUtil.getTreeCollapsedIcon());
        int maxWidth = Math.max(UIUtil.getTreeCollapsedIcon().getIconWidth(), UIUtil.getTreeExpandedIcon().getIconWidth());
        this.myExpandIcon.setMinimumSize(new Dimension(maxWidth, 0));
        this.myErrorTitle.setText(issue.getSummary());
        String displayText = issue.getSource().getDisplayText();
        if (displayText != "") {
            this.mySourceLabel.setText(displayText);
        }
    }

    private void setupFixPanel(@NotNull Issue issue) {
        if (issue == null) {
            IssueView.$$$reportNull$$$0(3);
        }
        this.myFixPanel.setLayout(new BoxLayout(this.myFixPanel, 1));
        issue.getFixes().forEach(this::createFixEntry);
        if (this.myFixPanel.getComponentCount() > 0) {
            this.myFixPanel.setVisible(true);
        } else {
            this.myFixPanel.setVisible(false);
        }
    }

    private void setupDescriptionPanel(@NotNull Issue issue) {
        if (issue == null) {
            IssueView.$$$reportNull$$$0(4);
        }
        this.myErrorDescription.setEditorKit(new IssueHTMLEditorKit());
        this.myErrorDescription.addHyperlinkListener(issue.getHyperlinkListener());
        this.myErrorDescription.setFont(UIUtil.getToolTipFont());
        this.myErrorDescription.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                IssueView.this.myContainerIssuePanel.setSelectedIssue(IssueView.this);
                IssueView.this.setFocused(true);
            }
        });
    }

    public void updateDescription(@NotNull Issue issue) {
        if (issue == null) {
            IssueView.$$$reportNull$$$0(5);
        }
        this.myErrorDescriptionContent = new HtmlBuilder().openHtmlBody().addHtml(issue.getDescription()).closeHtmlBody().getHtml();
    }

    private static int getDisplayPriority(@NotNull Issue error) {
        if (error == null) {
            IssueView.$$$reportNull$$$0(6);
        }
        if (error.getSeverity().equals((Object)HighlightSeverity.ERROR)) {
            return 0;
        }
        if (error.getSeverity().equals((Object)HighlightSeverity.WARNING)) {
            return 1;
        }
        if (error.getSeverity().equals((Object)HighlightSeverity.WEAK_WARNING)) {
            return 2;
        }
        return 3;
    }

    int getDisplayPriority() {
        return this.myDisplayPriority;
    }

    private void createFixEntry(@NotNull Issue.Fix fix) {
        if (fix == null) {
            IssueView.$$$reportNull$$$0(7);
        }
        this.myFixPanel.add(new FixEntry(fix.getButtonText(), fix.getDescription(), fix.getRunnable()));
    }

    @NotNull
    private MouseAdapter createMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                IssueView.this.myContainerIssuePanel.requestFocusInWindow();
                if (e.getClickCount() == 1) {
                    IssueView.this.myContainerIssuePanel.setSelectedIssue(IssueView.this);
                    IssueView.this.setFocused(true);
                }
                if (e.getX() > IssueView.this.myExpandIcon.getX() - 3 && e.getX() < IssueView.this.myExpandIcon.getX() + IssueView.this.myExpandIcon.getWidth() + 3 || e.getClickCount() >= 2) {
                    IssueView.this.setExpanded(!IssueView.this.myIsExpanded);
                }
            }
        };
    }

    void setExpanded(boolean expanded) {
        this.myIsExpanded = expanded;
        if (this.myIsExpanded) {
            this.myErrorDescription.setText(this.myErrorDescriptionContent);
            this.myErrorDescription.getPreferredSize();
        } else {
            this.myErrorDescription.setText("");
        }
        this.myDetailPanel.setVisible(this.myIsExpanded);
        this.myExpandIcon.setIcon(this.myIsExpanded ? UIUtil.getTreeExpandedIcon() : UIUtil.getTreeCollapsedIcon());
        List<IssuePanel.EventListener> eventListeners = this.myContainerIssuePanel.getEventListeners();
        eventListeners.forEach(listener2 -> listener2.onIssueExpanded(this.myContainerIssuePanel.getSelectedIssue(), expanded));
        this.myContainerIssuePanel.revalidate();
        this.myContainerIssuePanel.repaint();
    }

    @NotNull
    public static Icon getSeverityIcon(@Nullable HighlightSeverity severity) {
        if (severity != null) {
            if (HighlightSeverity.ERROR.equals((Object)severity)) {
                Icon icon2 = StudioIcons.Common.ERROR;
                if (icon2 == null) {
                    IssueView.$$$reportNull$$$0(8);
                }
                return icon2;
            }
            if (HighlightSeverity.WARNING.equals((Object)severity)) {
                Icon icon3 = StudioIcons.Common.WARNING;
                if (icon3 == null) {
                    IssueView.$$$reportNull$$$0(9);
                }
                return icon3;
            }
        }
        Icon icon4 = StudioIcons.Common.INFO;
        if (icon4 == null) {
            IssueView.$$$reportNull$$$0(10);
        }
        return icon4;
    }

    void setSelected(boolean selected) {
        this.setOpaque(selected);
        this.setBackground((Color)(selected ? SELECTED_BG_COLOR : UIUtil.getEditorPaneBackground()));
        this.setFocused(this.myContainerIssuePanel.hasFocus() && selected);
    }

    int getSourceLabelWidth() {
        return this.mySourceLabel.getFontMetrics(this.mySourceLabel.getFont()).stringWidth(this.mySourceLabel.getText());
    }

    void setSourceLabelSize(int sourceLabelSize) {
        Dimension size = this.mySourceLabel.getPreferredSize();
        size.width = sourceLabelSize;
        this.mySourceLabel.setPreferredSize(size);
    }

    @VisibleForTesting
    public String getIssueDescription() {
        return this.myErrorDescription.getText();
    }

    @VisibleForTesting
    public String getIssueTitle() {
        return this.myErrorTitle.getText();
    }

    private void createUIComponents() {
        this.myContent = this;
    }

    private static void applyIssueDescriptionStyle(@NotNull JTextPane textPane) {
        if (textPane == null) {
            IssueView.$$$reportNull$$$0(11);
        }
        Font font = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.NORMAL);
        MutableAttributeSet attrs = textPane.getInputAttributes();
        StyleConstants.setFontFamily(attrs, font.getFamily());
        StyleConstants.setFontSize(attrs, font.getSize());
        StyleConstants.setItalic(attrs, (font.getStyle() & 2) != 0);
        StyleConstants.setBold(attrs, (font.getStyle() & 1) != 0);
        textPane.getStyledDocument().setCharacterAttributes(0, textPane.getStyledDocument().getLength() + 1, attrs, false);
    }

    void setFocused(boolean focused) {
        this.setBorder((Border)(focused ? this.mySelectedBorder : this.myUnselectedBorder));
    }

    @VisibleForTesting
    @NotNull
    FixEntry[] getFixEntries() {
        FixEntry[] fixEntryArray = (FixEntry[])Arrays.copyOf(this.myFixPanel.getComponents(), this.myFixPanel.getComponentCount(), FixEntry[].class);
        if (fixEntryArray == null) {
            IssueView.$$$reportNull$$$0(12);
        }
        return fixEntryArray;
    }

    @NotNull
    int[] getColumnsX() {
        int[] nArray = new int[]{this.myExpandIcon.getX(), this.mySourceLabel.getX()};
        if (nArray == null) {
            IssueView.$$$reportNull$$$0(13);
        }
        return nArray;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextPane jTextPane;
        JPanel jPanel2;
        JBLabel jBLabel;
        JLabel jLabel;
        JLabel jLabel2;
        JBLabel jBLabel2;
        this.createUIComponents();
        JPanel jPanel3 = this.myContent;
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 5, new Insets(2, 5, 2, 5), -1, -1, false, false));
        jPanel3.setOpaque(false);
        this.myExpandIcon = jBLabel2 = new JBLabel();
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myErrorIcon = jLabel2 = new JLabel();
        jLabel2.setText("");
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySourceLabel = jLabel = new JLabel();
        jPanel3.add((Component)jLabel, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myErrorTitle = jBLabel = new JBLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jBLabel.getFont());
        if (font != null) {
            jBLabel.setFont(font);
        }
        jBLabel.setHorizontalAlignment(2);
        jBLabel.setHorizontalTextPosition(2);
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 0, null, null, null));
        this.myDetailPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setOpaque(false);
        ((Component)jPanel2).setVisible(false);
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 2, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myErrorDescription = jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        Font font2 = this.$$$getFont$$$(null, -1, -1, jTextPane.getFont());
        if (font2 != null) {
            jTextPane.setFont(font2);
        }
        jTextPane.setOpaque(false);
        jPanel2.add((Component)jTextPane, new GridConstraints(0, 0, 1, 1, 1, 1, 6, 2, null, new Dimension(558, 50), null));
        this.myFixPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setOpaque(false);
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 9, 0, 3, 3, null, new Dimension(558, 24), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContent;
    }

    private /* synthetic */ Font $$$getFont$$$(String string2, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string3 = string2 == null ? font.getName() : ((font2 = new Font(string2, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string2 : font.getName());
        Font font3 = new Font(string3, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/error/IssueView";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/error/IssueView";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverityIcon";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixEntries";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnsX";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setupHeader";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupFixPanel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupDescriptionPanel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateDescription";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayPriority";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFixEntry";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyIssueDescriptionStyle";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IssueHTMLEditorKit
    extends HTMLEditorKit {
        StyleSheet style = this.createStyleSheet();

        private IssueHTMLEditorKit() {
        }

        public StyleSheet createStyleSheet() {
            StyleSheet style2 = new StyleSheet();
            style2.addStyleSheet(StyleSheetUtil.getDefaultStyleSheet());
            style2.addRule("body { font-family: Sans-Serif; }");
            style2.addRule("code { font-size: 100%; font-family: monospace; }");
            style2.addRule("small { font-size: small; }");
            style2.addRule("a { text-decoration: none;}");
            return style2;
        }

        @Override
        public StyleSheet getStyleSheet() {
            return this.style;
        }

        @Override
        protected void createInputAttributes(Element element, MutableAttributeSet set) {
        }
    }

    public static class FixEntry
    extends JComponent {
        private JButton myFixButton;
        private JBLabel myFixText;
        private JComponent myComponent;

        public FixEntry(@NotNull String buttonText, @NotNull String text, @NotNull Runnable fixRunnable) {
            if (buttonText == null) {
                FixEntry.$$$reportNull$$$0(0);
            }
            if (text == null) {
                FixEntry.$$$reportNull$$$0(1);
            }
            if (fixRunnable == null) {
                FixEntry.$$$reportNull$$$0(2);
            }
            this.$$$setupUI$$$();
            this.myFixText.setText(text);
            this.myFixButton.setText(buttonText);
            this.myFixButton.addActionListener(e -> fixRunnable.run());
        }

        private void createUIComponents() {
            this.myComponent = this;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBLabel jBLabel;
            JButton jButton;
            this.createUIComponents();
            JComponent jComponent = this.myComponent;
            jComponent.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jComponent.setOpaque(false);
            this.myFixButton = jButton = new JButton();
            jButton.setOpaque(false);
            jButton.setText("Fix");
            jComponent.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 3, null, null, null));
            Spacer spacer = new Spacer();
            jComponent.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            this.myFixText = jBLabel = new JBLabel();
            jComponent.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "buttonText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fixRunnable";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/common/error/IssueView$FixEntry";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

