/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.tools.idea.common.error.DesignerCommonIssueProvider;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.error.IssuedFileData;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\u0004\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/common/error/IssueModelProvider;", "Lcom/android/tools/idea/common/error/DesignerCommonIssueProvider;", "issueModel", "Lcom/android/tools/idea/common/error/IssueModel;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/android/tools/idea/common/error/IssueModel;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getIssuedFileDataList", "", "Lcom/android/tools/idea/common/error/IssuedFileData;", "getIssues", "Lcom/android/tools/idea/common/error/Issue;", "intellij.android.designer"})
public final class IssueModelProvider
implements DesignerCommonIssueProvider {
    private final IssueModel issueModel;
    private final VirtualFile file;

    @Override
    @NotNull
    public List<Issue> getIssues(@NotNull IssuedFileData file2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (Intrinsics.areEqual((Object)file2.getSource(), (Object)this.issueModel)) {
            ImmutableList<Issue> immutableList = this.issueModel.getIssues();
            Intrinsics.checkNotNullExpressionValue(immutableList, (String)"issueModel.issues");
            list = (List)immutableList;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<IssuedFileData> getIssuedFileDataList() {
        return CollectionsKt.listOf((Object)new IssuedFileData(this.file, this.issueModel));
    }

    public IssueModelProvider(@NotNull IssueModel issueModel, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)issueModel, (String)"issueModel");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.issueModel = issueModel;
        this.file = file2;
    }
}

