/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueProvider;
import com.android.tools.idea.common.error.IssueSource;
import com.android.tools.idea.common.error.TooManyIssuesIssue;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ModalityState;
import com.intellij.util.ModalityUiUtil;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssueModel {
    private static final int MAX_ISSUE_NUMBER_LIMIT = 200;
    private final int myIssueNumberLimit;
    private ImmutableList<Issue> myIssues;
    private final ListenerCollection<IssueModelListener> myListeners;
    protected int myWarningCount;
    protected int myErrorCount;
    @VisibleForTesting
    public final Runnable myUpdateCallback;
    private final List<IssueProvider> myIssueProviders;

    @VisibleForTesting
    IssueModel(@NotNull Executor listenerExecutor, int issueNumberLimit) {
        if (listenerExecutor == null) {
            IssueModel.$$$reportNull$$$0(0);
        }
        this.myIssues = ImmutableList.of();
        this.myUpdateCallback = () -> this.updateErrorsList();
        this.myIssueProviders = new ArrayList<IssueProvider>();
        this.myListeners = ListenerCollection.createWithExecutor((Executor)listenerExecutor);
        this.myIssueNumberLimit = issueNumberLimit;
    }

    @VisibleForTesting
    IssueModel(@NotNull Executor listenerExecutor) {
        if (listenerExecutor == null) {
            IssueModel.$$$reportNull$$$0(1);
        }
        this(listenerExecutor, 200);
    }

    public IssueModel() {
        this(command -> ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), (Runnable)command));
    }

    @Nullable
    public Issue getHighestSeverityIssue(@NotNull NlComponent component) {
        if (component == null) {
            IssueModel.$$$reportNull$$$0(2);
        }
        IssueSource componentSource = IssueSource.fromNlComponent(component);
        Issue[] filtered = (Issue[])this.myIssues.stream().filter(it -> componentSource.equals(it.getSource())).toArray(Issue[]::new);
        if (filtered.length == 0) {
            return null;
        }
        Issue max = filtered[0];
        for (int i = 1; i < filtered.length; ++i) {
            Issue it2 = filtered[i];
            if (max.getSeverity().compareTo(it2.getSeverity()) >= 0) continue;
            max = it2;
        }
        return max;
    }

    @Nullable
    public static Icon getIssueIcon(@NotNull HighlightSeverity severity, boolean selected) {
        boolean isError;
        if (severity == null) {
            IssueModel.$$$reportNull$$$0(3);
        }
        boolean bl = isError = severity == HighlightSeverity.ERROR;
        if (selected) {
            return isError ? StudioIcons.Common.ERROR_INLINE_SELECTED : StudioIcons.Common.WARNING_INLINE_SELECTED;
        }
        return isError ? StudioIcons.Common.ERROR_INLINE : StudioIcons.Common.WARNING_INLINE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateErrorsList() {
        ImmutableList providers2;
        this.myWarningCount = 0;
        this.myErrorCount = 0;
        ImmutableList.Builder issueListBuilder = ImmutableList.builder();
        UnmodifiableIterator unmodifiableIterator = this.myIssueProviders;
        synchronized (unmodifiableIterator) {
            providers2 = ImmutableList.copyOf(this.myIssueProviders);
        }
        for (IssueProvider provider2 : providers2) {
            provider2.collectIssues((ImmutableCollection.Builder<Issue>)issueListBuilder);
        }
        ImmutableList newIssueList = issueListBuilder.build();
        if (newIssueList.size() > this.myIssueNumberLimit) {
            newIssueList = ImmutableList.builder().addAll((Iterable)newIssueList.subList(0, this.myIssueNumberLimit)).add((Object)new TooManyIssuesIssue(newIssueList.size() - this.myIssueNumberLimit)).build();
        }
        newIssueList.forEach(issue -> this.updateIssuesCounts((Issue)issue));
        this.myIssues = newIssueList;
        this.myListeners.forEach(IssueModelListener::errorModelChanged);
    }

    private void updateIssuesCounts(@NotNull Issue issue) {
        if (issue == null) {
            IssueModel.$$$reportNull$$$0(4);
        }
        if (issue.getSeverity().equals((Object)HighlightSeverity.WARNING)) {
            ++this.myWarningCount;
        } else if (issue.getSeverity().equals((Object)HighlightSeverity.ERROR)) {
            ++this.myErrorCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIssueProvider(@NotNull IssueProvider issueProvider2, boolean update2) {
        if (issueProvider2 == null) {
            IssueModel.$$$reportNull$$$0(5);
        }
        List<IssueProvider> list = this.myIssueProviders;
        synchronized (list) {
            this.myIssueProviders.add(issueProvider2);
        }
        issueProvider2.addListener(this.myUpdateCallback);
        if (update2) {
            this.updateErrorsList();
        }
    }

    public void addIssueProvider(@NotNull IssueProvider issueProvider2) {
        if (issueProvider2 == null) {
            IssueModel.$$$reportNull$$$0(6);
        }
        this.addIssueProvider(issueProvider2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIssueProvider(@NotNull IssueProvider issueProvider2) {
        if (issueProvider2 == null) {
            IssueModel.$$$reportNull$$$0(7);
        }
        List<IssueProvider> list = this.myIssueProviders;
        synchronized (list) {
            this.myIssueProviders.remove(issueProvider2);
        }
        issueProvider2.removeListener(this.myUpdateCallback);
        this.updateErrorsList();
    }

    @NotNull
    public ImmutableList<Issue> getIssues() {
        ImmutableList<Issue> immutableList = this.myIssues;
        if (immutableList == null) {
            IssueModel.$$$reportNull$$$0(8);
        }
        return immutableList;
    }

    public int getIssueCount() {
        return this.myIssues.size();
    }

    public void addErrorModelListener(@NotNull IssueModelListener listener2) {
        if (listener2 == null) {
            IssueModel.$$$reportNull$$$0(9);
        }
        this.myListeners.add((Object)listener2);
    }

    public void removeErrorModelListener(@NotNull IssueModelListener listener2) {
        if (listener2 == null) {
            IssueModel.$$$reportNull$$$0(10);
        }
        this.myListeners.remove((Object)listener2);
    }

    public int getWarningCount() {
        return this.myWarningCount;
    }

    public int getErrorCount() {
        return this.myErrorCount;
    }

    public boolean hasIssues() {
        return !this.myIssues.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerExecutor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issueProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/error/IssueModel";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/error/IssueModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHighestSeverityIssue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIssueIcon";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateIssuesCounts";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addIssueProvider";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeIssueProvider";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addErrorModelListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeErrorModelListener";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface IssueModelListener {
        public void errorModelChanged();
    }
}

