/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.editor.DesignToolsSplitEditor;
import com.android.tools.idea.common.editor.DesignerEditor;
import com.android.tools.idea.common.editor.DesignerEditorPanel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.common.type.DesignerTypeRegistrar;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.QuickDefinitionProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class DesignerEditorProvider
implements FileEditorProvider,
QuickDefinitionProvider,
DumbAware {
    @NotNull
    private final List<DesignerEditorFileType> myAcceptedTypes;

    protected DesignerEditorProvider(@NotNull List<DesignerEditorFileType> acceptedTypes) {
        if (acceptedTypes == null) {
            DesignerEditorProvider.$$$reportNull$$$0(0);
        }
        this.myAcceptedTypes = acceptedTypes;
        this.myAcceptedTypes.forEach(DesignerTypeRegistrar.INSTANCE::register);
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        PsiFile psiFile2;
        if (project == null) {
            DesignerEditorProvider.$$$reportNull$$$0(1);
        }
        if (virtualFile == null) {
            DesignerEditorProvider.$$$reportNull$$$0(2);
        }
        if ((psiFile2 = AndroidPsiUtils.getPsiFileSafely((Project)project, (VirtualFile)virtualFile)) instanceof XmlFile) {
            XmlFile xmlFile = (XmlFile)psiFile2;
            return this.myAcceptedTypes.stream().anyMatch(type -> type.isResourceTypeOf((PsiFile)xmlFile));
        }
        return false;
    }

    @NotNull
    public final FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            DesignerEditorProvider.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            DesignerEditorProvider.$$$reportNull$$$0(4);
        }
        DesignerEditor designEditor = this.createDesignEditor(project, file2);
        DesignerEditorPanel editorPanel2 = designEditor.getComponent();
        TextEditor textEditor = (TextEditor)TextEditorProvider.getInstance().createEditor(project, file2);
        DesignerEditorProvider.addCaretListener(textEditor, designEditor);
        editorPanel2.getSurface().setFileEditorDelegate((FileEditor)textEditor);
        DesignToolsSplitEditor splitEditor = new DesignToolsSplitEditor(textEditor, designEditor, project);
        editorPanel2.getWorkBench().setFileEditor((FileEditor)splitEditor);
        DataManager.registerDataProvider((JComponent)editorPanel2, (DataProvider)splitEditor);
        DesignToolsSplitEditor designToolsSplitEditor = splitEditor;
        if (designToolsSplitEditor == null) {
            DesignerEditorProvider.$$$reportNull$$$0(5);
        }
        return designToolsSplitEditor;
    }

    private static void addCaretListener(@NotNull TextEditor editor2, final @NotNull DesignerEditor designEditor) {
        if (editor2 == null) {
            DesignerEditorProvider.$$$reportNull$$$0(6);
        }
        if (designEditor == null) {
            DesignerEditorProvider.$$$reportNull$$$0(7);
        }
        final CaretModel caretModel = editor2.getEditor().getCaretModel();
        final MergingUpdateQueue updateQueue = new MergingUpdateQueue("split.editor.preview.edit", 250, true, null, (Disposable)designEditor, null, Alarm.ThreadToUse.SWING_THREAD);
        updateQueue.setRestartTimerOnAdd(true);
        caretModel.addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                final DesignSurface surface2 = designEditor.getComponent().getSurface();
                SceneView sceneView = surface2.getFocusedSceneView();
                int offset2 = caretModel.getOffset();
                if (sceneView == null || offset2 == -1) {
                    return;
                }
                NlModel model2 = sceneView.getSceneManager().getModel();
                ImmutableList<NlComponent> views = model2.findByOffset(offset2);
                if (views.isEmpty()) {
                    views = model2.getComponents();
                }
                SelectionModel selectionModel = sceneView.getSelectionModel();
                selectionModel.setSelection((List<? extends NlComponent>)views);
                updateQueue.queue(new Update("Design editor update"){

                    public void run() {
                        surface2.repaint();
                    }

                    public boolean canEat(Update update2) {
                        return true;
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/common/editor/DesignerEditorProvider$1", "caretPositionChanged"));
            }
        });
    }

    @NotNull
    public abstract DesignerEditor createDesignEditor(@NotNull Project var1, @NotNull VirtualFile var2);

    @NotNull
    public abstract String getEditorTypeId();

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            DesignerEditorProvider.$$$reportNull$$$0(8);
        }
        return fileEditorPolicy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptedTypes";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/editor/DesignerEditorProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/editor/DesignerEditorProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addCaretListener";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

